@extends('layouts.list')

@section('title')
    All Business Locations
@endsection

@section('list-title')
    {{__('business_location.business_locations')}}
@endsection

@section('list-navigation')
    <li>{{__('business_location.business_locations')}}</li>
@endsection

@section('list-new-button')
@if (Auth::user()->role == "super_admin")
<a href="{{ route('createBusinessLocation') }}" class="btn btn-outline-primary btn-sm me-2">
    <i class="fa-solid fa-plus me-2"></i>{{__('business_location.new_business_locations')}}
</a>
@endif
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('business_location.logo')}}</th>
    <th scope="col">{{__('business_location.business_name')}}</th>
    <th scope="col">{{__('business_location.address')}}</th>
    <th scope="col">{{__('business_location.owner_name')}}</th>
    <th scope="col">{{__('business_location.created_by')}}</th>
    <th scope="col">{{__('business_location.status')}}</th>
    <th scope="col">{{__('business_location.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($business_locations as $business_location)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row" class="imageTitle">
                @if ($business_location->image !== null && $business_location->image !== '')
                    <img class="image-fload" width="100px" height="100px"
                        src='{{ asset("uploads/$business_location->image") }}'
                        alt="{{ $business_location->business_name }}">
                @else
                    <h2> {{ $business_location->business_name[0] }}</h2>
                @endif
            </th>
            <td class="Zindex">
                <h6 class="col-4">{{__('business_location.name')}}</h6>
                <a class="text-decoration-none col-8" href="{{ route('viewBusinessLocation', $business_location->id) }}">
                    <p class="text-custome m-0 ">{{ $business_location->business_name }}</p>
                </a>
                <h6 class="col-4">{{__('business_location.email')}}</h6>
                <p class="m-0  col-8">{{ $business_location->email }}</p>
                <h6 class="col-4">{{__('business_location.phone')}}</h6>
                <p class="m-0  col-8">{{ $business_location->phone }}</p>
                <h6 class="col-4">{{__('business_location.alternative_phone')}}</h6>
                <p class="m-0  col-8">{{ $business_location->alternative_phone }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-4">{{__('business_location.address')}}</h6>
                <p class="m-0  col-8">{{ $business_location->address }}</p>
            </td>
       
            <td class="Zindex">
                <h6 class="col-4">{{__('business_location.owner_name')}}</h6>
                <a class="text-decoration-none col-8" href="{{ route('viewUser', $business_location->owner_id) }}">
                    <p class="m-0 ">{{ $business_location->owner->user_name }}</p>
                </a>
            </td>
            <td class="Zindex">
                <h6 class="col-4">{{__('business_location.created_by')}}</h6>
                <a class="text-decoration-none  col-8"  href="{{ route('viewUser', $business_location->created_by) }}">
                    <p class="m-0 ">{{ $business_location->createdPerson->user_name }}</p>
                </a>
            </td>
            <td class="Zindex">

                @if ($business_location->is_active == 'Active')
                    <button class="btn btn-sm btn-success">{{__('business_location.active')}}</button>
                @else
                    <button class="btn btn-sm btn-danger">{{__('business_location.inactive')}}</button>
                @endif
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('viewBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('business_location.view')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('editBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('business_location.edit')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == "super_admin")
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('deleteBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                {{__('business_location.delete')}}
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $business_locations->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $business_locations->links() }} --}}
@endsection
