@extends('layouts.app_layout')

@section('title')
All Business Locations
@endsection

@section('content')

@if(session('message'))
    <h6 class="alert alert-success">
        {{ session('message') }}
    </h6>
@endif


<table id="example" class="table table-striped cell-border" style="width:100%">
    <thead>
      <tr>
        <th scope="col">logo</th>
        <th scope="col">Name</th>
        <th scope="col">Address</th>
        <th scope="col">Phone</th>
        <th scope="col">Alternatiev Phone</th>
        <th scope="col">Email</th>
        <th scope="col">License Start Date</th>
        <th scope="col">License End Date</th>
        <th scope="col">Max Assignments</th>
        <th scope="col">Max Students</th>
        <th scope="col">Max Submissions</th>
        <th scope="col">Status</th>
        <th scope="col">Owner Name</th>
        <th scope="col">Created By</th>
        <th scope="col">Actions</th>
      </tr>
    </thead>
    <tbody>
        @foreach ($business_locations as $business_location)
      <tr>
        <th scope="row">
            @if ($business_location->logo !== null)
                <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$business_location->logo") }}' alt="{{ $business_location->business_name }}">   
            @else
                No Logo
            @endif
        </th>
        <td>
            <a href="{{route('viewBusinessLocation' , $business_location->id )}}"><p>{{ $business_location->business_name }}</p></a>
        </td>
        <td>
            <p>{{ $business_location->address }}</p>
        </td>
        <td>
            <p>{{ $business_location->phone }}</p>
        </td>
        <td>
            <p>{{ $business_location->alternative_phone }}</p>
        </td>
        <td>
            <p>{{ $business_location->email }}</p>
        </td>
        <td>
            <p>{{ $business_location->license_start_date }}</p>
        </td>
        <td>
            <p>{{ $business_location->license_end_date }}</p>
        </td>
        <td>
            <p>{{ $business_location->max_assignments }}</p>
        </td>
        <td>
            <p>{{ $business_location->max_students }}</p>
        </td>
        <td>
            <p>{{ $business_location->max_submissions }}</p>
        </td>
        <td>
            @if ($business_location->is_active == 1)
                <p>Active</p>
            @else
                <p>Not Active</p>
            @endif
        </td>
        <td>
            <p>{{ $business_location->owner->user_name }}</p>
        </td>
        <td>
            <p>{{ $business_location->createdPerson->user_name }}</p>
        </td>
        <td>
            <a href="{{ route('viewBusinessLocation' , $business_location->id ) }}" class="btn btn-outline-primary mt-3">View</a>
            <a href="{{ route('editBusinessLocation' , $business_location->id ) }}" class="btn btn-outline-primary mt-3">Edit</a>
            <a href="{{ route('deleteBusinessLocation' , $business_location->id) }}" class="btn btn-outline-primary mt-3">Delete</a>
        </td>
      </tr>

      @endforeach
      
    </tbody>
</table>

{{-- {{ $business_locations->links() }} --}}



@endsection


