@extends('layouts.list')

@section('title')
Search Business Locations
@endsection

@section('list-title')
    Business Locations
@endsection

@section('list-navigation')
    <li><a class="text-decoration-none" href="{{ route('allBusinessLocations') }}">List Business Locations </a></li>
    <li>Search Business Locations</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createBusinessLocation') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Business Location
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">logo</th>
    <th scope="col">Business Name</th>
    <th scope="col">Address</th>
    <th scope="col">License Start Date</th>
    <th scope="col">License End Date</th>
    <th scope="col">Max Assignments</th>
    <th scope="col">Max Students</th>
    <th scope="col">Max Submissions</th>
    <th scope="col">Status</th>
    <th scope="col">Owner Name</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($business_locations as $business_location)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row">
                @if ($business_location->image !== null)
                    <img class="image-fload" width="100px" height="100px"
                        src='{{ asset("uploads/$business_location->image") }}'
                        alt="{{ $business_location->business_name }}">
                @else
                    No Logo
                @endif
            </th>
            <td>
                <a class="text-decoration-none" href="{{ route('viewBusinessLocation', $business_location->id) }}">
                    <p class="text-custome m-0 px-3">{{ $business_location->business_name }}</p>
                </a>
                <p class="m-0 px-3">{{ $business_location->email }}</p>
                <p class="m-0 px-3">{{ $business_location->phone }}</p>
                <p class="m-0 px-3">{{ $business_location->alternative_phone }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->address }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->license_start_date }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->license_end_date }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->max_assignments }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->max_students }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $business_location->max_submissions }}</p>
            </td>
            <td>
                @if ($business_location->is_active == 'Active')
                    <p class="m-0 px-3 text-success">Active</p>
                @else
                    <p class="m-0 px-3 text-danger">InActive</p>
                @endif
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewUser', $business_location->owner_id) }}">
                    <p class="m-0 px-3">{{ $business_location->owner->user_name }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewUser', $business_location->created_by) }}">
                    <p class="m-0 px-3">{{ $business_location->createdPerson->user_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('viewBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('editBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('deleteBusinessLocation', $business_location->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $business_locations->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $business_locations->links() }} --}}
@endsection
