@extends('layouts.view')

@section('title')
    View Business Location
@endsection

@section('view-title')
    {{__('business_location.view_business_location')}} - {{ $business_location->business_name }}
@endsection

@section('view-navigation')
    <li><a class="text-decoration-none" href="{{ route('allBusinessLocations') }}">{{__('business_location.list_business_location')}}</a></li>
    <li>{{__('business_location.view_business_location')}}</li>
@endsection

@section('view-panel')
    <div class="user-avtar">
        @if ($business_location->image !== null)
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='{{ asset("uploads/$business_location->image") }}' alt="{{ $business_location->business_name }}">
        @else
            <span>{{ ucfirst($business_location->business_name[0]) }}</span>
        @endif
    </div>
    <div class="user-details text-center pt-3">
        <h3>{{ $business_location->business_name }}</h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="pills-business-location-info-tab" data-bs-toggle="pill"
                data-bs-target="#pills-business-location-info" type="button" role="tab"
                aria-controls="pills-business-location-info" aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>{{__('business_location.business_location_info')}}</span>
            </button>
            <button class="nav-link" id="v-pills-business-location-license-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-license" type="button" role="tab"
                aria-controls="v-pills-business-location-license" aria-selected="false"><i
                    class="fa-solid fa-address-book"></i><span>{{__('business_location.license_info')}}</span></button>
            <button class="nav-link" id="v-pills-business-location-ownership-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-ownership" type="button" role="tab"
                aria-controls="v-pills-business-location-ownership" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>{{__('business_location.ownership_user_info')}}</span></button>
            <a class="nav-link" type="button" role="tab" aria-selected="false"
                href="{{ route('editBusinessLocation', $business_location->id) }}"><i
                    class="fa-solid fa-user-pen"></i><span>{{__('business_location.edit_business_location')}}</span></a>
            {{-- <button class="nav-link" id="v-pills-user-documents-tab" data-bs-toggle="pill" data-bs-target="#v-pills-user-documents" type="button" role="tab" aria-controls="v-pills-user-documents" aria-selected="false"><i class="fa-solid fa-envelope"></i><span>Send Email</span></button> --}}
            <button class="nav-link" id="v-pills-business-location-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-business-location-sendwhatsapp" aria-selected="false"><i
                    class="fa-solid fa-envelope"></i> <span>{{__('business_location.send_whatsApp')}}</span></button>
        </div>
    </div>
@endsection


@section('view-tabs')
    {{-- Business Location Info --}}
    <div class="tab-pane fade show active" id="pills-business-location-info" role="tabpanel"
        aria-labelledby="pills-business-location-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('business_location.business_location_info')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('business_location.business_name')}}</td>
                            <td>{{ $business_location->business_name }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.address')}}</td>
                            <td>{{ $business_location->address }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.email')}}</td>
                            <td>{{ $business_location->email }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.phone')}}</td>
                            <td>{{ $business_location->phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.alternative_phone')}}</td>
                            <td>{{ $business_location->alternative_phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.status')}}</td>
                            <td>
                                @if ($business_location->is_active == 'Active')
                                    <span class="text-success">{{ $business_location->is_active }}</span>
                                @else
                                    <span class="text-danger">{{ $business_location->is_active }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.theme_color')}}</td>
                            <td><input type="color" class="form-control text-start text-start" id="colorPicker"
                                aria-describedby="theme_color" placeholder="Select Business Location Color ..."
                                name="theme_color" value="{{$business_location->theme_color}}" disabled>
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.created_by')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ route('viewUser', $business_location->owner_id) }}">{{ $business_location->createdPerson->user_name }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.created_date')}}</td>
                            <td>{{ $business_location->created_at }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Business Location License Info --}}
    <div class="tab-pane fade" id="v-pills-business-location-license" role="tabpanel"
        aria-labelledby="v-pills-business-location-license-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('business_location.license_info')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('business_location.start_date')}}</td>
                            <td>{{ $business_location->license_start_date }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.end_date')}}</td>
                            <td>{{ $business_location->license_end_date }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.max_assignments')}}</td>
                            <td>{{ $business_location->max_assignments }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.max_students')}}</td>
                            <td>{{ $business_location->max_students }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.max_submissions')}}</td>
                            <td>{{ $business_location->max_submissions }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.max_admins')}}</td>
                            <td>{{ $business_location->max_admins }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.max_trainers')}}</td>
                            <td>{{ $business_location->max_trainers }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Business Location Ownership Info --}}
    <div class="tab-pane fade" id="v-pills-business-location-ownership" role="tabpanel"
        aria-labelledby="v-pills-business-location-ownership-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('business_location.ownership_user_info')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('business_location.ownership')}} {{__('business_location.name')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ route('viewUser', $business_location->owner_id) }}">{{ $business_location->owner->full_name }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.ownership')}} {{__('business_location.email')}}</td>
                            <td>{{ $business_location->owner->email }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.ownership')}} {{__('business_location.phone')}}</td>
                            <td>{{ $business_location->owner->phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.ownership')}} {{__('business_location.alternative_phone')}}</td>
                            <td>{{ $business_location->owner->alternative_phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.ownership')}} {{__('business_location.contact_number')}}</td>
                            <td>{{ $business_location->owner->contact_number }}</td>
                        </tr>
                        <tr>
                            <td>{{__('business_location.status')}}</td>
                            <td>
                                @if ($business_location->owner->is_active == 'Active')
                                    <span class="text-success">{{ $business_location->owner->is_active }}</span>
                                @else
                                    <span class="text-danger">{{ $business_location->owner->is_active }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Send Email --}}

    {{-- Send Whatsapp to Business Location --}}
    <div class="tab-pane fade" id="v-pills-business-location-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-business-location-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('business_location.send_whatsapp_to_business_location_phone')}}
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>{{__('business_location.to')}}</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>{{__('business_location.message')}}</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">{{__('business_location.send')}}</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "{{ $business_location->phone }}";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>

@endsection
