@extends('layouts.form')

@section('title')
    Edit Father
@endsection

@section('form-title')
    Edit Father
@endsection

@section('form-navigation')
    <li><a class="text-decoration-none" href="{{ route('allFathers') }}">List Fathers </a></li>
    <li>Edit Father - {{ $student_father_profile->father_name }}</li>
@endsection

@section('form-tabs-li')
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary"
            aria-selected="true">Basic Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary"
            aria-selected="false">Address Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links"
            type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">Social Links</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-education-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-education-primary" type="button" role="tab" aria-controls="pills-education-primary"
            aria-selected="false">Education Info</button>
    </li>
@endsection

@section('form-tabs-content')
    <form class="needs-validation" method="POST" action="{{ route('updateFather', $student_father_profile->id) }}"
        enctype="multipart/form-data">
        @csrf

        <div class="tab-content" id="pills-tabContent">
            {{-- Basic Info Group --}}
            <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel"
                aria-labelledby="pills-basic-primary-tab">

                {{-- <form class="row g-3 needs-validation flex-row-reverse text-end" novalidate> --}}
                <div class="row">

                    {{-- Full Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_name" class="form-label">Full Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_name" aria-describedby="nameHelp"
                                placeholder="Enter Father Full Name ..." name="father_name"
                                value="{{ old('father_name') ?? $student_father_profile->father_name }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_email" class="form-label">Email Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_email"
                                aria-describedby="father_email" placeholder="Enter Father Email Address ..."
                                name="father_email"
                                value="{{ old('father_email') ?? $student_father_profile->father_email }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_phone" class="form-label">Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_phone"
                                placeholder="Enter Father Mobile Number . . ." name="father_phone"
                                value="{{ old('father_phone') ?? $student_father_profile->father_phone }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_alternative_phone" class="form-label">Alternative Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_alternative_phone"
                                placeholder="Enter Father Alternative Mobile Number . . ." name="father_alternative_phone"
                                value="{{ old('father_alternative_phone') ?? $student_father_profile->father_alternative_phone }}">
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Nationality --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_nationality" class="form-label">Nationality</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_nationality"
                                placeholder="Enter Father Nationality . . ." name="father_nationality"
                                value="{{ old('father_nationality') ?? $student_father_profile->father_nationality }}"
                                required>

                        </div>
                    </div>

                    {{-- National Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_national_number" class="form-label">National Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-id-card"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_national_number"
                                placeholder="Enter Father National Number . . ." name="father_national_number"
                                value="{{ old('father_national_number') ?? $student_father_profile->father_national_number }}"
                                required>
            
                        </div>
                    </div>

                {{-- Upload Image --}}
                <div class="col-md-2 mt-4">
                    @if ($student_father_profile->father_image !== null)
                        <div class="form-group">
                            <img class="image-fload" width="100%" height="100%"
                                src='{{ asset("uploads/$student_father_profile->father_image") }}'
                                alt="{{ $student_father_profile->father_name }}">
                        </div>
                    @else
                        <br>
                        <p class="filelabel">No Father Image</p>
                    @endif
                </div>
                <div class="col-md-2 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            Upload Image
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="father_image" type="file" />
                    </label>
                </div>

                    {{-- Date of Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_dob" class="form-label">Date Of Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="father_dob"
                                placeholder="Enter Father Date of Birth . . ." name="father_dob"
                                value="{{ old('father_dob') ?? $student_father_profile->father_dob }}" required>
                    
                        </div>
                    </div>

                    {{-- Father Job --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_job" class="form-label">Father Job</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_job"
                                placeholder="Enter Father Job . . ." name="father_job"
                                value="{{ old('father_job') ?? $student_father_profile->father_job }}" required>
                      
                        </div>
                    </div>

                    {{-- Degree Of Kinship --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_degree_of_kinship" class="form-label">Degree Of Kinship</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_degree_of_kinship"
                                placeholder="Enter Degree Of Kinship . . ." name="father_degree_of_kinship"
                                value="{{ old('father_degree_of_kinship') ?? $student_father_profile->father_degree_of_kinship }}"
                                required>
                           
                          
                        </div>
                    </div>

                    {{-- Marital Status --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_marital_status" class="form-label">Marital Status</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="father_marital_status"
                                name="father_marital_status" required>
                                <option value="">-- Please choose an option --</option>
                                <option value="Single"
                                    @if (old('father_marital_status') == null) {{ $student_father_profile->father_marital_status == 'Single' ? 'selected' : '' }} @else {{ old('father_marital_status') == 'Single' ? 'selected' : '' }} @endif>
                                    Single</option>
                                <option value="Married"
                                    @if (old('father_marital_status') == null) {{ $student_father_profile->father_marital_status == 'Married' ? 'selected' : '' }} @else {{ old('father_marital_status') == 'Married' ? 'selected' : '' }} @endif>
                                    Married</option>
                                <option value="Divorced"
                                    @if (old('father_marital_status') == null) {{ $student_father_profile->father_marital_status == 'Divorced' ? 'selected' : '' }} @else {{ old('father_marital_status') == 'Divorced' ? 'selected' : '' }} @endif>
                                    Divorced</option>
                            </select>
                      
                        </div>
                    </div>

                </div>

            </div>



            {{-- Address Info --}}
            <div class="tab-pane fade show px-3" id="pills-address-primary" role="tabpanel"
                aria-labelledby="pills-address-primary-tab">

                <div class="row">

                    {{-- Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_address" class="form-label">Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_address"
                                aria-describedby="father_address" placeholder="Enter Father Address ..."
                                name="father_address"
                                value="{{ old('father_address') ?? $student_father_profile->father_address }}">
                     
                        </div>
                    </div>

                    {{-- City --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_city" class="form-label">City</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_city"
                                aria-describedby="father_city" placeholder="Enter Father City ..." name="father_city"
                                value="{{ old('father_city') ?? $student_father_profile->father_city }}">
                   
                        </div>
                    </div>

                    {{-- State --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_state" class="form-label">State</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_state"
                                aria-describedby="father_state" placeholder="Enter Father State ..." name="father_state"
                                value="{{ old('father_state') ?? $student_father_profile->father_state }}">
                           
                        </div>
                    </div>

                    {{-- Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_country" class="form-label">Country</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_country"
                                aria-describedby="father_country" placeholder="Enter Father Country ..."
                                name="father_country"
                                value="{{ old('father_country') ?? $student_father_profile->father_country }}">
                     
                        </div>
                    </div>

                    {{-- Landmark --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_landmark" class="form-label">Landmark</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_landmark"
                                aria-describedby="father_landmark" placeholder="Enter Father Landmark ..."
                                name="father_landmark"
                                value="{{ old('father_landmark') ?? $student_father_profile->father_landmark }}">
                    
                        </div>
                    </div>


                </div>
            </div>



            {{-- Socail Links --}}
            <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel"
                aria-labelledby="pills-social-links-tab">

                <div class="row">

                    {{-- FaceBook Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_fb_link" class="form-label">FaceBook Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="father_fb_link"
                                placeholder="Enter Father FaceBook Link ..." name="father_fb_link"
                                value="{{ old('father_fb_link') ?? $student_father_profile->father_fb_link }}">
                     
                        </div>
                    </div>

                    {{-- Twitter Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_twitter_link" class="form-label">Twitter Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="father_twitter_link"
                                placeholder="Enter Father Twitter Link ..." name="father_twitter_link"
                                value="{{ old('father_twitter_link') ?? $student_father_profile->father_twitter_link }}">
                        
                        </div>
                    </div>

                    {{-- Social Media Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_social_media_1" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="father_social_media_1"
                                placeholder="Enter Father Social Media Link ..." name="father_social_media_1"
                                value="{{ old('father_social_media_1') ?? $student_father_profile->father_social_media_1 }}">
                         
                        </div>
                    </div>

                    {{-- Social Media Link 2 --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_social_media_2" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="father_social_media_2"
                                placeholder="Enter Father Social Media Link ..." name="father_social_media_2"
                                value="{{ old('father_social_media_2') ?? $student_father_profile->father_social_media_2 }}">
                     
                        </div>
                    </div>


                </div>
            </div>


            {{-- Education Info --}}
            <div class="tab-pane fade show px-3" id="pills-education-primary" role="tabpanel"
                aria-labelledby="pills-education-primary-tab">

                <div class="row">

                    {{-- Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_qualification" class="form-label">Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="father_qualification"
                                name="father_qualification" required>
                                <option value="Bachelor"
                                    @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == 'Bachelor' ? 'selected' : '' }} @else {{ old('father_qualification') == 'Bachelor' ? 'selected' : '' }} @endif>
                                    Bachelor</option>
                                <option value="Diploma"
                                    @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == 'Diploma' ? 'selected' : '' }} @else {{ old('father_qualification') == 'Diploma' ? 'selected' : '' }} @endif>
                                    Diploma</option>
                                <option value="Phd"
                                    @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == 'Phd' ? 'selected' : '' }} @else {{ old('father_qualification') == 'Phd' ? 'selected' : '' }} @endif>
                                    Phd</option>
                                <option value="Other"
                                    @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == 'Other' ? 'selected' : '' }} @else {{ old('father_qualification') == 'Other' ? 'selected' : '' }} @endif>
                                    Other</option>
                            </select>
                          
                        </div>
                    </div>
                    {{-- If other selected show the other qualification --}}
                    {{-- Other Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_qualification_other" class="form-label">Other Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_qualification_other"
                                aria-describedby="father_qualification_other"
                                placeholder="Enter Father Other Qualification ..." name="father_qualification_other"
                                value="{{ old('father_qualification_other') ?? $student_father_profile->father_qualification_other }}">
                         
                        </div>
                    </div>

                    {{-- Wedding Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_wedding_date" class="form-label">Wedding Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="father_wedding_date"
                                placeholder="Enter Father Wedding Date . . ." name="father_wedding_date"
                                value="{{ old('father_wedding_date') ?? $student_father_profile->father_wedding_date }}"
                                required>
                          
                        </div>
                    </div>

                    {{-- Interests --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_interests" class="form-label">Interests</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_interests"
                                aria-describedby="father_interests" placeholder="Enter Father Interests ..."
                                name="father_interests"
                                value="{{ old('father_interests') ?? $student_father_profile->father_interests }}">
                      
                        </div>
                    </div>

                    {{-- Father Age At Student Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_age_at_student_birth" class="form-label">Father Age At Student Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_age_at_student_birth"
                                aria-describedby="father_age_at_student_birth"
                                placeholder="Enter Father Age At Student Birth ..." name="father_age_at_student_birth"
                                value="{{ old('father_age_at_student_birth') ?? $student_father_profile->father_age_at_student_birth }}">
                         
                        </div>
                    </div>

                    {{-- Father Relation With Child --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_relation_with_child" class="form-label">Father Relation With Child</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_relation_with_child"
                                aria-describedby="father_relation_with_child"
                                placeholder="Enter Father Relation With Child ..." name="father_relation_with_child"
                                value="{{ old('father_relation_with_child') ?? $student_father_profile->father_relation_with_child }}">
                          
                        </div>
                    </div>

                    {{-- Student Attitudes Towards Parent --}}
                    <div class="col-md-4 mt-4">
                        <label for="father_attitudes_towards_parent" class="form-label">Student Attitudes Towards
                            Parent</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="father_attitudes_towards_parent"
                                aria-describedby="father_attitudes_towards_parent"
                                placeholder="Enter Student Attitudes Towards Parent ..."
                                name="father_attitudes_towards_parent"
                                value="{{ old('father_attitudes_towards_parent') ?? $student_father_profile->father_attitudes_towards_parent }}">
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>


        <div class="col-12">
            <button class="btn btn-outline-primary" type="submit">save</button>
        </div>

    </form>
@endsection
