@extends('layouts.app_layout')

@section('title')
Edit Trainer
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('updateFather' , $student_father_profile->id ) }}" enctype="multipart/form-data">
    @csrf
    <h2>Edit Father</h2>
    <div class="form-group">
      <label for="father_name">Full Name</label>
      <input type="text" class="form-control" id="father_name" aria-describedby="nameHelp" placeholder="Father Full Name" name="father_name" value="{{old('father_name') ?? $student_father_profile->father_name}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="father_email">Email</label>
      <input type="text" class="form-control" id="father_email" aria-describedby="father_email" placeholder="Email" name="father_email" value="{{old('father_email') ?? $student_father_profile->father_email}}" required>
      {{-- <small id="father_email" class="form-text text-muted">Email will be used .</small> --}}
    </div>
    
    <hr>
    <h2>More Informations</h2>
    
    <div class="form-group">
        <label for="father_address">Address</label>
        <input type="text" class="form-control" id="father_address" placeholder="Address" name="father_address" value="{{old('father_address') ?? $student_father_profile->father_address}}">
    </div>

    <div class="form-group">
        <label for="father_city">City</label>
        <input type="text" class="form-control" id="father_city" placeholder="City" name="father_city" value="{{old('father_city') ?? $student_father_profile->father_city}}">
    </div>

    <div class="form-group">
        <label for="father_state">State</label>
        <input type="text" class="form-control" id="father_state" placeholder="State" name="father_state" value="{{old('father_state') ?? $student_father_profile->father_state}}">
    </div>
    
    <div class="form-group">
        <label for="father_country">Country</label>
        <input type="text" class="form-control" id="father_country" placeholder="Country" name="father_country" value="{{old('father_country') ?? $student_father_profile->father_country}}">
    </div>
    
    <div class="form-group">
        <label for="father_landmark">Landmark</label>
        <input type="text" class="form-control" id="father_landmark" placeholder="Landmark" name="father_landmark" value="{{old('father_landmark') ?? $student_father_profile->father_landmark}}">
    </div>
    
    <div class="form-group">
        <label for="father_phone">Phone</label>
        <input type="number" class="form-control" id="father_phone" placeholder="Phone" name="father_phone" value="{{old('father_phone') ?? $student_father_profile->father_phone}}">
    </div>

    <div class="form-group">
        <label for="father_alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="father_alternative_phone" placeholder="Alternative Phone Number" name="father_alternative_phone" value="{{old('father_alternative_phone') ?? $student_father_profile->father_alternative_phone}}">
    </div>
    
    <div class="form-group">
        <label for="father_nationality">Nationality</label>
        <input type="text" class="form-control" id="father_nationality" placeholder="Nationality" name="father_nationality" value="{{old('father_nationality') ?? $student_father_profile->father_nationality}}">
    </div>
    
    <div class="form-group">
        <label for="father_national_number">National Number</label>
        <input type="number" class="form-control" id="father_national_number" placeholder="National Number" name="father_national_number" value="{{old('father_national_number') ?? $student_father_profile->father_national_number}}">
    </div>
    
    <div class="form-group">
        <label for="father_dob">Date Of Birth</label>
        <input type="date" class="form-control" id="father_dob" placeholder="Date Of Birth" name="father_dob" value="{{old('father_dob') ?? $student_father_profile->father_dob}}">
    </div>
    
    @if ($student_father_profile->father_image !== null)
    <div class="form-group">
        <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$student_father_profile->father_image") }}' alt="{{$student_father_profile->father_name}}">   
    </div>
    @endif

    <div class="form-group">
        <label for="father_image">Upload Image</label>
        <input type="file" name="father_image" id="father_image" >
    </div>
    
    {{-- <div class="form-group">
        <label for="gender">Gender</label>
        <select class="form-control" id="gender" name="gender">
            <option value="male" {{ old('gender') == "male" ? 'selected' : '' }}>Male</option>
            <option value="female" {{ old('gender') == "female" ? 'selected' : '' }}>Female</option>
        </select>
    </div> --}}
    
    {{-- <div class="form-group">
        <label for="marital_status">Marital Status</label>
        <select class="form-control" id="marital_status" name="marital_status">
            <option value="single" {{ old('marital_status') == "single" ? 'selected' : '' }}>Single</option>
            <option value="married" {{ old('marital_status') == "married" ? 'selected' : '' }}>Married</option>
            <option value="divorced" {{ old('marital_status') == "divorced" ? 'selected' : '' }}>Divorced</option>
        </select>
    </div> --}}
    
    <div class="form-group">
        <label for="father_job">Job</label>
        <input type="text" class="form-control" id="father_job" placeholder="Job" name="father_job" value="{{old('father_job') ?? $student_father_profile->father_job}}">
    </div>
    
    <div class="form-group">
        <label for="father_degree_of_kinship">Degree Of Kinship</label>
        <input type="text" class="form-control" id="father_degree_of_kinship" placeholder="Degree Of Kinship" name="father_degree_of_kinship" value="{{old('father_degree_of_kinship') ?? $student_father_profile->father_degree_of_kinship}}">
    </div>
    
    <div class="form-group">
        <label for="father_fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="father_fb_link" placeholder="FaceBook Link" name="father_fb_link" value="{{old('father_fb_link') ?? $student_father_profile->father_fb_link}}">
    </div>
    
    <div class="form-group">
        <label for="father_twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="father_twitter_link" placeholder="Twitter Link" name="father_twitter_link" value="{{old('father_twitter_link') ?? $student_father_profile->father_twitter_link}}">
    </div>
    
    <div class="form-group">
        <label for="father_social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="father_social_media_1" placeholder="Social Media Link" name="father_social_media_1" value="{{old('father_social_media_1') ?? $student_father_profile->father_social_media_1}}">
    </div>
    
    <div class="form-group">
        <label for="father_social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="father_social_media_2" placeholder="Social Media Link" name="father_social_media_2" value="{{old('father_social_media_2') ?? $student_father_profile->father_social_media_2}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="father_qualification">Qualification</label>
        <select class="form-control" id="father_qualification" name="father_qualification">
            <option value="Bachelor" @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == "Bachelor" ? 'selected' : '' }} @else {{ old('father_qualification') == "Bachelor" ? 'selected' : '' }} @endif >Bachelor</option>
            <option value="Diploma" @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == "Diploma" ? 'selected' : '' }} @else {{ old('father_qualification') == "Diploma" ? 'selected' : '' }} @endif >Diploma</option>
            <option value="Phd" @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == "Phd" ? 'selected' : '' }} @else {{ old('father_qualification') == "Phd" ? 'selected' : '' }} @endif >Phd</option>
            <option value="Other" @if (old('father_qualification') == null) {{ $student_father_profile->father_qualification == "Other" ? 'selected' : '' }} @else {{ old('father_qualification') == "Other" ? 'selected' : '' }} @endif >Other</option>
        </select>
    </div>
    {{-- If other selected show the other qualification --}}
    <div class="form-group">
        <label for="father_qualification_other">Other Qualification</label>
        <input type="text" class="form-control" id="father_qualification_other" placeholder="Other Qualification" name="father_qualification_other" value="{{old('father_qualification_other') ?? $student_father_profile->father_qualification_other}}">
    </div>
    
    <div class="form-group">
        <label for="father_wedding_date">Wedding Date</label>
        <input type="date" class="form-control" id="father_wedding_date" placeholder="Wedding Date" name="father_wedding_date" value="{{old('father_wedding_date') ?? $student_father_profile->father_wedding_date}}">
    </div>
    
    <div class="form-group">
        <label for="father_interests">Interests</label>
        <input type="text" class="form-control" id="father_interests" placeholder="Interests" name="father_interests" value="{{old('father_interests') ?? $student_father_profile->father_interests}}">
    </div>
    
    <div class="form-group">
        <label for="father_age_at_student_birth">Father Age At Student Birth</label>
        <input type="text" class="form-control" id="father_age_at_student_birth" placeholder="Father Age At Student Birth" name="father_age_at_student_birth" value="{{old('father_age_at_student_birth') ?? $student_father_profile->father_age_at_student_birth}}">
    </div>
    
    <div class="form-group">
        <label for="father_relation_with_child">Father Relation With Child</label>
        <input type="text" class="form-control" id="father_relation_with_child" placeholder="Father Relation With Child" name="father_relation_with_child" value="{{old('father_relation_with_child') ?? $student_father_profile->father_relation_with_child}}">
    </div>
    
    <div class="form-group">
        <label for="father_attitudes_towards_parent">Student Attitudes Towards Parent</label>
        <input type="text" class="form-control" id="father_attitudes_towards_parent" placeholder="Student Attitudes Towards Parent" name="father_attitudes_towards_parent" value="{{old('father_attitudes_towards_parent') ?? $student_father_profile->father_attitudes_towards_parent}}">
    </div>
    
    
    <button type="submit" class="btn btn-outline-primary mt-3">Submit</button>
</form>


<a href="{{ route('allTrainers') }}" class="btn btn-outline-primary mt-3">Back To All Trainers</a>

@endsection