<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title')</title>
    <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@200;300;400&family=Poppins:wght@200;300;400&display=swap" rel="stylesheet">
    <!-- <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css" /> -->

    <link rel="stylesheet" type="text/css" href="{{ asset('css/dataTables.bootstrap5.min.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ asset('css/buttons.dataTables.min.css') }}" />

    <link rel="stylesheet" href="{{ asset('css/all.min.css') }}">
    @if( Config::get('languages')[App::getLocale()] =="Arabic" )
    <link rel="stylesheet" href="{{ asset('css/bootstrap.rtl.min.css') }}">
    @else
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">

    @endif

    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/gif" sizes="16x16">
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/gif" sizes="18x18">
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/gif" sizes="20x20">

    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
    @if( Config::get('languages')[App::getLocale()] =="Arabic" )
    <link rel="stylesheet" href="{{ asset('css/style_ar.css') }}">
    @endif
    @yield('styles')
</head>

<body class="bg-light bg-gradient">

    @yield('layout')


    <script>
        var assetBaseUrl = "{{ asset('') }}";
    </script>
    <Script src="{{asset('js/jquery-3.6.0.min.js')}}"></Script>
    <Script src="{{asset('js/jquery.dataTables.min.js')}}"></Script>
    <Script src="{{asset('js/dataTables.bootstrap5.min.js')}}"></Script>
    <Script src="{{asset('js/dataTables.buttons.min.js')}}"></Script>
    <Script src="{{asset('js/jszip.min.js')}}"></Script>
    <Script src="{{asset('js/pdfmake.min.js')}}"></Script>
    <Script src="{{asset('js/vfs_fonts.js')}}"></Script>
    <Script src="{{asset('js/buttons.html5.min.js')}}"></Script>
    <Script src="{{asset('js/buttons.print.min.js')}}"></Script>
    <Script src="{{asset('js/bootstrap.bundle.min.js')}}"></Script>
    <!-- <Script src="{{asset('js/tinymce.min.js')}}" referrerpolicy="origin"></Script> -->
    <script src="https://cdn.tiny.cloud/1/0a0lx6zhkn9c5lloq7t8y1o1arjhhljo8xuya3qzza88z0jq/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <Script src="{{ asset('js/index.js') }}"></Script>
    @yield('scripts')
</body>

</html>