@extends('layouts.app')

@section('layout')
<nav class="navbar  navbar-expand-sm navbar-light bg-white shadow-sm fixed-top homenav offset-2 start-0">
    <div class="container-fluid">
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item" id="minmus">
                    <a class="nav-link" href="#">
                        <i class="fa-solid fa-hand-point-left border p-2 rounded-circle"></i>
                    </a>
                </li>

                <li class="nav-item fullScreen">
                    <a class="nav-link " href="#">
                        <i class="fa-solid fa-expand border p-2 rounded-circle "></i>
                    </a>
                </li>
                <li class="nav-item">

                    <input type="text" class="form-control rounded-pill m-2" placeholder="{{__('admin_horizontal_menu.search')}}">

                </li>



            </ul>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

                {{-- Language Switcher --}}
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        {{ Config::get('languages')[App::getLocale()] }}
                    </a>
                    <ul class="dropdown-menu">
                        @foreach (Config::get('languages') as $lang => $language)
                        @if ($lang != App::getLocale())
                        <li> <a class="dropdown-item" href="{{ route('lang.switch', $lang) }}"> {{$language}}</a></li>
                        @endif
                        @endforeach
                    </ul>
                </li>

                {{-- End Language Switcher --}}

                <li class="nav-item">
                    <a class="nav-link" href="#">
                        <i class="fa-solid fa-house border p-2 rounded-circle"></i>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#">
                        <i class="fa-solid fa-grip border p-2 rounded-circle"></i>
                    </a>
                </li>

                <li class="nav-item menu-dropdown-wrapper rounded">
                    <a class="nav-link " href="#">
                        <i class="fa-regular fa-user border p-2 rounded-circle"></i>
                    </a>
                    <div class="menu-dropdown menu-dropdown-right menu-dropdown-push-right">
                        <div class="arrow arrow-right"></div>
                        <div class="menu-dropdown-inner ">
                            <div class="menu-dropdown-head pb-3 bg-gradient">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="tbl-cell d-flex align-items-center">
                                            <i class="fa-regular fa-1x fa-user border p-2 rounded-circle me-2"></i>
                                        </div>

                                    </div>
                                    <div class="col-md">
                                        <div class="tbl-cell d-flex align-items-center">
                                            @auth
                                            <h4>{{ Auth::user()->full_name }}</h4>
                                            @endauth
                                            @guest
                                            <h4>Welcome Sir</h4>
                                            @endguest
                                        </div>
                                        <div class="tbl-cell d-flex align-items-center">
                                            @auth
                                            @if (Auth::user()->role == 'super_admin')
                                            <h5>{{__('admin_horizontal_menu.super_admin')}}</h5>
                                            @elseif (Auth::user()->role == 'owner')
                                            <h5>{{__('admin_horizontal_menu.owner')}}</h5>
                                            @elseif (Auth::user()->role == 'admin')
                                            <h5>{{__('admin_horizontal_menu.admin')}}</h5>
                                            @elseif (Auth::user()->role == 'trainer')
                                            <h5>{{__('admin_horizontal_menu.trainer')}}</h5>
                                            @endif
                                            @endauth
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="menu-dropdown-body">
                                <ul class="menu-nav navbar-nav flex-column">
                                    @auth
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('viewUser', Auth::user()->id) }}">
                                            <i class="fa-solid fa-address-card me-2 "></i>{{__('admin_horizontal_menu.visit_profile')}}</a>
                                    </li>
                                    @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('editUser', Auth::user()->id) }}">
                                            <i class="fa-solid fa-key me-2  "></i>{{__('admin_horizontal_menu.edit_profile')}}</a>
                                    </li>
                                    @endif
                                    @endauth
                                    @guest
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('authLogin') }}">
                                            <i class="fa-solid fa-key me-2  "></i>{{__('admin_horizontal_menu.login')}}</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('authRegister') }}">{{__('admin_horizontal_menu.register')}}</a>
                                    </li>
                                    @endguest
                                </ul>
                            </div>
                            @auth
                            <div class="menu-dropdown-footer text-end">
                                <a href="{{ route('authLogout') }}" class="btn btn-outline-primary  rounded-pill btn-sm">{{__('admin_horizontal_menu.logout')}}</a>
                            </div>
                            @endauth
                        </div>
                    </div>
                </li>


            </ul>

        </div>
    </div>
</nav>

{{-- <div class="d-flex" id="navbarSupportedContent">
        <div class="col-2 vh-100 sidebar navbar-dark position-fixed">
            <div class="text-center m-3" id="logo"> <a href="#" class="navbar-brand ">

                    <img src="{{ asset('assets/white logo.png') }}" class="w-75" alt="">
</a></div>

<ul class="navbar-nav justify-content-end flex-grow-1 text-capitalize">
    @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
    <li class="nav-item">

        <a class="nav-link {{ Route::is('allUsers', 'viewUser', 'searchUsers', 'createUser', 'storeUser', 'editUser', 'updateUserPassword', 'deleteUser') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allUsers') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-user-group ms-2"></i> users</a>
    </li>
    @endif
    <li class="nav-item">

        <a class="nav-link {{ Route::is('allStudents', 'viewStudent', 'searchStudents', 'createStudent', 'storeStudent', 'editStudent', 'updateStudent', 'deleteStudent', 'takeStudentAssignment', 'createStudentAssignment', 'storeStudentAssignment') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allStudents') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-user-graduate ms-2"></i> students</a>
    </li>
    @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allBusinessLocations', 'viewBusinessLocation', 'searchBusinessLocations', 'createBusinessLocation', 'storeBusinessLocation', 'editBusinessLocation', 'updateBusinessLocation', 'deleteBusinessLocation') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allBusinessLocations') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-briefcase ms-2"></i>business locations</a>
    </li>
    @endif
    @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin')
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allTrainers', 'viewTrainer', 'searchTrainers', 'createTrainer', 'storeTrainer', 'editTrainer', 'updateTrainer', 'updateTrainerPassword', 'deleteTrainer') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allTrainers') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-user-tag"></i> trainers</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allFathers', 'viewFather', 'searchFathers', 'createFather', 'storeFather', 'editFather', 'updateFather', 'deleteFather') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allFathers') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-user"></i> fathers</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allMothers', 'viewMother', 'searchMothers', 'createMother', 'storeMother', 'editMother', 'updateMother', 'deleteMother') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allMothers') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-user"></i> mothers</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allSuperiors', 'viewSuperior', 'searchSuperiors', 'createSuperior', 'storeSuperior', 'editSuperior', 'updateSuperior', 'deleteSuperior') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allSuperiors') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-school "></i> superiors</a>
    </li>
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allQuestions', 'viewQuestion', 'searchQuestions', 'createQuestion', 'storeQuestion', 'editQuestion', 'updateQuestion', 'deleteQuestion') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allQuestions') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-file-code"></i> questions</a>
    </li>
    @endif
    <li class="nav-item">
        <a class="nav-link {{ Route::is('allAssignments', 'viewAssignment', 'searchAssignments', 'createAssignment', 'storeAssignment', 'editAssignment', 'updateAssignment', 'deleteAssignment') ? 'active text-custome fw-bolder' : '' }}" href="{{ route('allAssignments') }}">
            <span class="shape1"></span>


</ul>

</div>
</div> --}}
<div class="d-flex" id="navbarSupportedContent">
    <div class="col-2 vh-100 sidebar navbar-dark position-fixed">
        <div class="text-center m-3" id="logo"> <a href="#" class="navbar-brand ">

                <img src="{{ asset('assets/white logo.png') }}" class="w-75" alt="">
            </a></div>

        <ul class="navbar-nav justify-content-end flex-grow-1 text-capitalize">
            @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
            <li class="nav-item">

                <a class="nav-link {{ Route::is('dashboard') ? 'active text-custome' : '' }}" href="{{ route('dashboardIndex') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-tachometer col-1"></i>{{__('admin_vertical_menu.dashboard')}}</a>
            </li>
            @endif
            @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
            <li class="nav-item">

                <a class="nav-link {{ Route::is('allUsers', 'viewUser', 'searchUsers', 'createUser', 'storeUser', 'editUser', 'updateUserPassword', 'deleteUser') ? 'active text-custome' : '' }}" href="{{ route('allUsers') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-user-group col-1"></i>{{__('admin_vertical_menu.users')}}</a>
            </li>
            @endif
            <li class="nav-item">

                <a class="nav-link {{ Route::is('allStudents', 'viewStudent', 'searchStudents', 'createStudent', 'storeStudent', 'editStudent', 'updateStudent', 'deleteStudent', 'takeStudentAssignment', 'createStudentAssignment', 'storeStudentAssignment') ? 'active text-custome' : '' }}" href="{{ route('allStudents') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-user-graduate col-1"></i>{{__('admin_vertical_menu.students')}}</a>
            </li>
            @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allBusinessLocations', 'viewBusinessLocation', 'searchBusinessLocations', 'createBusinessLocation', 'storeBusinessLocation', 'editBusinessLocation', 'updateBusinessLocation', 'deleteBusinessLocation') ? 'active text-custome' : '' }}" href="{{ route('allBusinessLocations') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-briefcase col-1"></i>{{__('admin_vertical_menu.business_locations')}}</a>
            </li>
            @endif
            @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin')
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allTrainers', 'viewTrainer', 'searchTrainers', 'createTrainer', 'storeTrainer', 'editTrainer', 'updateTrainer', 'updateTrainerPassword', 'deleteTrainer') ? 'active text-custome' : '' }}" href="{{ route('allTrainers') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-user-tag col-1"></i>{{__('admin_vertical_menu.trainers')}}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allFathers', 'viewFather', 'searchFathers', 'createFather', 'storeFather', 'editFather', 'updateFather', 'deleteFather') ? 'active text-custome' : '' }}" href="{{ route('allFathers') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-user col-1"></i>{{__('admin_vertical_menu.fathers')}}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allMothers', 'viewMother', 'searchMothers', 'createMother', 'storeMother', 'editMother', 'updateMother', 'deleteMother') ? 'active text-custome' : '' }}" href="{{ route('allMothers') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-user col-1"></i>{{__('admin_vertical_menu.mothers')}}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allSuperiors', 'viewSuperior', 'searchSuperiors', 'createSuperior', 'storeSuperior', 'editSuperior', 'updateSuperior', 'deleteSuperior') ? 'active text-custome' : '' }}" href="{{ route('allSuperiors') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-school col-1 "></i>{{__('admin_vertical_menu.superiors')}}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allQuestions', 'viewQuestion', 'searchQuestions', 'createQuestion', 'storeQuestion', 'editQuestion', 'updateQuestion', 'deleteQuestion') ? 'active text-custome' : '' }}" href="{{ route('allQuestions') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-file-code col-1"></i>{{__('admin_vertical_menu.questions')}}</a>
            </li>
            @endif
            <li class="nav-item">
                <a class="nav-link {{ Route::is('allAssignments', 'viewAssignment', 'searchAssignments', 'createAssignment', 'storeAssignment', 'editAssignment', 'updateAssignment', 'deleteAssignment') ? 'active text-custome' : '' }}" href="{{ route('allAssignments') }}">
                    <span class="shape1"></span>

                    <i class="fa-solid fa-file-lines col-1"></i>{{__('admin_vertical_menu.assignments')}}</a>
            </li>
            {{-- <li class="nav-item">
                    <a class="nav-link {{ Route::is('allSubmissions', 'viewSubmission', 'createSubmission', 'storeSubmission', 'editSubmission', 'updateSubmission', 'deleteSubmission') ? 'active text-custome' : '' }}"
            href="{{ route('allSubmissions') }}">
            <span class="shape1"></span>

            <i class="fa-solid fa-file-arrow-up col-1"></i>{{__('admin_vertical_menu.submissions')}}</a>
            </li> --}}

        </ul>

    </div>

    <div class="col-10 my-5 py-5 offset-2 content">
        <div class="container-md">
            @yield('content')
        </div>
    </div>
</div>
</nav>

{{-- <div class="outBox  d-flex position-fixed  col-2 align-items-start">
        <div class="cog col-2  text-center p-1 rounded-start">

            <i class="fa-solid fa-gear fa-2x  text-white fa-spin "></i>
        </div>
        <div class="innerBox  flex-wrap p-4 col-10 d-flex align-items-center rounded-bottom">
            <h6>Choose Your Color </h6>
            <div class="box  " style="background-color: #43a047"></div>
            <div class="box  " style="background-color: #d81b60"></div>
            <div class="box " style="background-color: #ff9510"></div>
            <div class="box " style="background-color: #703aca"></div>
            <div class="box " style="background-color: #006492"></div>
            <div class="box " style="background-color: #4b6875"></div>
            <div class="box " style="background-color: #ff9800"></div>
            <div class="box " style="background-color: #4caf50"></div>
            <div class="box " style="background-color: #e91e63"></div>
            <div class="box " style="background-color: #607d8b"></div>
        </div> 

    </div> --}}
@endsection