@extends('layouts.app_layout')

@section('content')
@include('inc.errors')
@if (session('message'))
<h6 class="alert alert-success">
    {{ session('message') }}
</h6>
@endif

<div class="px-3">
    <div class="row align-items-center">
        <div class="col-sm-12">
            <h5 class="page-title-text d-inline-block">@yield('form-title')</h5>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="{{ route('dashboardIndex') }}">{{__('common.home')}}</a></li>
                    @yield('form-navigation')
                </ul>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="breadcrumbs d-inline-block">
                @yield('form-questions')
            </div>
        </div>
    </div>

    @yield('form')
    <div class=" bg-white rounded shadow-sm p-3 my-4">
        <ul class="navsTabs nav nav-pills mt-3 border-bottom"  role="tablist">
            @yield('form-tabs-li')
        </ul>
        <div class="row tab-content" id="pills-tabContent">
            @yield('form-tabs-content')
        </div>
    </div>
    
    @yield('form-model')
</div>

@endsection