@extends('layouts.app_layout')

@section('title')
Add Mother
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('storeMother') }}" enctype="multipart/form-data">
    @csrf
    <h2>Add Mother</h2>
    <div class="form-group">
      <label for="mother_name">Full Name</label>
      <input type="text" class="form-control" id="mother_name" aria-describedby="nameHelp" placeholder="Mother Full Name" name="mother_name" value="{{old('mother_name')}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="mother_email">Email</label>
      <input type="text" class="form-control" id="mother_email" aria-describedby="mother_email" placeholder="Email" name="mother_email" value="{{old('mother_email')}}" required>
      {{-- <small id="mother_email" class="form-text text-muted">Email will be used .</small> --}}
    </div>
    
    <hr>
    <h2>More Informations</h2>
    
    <div class="form-group">
        <label for="mother_address">Address</label>
        <input type="text" class="form-control" id="mother_address" placeholder="Address" name="mother_address" value="{{old('mother_address')}}">
    </div>

    <div class="form-group">
        <label for="mother_city">City</label>
        <input type="text" class="form-control" id="mother_city" placeholder="City" name="mother_city" value="{{old('mother_city')}}">
    </div>

    <div class="form-group">
        <label for="mother_state">State</label>
        <input type="text" class="form-control" id="mother_state" placeholder="State" name="mother_state" value="{{old('mother_state')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_country">Country</label>
        <input type="text" class="form-control" id="mother_country" placeholder="Country" name="mother_country" value="{{old('mother_country')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_landmark">Landmark</label>
        <input type="text" class="form-control" id="mother_landmark" placeholder="Landmark" name="mother_landmark" value="{{old('mother_landmark')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_phone">Phone</label>
        <input type="number" class="form-control" id="mother_phone" placeholder="Phone" name="mother_phone" value="{{old('mother_phone')}}">
    </div>

    <div class="form-group">
        <label for="mother_alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="mother_alternative_phone" placeholder="Alternative Phone Number" name="mother_alternative_phone" value="{{old('mother_alternative_phone')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_nationality">Nationality</label>
        <input type="text" class="form-control" id="mother_nationality" placeholder="Nationality" name="mother_nationality" value="{{old('mother_nationality')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_national_number">National Number</label>
        <input type="number" class="form-control" id="mother_national_number" placeholder="National Number" name="mother_national_number" value="{{old('mother_national_number')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_dob">Date Of Birth</label>
        <input type="date" class="form-control" id="mother_dob" placeholder="Date Of Birth" name="mother_dob" value="{{old('mother_dob')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_image">Upload Image</label>
        <input type="file" name="mother_image" id="mother_image" >
    </div>
        
    <div class="form-group">
        <label for="mother_job">Job</label>
        <input type="text" class="form-control" id="mother_job" placeholder="Job" name="mother_job" value="{{old('mother_job')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_degree_of_kinship">Degree Of Kinship</label>
        <input type="text" class="form-control" id="mother_degree_of_kinship" placeholder="Degree Of Kinship" name="mother_degree_of_kinship" value="{{old('mother_degree_of_kinship')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="mother_fb_link" placeholder="FaceBook Link" name="mother_fb_link" value="{{old('mother_fb_link')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="mother_twitter_link" placeholder="Twitter Link" name="mother_twitter_link" value="{{old('mother_twitter_link')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="mother_social_media_1" placeholder="Social Media Link" name="mother_social_media_1" value="{{old('mother_social_media_1')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="mother_social_media_2" placeholder="Social Media Link" name="mother_social_media_2" value="{{old('mother_social_media_2')}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="mother_qualification">Qualification</label>
        <select class="form-control" id="mother_qualification" name="mother_qualification">
            <option value="Bachelor" {{ old('mother_qualification') == "Bachelor" ? 'selected' : '' }}>Bachelor</option>
            <option value="Diploma" {{ old('mother_qualification') == "Diploma" ? 'selected' : '' }}>Diploma</option>
            <option value="Phd" {{ old('mother_qualification') == "Phd" ? 'selected' : '' }}>Phd</option>
            <option value="Other" {{ old('mother_qualification') == "Other" ? 'selected' : '' }}>Other</option>
        </select>
    </div>
    {{-- If other selected show the other qualification --}}
    <div class="form-group">
        <label for="mother_qualification_other">Other Qualification</label>
        <input type="text" class="form-control" id="mother_qualification_other" placeholder="Other Qualification" name="mother_qualification_other" value="{{old('mother_qualification_other')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_wedding_date">Wedding Date</label>
        <input type="date" class="form-control" id="mother_wedding_date" placeholder="Wedding Date" name="mother_wedding_date" value="{{old('mother_wedding_date')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_interests">Interests</label>
        <input type="text" class="form-control" id="mother_interests" placeholder="Interests" name="mother_interests" value="{{old('mother_interests')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_age_at_student_birth">Mother Age At Student Birth</label>
        <input type="text" class="form-control" id="mother_age_at_student_birth" placeholder="Mother Age At Student Birth" name="mother_age_at_student_birth" value="{{old('mother_age_at_student_birth')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_relation_with_child">Mother Relation With Child</label>
        <input type="text" class="form-control" id="mother_relation_with_child" placeholder="Mother Relation With Child" name="mother_relation_with_child" value="{{old('mother_relation_with_child')}}">
    </div>
    
    <div class="form-group">
        <label for="mother_attitudes_towards_parent">Student Attitudes Towards Parent</label>
        <input type="text" class="form-control" id="mother_attitudes_towards_parent" placeholder="Student Attitudes Towards Parent" name="mother_attitudes_towards_parent" value="{{old('mother_attitudes_towards_parent')}}">
    </div>
        

    {{-- If Gender Female has been selected --}}
    <div class="form-group">
        <label for="mother_pregnancy_number">Mother Pregnancy Number</label>
        <input type="text" class="form-control" id="mother_pregnancy_number" placeholder="Mother Pregnancy Number" name="mother_pregnancy_number" value="{{old('mother_pregnancy_number')}}">
    </div>
    {{-- If Gender Female has been selected --}}
    <div class="form-group">
        <label for="mother_miscarriages_number">Mother Miscarriages Number</label>
        <input type="text" class="form-control" id="mother_miscarriages_number" placeholder="Mother Miscarriages Number" name="mother_miscarriages_number" value="{{old('mother_miscarriages_number')}}">
    </div>
    
    <button type="submit" class="btn btn-outline-primary mt-3">Submit</button>
</form>


<a href="{{ route('allMothers') }}" class="btn btn-info mt-3">Back To All Mothers</a>


@endsection