@extends('layouts.form')

@section('title')
    Edit Mother
@endsection

@section('form-title')
    Edit Mother
@endsection

@section('form-navigation')
    <li><a class="text-decoration-none" href="{{ route('allMothers') }}">List Mothers </a></li>
    <li>Edit Mother - {{ $student_mother_profile->mother_name }}</li>
@endsection

@section('form-tabs-li')
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-info-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-info"
            type="button" role="tab" aria-controls="pills-basic-info" aria-selected="true">Basic Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-address-info-tab" data-bs-toggle="pill" data-bs-target="#pills-address-info"
            type="button" role="tab" aria-controls="pills-address-info" aria-selected="false">Address Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links"
            type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">Social Links</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-education-info-tab" data-bs-toggle="pill"
            data-bs-target="#pills-education-info" type="button" role="tab" aria-controls="pills-education-info"
            aria-selected="false">Education Info</button>
    </li>
@endsection

@section('form-tabs-content')
    <form class="needs-validation" method="POST" action="{{ route('updateMother', $student_mother_profile->id) }}"
        enctype="multipart/form-data">
        @csrf

        <div class="tab-content" id="pills-tabContent">
            {{-- Basic Info Group --}}
            <div class="tab-pane fade show active px-3" id="pills-basic-info" role="tabpanel"
                aria-labelledby="pills-basic-info-tab">

                {{-- <form class="row g-3 needs-validation flex-row-reverse text-end" novalidate> --}}
                <div class="row">

                    {{-- Full Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_name" class="form-label">Full Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_name" aria-describedby="nameHelp"
                                placeholder="Enter Mother Full Name ..." name="mother_name"
                                value="{{ old('mother_name') ?? $student_mother_profile->mother_name }}" required>
                      
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_email" class="form-label">Email Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_email"
                                aria-describedby="mother_email" placeholder="Enter Mother Email Address ..."
                                name="mother_email"
                                value="{{ old('mother_email') ?? $student_mother_profile->mother_email }}" required>
                         
                        </div>
                    </div>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_phone" class="form-label">Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_phone"
                                placeholder="Enter Mother Mobile Number . . ." name="mother_phone"
                                value="{{ old('mother_phone') ?? $student_mother_profile->mother_phone }}" required>
                            
                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_alternative_phone" class="form-label">Alternative Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_alternative_phone"
                                placeholder="Enter Mother Alternative Mobile Number . . ." name="mother_alternative_phone"
                                value="{{ old('mother_alternative_phone') ?? $student_mother_profile->mother_alternative_phone }}">
                   
                        </div>
                    </div>

                    {{-- Nationality --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_nationality" class="form-label">Nationality</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_nationality"
                                placeholder="Enter Mother Nationality . . ." name="mother_nationality"
                                value="{{ old('mother_nationality') ?? $student_mother_profile->mother_nationality }}"
                                required>
                      

                        </div>
                    </div>

                    {{-- National Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_national_number" class="form-label">National Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_national_number"
                                placeholder="Enter Mother National Number . . ." name="mother_national_number"
                                value="{{ old('mother_national_number') ?? $student_mother_profile->mother_national_number }}"
                                required>
                         
                        </div>
                    </div>

                {{-- Upload Image --}}
                <div class="col-md-2 mt-4">
                    @if ($student_mother_profile->mother_image !== null)
                        <div class="form-group">
                            <img class="image-fload" width="100%" height="100%"
                                src='{{ asset("uploads/$student_mother_profile->mother_image") }}'
                                alt="{{ $student_mother_profile->mother_name }}">
                        </div>
                    @else
                        <br>
                        <p class="filelabel">No Mother Image</p>
                    @endif
                </div>
                <div class="col-md-2 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            Upload Image
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="mother_image" type="file" />
                    </label>
                </div>

                    {{-- Date of Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_dob" class="form-label">Date Of Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="mother_dob"
                                placeholder="Enter Mother Date of Birth . . ." name="mother_dob"
                                value="{{ old('mother_dob') ?? $student_mother_profile->mother_dob }}" required>
                        
                        </div>
                    </div>

                    {{-- Mother Job --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_job" class="form-label">Mother Job</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_job"
                                placeholder="Enter Mother Job . . ." name="mother_job"
                                value="{{ old('mother_job') ?? $student_mother_profile->mother_job }}" required>
                 
                        </div>
                    </div>

                    {{-- Degree Of Kinship --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_degree_of_kinship" class="form-label">Degree Of Kinship</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_degree_of_kinship"
                                placeholder="Enter Degree Of Kinship . . ." name="mother_degree_of_kinship"
                                value="{{ old('mother_degree_of_kinship') ?? $student_mother_profile->mother_degree_of_kinship }}"
                                required>
                          
                        </div>
                    </div>

                    {{-- Marital Status --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_marital_status" class="form-label">Marital Status</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="mother_marital_status"
                                name="mother_marital_status" required>
                                <option value="">-- Please choose an option --</option>
                                <option value="Single"
                                    @if (old('mother_marital_status') == null) {{ $student_mother_profile->mother_marital_status == 'Single' ? 'selected' : '' }} @else {{ old('mother_marital_status') == 'Single' ? 'selected' : '' }} @endif>
                                    Single</option>
                                <option value="Married"
                                    @if (old('mother_marital_status') == null) {{ $student_mother_profile->mother_marital_status == 'Married' ? 'selected' : '' }} @else {{ old('mother_marital_status') == 'Married' ? 'selected' : '' }} @endif>
                                    Married</option>
                                <option value="Divorced"
                                    @if (old('mother_marital_status') == null) {{ $student_mother_profile->mother_marital_status == 'Divorced' ? 'selected' : '' }} @else {{ old('mother_marital_status') == 'Divorced' ? 'selected' : '' }} @endif>
                                    Divorced</option>
                            </select>
           
                        </div>
                    </div>

                </div>

            </div>

            {{-- Address Info --}}
            <div class="tab-pane fade show px-3" id="pills-address-info" role="tabpanel"
                aria-labelledby="pills-address-info-tab">

                <div class="row">

                    {{-- Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_address" class="form-label">Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_address"
                                aria-describedby="mother_address" placeholder="Enter Mother Address ..."
                                name="mother_address"
                                value="{{ old('mother_address') ?? $student_mother_profile->mother_address }}">
                         
                        </div>
                    </div>

                    {{-- City --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_city" class="form-label">City</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_city"
                                aria-describedby="mother_city" placeholder="Enter Mother City ..." name="mother_city"
                                value="{{ old('mother_city') ?? $student_mother_profile->mother_city }}">
                           
                        </div>
                    </div>

                    {{-- State --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_state" class="form-label">State</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_state"
                                aria-describedby="mother_state" placeholder="Enter Mother State ..." name="mother_state"
                                value="{{ old('mother_state') ?? $student_mother_profile->mother_state }}">
                    
                        </div>
                    </div>

                    {{-- Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_country" class="form-label">Country</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_country"
                                aria-describedby="mother_country" placeholder="Enter Mother Country ..."
                                name="mother_country"
                                value="{{ old('mother_country') ?? $student_mother_profile->mother_country }}">
                       
                        </div>
                    </div>

                    {{-- Landmark --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_landmark" class="form-label">Landmark</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_landmark"
                                aria-describedby="mother_landmark" placeholder="Enter Mother Landmark ..."
                                name="mother_landmark"
                                value="{{ old('mother_landmark') ?? $student_mother_profile->mother_landmark }}">
                    
                        </div>
                    </div>


                </div>
            </div>



            {{-- Socail Links --}}
            <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel"
                aria-labelledby="pills-social-links-tab">

                <div class="row">

                    {{-- FaceBook Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_fb_link" class="form-label">FaceBook Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="mother_fb_link"
                                placeholder="Enter Mother FaceBook Link ..." name="mother_fb_link"
                                value="{{ old('mother_fb_link') ?? $student_mother_profile->mother_fb_link }}">
                           
                        </div>
                    </div>

                    {{-- Twitter Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_twitter_link" class="form-label">Twitter Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="mother_twitter_link"
                                placeholder="Enter Mother Twitter Link ..." name="mother_twitter_link"
                                value="{{ old('mother_twitter_link') ?? $student_mother_profile->mother_twitter_link }}">
                          
                        </div>
                    </div>

                    {{-- Social Media Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_social_media_1" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="mother_social_media_1"
                                placeholder="Enter Mother Social Media Link ..." name="mother_social_media_1"
                                value="{{ old('mother_social_media_1') ?? $student_mother_profile->mother_social_media_1 }}">
                         
                        </div>
                    </div>

                    {{-- Social Media Link 2 --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_social_media_2" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="mother_social_media_2"
                                placeholder="Enter Mother Social Media Link ..." name="mother_social_media_2"
                                value="{{ old('mother_social_media_2') ?? $student_mother_profile->mother_social_media_2 }}">
                         
                        </div>
                    </div>


                </div>
            </div>


            {{-- Education Info --}}
            <div class="tab-pane fade show px-3" id="pills-education-info" role="tabpanel"
                aria-labelledby="pills-education-info-tab">

                <div class="row">

                    {{-- Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_qualification" class="form-label">Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="mother_qualification"
                                name="mother_qualification" required>
                                <option value="Bachelor"
                                    @if (old('mother_qualification') == null) {{ $student_mother_profile->mother_qualification == 'Bachelor' ? 'selected' : '' }} @else {{ old('mother_qualification') == 'Bachelor' ? 'selected' : '' }} @endif>
                                    Bachelor</option>
                                <option value="Diploma"
                                    @if (old('mother_qualification') == null) {{ $student_mother_profile->mother_qualification == 'Diploma' ? 'selected' : '' }} @else {{ old('mother_qualification') == 'Diploma' ? 'selected' : '' }} @endif>
                                    Diploma</option>
                                <option value="Phd"
                                    @if (old('mother_qualification') == null) {{ $student_mother_profile->mother_qualification == 'Phd' ? 'selected' : '' }} @else {{ old('mother_qualification') == 'Phd' ? 'selected' : '' }} @endif>
                                    Phd</option>
                                <option value="Other"
                                    @if (old('mother_qualification') == null) {{ $student_mother_profile->mother_qualification == 'Other' ? 'selected' : '' }} @else {{ old('mother_qualification') == 'Other' ? 'selected' : '' }} @endif>
                                    Other</option>
                            </select>
                        
                        </div>
                    </div>
                    {{-- If other selected show the other qualification --}}
                    {{-- Other Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_qualification_other" class="form-label">Other Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_qualification_other"
                                aria-describedby="mother_qualification_other"
                                placeholder="Enter Mother Other Qualification ..." name="mother_qualification_other"
                                value="{{ old('mother_qualification_other') ?? $student_mother_profile->mother_qualification_other }}">
                          
                        </div>
                    </div>

                    {{-- Wedding Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_wedding_date" class="form-label">Wedding Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="mother_wedding_date"
                                placeholder="Enter Mother Wedding Date . . ." name="mother_wedding_date"
                                value="{{ old('mother_wedding_date') ?? $student_mother_profile->mother_wedding_date }}"
                                required>
                      
                        </div>
                    </div>

                    {{-- Interests --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_interests" class="form-label">Interests</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_interests"
                                aria-describedby="mother_interests" placeholder="Enter Mother Interests ..."
                                name="mother_interests"
                                value="{{ old('mother_interests') ?? $student_mother_profile->mother_interests }}">
                          
                        </div>
                    </div>

                    {{-- Mother Age At Student Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_age_at_student_birth" class="form-label">Mother Age At Student Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_age_at_student_birth"
                                aria-describedby="mother_age_at_student_birth"
                                placeholder="Enter Mother Age At Student Birth ..." name="mother_age_at_student_birth"
                                value="{{ old('mother_age_at_student_birth') ?? $student_mother_profile->mother_age_at_student_birth }}">
                           
                        </div>
                    </div>

                    {{-- Mother Relation With Child --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_relation_with_child" class="form-label">Mother Relation With Child</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_relation_with_child"
                                aria-describedby="mother_relation_with_child"
                                placeholder="Enter Mother Relation With Child ..." name="mother_relation_with_child"
                                value="{{ old('mother_relation_with_child') ?? $student_mother_profile->mother_relation_with_child }}">
                      
                        </div>
                    </div>

                    {{-- Student Attitudes Towards Parent --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_attitudes_towards_parent" class="form-label">Student Attitudes Towards
                            Parent</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_attitudes_towards_parent"
                                aria-describedby="mother_attitudes_towards_parent"
                                placeholder="Enter Student Attitudes Towards Parent ..."
                                name="mother_attitudes_towards_parent"
                                value="{{ old('mother_attitudes_towards_parent') ?? $student_mother_profile->mother_attitudes_towards_parent }}">
                       
                        </div>
                    </div>

                    {{-- Mother Pregnancy Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_pregnancy_number" class="form-label">Mother Pregnancy Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_pregnancy_number"
                                aria-describedby="mother_pregnancy_number" placeholder="Enter Mother Pregnancy Number ..."
                                name="mother_pregnancy_number"
                                value="{{ old('mother_pregnancy_number') ?? $student_mother_profile->mother_pregnancy_number }}">
                       
                        </div>
                    </div>

                    {{-- Mother Miscarriages Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_miscarriages_number" class="form-label">Mother Miscarriages Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="mother_miscarriages_number"
                                aria-describedby="mother_miscarriages_number"
                                placeholder="Enter Mother Miscarriages Number ..." name="mother_miscarriages_number"
                                value="{{ old('mother_miscarriages_number') ?? $student_mother_profile->mother_miscarriages_number }}">
                          
                        </div>
                    </div>

                </div>
            </div>
        </div>


        <div class="col-12">
            <button class="btn btn-outline-primary" type="submit">save</button>
        </div>

    </form>
@endsection
