@extends('layouts.app_layout')

@section('title')
    All Mothers
@endsection

@section('content')
    @if (session('message'))
        <h6 class="alert alert-success">
            {{ session('message') }}
        </h6>
    @endif

    <div class="px-3">

        <div class="row align-items-center">
            <div class="col-sm-6">
                <h5 class="page-title-text d-inline-block">Mothers</h5>
                <div class="breadcrumbs d-inline-block">
                    <ul>
                        <li><a class="text-decoration-none" href="{{ route('dashboardIndex') }}">{{__('common.home')}}</a></li>
                        <li>Mothers</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 text-right">
                <div class=" text-end mb-3">
                    <a href="{{ route('createMother') }}" class="btn btn-outline-primaryary btn-sm me-2">
                        <i class="fa-solid fa-plus me-2"></i> New Mother
                    </a>
                </div>
            </div>
        </div>

        <div class="bg-white rounded shadow p-4">

            <div class="  table-responsive">
                <table id="example" class="table table-striped cell-border" style="width:100%">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Image</th>
                            <th scope="col">Mother</th>
                            <th scope="col">Nationality</th>
                            <th scope="col">Created By</th>
                            <th scope="col">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($student_mother_profiles as $student_mother_profile)
                            <tr>
                                <td>
                                    <p class="m-0 px-3">1</p>
                                </td>
                                <th scope="row">
                                    @if ($student_mother_profile->mother_image !== null)
                                        <img class="image-fload" width="100px" height="100px"
                                            src='{{ asset("uploads/$student_mother_profile->mother_image") }}'
                                            alt="{{ $student_mother_profile->mother_name }}">
                                    @else
                                        No Mother Image
                                    @endif
                                </th>
                                <td>
                                    <a class="text-decoration-none"
                                        href="{{ route('viewMother', $student_mother_profile->id) }}">
                                        <p class="text-custome m-0 px-3">{{ $student_mother_profile->mother_name }}</p>
                                    </a>
                                    <p class="m-0 px-3">{{ $student_mother_profile->mother_email }}</p>
                                    <p class="m-0 px-3">{{ $student_mother_profile->mother_phone }}</p>
                                </td>
                                <td>
                                    <p class="m-0 px-3">{{ $student_mother_profile->mother_nationality }}</p>
                                </td>
                                <td>
                                    <a href="{{ route('viewUser', $student_mother_profile->mother_created_by) }}">
                                        <p class="text-custome m-0 px-3">
                                            {{ $student_mother_profile->createdPerson->full_name }}</p>
                                    </a>
                                </td>
                                <td>
                                    <div class="btn-group">

                                        <i data-bs-toggle="dropdown" aria-expanded="false"
                                            class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                                        <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('viewMother', $student_mother_profile->id) }}">
                                                    <i class="fa-solid fa-eye me-2 text-custome"></i>
                                                    View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('editMother', $student_mother_profile->id) }}">
                                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                                    Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('deleteMother', $student_mother_profile->id) }}">
                                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                                    Delete
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
                {{-- <div class="d-flex">
                    {!! $student_mother_profiles->links() !!}
                </div> --}}
            </div>
        </div>

    </div>

    {{-- {{ $student_mother_profiles->links() }} --}}
@endsection
