@extends('layouts.list')

@section('title')
    Search Mothers
@endsection

@section('list-title')
    Mothers
@endsection

@section('list-navigation')
    <li><a class="text-decoration-none" href="{{ route('allMothers') }}">List Mothers </a></li>
    <li>Search Mothers</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createMother') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Mother
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">Mother</th>
    <th scope="col">Nationality</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($student_mother_profiles as $student_mother_profile)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row">
                @if ($student_mother_profile->mother_image !== null)
                    <img class="image-fload" width="100px" height="100px"
                        src='{{ asset("uploads/$student_mother_profile->mother_image") }}'
                        alt="{{ $student_mother_profile->mother_name }}">
                @else
                    No Mother Image
                @endif
            </th>
            <td>
                <a class="text-decoration-none" href="{{ route('viewMother', $student_mother_profile->id) }}">
                    <p class="text-custome m-0 px-3">{{ $student_mother_profile->mother_name }}</p>
                </a>
                <p class="m-0 px-3">{{ $student_mother_profile->mother_email }}</p>
                <p class="m-0 px-3">{{ $student_mother_profile->mother_phone }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $student_mother_profile->mother_nationality }}</p>
            </td>
            <td>
                <a href="{{ route('viewUser', $student_mother_profile->mother_created_by) }}">
                    <p class="text-custome m-0 px-3">
                        {{ $student_mother_profile->createdPerson->full_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('viewMother', $student_mother_profile->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('editMother', $student_mother_profile->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('deleteMother', $student_mother_profile->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $student_mother_profiles->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $student_mother_profiles->links() }} --}}
@endsection
