@extends('layouts.view')

@section('title')
    View Mother
@endsection

@section('view-title')
View Mother - {{ $student_mother_profile->mother_name }}
@endsection

@section('view-navigation')
    <li><a class="text-decoration-none" href="{{ route('allMothers') }}">List Mothers </a></li>
    <li>View Mother</li>
@endsection

@section('view-panel')
    <div class="user-avtar">
        @if ($student_mother_profile->mother_image !== null)
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='{{ asset("uploads/$student_mother_profile->mother_image") }}'
                alt="{{ $student_mother_profile->mother_name }}">
        @else
            <span>{{ ucfirst($student_mother_profile->mother_name[0]) }}</span>
        @endif
    </div>
    <div class="user-details text-center pt-3">
        <h3>{{ $student_mother_profile->mother_name }}</h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="v-pills-mother-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-mother-info" type="button" role="tab" aria-controls="v-pills-mother-info"
                aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>Mother Info</span>
            </button>
            <button class="nav-link" id="v-pills-mother-address-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-mother-address" type="button" role="tab" aria-controls="v-pills-mother-address"
                aria-selected="false"><i class="fa-solid fa-address-book"></i><span>Address Info</span></button>
            <button class="nav-link" id="v-pills-mother-social-media-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-mother-social-media" type="button" role="tab"
                aria-controls="v-pills-mother-social-media" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Social
                    Links</span></button>
            <button class="nav-link" id="v-pills-mother-children-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-mother-children" type="button" role="tab"
                aria-controls="v-pills-mother-children" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Mother Childrens</span></button>
            <a class="nav-link" type="button" role="tab" aria-selected="false"
                href="{{ route('editMother', $student_mother_profile->id) }}"><i
                    class="fa-solid fa-user-pen"></i><span>Edit
                    Mother</span></a>
            {{-- <button class="nav-link" id="v-pills-user-documents-tab" data-bs-toggle="pill" data-bs-target="#v-pills-user-documents" type="button" role="tab" aria-controls="v-pills-user-documents" aria-selected="false"><i class="fa-solid fa-envelope"></i><span>Send Email</span></button> --}}
            <button class="nav-link" id="v-pills-mother-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-mother-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-mother-sendwhatsapp" aria-selected="false"><i class="fa-solid fa-envelope"></i>
                <span>Send WhatsApp</span></button>
        </div>
    </div>
@endsection


@section('view-tabs')
    {{-- Mother Info --}}
    <div class="tab-pane fade show active" id="v-pills-mother-info" role="tabpanel"
        aria-labelledby="v-pills-mother-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Mother Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Mother Name</td>
                            <td>{{ $student_mother_profile->mother_name }}</td>
                        </tr>
                        <tr>
                            <td>Email Address</td>
                            <td>{{ $student_mother_profile->mother_email }}</td>
                        </tr>
                        <tr>
                            <td>Mobile Number</td>
                            <td>{{ $student_mother_profile->mother_phone }}</td>
                        </tr>
                        <tr>
                            <td>Alternative Mobile Number</td>
                            <td>{{ $student_mother_profile->mother_alternative_phone }}</td>
                        </tr>
                        <tr>
                            <td>Date of Birth</td>
                            <td>{{ $student_mother_profile->mother_dob }}</td>
                        </tr>
                        <tr>
                            <td>Nationality</td>
                            <td>{{ $student_mother_profile->mother_nationality }}</td>
                        </tr>
                        <tr>
                            <td>National Number</td>
                            <td>{{ $student_mother_profile->mother_national_number }}</td>
                        </tr>
                        <tr>
                            <td>Marital Status</td>
                            <td>{{ $student_mother_profile->mother_marital_status }}</td>
                        </tr>
                        <tr>
                            <td>Created By</td>
                            <td><a class="text-decoration-none"
                                    href="{{ route('viewUser', $student_mother_profile->mother_created_by) }}">{{ $student_mother_profile->createdPerson->full_name }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>Created Date</td>
                            <td>{{ $student_mother_profile->created_at }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Mother Address --}}
    <div class="tab-pane fade" id="v-pills-mother-address" role="tabpanel"
        aria-labelledby="v-pills-mother-address-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Mother Address</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Address</td>
                            <td>{{ $student_mother_profile->mother_address }}</td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td>{{ $student_mother_profile->mother_city }}</td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td>{{ $student_mother_profile->mother_state }}</td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td>{{ $student_mother_profile->mother_country }}</td>
                        </tr>
                        <tr>
                            <td>Landmark</td>
                            <td>{{ $student_mother_profile->mother_landmark }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Mother Social Media --}}
    <div class="tab-pane fade" id="v-pills-mother-social-media" role="tabpanel"
        aria-labelledby="v-pills-mother-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Mother Social Media</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>FaceBook</td>
                            <td><a class="text-decoration-none" href="{{ $student_mother_profile->mother_fb_link }}">{{ $student_mother_profile->mother_fb_link }}</a></td>
                        </tr>
                        <tr>
                            <td>Twitter</td>
                            <td><a class="text-decoration-none" href="{{ $student_mother_profile->mother_twitter_link }}">{{ $student_mother_profile->mother_twitter_link }}</a></td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none" href="{{ $student_mother_profile->mother_social_media_1 }}">{{ $student_mother_profile->mother_social_media_1 }}</a></td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none" href="{{ $student_mother_profile->mother_social_media_2 }}">{{ $student_mother_profile->mother_social_media_2 }}</a></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Send Email --}}

    {{-- Send Whatsapp to Mother --}}
    <div class="tab-pane fade" id="v-pills-mother-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-mother-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Send Whatsapp to Mother
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>To</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>Message</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "{{ $student_mother_profile->mother_phone }}";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>

    {{-- Mother Other Info --}}
    <div class="tab-pane fade" id="v-pills-mother-social-media" role="tabpanel"
        aria-labelledby="v-pills-mother-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Mother Other Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Mother Degree Of Kinship</td>
                            <td>{{ $student_mother_profile->mother_degree_of_kinship }}</td>
                        </tr>
                        <tr>
                            <td>Mother Job</td>
                            <td>{{ $student_mother_profile->mother_job }}</td>
                        </tr>
                        <tr>
                            <td>Mother Qualification</td>
                            <td>{{ $student_mother_profile->mother_qualification }}</td>
                        </tr>
                        <tr>
                            <td>Mother Qualification Other</td>
                            <td>{{ $student_mother_profile->mother_qualification_other }}</td>
                        </tr>
                        <tr>
                            <td>Mother Wedding Date</td>
                            <td>{{ $student_mother_profile->mother_wedding_date }}</td>
                        </tr>
                        <tr>
                            <td>Mother Interests</td>
                            <td>{{ $student_mother_profile->mother_interests }}</td>
                        </tr>
                        <tr>
                            <td>Mother Age At Student Birth</td>
                            <td>{{ $student_mother_profile->mother_age_at_student_birth }}</td>
                        </tr>
                        <tr>
                            <td>Mother Relation With Child</td>
                            <td>{{ $student_mother_profile->mother_relation_with_child }}</td>
                        </tr>
                        <tr>
                            <td>Mother Attitudes Towards Parent</td>
                            <td>{{ $student_mother_profile->mother_attitudes_towards_parent }}</td>
                        </tr>
                        <tr>
                            <td>Mother Pregnancy Number</td>
                            <td>{{ $student_mother_profile->mother_pregnancy_number }}</td>
                        </tr>
                        <tr>
                            <td>Mother Miscarriages Number</td>
                            <td>{{ $student_mother_profile->mother_miscarriages_number }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Mother His Children Data --}}
    <div class="tab-pane fade" id="v-pills-mother-children" role="tabpanel"
        aria-labelledby="v-pills-mother-children-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Mother Children Data</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <thead>
                        <tr>
                            <th scope="col">Student Image</th>
                            <th scope="col">Student Name</th>
                            <th scope="col">Student Phone</th>
                            <th scope="col">Student Gender</th>
                            <th scope="col">Student DOB</th>
                            <th scope="col">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($students as $student)
                            <tr>
                                <th scope="row">
                                    @if ($student->image !== null)
                                        <img class="image-fload" width="100px" height="100px"
                                            src='{{ asset("uploads/$student->image") }}'
                                            alt="{{ $student->student_name }}">
                                    @else
                                        No Student Image
                                    @endif
                                </th>
                                <td>
                                    <a class="text-decoration-none" href="{{ route('viewStudent', $student->id) }}">
                                        <p>{{ $student->student_name }}</p>
                                    </a>
                                </td>
                                <td>
                                    <p>{{ $student->phone }}</p>
                                </td>
                                <td>
                                    <p>{{ $student->gender }}</p>
                                </td>
                                <td>
                                    <p>{{ $student->dob }}</p>
                                </td>
                                <td>
                                    <div class="btn-group">

                                        <i data-bs-toggle="dropdown" aria-expanded="false"
                                            class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                                        <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('viewStudent', $student->id) }}">
                                                    <i class="fa-solid fa-eye me-2 text-custome"></i>
                                                    View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('editStudent', $student->id) }}">
                                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                                    Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('deleteStudent', $student->id) }}">
                                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                                    Delete
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection