@extends('layouts.list')

@section('title')
    All Questions
@endsection

@section('list-title')
    {{__('questions.questions')}}
@endsection

@section('list-navigation')
    <li>{{__('questions.questions')}}</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createQuestion') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i>{{__('questions.new_question')}}
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('questions.question_title')}}</th>
    <th scope="col">{{__('questions.business_location')}}</th>
    <th scope="col">{{__('questions.created_by')}}</th>
    <th scope="col">{{__('questions.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($questions as $question)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6">{{__('questions.question_title')}}</h6>
                <a class="text-decoration-none col-6" href="{{route('viewQuestion' , $question->id )}}">
                    @if (Config::get('languages')[App::getLocale()] = "english")
                        <p class="text-custome m-0 ">{{ $question->question_title }}</p>
                    @else
                        <p class="text-custome m-0 ">{{ $question->question_title_ar }}</p>
                    @endif
                </a>
            </td>
            {{-- <td class="Zindex">
                <h6 class="col-6">  Business Location </h6>
                <a class="text-decoration-none col-6" href="{{route('viewBusinessLocation' , $question->business_id )}}">
                    <p class="text-custome m-0 ">{{ $question->ز->business_name }}</p>
                </a>
            </td> --}}
            {{-- <td class="Zindex">
                <h6 class="col-6">{{__('questions.created_by')}}</h6>
                <a class="text-decoration-none col-6" href="{{route('viewUser' , $question->created_by )}}">
                    <p class="text-custome m-0 ">{{ $question->createdPerson->full_name }}</p>
                </a>
            </td> --}}
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewQuestion', $question->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('questions.view')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == "super_admin" || Auth::user()->role == "owner")    
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editQuestion', $question->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('questions.edit')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('deleteQuestion', $question->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                {{__('questions.delete')}}
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $questions->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $questions->links() }} --}}
@endsection
