@extends('layouts.app_layout')

@section('title')
All Questions
@endsection

@section('content')

@if(session('message'))
    <h6 class="alert alert-success">
        {{ session('message') }}
    </h6>
@endif


<table id="example" class="table table-striped cell-border" style="width:100%">
    <thead>
      <tr>
        <th scope="col">Question Title</th>
        <th scope="col">Business Location</th>
        <th scope="col">Created By</th>
        <th scope="col">Actions</th>
      </tr>
    </thead>
    <tbody>
        @foreach ($questions as $question)
      <tr>
        <td>
            <a href="{{route('viewQuestion' , $question->id )}}"><p>{{ $question->question_title }}</p></a>
        </td>
        <td>
            <a href="{{route('viewBusinessLocation' , $question->business_id )}}"><p>{{ $question->businessLocation->business_name }}</p></a>
        </td>
        <td>
            <a href="{{route('viewUser' , $question->created_by )}}"><p>{{ $question->createdPerson->full_name }}</p></a>
        </td>
        <td>
            <a href="{{ route('viewQuestion' , $question->id ) }}" class="btn btn-outline-primary mt-3">View</a>
            <a href="{{ route('editQuestion' , $question->id ) }}" class="btn btn-outline-primary mt-3">Edit</a>
            <a href="{{ route('deleteQuestion' , $question->id) }}" class="btn btn-outline-primary mt-3">Delete</a>
        </td>
      </tr>

      @endforeach
      
    </tbody>
</table>

{{ $questions->links() }}



@endsection


