@extends('layouts.list')

@section('title')
    Search Questions
@endsection

@section('list-title')
    Questions
@endsection

@section('list-navigation')
    <li>Questions</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createQuestion') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Question
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Question Title</th>
    <th scope="col">Business Location</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($questions as $question)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td>
                <a class="text-decoration-none" href="{{route('viewQuestion' , $question->id )}}">
                    <p class="text-custome m-0 px-3">{{ $question->question_title }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{route('viewBusinessLocation' , $question->business_id )}}">
                    <p class="text-custome m-0 px-3">{{ $question->businessLocation->business_name }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{route('viewUser' , $question->created_by )}}">
                    <p class="text-custome m-0 px-3">{{ $question->createdPerson->full_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewQuestion', $question->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editQuestion', $question->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('deleteQuestion', $question->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $questions->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $questions->links() }} --}}
@endsection
