@extends('layouts.app_layout')

@section('title')
View Question
@endsection

@section('content')

<div class="px-3">

    <div class="row align-items-center">
        <div class="col-sm-8">
            <h5 class="page-title-text d-inline-block">{{__('questions.view_question')}} </h5>
        </div>
        <div class="col-sm-4 text-right">
            <div class=" text-end mb-3">
                <a href="{{ route('editQuestion' , $question->id) }}" class="btn btn-outline-warning btn-sm me-2">
                    <i class="fa-solid fa-pen-to-square me-2"></i>{{__('questions.edit_question')}}
                </a>  
            </div>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-12">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="{{ route('dashboardIndex') }}">{{__('common.home')}}</a></li>
                    <li><a class="text-decoration-none" href="{{ route('allUsers') }}">{{__('questions.list_questions')}}</a></li>
                    <li>{{__('questions.view_question')}}</li>
                </ul>
            </div>
        </div>
    </div>

    <section class="container px-5">
        <div class="bg-white w-100 m-auto shadow-lg rounded-lg  overflow-auto">
            <div class="p-3 bg-light border-bottom overflow-auto">
                <h1 class="text-spec text-center">{{__('questions.questions')}}</h1>
            </div>
    
            <div class="p-4 text-spec">
                @if (Config::get('languages')[App::getLocale()] = "english")
                    <h6 class="">Q: {{ $question->question_title }} </h6>
                    <h6 id="question" class="text-muted mb-5">{{ $question->question_note }}</h6>
                @else
                    <h6 class="">س: {{ $question->question_title_ar }} </h6>
                    <h6 id="question" class="text-muted mb-5">{{ $question->question_note_ar }}</h6>
                @endif
    
                <div id="rowAnswer" class="row g-5 px-2">
                    @foreach ( json_decode($question->answers) as $Answer)
                    <div class="form-check d-flex justify-content-center col-md-3">
                        <label class="form-check-label text-center">
                            <!-- {{ $loop->index}} -->
                            <input type="radio" disabled class="form-check-input d-block m-auto my-2" name="answer" id="q1" value="value">
                           
                         
                            @if ($Answer->answer_image !== null)
                            <img class="image-fload img-thumbnail"  src='{{ asset("uploads/$Answer->answer_image") }}' alt="{{ $Answer->answer_text }}">
                            @endif

                            @if (Config::get('languages')[App::getLocale()] = "english")
                                <p class="my-2"> {{ $Answer->answer_text}}</p>
                            @else
                                <p class="my-2"> {{ $Answer->answer_text_ar}}</p>
                            @endif
                            
                        </label>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    

</div>

@endsection
