@extends('layouts.list')

@section('title')
    Reports
@endsection

@section('list-title')
    Reports
@endsection

@section('list-navigation')
    <li>Reports</li>
@endsection

@section('list-new-button')
    <form method="POST" action="{{ route('assignmentReportView') }}" id="FormTabs" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="report_id" value="{{ $report->id }}">
        <input type="hidden" id="submission_id" name="submission_id" value="">
        <button type="submit" disabled id="button" class="btn btn-outline-danger">Get Report</button>
    </form>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th class="d-none">d</th>
    <th class="d-none">d</th>
    <th scope="col">Report Title</th>
@endsection

@section('list-table-body')
    @foreach ($submissions as $submission)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="d-none" assignmentId="{{ $submission->assignment_id }}"
                id="assignment">
                {{ $submission->assignment_id }}
            </td>
            <td class="d-none"
                submissionId="{{ $submission->id }}" id="Submition">
                {{  $submission->id }}
            </td>
            <td class="Zindex">
                <?php /* <a class="text-decoration-none" href="{{ route('assignmentReportView', ['report_id' => $report->id, 'submission_id' => $submission->id]) }}"> */?>
                <p class="text-custome m-0 px-3 ">Assignment ID: {{ $submission->assignment_id }}</p>
                <p class="text-custome m-0 px-3">Trainer: {{ $submission->trainer_id }}</p>
                <p class="text-custome m-0 px-3">Business: {{ $submission->business_id }}</p>
                <p class="text-custome m-0 px-3">Assignment Information Provider:
                    {{ $submission->assignment_information_provider }}</p>
                <p class="text-custome m-0 px-3">Created At: {{ $submission->created_at }}</p>
                <?php /* </a> */?>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
     {!! $reports->links() !!} 
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $reports->links() }} --}}
@endsection
@section('scripts')
    <script>
        var dataTable = $('#example,#questions').DataTable({})
        let data = dataTable.rows('.selected').data();
        $('#example tbody').on('click', 'tr', function() {
            let assignmentId = $(this).find("#assignment").attr('assignmentId')
            let data = dataTable.rows('.selected').data();
            let count = 0;
            $('#button').prop("disabled", false)
            if ($(this).hasClass('selected')) {
                $(this).toggleClass('selected')
            } else {
                if (data.length > 0) {
                    for (let i = 0; i < data.length; i++) {
                        const element = data[i][1];
                        if (element == assignmentId) {
                            count++
                        }
                    }
                }
                if (data.length == 0) {
                    $(this).toggleClass('selected');
                }
                if (data.length > 0 && count == 0) {
                    $(this).toggleClass('selected');
                }
            }
        });

        $('#button').click(function() {
            let submitions = [];
            let data = dataTable.rows('.selected').data();
            for (let i = 0; i < data.length; i++) {
                const element = data[i][2];
                submitions.push(element)
            }

            console.log(submitions.join(','));
            $('#submission_id').val(submitions.join(','));
        });
    </script>
@endsection
