@extends('layouts.form')

@section('title')
    Add Student
@endsection

@section('form-title')
{{__('students.new_student')}}
@endsection

@section('form-navigation')
    <li><a class="text-decoration-none" href="{{ route('allStudents') }}">{{__('students.list_students')}}</a></li>
    <li>{{__('students.new_student')}}</li>
@endsection

@section('form-tabs-li')
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary"
            aria-selected="true">{{__('students.basic_info')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary"
            aria-selected="false">{{__('students.address_info')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links"
            type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">{{__('students.social_links')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-main-problem-tab" data-bs-toggle="pill" data-bs-target="#pills-main-problem"
            type="button" role="tab" aria-controls="pills-main-problem" aria-selected="false">{{__('students.main_problem')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-family-history-tab" data-bs-toggle="pill"
            data-bs-target="#pills-family-history" type="button" role="tab" aria-controls="pills-family-history"
            aria-selected="false">{{__('students.family_history')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-economic_situation-tab" data-bs-toggle="pill"
            data-bs-target="#pills-economic_situation" type="button" role="tab" aria-controls="pills-economic_situation"
            aria-selected="false">{{__('students.the_standard_of_living_for_the_family')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-Organic_growth_history-tab" data-bs-toggle="pill"
            data-bs-target="#pills-Organic_growth_history" type="button" role="tab"
            aria-controls="pills-Organic_growth_history" aria-selected="false">{{__('students.organic_growth_history')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-Psychological-behavioral-tab" data-bs-toggle="pill"
            data-bs-target="#pills-Psychological-behavioral" type="button" role="tab"
            aria-controls="pills-Psychological-behavioral" aria-selected="false">{{__('students.psychological_and_behavioral_side')}}</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-Linguistic-side-tab" data-bs-toggle="pill"
            data-bs-target="#pills-Linguistic-side" type="button" role="tab" aria-controls="pills-Linguistic-side"
            aria-selected="false">{{__('students.linguistic_side')}}</button>
    </li>
@endsection

@section('form-tabs-content')
    <form class="needs-validation" method="POST" action="{{ route('storeStudent') }}" enctype="multipart/form-data">
        @csrf

        <div class="tab-content  text-capitalize" id="pills-tabContent">
            {{-- Basic Info Group --}}
            <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel"
                aria-labelledby="pills-basic-primary-tab">

                <div class="row">

                    {{-- Full Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="student_name" class="form-label">{{__('students.full_name')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="student_name" aria-describedby="nameHelp"
                                placeholder="{{__('students.enter')}} {{__('students.full_name')}} ..." name="student_name"
                                value="{{ old('student_name') }}" required>
                        </div>
                    </div>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="phone" class="form-label">{{__('students.mobile_number')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="phone"
                                placeholder="{{__('students.enter')}} {{__('students.mobile_number')}} ..." name="phone" value="{{ old('phone') }}" required>
                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="alternative_phone" class="form-label">{{__('students.alternative_mobile_number')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="alternative_phone"
                                placeholder="{{__('students.enter')}} {{__('students.alternative_mobile_number')}} ..." name="alternative_phone"
                                value="{{ old('alternative_phone') }}" required>
                        </div>
                    </div>

                    {{-- Contact Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="contact_number" class="form-label">{{__('students.contact_number')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="contact_number"
                                placeholder="{{__('students.enter')}} {{__('students.contact_number')}} ..." name="contact_number"
                                value="{{ old('contact_number') }}">
                        </div>
                    </div>

                    {{-- Home Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="home_phone" class="form-label">{{__('students.home_contact_number')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="home_phone"
                                placeholder="{{__('students.enter')}} {{__('students.home_contact_number')}} ..." name="home_phone"
                                value="{{ old('home_phone') }}">
                        </div>
                    </div>

                    {{-- Nationality --}}
                    <div class="col-md-4 mt-4">
                        <label for="nationality" class="form-label">{{__('students.nationality')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-building"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="nationality"
                                placeholder="{{__('students.enter')}} {{__('students.nationality')}} ..." name="nationality" value="{{ old('nationality') }}"
                                required>

                        </div>
                    </div>

                    {{-- National Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="national_number" class="form-label">{{__('students.national_number')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-id-card"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="national_number"
                                placeholder="{{__('students.enter')}} {{__('students.national_number')}} ..." name="national_number"
                                value="{{ old('national_number') }}" required>

                        </div>
                    </div>


                    {{-- Date of Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="dob" class="form-label">{{__('students.dob')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="dob"
                                placeholder="{{__('students.enter')}} {{__('students.dob')}} ..." name="dob" value="{{ old('dob') }}" required>
                        </div>
                    </div>

                    {{-- Birth Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="birth_address" class="form-label">{{__('students.birth_address')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="birth_address"
                                placeholder="{{__('students.enter')}} {{__('students.birth_address')}} ..." name="birth_address"
                                value="{{ old('birth_address') }}">
                        </div>
                    </div>

                    {{-- Gender --}}
                    <div class="col-md-4 mt-4">
                        <label for="gender" class="form-label">{{__('students.gender')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-user-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="gender" name="gender" required>
                                <option value="" disabled>{{__('students.choose_option')}}</option>
                                <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>{{__('students.male')}}</option>
                                <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>{{__('students.female')}}</option>
                            </select>

                        </div>
                    </div>

                    {{-- Blood Group --}}
                    <div class="col-md-4 mt-4">
                        <label for="blood_group" class="form-label">{{__('students.blood_group')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-heart-pulse"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                                <option value="">{{__('students.choose_option')}}</option>
                                <option value="A+" {{ old('blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                                <option value="A-" {{ old('blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                                <option value="B+" {{ old('blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                                <option value="B-" {{ old('blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                                <option value="O+" {{ old('blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                                <option value="O-" {{ old('blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                                <option value="AB+" {{ old('blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                                <option value="AB-" {{ old('blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                            </select>
                        </div>
                    </div>


                    {{-- Upload Image --}}
                    <div class="col-md-4 mt-4">
                        <label for="image_input" class="form-label filelabel">
                            <i class="fa fa-paperclip">
                            </i>
                            <span class="title">
                                {{__('students.upload_image')}}
                            </span>
                            <input class="FileUpload1" id="image_input" name="image" type="file" />
                        </label>
                    </div>

                    {{-- Height --}}
                    <div class="col-md-4 mt-4">
                        <label for="height" class="form-label">{{__('students.height')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="number" class="form-control text-start" id="height"
                                placeholder="{{__('students.enter')}} {{__('students.height')}} ..." name="height" value="{{ old('height') }}">
                        </div>
                    </div>

                    {{-- Weight --}}
                    <div class="col-md-4 mt-4">
                        <label for="weight" class="form-label">{{__('students.weight')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="number" class="form-control text-start" id="weight"
                                placeholder="{{__('students.enter')}} {{__('students.weight')}} ..." name="weight" value="{{ old('weight') }}">
                        </div>
                    </div>

                    {{-- School Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="school_name" class="form-label">{{__('students.school_name')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="school_name"
                                placeholder="{{__('students.enter')}} {{__('students.school_name')}} ..." name="school_name"
                                value="{{ old('school_name') }}">
                        </div>
                    </div>


                </div>

            </div>


            {{-- Address Info --}}
            <div class="tab-pane fade show px-3" id="pills-address-primary" role="tabpanel"
                aria-labelledby="pills-address-primary-tab">

                <div class="row">

                    {{-- Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="address" class="form-label">{{__('students.address')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="address" aria-describedby="address"
                                placeholder="{{__('students.enter')}} {{__('students.address')}} ..." name="address" value="{{ old('address') }}">

                        </div>
                    </div>

                    {{-- City --}}
                    <div class="col-md-4 mt-4">
                        <label for="city" class="form-label">{{__('students.city')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-location"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="city" aria-describedby="city"
                                placeholder="{{__('students.enter')}} {{__('students.city')}} ..." name="city" value="{{ old('city') }}">

                        </div>
                    </div>

                    {{-- State --}}
                    <div class="col-md-4 mt-4">
                        <label for="state" class="form-label">{{__('students.state')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="state" aria-describedby="state"
                                placeholder="{{__('students.enter')}} {{__('students.state')}} ..." name="state" value="{{ old('state') }}">

                        </div>
                    </div>

                    {{-- Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="country" class="form-label">{{__('students.country')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-pin"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="country" aria-describedby="country"
                                placeholder="{{__('students.enter')}} {{__('students.country')}} ..." name="country" value="{{ old('country') }}">

                        </div>
                    </div>

                    {{-- Landmark --}}
                    <div class="col-md-4 mt-4">
                        <label for="landmark" class="form-label">{{__('students.landmark')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-landmark"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="landmark" aria-describedby="landmark"
                                placeholder="{{__('students.enter')}} {{__('students.landmark')}} ..." name="landmark" value="{{ old('landmark') }}">

                        </div>
                    </div>


                </div>
            </div>


            {{-- Socail Links --}}
            <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel"
                aria-labelledby="pills-social-links-tab">

                <div class="row">

                    {{-- FaceBook Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="fb_link" class="form-label">{{__('students.facebook_link')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-brands fa-facebook-f"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="fb_link"
                                placeholder="{{__('students.enter')}} {{__('students.facebook_link')}} ..." name="fb_link" value="{{ old('fb_link') }}">

                        </div>
                    </div>

                    {{-- Twitter Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="twitter_link" class="form-label">{{__('students.twitter_link')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-brands fa-twitter"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="twitter_link"
                                placeholder="{{__('students.enter')}} {{__('students.twitter_link')}} ..." name="twitter_link"
                                value="{{ old('twitter_link') }}">

                        </div>
                    </div>

                    {{-- Social Media Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="social_media_1" class="form-label">{{__('students.social_media_link')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-hashtag"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_1"
                                placeholder="{{__('students.enter')}} {{__('students.social_media_link')}} ..." name="social_media_1"
                                value="{{ old('social_media_1') }}">

                        </div>
                    </div>

                    {{-- Social Media Link 2 --}}
                    <div class="col-md-4 mt-4">
                        <label for="social_media_2" class="form-label">{{__('students.social_media_link_2')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-hashtag"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_2"
                                placeholder="{{__('students.enter')}} {{__('students.social_media_link_2')}} ..." name="social_media_2"
                                value="{{ old('social_media_2') }}">

                        </div>
                    </div>


                </div>
            </div>


            {{-- Main Problem Info --}}
            <div class="tab-pane fade show px-3" id="pills-main-problem" role="tabpanel"
                aria-labelledby="pills-main-problem-tab">

                <div class="row">

                    {{-- Main Problem --}}
                    <div class="col-md-4 mt-4">
                        <label for="main_complaint" class="form-label">{{__('students.main_problem')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <textarea class="form-control text-start" id="main_complaint" aria-describedby="main_complaint"
                                placeholder="{{__('students.enter')}} {{__('students.main_problem')}} ..." name="main_complaint"
                                rows="3">{{ old('main_complaint') }}</textarea>
                        </div>
                    </div>

                    {{-- Time Of Increasing Problem Feeling --}}
                    <div class="col-md-4 mt-4">
                        <label for="time_of_increasing_problem_feeling" class="form-label">{{__('students.time_of_increasing_problem_feeling')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map"></i>
                            </span>
                            <textarea class="form-control text-start" id="time_of_increasing_problem_feeling"
                                aria-describedby="time_of_increasing_problem_feeling"
                                placeholder="{{__('students.enter')}} {{__('students.time_of_increasing_problem_feeling')}}Enter Time Of Increasing Problem Feeling ..."
                                name="time_of_increasing_problem_feeling"
                                rows="3">{{ old('time_of_increasing_problem_feeling') }}</textarea>
                        </div>
                    </div>

                    {{-- Time Of Decreasing Problem Feeling --}}
                    <div class="col-md-4 mt-4">
                        <label for="time_of_decreasing_problem_feeling" class="form-label">{{__('students.time_of_decreasing_problem_feeling')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map"></i>
                            </span>
                            <textarea class="form-control text-start" id="time_of_decreasing_problem_feeling"
                                aria-describedby="time_of_decreasing_problem_feeling"
                                placeholder="{{__('students.enter')}} {{__('students.time_of_decreasing_problem_feeling')}}"
                                name="time_of_decreasing_problem_feeling"
                                rows="3">{{ old('time_of_decreasing_problem_feeling') }}</textarea>
                        </div>
                    </div>

                    {{-- Problem As Child Sideview --}}
                    <div class="col-md-4 mt-4">
                        <label for="problem_as_child_view" class="form-label">{{__('students.problem_as_child_sideview')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-pin"></i>
                            </span>
                            <textarea class="form-control text-start" id="problem_as_child_view" aria-describedby="problem_as_child_view"
                                placeholder="{{__('students.enter')}} {{__('students.problem_as_child_sideview')}} ..." name="problem_as_child_view"
                                rows="3">{{ old('problem_as_child_view') }}</textarea>
                        </div>
                    </div>

                    {{-- Problem As Father Sideview --}}
                    <div class="col-md-4 mt-4">
                        <label for="problem_as_father_view" class="form-label">{{__('students.problem_as_father_sideview')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-pin"></i>
                            </span>
                            <textarea class="form-control text-start" id="problem_as_father_view" aria-describedby="problem_as_father_view"
                                placeholder="{{__('students.enter')}} {{__('students.problem_as_father_sideview')}} ..." name="problem_as_father_view"
                                rows="3">{{ old('problem_as_father_view') }}</textarea>
                        </div>
                    </div>

                    {{-- Problem As Mother Sideview --}}
                    <div class="col-md-4 mt-4">
                        <label for="problem_as_mother_view" class="form-label">{{__('students.problem_as_mother_sideview')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-pin"></i>
                            </span>
                            <textarea class="form-control text-start" id="problem_as_mother_view" aria-describedby="problem_as_mother_view"
                                placeholder="{{__('students.enter')}} {{__('students.problem_as_mother_sideview')}} ..." name="problem_as_mother_view"
                                rows="3">{{ old('problem_as_mother_view') }}</textarea>
                        </div>
                    </div>

                    {{-- Problem Reasons --}}
                    <div class="col-md-4 mt-4">
                        <label for="problem_reasons" class="form-label">{{__('students.problem_reasons')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-landmark"></i>
                            </span>
                            <textarea class="form-control text-start" id="problem_reasons" aria-describedby="problem_reasons"
                                placeholder="{{__('students.enter')}} {{__('students.problem_reasons')}} ..." name="problem_reasons"
                                rows="3">{{ old('problem_reasons') }}</textarea>
                        </div>
                    </div>

                    {{-- Feeling Problem Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="problem_start_at" class="form-label">{{__('students.feeling_problem_date')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="problem_start_at"
                                placeholder="{{__('students.enter')}} {{__('students.feeling_problem_date')}} ..." name="problem_start_at"
                                value="{{ old('problem_start_at') }}">
                        </div>
                    </div>

                    {{-- Student Diseases Which Has A Realtion With The Problem --}}
                    <div class="d-flex align-items-start flex-column my-3">
                        <div class="col-md-6  switchParent">
                            <div class="form-check form-switch">
                                <input class="form-check-input " type="checkbox" role="switch" id="Student_Diseases">
                                <label class="form-check-label" for="Student_Diseases">{{__('students.student_diseases_which_has_a_realtion_with_the_problem')}}</label>
                            </div>
                        </div>



                        <div class="w-100 d-none noParents" id="noParents2">
                            <div class="row g-3 align-items-end mb-2">

                                {{-- Disease --}}
                                <div class="col-md-3">
                                    <label for="validationCustomParent" class="form-label">{{__('students.disease')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="student_diseases[0][disease]"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <input type="text" class="form-control" id="student_diseases[0][disease]"
                                            aria-describedby="inputGroupPrepend" name="student_diseases[0][disease]"
                                            placeholder="{{__('students.enter')}} {{__('students.disease')}} ..."
                                            value="{{ old('student_diseases[0][disease]') }}">
                                    </div>
                                </div>

                                {{-- Age At InJury --}}
                                <div class="col-md-3">
                                    <label for="student_diseases[0][age_at_injury]" class="form-label">{{__('students.age_at_inJury')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input type="text" class="form-control" id="student_diseases[0][age_at_injury]"
                                            aria-describedby="inputGroupPrepend" name="student_diseases[0][age_at_injury]"
                                            placeholder="{{__('students.enter')}} {{__('students.age_at_inJury')}} ..."
                                            value="{{ old('student_diseases[0][age_at_injury]') }}">
                                    </div>
                                </div>

                                {{-- Disease Duration --}}
                                <div class="col-md-3">
                                    <label for="student_diseases[0][disease_duration]" class="form-label">{{__('students.disease_duration')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"><i
                                                class="fa-solid fa-phone"></i></span>
                                        <input type="number" class="form-control"
                                            name="student_diseases[0][disease_duration]"
                                            id="student_diseases[0][disease_duration]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.disease_duration')}} ..."
                                            value="{{ old('student_diseases[0][disease_duration]') }}">
                                    </div>
                                </div>

                                {{-- Disease Strength --}}
                                <div class="col-md-2">
                                    <label for="student_diseases[0][disease_degree]" class="form-label">{{__('students.disease_strength')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-address-card"></i></span>
                                        <input type="text" class="form-control"
                                            name="student_diseases[0][disease_degree]"
                                            id="student_diseases[0][disease_degree]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.disease_strength')}} ..."
                                            value="{{ old('student_diseases[0][disease_degree]') }}">
                                    </div>
                                </div>
                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="problems_fields();"></i>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- Previous treatment efforts --}}
                    <div class="d-flex align-items-start  flex-column">
                        <div class="col-md-6 switchParent">
                            <div class="form-check form-switch">
                                <input class="form-check-input " type="checkbox" role="switch"
                                    id="previous_treatment_efforts">
                                <label class="form-check-label" for="previous_treatment_efforts">{{__('students.previous_treatment_efforts')}}</label>
                            </div>
                        </div>
                        <div class="w-100 d-none noParents text-capitalize" id="noParents3">
                            <div class="row g-3 align-items-end my-3">

                                {{-- The Name Of Medical Institution --}}
                                <div class="col-md-3">
                                    <label for="previous_treatment_efforts[0][medical_institution]" class="form-label">
                                        {{__('students.the_name_of_medical_institution')}}
                                    </label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <input type="text" name="previous_treatment_efforts[0][medical_institution]"
                                            class="form-control" id="previous_treatment_efforts[0][medical_institution]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.the_name_of_medical_institution')}} ..."
                                            value="{{ old('previous_treatment_efforts[0][medical_institution]') }}">

                                    </div>
                                </div>

                                {{-- Provided Service --}}
                                <div class="col-md-3">
                                    <label for="previous_treatment_efforts[0][provided_service]" class="form-label">
                                        {{__('students.provided_service')}}
                                    </label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input type="text" class="form-control"
                                            id="previous_treatment_efforts[0][provided_service]"
                                            name="previous_treatment_efforts[0][provided_service]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.provided_service')}} ..."
                                            value="{{ old('previous_treatment_efforts[0][provided_service]') }}">

                                    </div>
                                </div>

                                {{-- Provided Service Effects --}}
                                <div class="col-md-4">
                                    <label for="validationCustomUserPhoneNumber" class="form-label d-block">
                                        {{__('students.provided_service_effects')}}
                                    </label>
                                    <div class="d-flex justify-content-between mt-3">
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio"
                                                name="previous_treatment_efforts[0][provided_service_effects]"
                                                id="previous_treatment_efforts[0][provided_service_effects][negative]"
                                                value="negative">
                                            <label class="form-check-label"
                                                for="previous_treatment_efforts[0][provided_service_effects][negative]">
                                                {{__('students.negative')}}
                                            </label>
                                        </div>
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio"
                                                id="previous_treatment_efforts[0][provided_service_effects][positive]"
                                                name="previous_treatment_efforts[0][provided_service_effects]"
                                                value="positive">
                                            <label class="form-check-label"
                                                for="previous_treatment_efforts[0][provided_service_effects][positive]">
                                                {{__('students.positive')}}
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="efforts_fields();"></i>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- Genetic Diseases --}}
                    <div class="d-flex align-items-start flex-column">
                        <div class="col-md-4 switchParent">
                            <div class="form-check form-switch">
                                <input class="form-check-input " type="checkbox" role="switch" id="genetic_diseases">
                                <label class="form-check-label" for="genetic_diseases">
                                    {{__('students.genetic_diseases')}}
                                </label>
                            </div>
                        </div>
                        <div class="w-100 d-none noParents" id="noParents4">
                            <div class="row g-3  align-items-end mb-2">

                                {{-- Name --}}
                                <div class="col-md-3">
                                    <label for="genetic_diseases[0][name]" class="form-label">{{__('students.name_of_genetic_diseases')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <input type="text" class="form-control" name="genetic_diseases[0][name]"
                                            id="genetic_diseases[0][name]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.name_of_genetic_diseases')}} ..." value="{{ old('genetic_diseases[0][name]') }}">
                                    </div>
                                </div>

                                {{-- Age At Injury --}}
                                <div class="col-md-3">
                                    <label for="genetic_diseases[0][age_at_injury]" class="form-label">
                                        {{__('students.age_at_inJury')}}
                                    </label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input type="text" class="form-control" name="genetic_diseases[0][age_at_injury]"
                                            id="genetic_diseases[0][age_at_injury]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.age_at_inJury')}} ..."
                                            value="{{ old('genetic_diseases[0][age_at_injury]') }}">

                                    </div>
                                </div>

                                {{-- Degree Of Kinship --}}
                                <div class="col-md-3">
                                    <label for="genetic_diseases[0][degree_of_kinship]" class="form-label">
                                        {{__('students.degree_of_kinship')}}
                                    </label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"><i
                                                class="fa-solid fa-phone"></i></span>
                                        <input type="text" class="form-control"
                                            id="genetic_diseases[0][degree_of_kinship]"
                                            name="genetic_diseases[0][degree_of_kinship]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.degree_of_kinship')}} ..."
                                            value="{{ old('genetic_diseases[0][degree_of_kinship]') }}">

                                    </div>
                                </div>

                                {{-- Disease --}}
                                <div class="col-md-2">
                                    <label for="genetic_diseases[0][disease]" class="form-label">{{__('students.disease')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-address-card"></i></span>
                                        <input type="text" class="form-control" id="genetic_diseases[0][disease]"
                                            name="genetic_diseases[0][disease]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.disease')}} ..."
                                            value="{{ old('genetic_diseases[0][disease]') }}">

                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="body_problems_fields();"></i>
                                </div>

                            </div>
                        </div>
                    </div>

                    {{-- Injuries And Wounds --}}
                    <div class="d-flex align-items-start flex-column">
                        <div class="col-md-4 switchParent">
                            <div class="form-check form-switch">
                                <input class="form-check-input " type="checkbox" role="switch" id="injuries_and_wounds">
                                <label class="form-check-label" for="injuries_and_wounds">
                                    {{__('students.injuries_and_wounds')}}
                                </label>
                            </div>
                        </div>

                        {{-- Injury --}}
                        <div class="w-100 d-none noParents" id="noParents5">
                            <div class="row g-3  align-items-end mb-2">
                                <div class="col-md-3">
                                    <label for="injuries_and_wounds[0][injury]" class="form-label">{{__('students.injury')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <input type="text" class="form-control" id="injuries_and_wounds[0][injury]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.injury')}} ..."
                                            value="{{ old('injuries_and_wounds[0][injury]') }}">
                                    </div>
                                </div>

                                {{-- Age At Injury --}}
                                <div class="col-md-3">
                                    <label for="injuries_and_wounds[0][age_at_injury]" class="form-label">
                                        {{__('students.age_at_injury')}}
                                    </label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input type="text" class="form-control"
                                            id="injuries_and_wounds[0][age_at_injury]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.age_at_injury')}} ..."
                                            value="{{ old('injuries_and_wounds[0][age_at_injury]') }}">
                                    </div>
                                </div>

                                {{-- Clinic --}}
                                <div class="col-md-3">
                                    <label for="injuries_and_wounds[0][provided_service]"
                                        class="form-label">{{__('students.clinic')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"><i
                                                class="fa-solid fa-phone"></i></span>
                                        <input type="number" class="form-control"
                                            id="injuries_and_wounds[0][provided_service]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.clinic')}} ..."
                                            value="{{ old('injuries_and_wounds[0][provided_service]') }}">

                                    </div>
                                </div>

                                {{-- Results --}}
                                <div class="col-md-2">
                                    <label for="injuries_and_wounds[0][result]" class="form-label">{{__('students.results')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-address-card"></i></span>
                                        <input type="text" class="form-control" id="injuries_and_wounds[0][result]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.results')}} ..."
                                            value="{{ old('injuries_and_wounds[0][result]') }}">
                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="Injuries_problems_fields();"></i>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Family History Info --}}
            <div class="tab-pane fade" id="pills-family-history" role="tabpanel"
                aria-labelledby="pills-family-history-tab">


                <div class="row g-3 align-items-end">

                    {{-- Father Info --}}
                    <div class="col-md-8 mt-4">
                        <label for="father_info" class="form-label">{{__('students.father_info')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <input class="form-control" list="datalistOptions" id="exampleDataList" name="father_id"
                                placeholder="{{__('students.type_to_search')}}">
                            <datalist id="datalistOptions" class="text-start " name="father_id">
                                <option value="" disabled>{{__('students.choose_option')}}</option>
                                @foreach ($student_father_profiles as $student_father_profile)
                                    <option value="{{ $student_father_profile->id }}"
                                        {{ old('father_id') == '$student_father_profile->id' ? 'selected' : '' }}>
                                        ({{__('students.name')}} : {{ $student_father_profile->father_name }})
                                        / ( {{__('students.national_id')}} : {{ $student_father_profile->father_national_number }} )
                                    </option>
                                @endforeach
                            </datalist>
                        </div>

                    </div>
                    <div class="col-md-2 d-flex justify-content-end">
                        <i class="fa-regular fa-plus  icons bg-success text-white" onclick="fatherInfo();"></i>
                    </div>
                    <div id="FatherInfo" class="col-md-12 ">
                        <div class="rounded shadow-sm p-3 my-4 d-flex justify-content-start">
                            <ul class="nav flex-column nav-pills me-3 col-2" id="v-pills-tab" role="tablist"
                                aria-orientation="vertical">

                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="FatherInfopills-basic-primary-tab"
                                        data-bs-toggle="pill" data-bs-target="#FatherInfopills-basic-primary" type="button"
                                        role="tab" aria-controls="FatherInfopills-basic-primary" aria-selected="true">{{__('students.basic_info')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="FatherInfopills-address-primary-tab"
                                        data-bs-toggle="pill" data-bs-target="#FatherInfopills-address-primary"
                                        type="button" role="tab" aria-controls="FatherInfopills-address-primary"
                                        aria-selected="false">{{__('students.address_info')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="FatherInfopills-social-links-tab"
                                        data-bs-toggle="pill" data-bs-target="#FatherInfopills-social-links" type="button"
                                        role="tab" aria-controls="FatherInfopills-social-links" aria-selected="false">{{__('students.social_links')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="FatherInfopills-education-primary-tab"
                                        data-bs-toggle="pill" data-bs-target="#FatherInfopills-education-primary"
                                        type="button" role="tab" aria-controls="FatherInfopills-education-primary"
                                        aria-selected="false">{{__('students.education_info')}}</button>
                                </li>
                            </ul>


                            {{-- Basic Info Group --}}

                            <div class="tab-content col-10" id="v-pills-tabContent">
                                <div class="tab-pane fade show active px-3" id="FatherInfopills-basic-primary"
                                    role="tabpanel" aria-labelledby="FatherInfopills-basic-primary-tab">


                                    <div class="row">

                                        {{-- Full Name --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_name" class="form-label">{{__('students.parent_name')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_name"
                                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.parent_name')}} ..."
                                                    name="father_name" value="{{ old('father_name') }}">

                                            </div>
                                        </div>

                                        {{-- Email --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_email" class="form-label">{{__('students.parent_email')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_email"
                                                    aria-describedby="father_email"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_email')}} ..." name="father_email"
                                                    value="{{ old('father_email') }}">

                                            </div>
                                        </div>

                                        {{-- Mobile Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_phone" class="form-label">{{__('students.parent_phone')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-mobile-screen-button"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_phone"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_phone')}} . . ." name="father_phone"
                                                    value="{{ old('father_phone') }}">

                                            </div>
                                        </div>

                                        {{-- Alternative Mobile Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_alternative_phone" class="form-label">{{__('students.parent_alternative_phone')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-mobile-screen-button"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="father_alternative_phone"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_alternative_phone')}} . . ."
                                                    name="father_alternative_phone"
                                                    value="{{ old('father_alternative_phone') }}">

                                            </div>
                                        </div>

                                        {{-- Nationality --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_nationality" class="form-label">{{__('students.parent_nationality')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-building"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_nationality"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_nationality')}} . . ." name="father_nationality"
                                                    value="{{ old('father_nationality') }}">

                                            </div>
                                        </div>

                                        {{-- National Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_national_number" class="form-label">{{__('students.parent_national_number')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-id-card"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="father_national_number"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_national_number')}} . . ."
                                                    name="father_national_number"
                                                    value="{{ old('father_national_number') }}">

                                            </div>
                                        </div>


                                        {{-- Date of Birth --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_dob" class="form-label">{{__('students.parent_dob')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-calendar-minus"></i>
                                                </span>
                                                <input type="date" class="form-control text-start" id="father_dob"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_dob')}} . . ." name="father_dob"
                                                    value="{{ old('father_dob') }}">

                                            </div>
                                        </div>

                                        {{-- Father Job --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_job" class="form-label">{{__('students.parent_job')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-user-doctor"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_job"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_job')}} . . ." name="father_job"
                                                    value="{{ old('father_job') }}">

                                            </div>
                                        </div>

                                        {{-- Degree Of Kinship --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_degree_of_kinship" class="form-label">{{__('students.parent_degree_of_kinship')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-file-excel"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="father_degree_of_kinship"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_degree_of_kinship')}} . . ."
                                                    name="father_degree_of_kinship"
                                                    value="{{ old('father_degree_of_kinship') }}">

                                            </div>
                                        </div>

                                        {{-- Marital Status --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_marital_status" class="form-label">{{__('students.marital_status')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                                <select class="form-control text-start custom-select"
                                                    id="father_marital_status" name="father_marital_status">
                                                    <option value="">{{__('students.choose_option')}}</option>
                                                    <option value="Single"
                                                        {{ old('father_marital_status') == 'Single' ? 'selected' : '' }}>
                                                        {{__('students.single')}}
                                                    </option>
                                                    <option value="Married"
                                                        {{ old('father_marital_status') == 'Married' ? 'selected' : '' }}>
                                                        {{__('students.married')}}
                                                    </option>
                                                    <option value="Divorced"
                                                        {{ old('father_marital_status') == 'Divorced' ? 'selected' : '' }}>
                                                        {{__('students.divorced')}}
                                                    </option>
                                                </select>

                                            </div>
                                        </div>
                                        {{-- Upload Image --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_image_input" class="form-label filelabel">
                                                <i class="fa fa-paperclip">
                                                </i>
                                                <span class="title">
                                                    {{__('students.upload_image')}}
                                                </span>
                                                <input class="FileUpload1" id="father_image_input" name="father_image"
                                                    type="file" />
                                            </label>
                                            {{-- <input type="file" name="image" id="image"> --}}

                                        </div>

                                    </div>

                                </div>



                                {{-- Address Info --}}
                                <div class="tab-pane fade  px-3" id="FatherInfopills-address-primary" role="tabpanel"
                                    aria-labelledby="FatherInfopills-address-primary-tab">
                                    <div class="row">
                                        {{-- Address --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_address" class="form-label">{{__('students.address')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-location-dot"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_address"
                                                    aria-describedby="father_address" placeholder="{{__('students.enter')}} {{__('students.address')}} ..."
                                                    name="father_address" value="{{ old('father_address') }}">

                                            </div>
                                        </div>

                                        {{-- City --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_city" class="form-label">{{__('students.city')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-map-location"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_city"
                                                    aria-describedby="father_city" placeholder="{{__('students.enter')}} {{__('students.city')}} ..."
                                                    name="father_city" value="{{ old('father_city') }}">

                                            </div>
                                        </div>

                                        {{-- State --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_state" class="form-label">{{__('students.state')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-map"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_state"
                                                    aria-describedby="father_state" placeholder="{{__('students.enter')}} {{__('students.state')}} ..."
                                                    name="father_state" value="{{ old('father_state') }}">

                                            </div>
                                        </div>

                                        {{-- Country --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_country" class="form-label">{{__('students.country')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-map-pin"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_country"
                                                    aria-describedby="father_country" placeholder="{{__('students.enter')}} {{__('students.country')}} ..."
                                                    name="father_country" value="{{ old('father_country') }}">

                                            </div>
                                        </div>

                                        {{-- Landmark --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_landmark" class="form-label">{{__('students.landmark')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-landmark"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_landmark"
                                                    aria-describedby="father_landmark"
                                                    placeholder="{{__('students.enter')}} {{__('students.landmark')}} ..." name="father_landmark"
                                                    value="{{ old('father_landmark') }}">

                                            </div>
                                        </div>


                                    </div>
                                </div>



                                {{-- Socail Links --}}
                                <div class="tab-pane fade  px-3" id="FatherInfopills-social-links" role="tabpanel"
                                    aria-labelledby="FatherInfopills-social-links-tab">

                                    <div class="row">

                                        {{-- FaceBook Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_fb_link" class="form-label">{{__('students.facebook_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-brands fa-facebook-f"></i>
                                                </span>
                                                <input type="url" class="form-control text-start" id="father_fb_link"
                                                    placeholder="{{__('students.enter')}} {{__('students.facebook_link')}} ..." name="father_fb_link"
                                                    value="{{ old('father_fb_link') }}">

                                            </div>
                                        </div>

                                        {{-- Twitter Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_twitter_link" class="form-label">{{__('students.twitter_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-brands fa-twitter"></i>
                                                </span>
                                                <input type="url" class="form-control text-start" id="father_twitter_link"
                                                    placeholder="{{__('students.enter')}} {{__('students.twitter_link')}} ..." name="father_twitter_link"
                                                    value="{{ old('father_twitter_link') }}">

                                            </div>
                                        </div>

                                        {{-- Social Media Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_social_media_1" class="form-label">{{__('students.social_media_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-hashtag"></i>
                                                </span>
                                                <input type="url" class="form-control text-start"
                                                    id="father_social_media_1"
                                                    placeholder="{{__('students.enter')}} {{__('students.social_media_link')}} ..."
                                                    name="father_social_media_1"
                                                    value="{{ old('father_social_media_1') }}">

                                            </div>
                                        </div>

                                        {{-- Social Media Link 2 --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_social_media_2" class="form-label">{{__('students.social_media_link_2')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-hashtag"></i>
                                                </span>
                                                <input type="url" class="form-control text-start"
                                                    id="father_social_media_2"
                                                    placeholder="{{__('students.enter')}} {{__('students.social_media_link_2')}} ..."
                                                    name="father_social_media_2"
                                                    value="{{ old('father_social_media_2') }}">

                                            </div>
                                        </div>


                                    </div>
                                </div>


                                {{-- Education Info --}}
                                <div class="tab-pane fade  px-3" id="FatherInfopills-education-primary" role="tabpanel"
                                    aria-labelledby="FatherInfopills-education-primary-tab">

                                    <div class="row">

                                        {{-- Qualification --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_qualification" class="form-label">{{__('students.parent_qualification')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-file"></i>
                                                </span>
                                                <select class="form-control text-start custom-select"
                                                    id="father_qualification" name="father_qualification">
                                                    <option value="" disabled>{{__('students.choose_option')}}</option>
                                                    <option value="Bachelor"
                                                        {{ old('father_qualification') == 'Bachelor' ? 'selected' : '' }}>
                                                        {{__('students.bachelor')}}
                                                    </option>
                                                    <option value="Diploma"
                                                        {{ old('father_qualification') == 'Diploma' ? 'selected' : '' }}>
                                                        {{__('students.diploma')}}
                                                    </option>
                                                    <option value="Phd"
                                                        {{ old('father_qualification') == 'Phd' ? 'selected' : '' }}>{{__('students.phd')}}
                                                    </option>
                                                    <option value="Other"
                                                        {{ old('father_qualification') == 'Other' ? 'selected' : '' }}>
                                                        {{__('students.other')}}</option>
                                                </select>

                                            </div>
                                        </div>
                                        {{-- If other selected show the other qualification --}}
                                        {{-- Other Qualification --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_qualification_other" class="form-label">{{__('students.other_qualification')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-file"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="father_qualification_other"
                                                    aria-describedby="father_qualification_other"
                                                    placeholder="{{__('students.enter')}} {{__('students.other_qualification')}} ..."
                                                    name="father_qualification_other"
                                                    value="{{ old('father_qualification_other') }}">

                                            </div>
                                        </div>

                                        {{-- Wedding Date --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_wedding_date" class="form-label">{{__('students.wedding_date')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-calendar-days"></i>
                                                </span>
                                                <input type="date" class="form-control text-start" id="father_wedding_date"
                                                    placeholder="{{__('students.enter')}} {{__('students.wedding_date')}} . . ." name="father_wedding_date"
                                                    value="{{ old('father_wedding_date') }}">

                                            </div>
                                        </div>

                                        {{-- Interests --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="father_interests" class="form-label">{{__('students.interests')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-file"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="father_interests"
                                                    aria-describedby="father_interests"
                                                    placeholder="{{__('students.enter')}} {{__('students.interests')}} ..." name="father_interests"
                                                    value="{{ old('father_interests') }}">

                                            </div>
                                        </div>



                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    {{-- Additional Father INfo --}}
                    <div class="col-md-12">
                        <div class="col-md-6 mt-4">
                            <label for="father_age_when_applying" class="form-label">{{__('students.age_on_applying')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-regular fa-user"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="father_age_when_applying"
                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_applying')}} ..."
                                    name="father_age_when_applying" value="{{ old('father_age_when_applying') }}">
                            </div>
                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="father_age_at_student_birth" class="form-label">{{__('students.age_on_student_birth')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-regular fa-user"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="father_age_at_student_birth"
                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_student_birth')}} ..."
                                    name="father_age_at_student_birth" value="{{ old('father_age_at_student_birth') }}">
                            </div>
                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="father_relation_with_child" class="form-label">
                                {{__('students.relation_with_child')}}
                            </label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="father_relation_with_child">
                                    <i class="fa-solid fa-address-card"></i>
                                </span>
                                <textarea class="form-control" name="father_relation_with_child" placeholder="{{__('students.enter')}} {{__('students.relation_with_child')}}" id="father_relation_with_child"
                                    rows="3">{{ old('father_relation_with_child') }}</textarea>
                            </div>

                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="child_attitudes_towards_father" class="form-label">
                                {{__('students.child_attitudes_towards_father')}}
                            </label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="child_attitudes_towards_father">
                                    <i class="fa-solid fa-address-card"></i>
                                </span>
                                <textarea class="form-control" name="child_attitudes_towards_father"
                                    placeholder="{{__('students.enter')}} {{__('students.child_attitudes_towards_father')}} ..."
                                    id="child_attitudes_towards_father"
                                    rows="3">{{ old('child_attitudes_towards_father') }}</textarea>
                            </div>

                        </div>
                    </div>

                    {{-- Mother Info --}}
                    <div class="col-md-8 mt-4">
                        <label for="mother_info" class="form-label">{{__('students.mother_info')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <input class="form-control" list="datalistOptions" id="exampleDataList2" name="mother_id"
                                placeholder="Type to search...">
                            <datalist id="datalistOptions" class="text-start " name="mother_id">
                                <option value="" disabled>{{__('students.choose_option')}}</option>
                                @foreach ($student_mother_profiles as $student_mother_profile)
                                    <option value="{{ $student_mother_profile->id }}"
                                        {{ old('mother_id') == '$student_mother_profile->id' ? 'selected' : '' }}>
                                        ({{__('students.name')}} : {{ $student_mother_profile->mother_name }})
                                        / ( {{__('students.national_id')}} : {{ $student_mother_profile->mother_national_number }} )
                                    </option>
                                @endforeach
                            </datalist>
                        </div>
                    </div>
                    <div class="col-md-2 d-flex justify-content-end">
                        <i class="fa-regular fa-plus  icons bg-success text-white" onclick="motherInfo();"></i>
                    </div>
                    <div id="MotherInfo" class="col-md-12 ">
                        <div class="rounded shadow-sm p-3 my-4 d-flex justify-content-start">
                            <ul class="nav flex-column nav-pills me-3 col-2" id="v-pills-tab" role="tablist"
                                aria-orientation="vertical">

                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="MotherInfopills-basic-info-tab"
                                        data-bs-toggle="pill" data-bs-target="#MotherInfopills-basic-info" type="button"
                                        role="tab" aria-controls="MotherInfopills-basic-info" aria-selected="true">{{__('students.basic_info')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="MotherInfopills-address-info-tab"
                                        data-bs-toggle="pill" data-bs-target="#MotherInfopills-address-info" type="button"
                                        role="tab" aria-controls="MotherInfopills-address-info"
                                        aria-selected="false">{{__('students.address_info')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="MotherInfopills-social-links-tab"
                                        data-bs-toggle="pill" data-bs-target="#MotherInfopills-social-links" type="button"
                                        role="tab" aria-controls="MotherInfopills-social-links" aria-selected="false">{{__('students.social_links')}}</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="MotherInfopills-education-info-tab"
                                        data-bs-toggle="pill" data-bs-target="#MotherInfopills-education-info" type="button"
                                        role="tab" aria-controls="MotherInfopills-education-info"
                                        aria-selected="false">{{__('students.education_info')}}</button>
                                </li>
                            </ul>


                            {{-- Basic Info Group --}}

                            <div class="tab-content col-10" id="v-pills-tabContent2">

                                {{-- Basic Info Group --}}
                                <div class="tab-pane fade show active px-3" id="MotherInfopills-basic-info" role="tabpanel"
                                    aria-labelledby="MotherInfopills-basic-info-tab">
                                    <div class="row">

                                        {{-- Full Name --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_name" class="form-label">{{__('students.parent_name')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_name"
                                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.parent_name')}} ..."
                                                    name="mother_name" value="{{ old('mother_name') }}">
                                            </div>
                                        </div>

                                        {{-- Email --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_email" class="form-label">{{__('students.parent_email')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_email"
                                                    aria-describedby="mother_email"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_email')}} ..." name="mother_email"
                                                    value="{{ old('mother_email') }}">
                                            </div>
                                        </div>

                                        {{-- Mobile Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_phone" class="form-label">{{__('students.parent_phone')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_phone"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_phone')}} . . ." name="mother_phone"
                                                    value="{{ old('mother_phone') }}">
                                            </div>
                                        </div>

                                        {{-- Alternative Mobile Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_alternative_phone" class="form-label">{{__('students.parent_alternative_phone')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_alternative_phone"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_alternative_phone')}} . . ."
                                                    name="mother_alternative_phone"
                                                    value="{{ old('mother_alternative_phone') }}">
                                                <div class="invalid-feedback">
                                                    Please choose a student_name.
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Nationality --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_nationality" class="form-label">{{__('students.parent_nationality')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_nationality"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_nationality')}} . . ." name="mother_nationality"
                                                    value="{{ old('mother_nationality') }}">

                                            </div>
                                        </div>

                                        {{-- National Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_national_number" class="form-label">{{__('students.parent_national_number')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_national_number"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_national_number')}} . . ."
                                                    name="mother_national_number"
                                                    value="{{ old('mother_national_number') }}">

                                            </div>
                                        </div>

                                        {{-- Upload Image --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_image_input" class="form-label filelabel">
                                                <i class="fa fa-paperclip">
                                                </i>
                                                <span class="title">
                                                    {{__('students.upload_image')}}
                                                </span>
                                                <input class="FileUpload1" id="mother_image_input" name="mother_image"
                                                    type="file" />
                                            </label>

                                        </div>

                                        {{-- Date of Birth --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_dob" class="form-label">{{__('students.parent_dob')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="date" class="form-control text-start" id="mother_dob"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_dob')}} . . ." name="mother_dob"
                                                    value="{{ old('mother_dob') }}">

                                            </div>
                                        </div>

                                        {{-- Mother Job --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_job" class="form-label">{{__('students.parent_job')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_job"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_job')}} . . ." name="mother_job"
                                                    value="{{ old('mother_job') }}">
                                            </div>
                                        </div>

                                        {{-- Degree Of Kinship --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_degree_of_kinship" class="form-label">{{__('students.parent_degree_of_kinship')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_degree_of_kinship"
                                                    placeholder="{{__('students.enter')}} {{__('students.parent_degree_of_kinship')}} . . ."
                                                    name="mother_degree_of_kinship"
                                                    value="{{ old('mother_degree_of_kinship') }}">
                                            </div>
                                        </div>

                                        {{-- Marital Status --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_marital_status" class="form-label">{{__('students.marital_status')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                                <select class="form-control text-start custom-select"
                                                    id="mother_marital_status" name="mother_marital_status">
                                                    <option value="">{{__('students.choose_option')}}</option>
                                                    <option value="Single"
                                                        {{ old('mother_marital_status') == 'Single' ? 'selected' : '' }}>
                                                        {{__('students.single')}}
                                                    </option>
                                                    <option value="Married"
                                                        {{ old('mother_marital_status') == 'Married' ? 'selected' : '' }}>
                                                        {{__('students.married')}}
                                                    </option>
                                                    <option value="Divorced"
                                                        {{ old('mother_marital_status') == 'Divorced' ? 'selected' : '' }}>
                                                        {{__('students.divorced')}}
                                                    </option>
                                                </select>

                                            </div>
                                        </div>

                                    </div>

                                </div>

                                {{-- Address Info --}}
                                <div class="tab-pane fade show px-3" id="MotherInfopills-address-info" role="tabpanel"
                                    aria-labelledby="MotherInfopills-address-info-tab">

                                    <div class="row">

                                        {{-- Address --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_address" class="form-label">{{__('students.address')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_address"
                                                    aria-describedby="mother_address" placeholder="{{__('students.enter')}} {{__('students.address')}} ..."
                                                    name="mother_address" value="{{ old('mother_address') }}">

                                            </div>
                                        </div>

                                        {{-- City --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_city" class="form-label">{{__('students.city')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_city"
                                                    aria-describedby="mother_city" placeholder="{{__('students.enter')}} {{__('students.city')}} ..."
                                                    name="mother_city" value="{{ old('mother_city') }}">

                                            </div>
                                        </div>

                                        {{-- State --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_state" class="form-label">{{__('students.state')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_state"
                                                    aria-describedby="mother_state" placeholder="{{__('students.enter')}} {{__('students.state')}} ..."
                                                    name="mother_state" value="{{ old('mother_state') }}">

                                            </div>
                                        </div>

                                        {{-- Country --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_country" class="form-label">{{__('students.country')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_country"
                                                    aria-describedby="mother_country" placeholder="{{__('students.enter')}} {{__('students.country')}} ..."
                                                    name="mother_country" value="{{ old('mother_country') }}">

                                            </div>
                                        </div>

                                        {{-- Landmark --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_landmark" class="form-label">{{__('students.landmark')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_landmark"
                                                    aria-describedby="mother_landmark"
                                                    placeholder="{{__('students.enter')}} {{__('students.landmark')}} ..." name="mother_landmark"
                                                    value="{{ old('mother_landmark') }}">

                                            </div>
                                        </div>

                                    </div>
                                </div>



                                {{-- Socail Links --}}
                                <div class="tab-pane fade show px-3" id="MotherInfopills-social-links" role="tabpanel"
                                    aria-labelledby="MotherInfopills-social-links-tab">

                                    <div class="row">

                                        {{-- FaceBook Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_fb_link" class="form-label">{{__('students.facebook_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="url" class="form-control text-start" id="mother_fb_link"
                                                    placeholder="{{__('students.enter')}} {{__('students.facebook_link')}} ..." name="mother_fb_link"
                                                    value="{{ old('mother_fb_link') }}">

                                            </div>
                                        </div>

                                        {{-- Twitter Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_twitter_link" class="form-label">{{__('students.twitter_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="url" class="form-control text-start" id="mother_twitter_link"
                                                    placeholder="{{__('students.enter')}} {{__('students.twitter_link')}} ..." name="mother_twitter_link"
                                                    value="{{ old('mother_twitter_link') }}">

                                            </div>
                                        </div>

                                        {{-- Social Media Link --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_social_media_1" class="form-label">{{__('students.social_media_link')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="url" class="form-control text-start"
                                                    id="mother_social_media_1"
                                                    placeholder="{{__('students.enter')}} {{__('students.social_media_link')}} ..."
                                                    name="mother_social_media_1"
                                                    value="{{ old('mother_social_media_1') }}">

                                            </div>
                                        </div>

                                        {{-- Social Media Link 2 --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_social_media_2" class="form-label">{{__('students.social_media_link_2')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="url" class="form-control text-start"
                                                    id="mother_social_media_2"
                                                    placeholder="{{__('students.enter')}} {{__('students.social_media_link_2')}} ..."
                                                    name="mother_social_media_2"
                                                    value="{{ old('mother_social_media_2') }}">

                                            </div>
                                        </div>


                                    </div>
                                </div>


                                {{-- Education Info --}}
                                <div class="tab-pane fade show px-3" id="MotherInfopills-education-info" role="tabpanel"
                                    aria-labelledby="MotherInfopills-education-info-tab">

                                    <div class="row">

                                        {{-- Qualification --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_qualification" class="form-label">{{__('students.parent_qualification')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                                <select class="form-control text-start custom-select"
                                                    id="mother_qualification" name="mother_qualification">
                                                    <option value="" disabled>{{__('students.choose_option')}}</option>
                                                    <option value="Bachelor"
                                                        {{ old('mother_qualification') == 'Bachelor' ? 'selected' : '' }}>
                                                        {{__('students.bachelor')}}
                                                    </option>
                                                    <option value="Diploma"
                                                        {{ old('mother_qualification') == 'Diploma' ? 'selected' : '' }}>
                                                        {{__('students.diploma')}}
                                                    </option>
                                                    <option value="Phd"
                                                        {{ old('mother_qualification') == 'Phd' ? 'selected' : '' }}>{{__('students.phd')}}
                                                    </option>
                                                    <option value="Other"
                                                        {{ old('mother_qualification') == 'Other' ? 'selected' : '' }}>
                                                        {{__('students.other')}}</option>
                                                </select>

                                            </div>
                                        </div>
                                        {{-- If other selected show the other qualification --}}
                                        {{-- Other Qualification --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_qualification_other" class="form-label">{{__('students.other_qualification')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_qualification_other"
                                                    aria-describedby="mother_qualification_other"
                                                    placeholder="{{__('students.enter')}} {{__('students.other_qualification')}} ..."
                                                    name="mother_qualification_other"
                                                    value="{{ old('mother_qualification_other') }}">

                                            </div>
                                        </div>

                                        {{-- Wedding Date --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_wedding_date" class="form-label">{{__('students.wedding_date')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-regular fa-user"></i>
                                                </span>
                                                <input type="date" class="form-control text-start" id="mother_wedding_date"
                                                    placeholder="{{__('students.enter')}} {{__('students.wedding_date')}} . . ." name="mother_wedding_date"
                                                    value="{{ old('mother_wedding_date') }}">

                                            </div>
                                        </div>

                                        {{-- Interests --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_interests" class="form-label">{{__('students.interests')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start" id="mother_interests"
                                                    aria-describedby="mother_interests"
                                                    placeholder="{{__('students.enter')}} {{__('students.interests')}} ..." name="mother_interests"
                                                    value="{{ old('mother_interests') }}">

                                            </div>
                                        </div>

                                        {{-- Mother Pregnancy Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_pregnancy_number" class="form-label">{{__('students.mother_pregnancy_number')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_pregnancy_number" aria-describedby="mother_pregnancy_number"
                                                    name="mother_pregnancy_number"
                                                    placeholder="{{__('students.enter')}} {{__('students.mother_pregnancy_number')}} ..."
                                                    value="{{ old('mother_pregnancy_number') }}">

                                            </div>
                                        </div>

                                        {{-- Mother Miscarriages Number --}}
                                        <div class="col-md-4 mt-4">
                                            <label for="mother_miscarriages_number" class="form-label">{{__('students.mother_miscarriages_number')}}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </span>
                                                <input type="text" class="form-control text-start"
                                                    id="mother_miscarriages_number"
                                                    aria-describedby="mother_miscarriages_number"
                                                    placeholder="{{__('students.enter')}} {{__('students.mother_miscarriages_number')}} ..."
                                                    name="mother_miscarriages_number"
                                                    value="{{ old('mother_miscarriages_number') }}">

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    {{-- Additional Mother INfo --}}
                    <div class="col-md-12">
                        <div class="col-md-6 mt-4">
                            <label for="mother_age_when_applying" class="form-label">{{__('students.age_on_applying')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-regular fa-user"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="mother_age_when_applying"
                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_applying')}} ..."
                                    name="mother_age_when_applying" value="{{ old('mother_age_when_applying') }}">
                            </div>
                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="mother_age_at_student_birth" class="form-label">{{__('students.age_on_student_birth')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-regular fa-user"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="mother_age_at_student_birth"
                                    aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_student_birth')}} ..."
                                    name="mother_age_at_student_birth" value="{{ old('mother_age_at_student_birth') }}">
                            </div>
                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="mother_relation_with_child" class="form-label">
                                {{__('students.relation_with_child')}}
                            </label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="mother_relation_with_child">
                                    <i class="fa-solid fa-address-card"></i>
                                </span>
                                <textarea class="form-control" name="mother_relation_with_child" placeholder="{{__('students.enter')}} {{__('students.relation_with_child')}} ..."
                                    id="mother_relation_with_child"
                                    rows="3">{{ old('mother_relation_with_child') }}</textarea>
                            </div>

                        </div>
                        <div class="col-md-6 mt-4">
                            <label for="child_attitudes_towards_mother" class="form-label">
                                {{__('students.child_attitudes_towards_mother')}}
                            </label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="child_attitudes_towards_mother">
                                    <i class="fa-solid fa-address-card"></i>
                                </span>
                                <textarea class="form-control" name="child_attitudes_towards_mother"
                                    placeholder="{{__('students.enter')}} {{__('students.child_attitudes_towards_mother')}} ..."
                                    id="child_attitudes_towards_mother"
                                    rows="3">{{ old('child_attitudes_towards_mother') }}</textarea>
                            </div>

                        </div>
                    </div>

                    {{-- Superior Info --}}
                    <h4>{{__('students.superior')}}</h4>
                    <div class="d-flex justify-content-between mt-3 w-50">
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="are_Superior" id="are_Superior_yes"
                                value="Yes">
                            <label class="form-check-label" for="are_Superior_yes">
                                {{__('students.yes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="are_Superior" id="are_Superior_no"
                                value="No">
                            <label class="form-check-label" for="are_Superior_no">
                                {{__('students.no')}}
                            </label>
                        </div>


                    </div>
                    <div id="Superior" class="w-100  d-none">
                        <div class=" d-flex align-items-end">
                            <div class="col-md-8 mt-2">
                                <label for="superior_info" class="form-label">{{__('students.superior_info')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend">
                                        <i class="fa-solid fa-location-dot"></i>
                                    </span>
                                    <input class="form-control" list="datalistOptions" id="exampleDataList3"
                                        name="superior_id" placeholder="Type to search...">
                                    <datalist id="datalistOptions" class="text-start " name="superior_id">
                                        <option value="" disabled>{{__('students.choose_option')}}</option>
                                        @foreach ($student_superior_profiles as $student_superior_profile)
                                            <option value="{{ $student_superior_profile->id }}"
                                                {{ old('superior_id') == '$student_superior_profile->id' ? 'selected' : '' }}>
                                                ({{__('students.name')}} : {{ $student_superior_profile->superior_name }})
                                                / ( {{__('students.national_id')}} :
                                                {{ $student_superior_profile->superior_national_number }} )
                                            </option>
                                        @endforeach
                                    </datalist>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex justify-content-end">
                                <i class="fa-regular fa-plus  icons bg-success text-white" onclick="superiorInfo();"></i>
                            </div>
                        </div>
                        <div id="SuperiorInfo" class="col-md-12 ">
                            <div class="rounded shadow-sm p-3 my-4 d-flex justify-content-start">
                                <ul class="nav flex-column nav-pills me-3 col-2" id="v-pills-tab" role="tablist"
                                    aria-orientation="vertical">

                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="superiorInfopills-basic-info-tab"
                                            data-bs-toggle="pill" data-bs-target="#superiorInfopills-basic-info"
                                            type="button" role="tab" aria-controls="superiorInfopills-basic-info"
                                            aria-selected="true">{{__('students.basic_info')}}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="superiorInfopills-address-info-tab"
                                            data-bs-toggle="pill" data-bs-target="#superiorInfopills-address-info"
                                            type="button" role="tab" aria-controls="superiorInfopills-address-info"
                                            aria-selected="false">{{__('students.address_info')}}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="superiorInfopills-social-links-tab"
                                            data-bs-toggle="pill" data-bs-target="#superiorInfopills-social-links"
                                            type="button" role="tab" aria-controls="superiorInfopills-social-links"
                                            aria-selected="false">{{__('students.social_links')}}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="superiorInfopills-education-info-tab"
                                            data-bs-toggle="pill" data-bs-target="#superiorInfopills-education-info"
                                            type="button" role="tab" aria-controls="superiorInfopills-education-info"
                                            aria-selected="false">{{__('students.education_info')}}</button>
                                    </li>
                                </ul>


                                {{-- Basic Info Group --}}

                                <div class="tab-content col-10" id="v-pills-tabContent3">
                                    {{-- Basic Info Group --}}

                                    <div class="tab-pane fade show active px-3" id="superiorInfopills-basic-info"
                                        role="tabpanel" aria-labelledby="superiorInfopills-basic-info-tab">

                                        <div class="row">

                                            {{-- Full Name --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_name" class="form-label">{{__('students.parent_name')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_name"
                                                        aria-describedby="nameHelp"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_name')}} ..." name="superior_name"
                                                        value="{{ old('superior_name') }}">
                                                </div>
                                            </div>

                                            {{-- Email --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_email" class="form-label">{{__('students.parent_email')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_email"
                                                        aria-describedby="superior_email"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_email')}} ..." name="superior_email"
                                                        value="{{ old('superior_email') }}">

                                                </div>
                                            </div>

                                            {{-- Mobile Number --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_phone" class="form-label">{{__('students.parent_phone')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_phone"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_phone')}} . . ."
                                                        name="superior_phone" value="{{ old('superior_phone') }}">

                                                </div>
                                            </div>

                                            {{-- Alternative Mobile Number --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_alternative_phone" class="form-label">{{__('students.parent_alternative_phone')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_alternative_phone"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_alternative_phone')}} . . ."
                                                        name="superior_alternative_phone"
                                                        value="{{ old('superior_alternative_phone') }}">

                                                </div>
                                            </div>

                                            {{-- Nationality --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_nationality"
                                                    class="form-label">{{__('students.parent_nationality')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_nationality"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_nationality')}} . . ."
                                                        name="superior_nationality"
                                                        value="{{ old('superior_nationality') }}">

                                                </div>
                                            </div>

                                            {{-- National Number --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_national_number" class="form-label">{{__('students.parent_national_number')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_national_number"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_national_number')}} . . ."
                                                        name="superior_national_number"
                                                        value="{{ old('superior_national_number') }}">

                                                </div>
                                            </div>

                                            {{-- Upload Image --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_image_input" class="form-label filelabel">
                                                    <i class="fa fa-paperclip">
                                                    </i>
                                                    <span class="title">
                                                       {{__('students.upload_image')}}
                                                    </span>
                                                    <input class="FileUpload1" id="superior_image_input"
                                                        name="superior_image" type="file" />
                                                </label>

                                            </div>

                                            {{-- Date of Birth --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_dob" class="form-label">{{__('students.parent_dob')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="date" class="form-control text-start" id="superior_dob"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_dob')}} . . ." name="superior_dob"
                                                        value="{{ old('superior_dob') }}">

                                                </div>
                                            </div>

                                            {{-- Gender --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_gender" class="form-label">{{__('students.gender')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                    <select class="form-control text-start custom-select"
                                                        id="superior_gender" name="superior_gender">
                                                        <option value="" disabled>{{__('students.choose_option')}}</option>
                                                        <option value="Male"
                                                            {{ old('superior_gender') == 'Male' ? 'selected' : '' }}>
                                                            {{__('students.male')}}</option>
                                                        <option value="Female"
                                                            {{ old('superior_gender') == 'Female' ? 'selected' : '' }}>
                                                            {{__('students.female')}}
                                                        </option>
                                                    </select>

                                                </div>
                                            </div>

                                            {{-- Superior Job --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_job" class="form-label">{{__('students.parent_job')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_job"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_job')}} . . ." name="superior_job"
                                                        value="{{ old('superior_job') }}">

                                                </div>
                                            </div>

                                            {{-- Degree Of Kinship --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_degree_of_kinship" class="form-label">{{__('students.parent_degree_of_kinship')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_degree_of_kinship"
                                                        placeholder="{{__('students.enter')}} {{__('students.parent_degree_of_kinship')}} . . ."
                                                        name="superior_degree_of_kinship"
                                                        value="{{ old('superior_degree_of_kinship') }}">

                                                </div>
                                            </div>

                                            {{-- Marital Status --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_marital_status" class="form-label">{{__('students.marital_status')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                    <select class="form-control text-start custom-select"
                                                        id="superior_marital_status" name="superior_marital_status">
                                                        <option value="">{{__('students.choose_option')}}</option>
                                                        <option value="Single"
                                                            {{ old('superior_marital_status') == 'Single' ? 'selected' : '' }}>
                                                            {{__('students.single')}}
                                                        </option>
                                                        <option value="Married"
                                                            {{ old('superior_marital_status') == 'Married' ? 'selected' : '' }}>
                                                            {{__('students.married')}}
                                                        </option>
                                                        <option value="Divorced"
                                                            {{ old('superior_marital_status') == 'Divorced' ? 'selected' : '' }}>
                                                            {{__('students.divorced')}}
                                                        </option>
                                                    </select>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Address Info --}}
                                    <div class="tab-pane fade show px-3" id="superiorInfopills-address-info"
                                        role="tabpanel" aria-labelledby="superiorInfopills-address-info-tab">

                                        <div class="row">

                                            {{-- Address --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_address" class="form-label">{{__('students.address')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_address" aria-describedby="superior_address"
                                                        placeholder="{{__('students.enter')}} S{{__('students.address')}} ..." name="superior_address"
                                                        value="{{ old('superior_address') }}">

                                                </div>
                                            </div>

                                            {{-- City --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_city" class="form-label">{{__('students.city')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_city"
                                                        aria-describedby="superior_city"
                                                        placeholder="{{__('students.enter')}} {{__('students.city')}} ..." name="superior_city"
                                                        value="{{ old('superior_city') }}">

                                                </div>
                                            </div>

                                            {{-- State --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_state" class="form-label">{{__('students.state')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start" id="superior_state"
                                                        aria-describedby="superior_state"
                                                        placeholder="{{__('students.enter')}} {{__('students.state')}} ..." name="superior_state"
                                                        value="{{ old('superior_state') }}">

                                                </div>
                                            </div>

                                            {{-- Country --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_country" class="form-label">{{__('students.country')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_country" aria-describedby="superior_country"
                                                        placeholder="{{__('students.enter')}} {{__('students.country')}} ..." name="superior_country"
                                                        value="{{ old('superior_country') }}">

                                                </div>
                                            </div>

                                            {{-- Landmark --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_landmark" class="form-label">{{__('students.landmark')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_landmark" aria-describedby="superior_landmark"
                                                        placeholder="{{__('students.enter')}} {{__('students.landmark')}} ..." name="superior_landmark"
                                                        value="{{ old('superior_landmark') }}">

                                                </div>
                                            </div>


                                        </div>
                                    </div>

                                    {{-- Socail Links --}}
                                    <div class="tab-pane fade show px-3" id="superiorInfopills-social-links"
                                        role="tabpanel" aria-labelledby="superiorInfopills-social-links-tab">

                                        <div class="row">

                                            {{-- FaceBook Link --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_fb_link" class="form-label">{{__('students.facebook_link')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="url" class="form-control text-start" id="superior_fb_link"
                                                        placeholder="{{__('students.enter')}} {{__('students.facebook_link')}} ..."
                                                        name="superior_fb_link" value="{{ old('superior_fb_link') }}">

                                                </div>
                                            </div>

                                            {{-- Twitter Link --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_twitter_link" class="form-label">{{__('students.twitter_link')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="url" class="form-control text-start"
                                                        id="superior_twitter_link"
                                                        placeholder="{{__('students.enter')}} {{__('students.twitter_link')}} ..."
                                                        name="superior_twitter_link"
                                                        value="{{ old('superior_twitter_link') }}">

                                                </div>
                                            </div>

                                            {{-- Social Media Link --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_social_media_1" class="form-label">{{__('students.social_media_link')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="url" class="form-control text-start"
                                                        id="superior_social_media_1"
                                                        placeholder="{{__('students.enter')}} {{__('students.social_media_link')}} ..."
                                                        name="superior_social_media_1"
                                                        value="{{ old('superior_social_media_1') }}">

                                                </div>
                                            </div>

                                            {{-- Social Media Link 2 --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_social_media_2" class="form-label">{{__('students.social_media_link_2')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="url" class="form-control text-start"
                                                        id="superior_social_media_2"
                                                        placeholder="{{__('students.enter')}} {{__('students.social_media_link_2')}} ..."
                                                        name="superior_social_media_2"
                                                        value="{{ old('superior_social_media_2') }}">

                                                </div>
                                            </div>


                                        </div>
                                    </div>

                                    {{-- Education Info --}}
                                    <div class="tab-pane fade show px-3" id="superiorInfopills-education-info"
                                        role="tabpanel" aria-labelledby="superiorInfopills-education-info-tab">

                                        <div class="row">

                                            {{-- Qualification --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_qualification"
                                                    class="form-label">{{__('students.parent_qualification')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                    <select class="form-control text-start custom-select"
                                                        id="superior_qualification" name="superior_qualification">
                                                        <option value="" disabled>{{__('students.choose_option')}}</option>
                                                        <option value="Bachelor"
                                                            {{ old('superior_qualification') == 'Bachelor' ? 'selected' : '' }}>
                                                            {{__('students.bachelor')}}
                                                        </option>
                                                        <option value="Diploma"
                                                            {{ old('superior_qualification') == 'Diploma' ? 'selected' : '' }}>
                                                            {{__('students.diploma')}}
                                                        </option>
                                                        <option value="Phd"
                                                            {{ old('superior_qualification') == 'Phd' ? 'selected' : '' }}>
                                                            {{__('students.phd')}}
                                                        </option>
                                                        <option value="Other"
                                                            {{ old('superior_qualification') == 'Other' ? 'selected' : '' }}>
                                                            {{__('students.other')}}
                                                        </option>
                                                    </select>

                                                </div>
                                            </div>
                                            {{-- If other selected show the other qualification --}}
                                            {{-- Other Qualification --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_qualification_other" class="form-label">{{__('students.other_qualification')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_qualification_other"
                                                        aria-describedby="superior_qualification_other"
                                                        placeholder="{{__('students.enter')}} {{__('students.other_qualification')}} ..."
                                                        name="superior_qualification_other"
                                                        value="{{ old('superior_qualification_other') }}">

                                                </div>
                                            </div>

                                            {{-- Wedding Date --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_wedding_date" class="form-label">{{__('students.wedding_date')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-regular fa-user"></i>
                                                    </span>
                                                    <input type="date" class="form-control text-start"
                                                        id="superior_wedding_date"
                                                        placeholder="{{__('students.enter')}} {{__('students.wedding_date')}} . . ."
                                                        name="superior_wedding_date"
                                                        value="{{ old('superior_wedding_date') }}">

                                                </div>
                                            </div>

                                            {{-- Interests --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_interests" class="form-label">{{__('students.interests')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_interests" aria-describedby="superior_interests"
                                                        placeholder="{{__('students.enter')}} S{{__('students.interests')}} ..." name="superior_interests"
                                                        value="{{ old('superior_interests') }}">

                                                </div>
                                            </div>

                                            {{-- Superior Pregnancy Number --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_pregnancy_number" class="form-label">{{__('students.superior_pregnancy_number')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_pregnancy_number"
                                                        aria-describedby="superior_pregnancy_number"
                                                        placeholder="{{__('students.enter')}} {{__('students.superior_pregnancy_number')}} ..."
                                                        name="superior_pregnancy_number"
                                                        value="{{ old('superior_pregnancy_number') }}">

                                                </div>
                                                <small id="superior_pregnancy_number" class="form-text text-muted">
                                                    {{__('students.please_anwser_it_if_geneder_is_female')}}
                                                </small>
                                            </div>

                                            {{-- Superior Miscarriages Number --}}
                                            <div class="col-md-4 mt-4">
                                                <label for="superior_miscarriages_number" class="form-label">{{__('students.superior_miscarriages_number')}}</label>
                                                <div class="input-group has-validation">
                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                        <i class="fa-solid fa-envelope"></i>
                                                    </span>
                                                    <input type="text" class="form-control text-start"
                                                        id="superior_miscarriages_number"
                                                        aria-describedby="superior_miscarriages_number"
                                                        placeholder="{{__('students.enter')}} {{__('students.superior_miscarriages_number')}} ..."
                                                        name="superior_miscarriages_number"
                                                        value="{{ old('superior_miscarriages_number') }}">

                                                </div>
                                                <small id="superior_miscarriages_number" class="form-text text-muted">
                                                    {{__('students.please_anwser_it_if_geneder_is_female')}}
                                                </small>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        {{-- Additional Superior INfo --}}
                        <div class="col-md-12">
                            <div class="col-md-6 mt-4">
                                <label for="superior_age_when_applying" class="form-label">{{__('students.age_on_applying')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend">
                                        <i class="fa-regular fa-user"></i>
                                    </span>
                                    <input type="text" class="form-control text-start" id="superior_age_when_applying"
                                        aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_applying')}} ..."
                                        name="superior_age_when_applying"
                                        value="{{ old('superior_age_when_applying') }}">
                                </div>
                            </div>
                            <div class="col-md-6 mt-4">
                                <label for="superior_age_at_student_birth" class="form-label">{{__('students.age_on_student_birth')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend">
                                        <i class="fa-regular fa-user"></i>
                                    </span>
                                    <input type="text" class="form-control text-start" id="superior_age_at_student_birth"
                                        aria-describedby="nameHelp" placeholder="{{__('students.enter')}} {{__('students.age_on_student_birth')}} ..."
                                        name="superior_age_at_student_birth"
                                        value="{{ old('superior_age_at_student_birth') }}">
                                </div>
                            </div>
                            <div class="col-md-6 mt-4">
                                <label for="superior_relation_with_child" class="form-label">
                                    {{__('students.relation_with_child')}}
                                </label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="superior_relation_with_child">
                                        <i class="fa-solid fa-address-card"></i>
                                    </span>
                                    <textarea class="form-control" name="superior_relation_with_child"
                                        placeholder="{{__('students.enter')}} {{__('students.relation_with_child')}}..."
                                        id="superior_relation_with_child"
                                        rows="3">{{ old('superior_relation_with_child') }}</textarea>
                                </div>

                            </div>
                            <div class="col-md-6 mt-4">
                                <label for="child_attitudes_towards_superior" class="form-label">
                                    {{__('students.child_attitudes_towards_superior')}}
                                </label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="child_attitudes_towards_superior">
                                        <i class="fa-solid fa-address-card"></i>
                                    </span>
                                    <textarea class="form-control" name="child_attitudes_towards_superior"
                                        placeholder="{{__('students.enter')}} {{__('students.child_attitudes_towards_superior')}} ..."
                                        id="child_attitudes_towards_superior"
                                        rows="3">{{ old('child_attitudes_towards_superior') }}</textarea>
                                </div>

                            </div>
                        </div>
                    </div>



                    <h4 class="pt-2">{{__('students.relation_between_parents')}}</h4>
                    <div class="col-md-9">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">
                            {{__('students.type_of_relation')}}
                        </label>
                        <div class="d-flex justify-content-between mt-3">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="relation_between_parents"
                                    id="relation_between_parents_good" value="good">
                                <label class="form-check-label" for="relation_between_parents_good">
                                    {{__('students.good')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="relation_between_parents"
                                    id="relation_between_parents_normal" value="normal">
                                <label class="form-check-" for="relation_between_parents_normal">
                                    {{__('students.normal')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="relation_between_parents"
                                    id="relation_between_parents_not_stable" value="not_stable">
                                <label class="form-check-label d-inline" for="relation_between_parents_not_stable">
                                    {{__('students.not_stable')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="relation_between_parents"
                                    id="relation_between_parents_not_divorce" value="divorce">
                                <label class="form-check-label" for="relation_between_parents_not_divorce">
                                    {{__('students.divorce')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Main Problems Between Parents --}}
                    <div class="col-md-4">
                        <label for="birth_address" class="form-label">
                            {{__('students.main_problems_between_parents')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="main_problems_between_parents">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <textarea class="form-control" name="main_problems_between_parents" id="main_problems_between_parents" rows="3"
                                placeholder="{{__('students.enter')}} {{__('students.main_problems_between_parents')}} ...">{{ old('main_problems_between_parents') }}</textarea>
                        </div>

                    </div>

                    {{-- Child Attitude Towards Family Problems --}}
                    <div class="col-md-4">
                        <label for="child_attitude_towards_family_problems" class="form-label">
                            {{__('students.child_attitude_towards_family_problems')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <textarea class="form-control" name="child_attitude_towards_family_problems"
                                id="child_attitude_towards_family_problems" rows="3"
                                placeholder="{{__('students.enter')}} {{__('students.child_attitude_towards_family_problems')}} ...">{{ old('child_attitude_towards_family_problems') }}</textarea>
                        </div>

                    </div>

                    {{-- Brothers And Sisters --}}
                    <h4>{{__('students.brothers_and_sisters')}}</h4>
                    <div class="d-flex flex-column">
                        <div class="w-100  noParents" id="noParents6">
                            <div class="row g-3  align-items-end  my-3">

                                {{-- Name --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][name]" class="form-label">{{__('students.name')}}</label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control" id="brothers_and_sisters[0][name]"
                                            name="brothers_and_sisters[0][name]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.name')}} ..."
                                            value="{{ old('brothers_and_sisters[0][name]') }}">

                                    </div>
                                </div>

                                {{-- Age --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][dob]" class="form-label">{{__('students.age')}}</label>
                                    <input type="text" class="form-control" id="brothers_and_sisters[0][dob]"
                                        name="brothers_and_sisters[0][dob]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.age')}} ..." value="{{ old('brothers_and_sisters[0][dob]') }}">

                                </div>

                                {{-- Gender --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][gender]" class="form-label">{{__('students.gender')}}</label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control" id="brothers_and_sisters[0][gender]"
                                            name="brothers_and_sisters[0][gender]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.gender')}} ..."
                                            value="{{ old('brothers_and_sisters[0][gender]') }}">

                                    </div>
                                </div>

                                {{-- Job --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][job]" class="form-label">{{__('students.job')}}</label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control" id="brothers_and_sisters[0][job]"
                                            name="brothers_and_sisters[0][job]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.job')}} ..."
                                            value="{{ old('brothers_and_sisters[0][job]') }}">

                                    </div>
                                </div>

                                {{-- Status --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][status]" class="form-label">{{__('students.status')}}</label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control" id="brothers_and_sisters[0][status]"
                                            name="brothers_and_sisters[0][status]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.status')}} ..."
                                            value="{{ old('brothers_and_sisters[0][status]') }}">

                                    </div>
                                </div>

                                {{-- Education Level --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][education_level]" class="form-label">
                                        {{__('students.education_level')}}</label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control"
                                            id="brothers_and_sisters[0][education_level]"
                                            name="brothers_and_sisters[0][education_level]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.education_level')}} ..."
                                            value="{{ old('brothers_and_sisters[0][education_level]') }}">

                                    </div>
                                </div>

                                {{-- Relation With Student --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][relation_with_student]" class="form-label">
                                        {{__('students.relation_with_student')}}
                                    </label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control"
                                            id="brothers_and_sisters[0][relation_with_student]"
                                            name="brothers_and_sisters[0][relation_with_student]"
                                            aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.relation_with_student')}} ..."
                                            value="{{ old('brothers_and_sisters[0][relation_with_student]') }}">

                                    </div>
                                </div>

                                {{-- Student Relation --}}
                                <div class="col-md">
                                    <label for="brothers_and_sisters[0][student_relation]" class="form-label">
                                        {{__('students.student_relation')}}
                                    </label>
                                    <div class="input-group has-validation">

                                        <input type="text" class="form-control"
                                            id="brothers_and_sisters[0][student_relation]"
                                            name="brothers_and_sisters[0][student_relation]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.student_relation')}} ..."
                                            value="{{ old('brothers_and_sisters[0][student_relation]') }}">

                                    </div>
                                </div>

                                <div class="col-md d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="siblings_fields();"></i>
                                </div>

                            </div>
                        </div>
                    </div>
                    {{-- brothers and sisters Notes --}}
                    <div class="col-md-6">
                        <label for="brothers_and_sisters_notes" class="form-label">
                            {{__('students.brothers_and_sisters_notes')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <textarea class="form-control" name="brothers_and_sisters_notes" id="brothers_and_sisters_notes" rows="2"
                                placeholder="{{__('students.enter')}} {{__('students.brothers_and_sisters_notes')}} ...">{{ old('brothers_and_sisters_notes') }}</textarea>
                        </div>

                    </div>

                    {{-- Are Relatives ?! --}}
                    <div class="col-md-8">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">
                            {{__('students.are_relatives')}}
                        </label>
                        <div class="d-flex justify-content-between mt-3 w-50">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="are_relatives"
                                    id="are_relatives_yes" value="Yes">
                                <label class="form-check-label" for="are_relatives_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="are_relatives"
                                    id="are_relatives_no" value="No">
                                <label class="form-check-label" for="are_relatives_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>
                    {{-- Other Relative Data --}}
                    <div class="w-100 d-none noParents " id="noParents7">
                        <div class="row g-3  align-items-end mb-2">

                            {{-- Name --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][name]" class="form-label">{{__('students.name')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"> <i
                                            class="fa-regular fa-user "></i></span>
                                    <input type="text" class="form-control" id="other_relatives[0][name]"
                                        name="other_relatives[0][name]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.name')}} ..." value="{{ old('other_relatives[0][name]') }}">
                                </div>
                            </div>

                            {{-- Age --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][dob]" class="form-label">{{__('students.age')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend">@</span>
                                    <input type="text" class="form-control" id="other_relatives[0][dob]"
                                        name="other_relatives[0][dob]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.age')}} ..." value="{{ old('other_relatives[0][dob]') }}">

                                </div>
                            </div>

                            {{-- Relationship --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][relationship]" class="form-label">{{__('students.relationship')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"><i
                                            class="fa-solid fa-phone"></i></span>
                                    <input type="text" class="form-control" id="other_relatives[0][relationship]"
                                        name="other_relatives[0][relationship]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.relationship')}} ..."
                                        value="{{ old('other_relatives[0][relationship]') }}">

                                </div>
                            </div>

                            {{-- Education Level --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][education_level]" class="form-label">{{__('students.education_level')}}</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"> <i
                                            class="fa-solid fa-address-card"></i></span>
                                    <input type="text" class="form-control" id="other_relatives[0][education_level]"
                                        name="other_relatives[0][education_level]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.education_level')}} ..."
                                        value="{{ old('other_relatives[0][education_level]') }}">

                                </div>
                            </div>

                            {{-- Relation With Student --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][relation_with_student]" class="form-label">
                                    {{__('students.relation_with_student')}}
                                </label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"> <i
                                            class="fa-solid fa-address-card"></i></span>
                                    <input type="text" class="form-control"
                                        id="other_relatives[0][relation_with_student]"
                                        name="other_relatives[0][relation_with_student]"
                                        aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.relation_with_student')}} ..."
                                        value="{{ old('other_relatives[0][relation_with_student]') }}">

                                </div>
                            </div>

                            {{-- Student Relation --}}
                            <div class="col-sm">
                                <label for="other_relatives[0][student_relation]" class="form-label">
                                    {{__('students.student_relation')}}
                                </label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"> <i
                                            class="fa-solid fa-address-card"></i></span>
                                    <input type="text" class="form-control" id="other_relatives[0][student_relation]"
                                        name="other_relatives[0][student_relation]" aria-describedby="inputGroupPrepend"
                                        placeholder="{{__('students.enter')}} {{__('students.student_relation')}} ..."
                                        value="{{ old('other_relatives[0][student_relation]') }}">

                                </div>
                            </div>

                            <div class="col-sm d-flex justify-content-end">
                                <i class="fa-regular fa-plus  icons bg-success text-white" onclick="if_yes_fields();"></i>
                            </div>

                        </div>

                    </div>
                    <div class="d-none" id="noParents7_2">

                        <div class="row g-3  align-items-end mb-2">

                            {{-- Other Relatives Notes --}}
                            <div class="col-md-6 mt-4">
                                <label for="other_relatives_notes" class="form-label">
                                    {{__('students.other_relatives_notes')}}
                                </label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"> <i
                                            class="fa-regular fa-user"></i></span>
                                    <textarea class="form-control" name="other_relatives_notes" placeholder="{{__('students.enter')}} {{__('students.other_relatives_notes')}} ..."
                                        id="other_relatives_notes"
                                        rows="3">{{ old('other_relatives_notes') }}</textarea>

                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>


            {{-- The standard of living for the family --}}
            <div class="tab-pane fade" id="pills-economic_situation" role="tabpanel"
                aria-labelledby="pills-economic_situation-tab">


                <div class="row ">

                    {{-- Economic Situation --}}
                    <div class="col-md-6 mt-4">
                        <label for="economic_situation" class="form-label">
                            {{__('students.economic_situation')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-regular fa-user"></i></span>
                            <textarea class="form-control" name="economic_situation" placeholder="{{__('students.enter')}} {{__('students.economic_situation')}} ..."
                                id="economic_situation" rows="3">{{ old('economic_situation') }}</textarea>

                        </div>
                    </div>

                    {{-- Family Economic Problems --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_economic_problems" class="form-label">{{__('students.family_economic_problems')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <textarea class="form-control" name="family_economic_problems" placeholder="{{__('students.enter')}} {{__('students.family_economic_problems')}} ..."
                                id="family_economic_problems"
                                rows="3">{{ old('family_economic_problems') }}</textarea>
                        </div>
                    </div>

                    {{-- Monthly Average Income --}}
                    <div class="col-md-6 mt-4">
                        <label for="monthly_average_income" class="form-label">{{__('students.monthly_average_income')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <input type="text" class="form-control" id="monthly_average_income"
                                name="monthly_average_income" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.monthly_average_income')}} ..."
                                value="{{ old('monthly_average_income') }}">
                        </div>
                    </div>

                    {{-- Monthly Average Expenses --}}
                    <div class="col-md-6 mt-4">
                        <label for="monthly_average_expenses" class="form-label">{{__('students.monthly_average_expenses')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-day"></i>
                            </span>
                            <input type="text" class="form-control" id="monthly_average_expenses"
                                aria-describedby="inputGroupPrepend" name="monthly_average_expenses"
                                placeholder="{{__('students.enter')}} {{__('students.monthly_average_expenses')}} ..."
                                value="{{ old('monthly_average_expenses') }}">
                        </div>
                    </div>

                    {{-- Home Type --}}
                    <div class="col-md-4 mt-4">
                        <label for="home_type" class="form-label">{{__('students.home_type')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <input type="string" class="form-control" id="home_type" name="home_type"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.home_type')}} ..."
                                value="{{ old('home_type') }}">
                        </div>
                    </div>

                    {{-- Number Persons In Room --}}
                    <div class="col-md-4 mt-4">
                        <label for="no_persons_in_room" class="form-label">{{__('students.number_persons_in_room')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <input type="text" class="form-control" name="no_persons_in_room" id="no_persons_in_room"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.number_persons_in_room')}} ..."
                                value="{{ old('no_persons_in_room') }}">
                        </div>

                    </div>

                    {{-- Has Child Individual Room --}}
                    <div class="col-md-4 mt-4">
                        <label for="has_child_individual_room" class="form-label">
                            {{__('students.has_child_individual_room')}}</label>
                        <div class="d-flex justify-content-start">
                            <div class="form-check  me-4">
                                <input class="form-check-input" type="radio" name="has_child_individual_room"
                                    id="has_child_individual_room_yes" value="Yes">
                                <label class="form-check-label" for="has_child_individual_room_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="has_child_individual_room"
                                    id="has_child_individual_room_no" value="No">
                                <label class="form-check-label" for="has_child_individual_room_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Family Child Acceptance --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_child_acceptance" class="form-label">{{__('students.family_child_acceptance')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <textarea class="form-control" name="family_child_acceptance" placeholder="{{__('students.enter')}} {{__('students.family_child_acceptance')}} ..."
                                id="family_child_acceptance"
                                rows="3">{{ old('family_child_acceptance') }}</textarea>

                        </div>
                    </div>

                    {{-- Number Father Married --}}
                    <div class="col-md-3 mt-4">
                        <label for="no_father_married" class="form-label">{{__('students.number_father_married')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-regular fa-user"></i></span>
                            <input type="number" class="form-control" id="no_father_married" name="no_father_married"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.number_father_married')}} ..."
                                value="{{ old('no_father_married') }}">
                        </div>
                    </div>

                    {{-- Number Mother Married --}}
                    <div class="col-md-3 mt-4 ">
                        <label for="no_mother_married" class="form-label">{{__('students.number_mother_married')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <input type="number" class="form-control" id="no_mother_married" name="no_mother_married"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.number_mother_married')}} ..."
                                value="{{ old('no_mother_married') }}">
                        </div>
                    </div>

                    {{-- Family Divorce Cases --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_divorce_cases" class="form-label">{{__('students.family_divorce_cases')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-day"></i>
                            </span>
                            <textarea class="form-control" name="family_divorce_cases" placeholder="{{__('students.enter')}} {{__('students.family_divorce_cases')}} ..."
                                id="family_divorce_cases" rows="3">{{ old('family_divorce_cases') }}</textarea>
                        </div>
                    </div>

                    {{-- Family Stress Source --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_stress_source" class="form-label">{{__('students.family_stress_source')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <textarea class="form-control" name="family_stress_source" placeholder="{{__('students.enter')}} {{__('students.family_stress_source')}} ..."
                                id="family_stress_source" rows="3">{{ old('family_stress_source') }}</textarea>
                        </div>
                    </div>

                    {{-- Family Entertainment Source --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_entertainment_source" class="form-label">{{__('students.family_entertainment_source')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <textarea class="form-control" name="family_entertainment_source"
                                placeholder="{{__('students.enter')}} {{__('students.family_entertainment_source')}} ..." id="family_entertainment_source"
                                rows="3">{{ old('family_entertainment_source') }}</textarea>

                        </div>
                    </div>

                    {{-- Child Interacting With Family Entertainment Source --}}
                    <div class="col-md-6 mt-4">
                        <label for="family_entertainment_source_child_involve" class="form-label">{{__('students.child_interacting_with_family_entertainment_source')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text">
                                <i class="fa-solid fa-address-card"></i>
                            </span>
                            <textarea class="form-control" name="family_entertainment_source_child_involve"
                                placeholder="{{__('students.enter')}} {{__('students.child_interacting_with_family_entertainment_source')}} ..."
                                id="family_entertainment_source_child_involve"
                                rows="3">{{ old('family_entertainment_source_child_involve') }}</textarea>
                        </div>

                    </div>

                    {{-- Psychological Social Conditions Affect Child --}}
                    <div class="col-md-6 mt-4">
                        <label for="psychological_social_conditions_affect_child" class="form-label">{{__('students.psychological_social_conditions_affect_child')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"><i
                                    class="fa-solid fa-phone"></i></span>
                            <textarea class="form-control" name="psychological_social_conditions_affect_child"
                                placeholder="{{__('students.enter')}} {{__('students.psychological_social_conditions_affect_child')}} ..."
                                id="psychological_social_conditions_affect_child"
                                rows="3">{{ old('psychological_social_conditions_affect_child') }}</textarea>

                        </div>
                    </div>

                </div>
            </div>

            {{-- Organic growth history --}}

            <div class="tab-pane fade" id="pills-Organic_growth_history" role="tabpanel"
                aria-labelledby="pills-Organic_growth_history-tab">

                <div class="row ">

                    {{-- Mother Diseases During Pregnancy --}}
                    <div class="col-md-8 me-5 mt-4">
                        <label for="mother_diseases_during_pregnancy" class="form-label">{{__('students.mother_diseases_during_pregnancy')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <textarea class="form-control text-start" id="mother_diseases_during_pregnancy"
                                aria-describedby="mother_diseases_during_pregnancy"
                                placeholder="{{__('students.enter')}} {{__('students.mother_diseases_during_pregnancy')}} ..."
                                name="mother_diseases_during_pregnancy"
                                rows="3">{{ old('mother_diseases_during_pregnancy') }}</textarea>
                        </div>
                    </div>

                    {{-- Mother Pregnancy Type --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_pregnancy_type" class="form-label">
                            {{__('students.mother_pregnancy_type')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control" id="mother_pregnancy_type"
                                name="mother_pregnancy_type" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.mother_pregnancy_type')}} ..."
                                value="{{ old('mother_pregnancy_type') }}">
                        </div>
                    </div>

                    {{-- Disturbances During Child Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="disturbances_during_childbirth" class="form-label">{{__('students.disturbances_during_child_birth')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">

                                <i class="fa-solid fa-cake-candles"></i>
                            </span>
                            <input type="text" class="form-control" id="disturbances_during_childbirth"
                                name="disturbances_during_childbirth" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.disturbances_during_child_birth')}} ..."
                                value="{{ old('disturbances_during_childbirth') }}">
                        </div>
                    </div>

                    {{-- Mother Pregnancy Injuries --}}
                    <div class="col-md-4 mt-4">
                        <label for="mother_pregnancy_injuries" class="form-label">{{__('students.mother_pregnancy_injuries')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control" id="mother_pregnancy_injuries"
                                name="mother_pregnancy_injuries" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.mother_pregnancy_injuries')}} ..."
                                value="{{ old('mother_pregnancy_injuries') }}">
                        </div>
                    </div>

                    {{-- Child Weight At Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_weight_at_birth" class="form-label">
                            {{__('students.child_weight_at_birth')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">

                                <i class="fa-solid fa-pen-to-square"></i>

                            </span>
                            <input type="text" class="form-control" id="child_weight_at_birth"
                                name="child_weight_at_birth" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_weight_at_birth')}} ..."
                                value="{{ old('child_weight_at_birth') }}">
                        </div>
                    </div>

                    {{-- Breastfeeding Type --}}
                    <div class="col-md-4 mt-4">
                        <label for="breastfeeding_type" class="form-label">
                            {{__('students.breastfeeding_type')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>

                            </span>
                            <input type="text" class="form-control" id="breastfeeding_type" name="breastfeeding_type"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.breastfeeding_type')}} ..."
                                value="{{ old('breastfeeding_type') }}">
                        </div>
                    </div>

                    {{-- Breastfeeding Type Note --}}
                    <div class="col-md-4 mt-4">
                        <label for="breastfeeding_type_note" class="form-label">
                            {{__('students.breastfeeding_type_note')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-note-sticky"></i>
                            </span>
                            <input type="text" class="form-control" id="breastfeeding_type_note"
                                name="breastfeeding_type_note" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.breastfeeding_type_note')}} ..."
                                value="{{ old('breastfeeding_type_note') }}">
                        </div>
                    </div>

                    {{-- Child Age On Weaning --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_weaning" class="form-label">
                            {{__('students.child_age_on_weaning')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_weaning"
                                name="child_age_on_weaning" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_weaning')}} ..." value="{{ old('child_age_on_weaning') }}">
                        </div>
                    </div>

                    {{-- Weaning Problems --}}
                    <div class="col-md-4 mt-4">
                        <label for="weaning_problems" class="form-label">
                            {{__('students.weaning_problems')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control" id="weaning_problems" name="weaning_problems"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.weaning_problems')}} ..."
                                value="{{ old('weaning_problems') }}">
                        </div>
                    </div>

                    {{-- Child Age On First Tooth --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_first_tooth" class="form-label">
                            {{__('students.child_age_on_first_tooth')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_first_tooth"
                                name="child_age_on_first_tooth" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_first_tooth')}} ..."
                                value="{{ old('child_age_on_first_tooth') }}">

                        </div>
                    </div>

                    {{-- child_age_on_sitting --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_sitting" class="form-label">
                            {{__('students.child_age_on_sitting')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_sitting"
                                name="child_age_on_sitting" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_sitting')}} ..." value="{{ old('child_age_on_sitting') }}">
                        </div>
                    </div>

                    {{-- Child Age On Crawls --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_crawls" class="form-label">
                            {{__('students.child_age_on_crawls')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">


                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_crawls" name="child_age_on_crawls"
                                aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.child_age_on_crawls')}} ..."
                                value="{{ old('child_age_on_crawls') }}">
                        </div>
                    </div>

                    {{-- Child Age On Stand Up --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_stand_up" class="form-label">
                            {{__('students.child_age_on_stand_up')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">


                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_stand_up"
                                name="child_age_on_stand_up" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_stand_up')}} ..."
                                value="{{ old('child_age_on_stand_up') }}">
                        </div>
                    </div>

                    {{-- Child Age On Walking --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_walking" class="form-label">
                            {{__('students.child_age_on_walking')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">

                                <i class="fa-solid fa-child"></i>
                            </span>
                            <input type="text" class="form-control" id="child_age_on_walking"
                                name="child_age_on_walking" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_walking')}} ..." value="{{ old('child_age_on_walking') }}">
                        </div>
                    </div>

                    {{-- Child Age On First Word --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_first_word" class="form-label">
                            {{__('students.child_age_on_first_word')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-solid fa-child"></i></span>
                            <input type="text" class="form-control" id="child_age_on_first_word"
                                name="child_age_on_first_word" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_first_word')}} ..."
                                value="{{ old('child_age_on_first_word') }}">
                        </div>
                    </div>

                    {{-- Child Age On Open Door --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_open_door" class="form-label">
                            {{__('students.child_age_on_open_door')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-solid fa-child"></i></span>
                            <input type="text" class="form-control" id="child_age_on_open_door"
                                name="child_age_on_open_door" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_open_door')}} ..."
                                value="{{ old('child_age_on_open_door') }}">
                        </div>
                    </div>

                    {{-- Child Age On Use Spoon --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_use_spoon" class="form-label">
                            {{__('students.child_age_on_use_spoon')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-solid fa-child"></i></span>
                            <input type="text" class="form-control" id="child_age_on_use_spoon"
                                name="child_age_on_use_spoon" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_use_spoon')}} ..."
                                value="{{ old('child_age_on_use_spoon') }}">
                        </div>
                    </div>

                    {{-- Child Age On Adjust Output Process --}}
                    <div class="col-md-4 mt-4">
                        <label for="child_age_on_adjust_output_process" class="form-label">
                            {{__('students.child_age_on_adjust_output_process')}}
                        </label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-solid fa-child"></i></span>
                            <input type="text" class="form-control" id="child_age_on_adjust_output_process"
                                name="child_age_on_adjust_output_process" aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.child_age_on_adjust_output_process')}} ..."
                                value="{{ old('child_age_on_adjust_output_process') }}">
                        </div>
                    </div>

                    {{-- Does Health Problems --}}
                    <div class="col-md-6 mt-4">
                        <h6>{{__('students.does_health_problems')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_health_problems"
                                id="does_health_problems_yes" value="Yes">
                            <label class="form-check-label" for="does_health_problems_yes">
                                {{__('students.yes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_health_problems"
                                id="does_health_problems_no" value="No">
                            <label class="form-check-label" for="does_health_problems_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                        {{-- Current Health Problems --}}
                        <div class="w-100 d-none noParents" id="noParents8">
                            <div class="row g-3  align-items-end mb-2">
                                <div class="col-md-6">
                                    <label for="current_health_problems[0]" class="form-label">{{__('students.current_health_problems')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">

                                            <i class="fa-solid fa-briefcase-medical"></i>
                                        </span>
                                        <input type="text" class="form-control" name="current_health_problems[0]"
                                            id="current_health_problems[0]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.name')}} ..."
                                            value="{{ old('current_health_problems[0]') }}">
                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="body_health_problems();"></i>
                                </div>

                            </div>
                        </div>

                    </div>

                    {{-- Does Regularly Medicines --}}
                    <div class="col-md-6 mt-4">
                        <h6>{{__('students.does_regularly_medicines')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_regularly_medicines"
                                id="does_regularly_medicines_yes" value="Yes">
                            <label class="form-check-label" for="does_regularly_medicines_yes">
                                {{__('students.yes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_regularly_medicines"
                                id="does_regularly_medicines_no" value="No">
                            <label class="form-check-label" for="does_regularly_medicines_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                        {{-- Regularly Medicines --}}
                        <div class="w-100 d-none noParents" id="noParents9">
                            <div class="row g-3  align-items-end mb-2">
                                {{-- Regularly Medicines --}}
                                <div class="col-md-5">
                                    <label for="medicine" class="form-label">{{__('students.regularly_medicines')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-house-medical"></i></span>
                                        <input type="text" class="form-control" name="regularly_medicines[0][medicine]"
                                            id="medicine" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.medicine_name')}}..."
                                            value="{{ old('regularly_medicines[0][medicine]') }}">
                                    </div>
                                </div>
                                {{-- Dose --}}
                                <div class="col-md-5">
                                    <label for="dose" class="form-label">{{__('students.medicine_dose')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"><i
                                                class="fa-solid fa-pen-to-square"></i></span>
                                        <input type="text" class="form-control" name="regularly_medicines[0][dose]"
                                            id="dose" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.medicine_dose')}} ..."
                                            value="{{ old('regularly_medicines[0][dose]') }}">
                                    </div>
                                </div>


                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="body_regularly_medicines();"></i>
                                </div>

                            </div>
                        </div>

                    </div>


                    {{-- Does Complex Disabilities --}}
                    <div class="col-md-10 mt-4">

                        <h6>{{__('students.does_complex_disabilities')}}</h6>
                        <div class="w-100 d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="checkbox" name="does_complex_disabilities[]"
                                    id="No_disabilities" value="No_disabilities">
                                <label class="form-check-label" for="No_disabilities">
                                    {{__('students.No_disabilities')}}
                                </label>
                            </div>

                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="checkbox" name="does_complex_disabilities[]"
                                    id="Mentality" value="Mentality">
                                <label class="form-check-label" for="Mentality">
                                    {{__('students.mentality')}}
                                </label>
                            </div>

                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="checkbox" name="does_complex_disabilities[]"
                                    id="kinetics" value="kinetics">
                                <label class="form-check-label" for="kinetics">
                                    {{__('students.kinetics')}}
                                </label>
                            </div>

                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="checkbox" name="does_complex_disabilities[]"
                                    id="Audio" value="Audio">
                                <label class="form-check-label" for="Audio">
                                    {{__('students.audio')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="checkbox" name="does_complex_disabilities[]"
                                    id="Visual" value="Visual">
                                <label class="form-check-label" for="Visual">
                                    {{__('students.visual')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Other Complex Disabilities --}}
                    <div class="col-md-9">
                        <label for="complex_disabilities_other" class="form-label">{{__('students.other_complex_disabilities')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend"> <i
                                    class="fa-regular fa-user "></i></span>
                            <textarea type="text" class="form-control" name="complex_disabilities_other" id="complex_disabilities_other"
                                aria-describedby="inputGroupPrepend"
                                placeholder="{{__('students.enter')}} {{__('students.other_complex_disabilities')}} ...">{{ old('complex_disabilities_other') }}</textarea>
                        </div>
                    </div>

                    {{-- Does Prosthetic Devices --}}
                    <div class="col-md-9 mt-4">
                        <h6>{{__('students.does_prosthetic_devices')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_prosthetic_devices"
                                id="does_prosthetic_devices_yes" value="Yes">
                            <label class="form-check-label" for="does_prosthetic_devices_yes">
                                {{__('students.yes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="does_prosthetic_devices"
                                id="does_prosthetic_devices_no" value="No">
                            <label class="form-check-label" for="does_prosthetic_devices_no">
                                {{__('students.no')}}
                            </label>
                        </div>



                        {{-- Prosthetic Devices --}}
                        <div class="w-100 d-none noParents" id="noParents10">
                            <div class="row g-3  align-items-end mb-2">
                                <div class="col-md-6">
                                    <label for="prosthetic_devices[0]" class="form-label">{{__('students.prosthetic_devices')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-fax"></i></span>
                                        <input type="text" class="form-control" name="prosthetic_devices[0]"
                                            id="prosthetic_devices[0]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.prosthetic_devices')}} ..."
                                            value="{{ old('prosthetic_devices[0]') }}">
                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="body_prosthetic_devices();"></i>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

            {{-- pills Psychological behavioral --}}
            <div class="tab-pane fade" id="pills-Psychological-behavioral" role="tabpanel"
                aria-labelledby="pills-Psychological-behavioral-tab">

                <div class="row align-items-center justify-content-between">

                    {{-- personality traits --}}
                    <div class="col-md-9 my-3">
                        <h6>{{__('students.personality_traits')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="personality_traits"
                                id="personality_traits_introvert" value="Introvert">
                            <label class="form-check-label" for="personality_traits_introvert">
                                {{__('students.introvert')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="personality_traits"
                                id="personality_traits_diastolic" value="Diastolic">
                            <label class="form-check-label" for="personality_traits_diastolic">
                                {{__('students.diastolic')}}
                            </label>
                        </div>
                    </div>

                    {{-- relation with friends --}}
                    <div class="col-md-6 my-2">
                        <h6>{{__('students.relation_with_friends')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_friends"
                                id="relation_with_friends_submission" value="Submission">
                            <label class="form-check-label" for="relation_with_friends_submission">
                                {{__('students.submission')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_friends"
                                id="relation_with_friends_engagement" value="Engagement">
                            <label class="form-check-label" for="relation_with_friends_engagement">
                                {{__('students.engagement')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_friends"
                                id="relation_with_friends_Getaway" value="Get Away">
                            <label class="form-check-label" for="relation_with_friends_Getaway">
                                {{__('students.get_away')}}
                            </label>
                        </div>
                    </div>

                    {{-- Relation With Relatives --}}
                    <div class="col-md-6 my-2">
                        <h6>{{__('students.relation_with_relatives')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_relatives"
                                id="relation_with_relatives_submission" value="Submission">
                            <label class="form-check-label" for="relation_with_relatives_submission">
                                {{__('students.submission')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_relatives"
                                id="relation_with_relatives_engagement" value="Engagement">
                            <label class="form-check-label" for="relation_with_relatives_engagement">
                                {{__('students.engagement')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_relatives"
                                id="relation_with_relatives_Getaway" value="Get Away">
                            <label class="form-check-label" for="relation_with_relatives_Getaway">
                                {{__('students.get_away')}}
                            </label>
                        </div>
                    </div>

                    {{-- Relation With Neighbour --}}
                    <div class="col-md-6 my-2">
                        <h6>{{__('students.relation_with_neighbour')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_neighbour"
                                id="relation_with_neighbour_submission" value="Submission">
                            <label class="form-check-label" for="relation_with_neighbour_submission">
                                {{__('students.submission')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_neighbour"
                                id="relation_with_neighbour_engagement" value="Engagement">
                            <label class="form-check-label" for="relation_with_neighbour_engagement">
                                {{__('students.engagement')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_neighbour"
                                id="relation_with_neighbour_Getaway" value="Get Away">
                            <label class="form-check-label" for="relation_with_neighbour_Getaway">
                                {{__('students.get_away')}}
                            </label>
                        </div>
                    </div>

                    {{-- Relation With Other Gender --}}
                    <div class="col-md-6 my-2">
                        <h6>{{__('students.relation_with_other_gender')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_other_gender"
                                id="relation_with_other_gender_submission" value="Submission">
                            <label class="form-check-label" for="relation_with_other_gender_submission">
                                {{__('students.submission')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_other_gender"
                                id="relation_with_other_gender_engagement" value="Engagement">
                            <label class="form-check-label" for="relation_with_other_gender_engagement">
                                {{__('students.engagement')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="relation_with_other_gender"
                                id="relation_with_other_gender_Getaway" value="Get Away">
                            <label class="form-check-label" for="relation_with_other_gender_Getaway">
                                {{__('students.get_away')}}
                            </label>
                        </div>
                    </div>

                    {{-- Upbringing Style --}}
                    <div class="col-md-6 my-2">
                        <h6>{{__('students.upbringing_style')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="upbringing_style"
                                id="upbringing_style_intensity" value="Intensity">
                            <label class="form-check-label" for="upbringing_style_intensity">
                                {{__('students.intensity')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="upbringing_style"
                                id="upbringing_style_soft" value="Soft">
                            <label class="form-check-label" for="upbringing_style_soft">
                                {{__('students.soft')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="upbringing_style"
                                id="upbringing_style_Overprotection" value="Overprotection">
                            <label class="form-check-label" for="upbringing_style_Overprotection">
                                {{__('students.overprotection')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="upbringing_style"
                                id="upbringing_style_complacency" value="Complacency">
                            <label class="form-check-label" for="upbringing_style_complacency">
                                {{__('students.complacency')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="upbringing_style"
                                id="upbringing_style_Other_methods" value="Other Methods">
                            <label class="form-check-label" for="upbringing_style_Other_methods">
                               {{__('students.other_methods')}}
                            </label>
                        </div>


                    </div>

                    {{-- Physical Or Mental Reinforcements --}}
                    <div class="col-md-12 my-2">
                        <h6 class="mb-3">{{__('students.physical_or_mental_reinforcements')}}</h6>
                        <div class="w-100  noParents" id="noParents11">
                            <div class="row g-3  align-items-end mb-2">

                                <div class="col-md-10">
                                    <label for="reinforcements" class="form-label">{{__('students.reinforcements')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-house-medical"></i></span>
                                        <input type="text" class="form-control" name="reinforcements[0]"
                                            id="reinforcements" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.reinforcements')}} ..."
                                            value="{{ old('reinforcements[0]') }}">
                                    </div>
                                </div>


                                <div class="col-md-2 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="body_reinforcements();"></i>
                                </div>

                            </div>
                        </div>

                    </div>

                    {{-- Is the child subjected to punishment --}}
                    <div class="col-md-12 my-2">
                        <h6>{{__('students.is_the_child_subjected_to_punishment')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="is_punishment" id="is_punishment_yes"
                                value="Yes">
                            <label class="form-check-label" for="is_punishment_yes">
                                {{__('students.yes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="is_punishment" id="is_punishment_no"
                                value="No">
                            <label class="form-check-label" for="is_punishment_no">
                                {{__('students.no')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="is_punishment"
                                id="is_punishment_maybe" value="Maybe">
                            <label class="form-check-label" for="is_punishment_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>


                        <div class="w-100 d-none noParents" id="noParents12">
                            <div class="row g-3  align-items-end mb-2">
                                {{-- Punishment Reasons --}}
                                <div class="col-md-6">
                                    <label for="punishment_reasons" class="form-label">{{__('students.punishment_reasons')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <textarea type="text" class="form-control" name="punishment_reasons" id="punishment_reasons"
                                            aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.punishment_reasons')}} ...">{{ old('punishment_reasons') }}</textarea>
                                    </div>
                                </div>
                                {{-- Child Behavior Notes --}}
                                <div class="col-md-6">
                                    <label for="child_behavior_notes" class="form-label">{{__('students.child_behavior_notes')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <textarea type="text" class="form-control" name="child_behavior_notes" id="child_behavior_notes"
                                            aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.child_behavior_notes')}} ...">{{ old('child_behavior_notes') }}</textarea>
                                    </div>
                                </div>
                                {{-- Source Of Authority --}}
                                <div class="col-md-6">
                                    <label for="source_of_authority" class="form-label d-block">
                                        {{__('students.source_of_authority')}}
                                    </label>
                                    <div class="d-flex justify-content-between mt-3">
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio" name="source_of_authority"
                                                id="source_of_authority_father" value="Father">
                                            <label class="form-check-label" for="source_of_authority_father">
                                                {{__('students.father')}}
                                            </label>
                                        </div>
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio"
                                                id="source_of_authority_mother" name="source_of_authority" value="Mother">
                                            <label class="form-check-label" for="source_of_authority_mother">
                                                {{__('students.mother')}}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                {{-- Source Of Authority Notes --}}
                                <div class="col-md-6">
                                    <label for="source_of_authority_notes" class="form-label">{{__('students.source_of_authority_notes')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-regular fa-user "></i></span>
                                        <textarea type="text" class="form-control" name="source_of_authority_notes" id="source_of_authority_notes"
                                            aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.source_of_authority_notes')}} ...">{{ old('source_of_authority_notes') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    {{-- Child Behavior --}}
                    <h2>{{__('students.child_behavior')}}</h2>
                    <div class="col-md-6 my-2">
                        {{-- Crying --}}
                        <h6 class="mb-3">{{__('students.crying')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="crying" id="crying_always"
                                value="Always">
                            <label class="form-check-label" for="crying_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="crying" id="crying_sometimes"
                                value="Sometimes">
                            <label class="form-check-label" for="crying_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="crying" id="crying_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="crying_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>
                    </div>

                    <div class="col-md-6 my-2">
                        {{-- Talkative --}}
                        <h6 class="mb-3">{{__('students.talkative')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="talkative" id="talkative_always"
                                value="Always">
                            <label class="form-check-label" for="talkative_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="talkative" id="talkative_sometimes"
                                value="Sometimes">
                            <label class="form-check-label" for="talkative_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="talkative" id="talkative_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="talkative_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Lots Of Movement --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.lots_of_movement')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="lots_of_movement"
                                id="lots_of_movement_always" value="Always">
                            <label class="form-check-label" for="lots_of_movement_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="lots_of_movement"
                                id="lots_of_movement_sometimes" value="Sometimes">
                            <label class="form-check-label" for="lots_of_movement_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="lots_of_movement"
                                id="lots_of_movement_maybe" value="Maybe">
                            <label class="form-check-label" for="lots_of_movement_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Orderly Plan --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.orderly_plan')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="orderly_plan" id="orderly_plan_always"
                                value="Always">
                            <label class="form-check-label" for="orderly_plan_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="orderly_plan"
                                id="orderly_plan_sometimes" value="Sometimes">
                            <label class="form-check-label" for="orderly_plan_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="orderly_plan" id="orderly_plan_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="orderly_plan_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Damages --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.damages')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="damages" id="damages_always"
                                value="Always">
                            <label class="form-check-label" for="damages_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="damages" id="damages_sometimes"
                                value="Sometimes">
                            <label class="form-check-label" for="damages_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="damages" id="damages_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="damages_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Find Around Place --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.find_around_place')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="find_around_place"
                                id="find_around_place_always" value="Always">
                            <label class="form-check-label" for="find_around_place_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="find_around_place"
                                id="find_around_place_sometimes" value="Sometimes">
                            <label class="form-check-label" for="find_around_place_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="find_around_place"
                                id="find_around_place_maybe" value="Maybe">
                            <label class="form-check-label" for="find_around_place_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Grieves With Specialist --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.grieves_with_specialist')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="grieves_with_specialist"
                                id="grieves_with_specialist_always" value="Always">
                            <label class="form-check-label" for="grieves_with_specialist_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="grieves_with_specialist"
                                id="grieves_with_specialist_sometimes" value="Sometimes">
                            <label class="form-check-label" for="grieves_with_specialist_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="grieves_with_specialist"
                                id="grieves_with_specialist_maybe" value="Maybe">
                            <label class="form-check-label" for="grieves_with_specialist_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Afraid --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.afraid')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="afraid" id="afraid_always"
                                value="Always">
                            <label class="form-check-label" for="afraid_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="afraid" id="afraid_sometimes"
                                value="Sometimes">
                            <label class="form-check-label" for="afraid_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="afraid" id="afraid_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="afraid_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Enjoys --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.enjoys')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="enjoys" id="enjoys_always"
                                value="Always">
                            <label class="form-check-label" for="enjoys_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="enjoys" id="enjoys_sometimes"
                                value="Sometimes">
                            <label class="form-check-label" for="enjoys_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="enjoys" id="enjoys_maybe"
                                value="Maybe">
                            <label class="form-check-label" for="enjoys_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- Runs Randomly --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.runs_randomly')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="runs_randomly"
                                id="runs_randomly_always" value="Always">
                            <label class="form-check-label" for="runs_randomly_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="runs_randomly"
                                id="runs_randomly_sometimes" value="Sometimes">
                            <label class="form-check-label" for="runs_randomly_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="runs_randomly"
                                id="runs_randomly_maybe" value="Maybe">
                            <label class="form-check-label" for="runs_randomly_maybe">
                                {{__('students.maybe')}}
                            </label>
                        </div>

                    </div>
                    {{-- The main neurological and behavioral symptoms --}}
                    <h2>{{__('students.the_main_neurological_and_behavioral_symptoms')}}</h2>
                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Outbursts Of Anger --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.outbursts_of_anger')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="outbursts_of_anger"
                                        id="outbursts_of_anger_always" value="Always">
                                    <label class="form-check-label" for="outbursts_of_anger_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="outbursts_of_anger"
                                        id="outbursts_of_anger_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="outbursts_of_anger_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="outbursts_of_anger"
                                        id="outbursts_of_anger_no" value="No">
                                    <label class="form-check-label" for="outbursts_of_anger_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Outbursts Of Anger Time --}}
                        <div class="col-md-4 ">
                            <label for="outbursts_of_anger_time" class="form-label">{{__('students.outbursts_of_anger')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="outbursts_of_anger_time"
                                    name="outbursts_of_anger_time" placeholder="{{__('students.enter')}} {{__('students.outbursts_of_anger_time')}} {{__('students.time')}} . . ."
                                    value="{{ old('outbursts_of_anger_time') }}">
                            </div>
                        </div>

                        {{-- Outbursts Of Anger Degree --}}
                        <div class="col-md-4 ">
                            <label for="outbursts_of_anger_degree" class="form-label">{{__('students.outbursts_of_anger')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="outbursts_of_anger_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.outbursts_of_anger')}} {{__('students.degree')}} . . ." name="outbursts_of_anger_degree"
                                    value="{{ old('outbursts_of_anger_degree') }}">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Finger Sucking --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.finger_sucking')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="finger_sucking"
                                        id="finger_sucking_always" value="Always">
                                    <label class="form-check-label" for="finger_sucking_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="finger_sucking"
                                        id="finger_sucking_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="finger_sucking_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="finger_sucking"
                                        id="finger_sucking_no" value="No">
                                    <label class="form-check-label" for="finger_sucking_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Finger Sucking Time --}}
                        <div class="col-md-4 ">
                            <label for="finger_sucking_time" class="form-label">{{__('students.finger_sucking')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="finger_sucking_time"
                                placeholder="{{__('students.enter')}} {{__('students.finger_sucking')}} {{__('students.time')}} . . ." name="finger_sucking_time"
                                value="{{ old('finger_sucking_time') }}">
                            </div>
                        </div>
                        
                        {{-- Finger Sucking Degree --}}
                        <div class="col-md-4 ">
                            <label for="finger_sucking_degree" class="form-label">{{__('students.outbursts_of_anger')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="finger_sucking_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.outbursts_of_anger')}} {{__('students.degree')}} . . ." name="finger_sucking_degree"
                                    value="{{ old('finger_sucking_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">

                        {{-- Wetting Bed --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.wetting_bed')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="wetting_bed"
                                        id="wetting_bed_always" value="Always">
                                    <label class="form-check-label" for="wetting_bed_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="wetting_bed"
                                        id="wetting_bed_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="wetting_bed_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="wetting_bed"
                                        id="wetting_bed_no" value="No">
                                    <label class="form-check-label" for="wetting_bed_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Wetting Bed Tinme --}}
                        <div class="col-md-4 ">
                            <label for="wetting_bed_time" class="form-label">{{__('students.wetting_bed')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="wetting_bed_time"
                                    placeholder="{{__('students.enter')}} {{__('students.wetting_bed')}} {{__('students.time')}} . . ." name="wetting_bed_time"
                                    value="{{ old('wetting_bed_time') }}">
                            </div>
                        </div>

                        {{-- Wetting Bed Degree --}}
                        <div class="col-md-4">
                            <label for="wetting_bed_degree" class="form-label">{{__('students.wetting_bed')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="wetting_bed_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.wetting_bed')}} {{__('students.degree')}} . . ." name="wetting_bed_degree"
                                    value="{{ old('wetting_bed_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Night Screams Of Terror --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.night_screams_of_terror')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="night_screams_of_terror"
                                        id="night_screams_of_terror_always" value="Always">
                                    <label class="form-check-label" for="night_screams_of_terror_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="night_screams_of_terror"
                                        id="night_screams_of_terror_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="night_screams_of_terror_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="night_screams_of_terror"
                                        id="night_screams_of_terror_no" value="No">
                                    <label class="form-check-label" for="night_screams_of_terror_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Night Screams Of Terror Time --}}
                        <div class="col-md-4">
                            <label for="night_screams_of_terror_time" class="form-label">{{__('students.night_screams_of_terror')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="night_screams_of_terror_time"
                                    name="night_screams_of_terror_time"
                                    placeholder="{{__('students.enter')}} {{__('students.night_screams_of_terror')}} {{__('students.time')}} . . ."
                                    value="{{ old('night_screams_of_terror_time') }}">
                            </div>
                        </div>

                        {{-- Night Screams Of Terror Degree --}}
                        <div class="col-md-4">
                            <label for="night_screams_of_terror_degree" class="form-label">{{__('students.night_screams_of_terror')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="night_screams_of_terror_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.night_screams_of_terror')}} {{__('students.degree')}} . . ."
                                    name="night_screams_of_terror_degree"
                                    value="{{ old('night_screams_of_terror_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Sleep Walking --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.sleep_walking')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sleep_walking"
                                        id="sleep_walking_always" value="Always">
                                    <label class="form-check-label" for="sleep_walking_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sleep_walking"
                                        id="sleep_walking_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="sleep_walking_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sleep_walking"
                                        id="sleep_walking_no" value="No">
                                    <label class="form-check-label" for="sleep_walking_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Sleep Walking Time --}}
                        <div class="col-md-4 ">
                            <label for="sleep_walking_time" class="form-label">{{__('students.sleep_walking')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="sleep_walking_time"
                                    placeholder="{{__('students.enter')}} {{__('students.sleep_walking')}} {{__('students.time')}} . . ." name="sleep_walking_time"
                                    value="{{ old('sleep_walking_time') }}">
                            </div>
                        </div>

                        {{-- Sleep Walking Degree --}}
                        <div class="col-md-4 ">
                            <label for="sleep_walking_degree" class="form-label">{{__('students.sleep_walking')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="sleep_walking_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.sleep_walking')}} {{__('students.degree')}} . . ." name="sleep_walking_degree"
                                    value="{{ old('sleep_walking_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">

                        {{-- Excessive Fears --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.excessive_fears')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="excessive_fears"
                                        id="excessive_fears_always" value="Always">
                                    <label class="form-check-label" for="excessive_fears_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="excessive_fears"
                                        id="excessive_fears_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="excessive_fears_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="excessive_fears"
                                        id="excessive_fears_no" value="No">
                                    <label class="form-check-label" for="excessive_fears_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Excessive Fears Time --}}
                        <div class="col-md-4">
                            <label for="excessive_fears_time" class="form-label">{{__('students.excessive_fears')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="excessive_fears_time"
                                    placeholder="{{__('students.enter')}} {{__('students.excessive_fears')}} {{__('students.time')}} . . ." name="excessive_fears_time"
                                    value="{{ old('excessive_fears_time') }}">
                            </div>
                        </div>

                        {{-- Excessive Fears Degree --}}
                        <div class="col-md-4">
                            <label for="excessive_fears_degree" class="form-label">{{__('students.excessive_fears')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="excessive_fears_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.excessive_fears')}} {{__('students.degree')}} . . ." name="excessive_fears_degree"
                                    value="{{ old('excessive_fears_degree') }}">
                            </div>
                        </div>
                    </div>


                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Nervous Crises --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.nervous_crises')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="nervous_crises"
                                        id="nervous_crises_always" value="Always">
                                    <label class="form-check-label" for="nervous_crises_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="nervous_crises"
                                        id="nervous_crises_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="nervous_crises_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="nervous_crises"
                                        id="nervous_crises_no" value="No">
                                    <label class="form-check-label" for="nervous_crises_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Nervous Crises Time --}}
                        <div class="col-md-4">
                            <label for="nervous_crises_time" class="form-label">{{__('students.nervous_crises')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="nervous_crises_time"
                                    placeholder="{{__('students.enter')}} {{__('students.nervous_crises')}} {{__('students.time')}} . . ." name="nervous_crises_time"
                                    value="{{ old('nervous_crises_time') }}">
                            </div>
                        </div>

                        {{-- Nervous Crises Degree --}}
                        <div class="col-md-4">
                            <label for="nervous_crises_degree" class="form-label">{{__('students.nervous_crises')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="nervous_crises_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.nervous_crises')}} {{__('students.degree')}} . . ." name="nervous_crises_degree"
                                    value="{{ old('nervous_crises_degree') }}">
                            </div>
                        </div>
                    </div>

                    {{-- Cramps --}}
                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.cramps')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="cramps" id="cramps_always"
                                        value="Always">
                                    <label class="form-check-label" for="cramps_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="cramps" id="cramps_sometimes"
                                        value="Sometimes">
                                    <label class="form-check-label" for="cramps_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="cramps" id="cramps_no"
                                        value="No">
                                    <label class="form-check-label" for="cramps_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Cramps Time --}}
                        <div class="col-md-4">
                            <label for="cramps_time" class="form-label">{{__('students.cramps')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="cramps_time"
                                    placeholder="{{__('students.enter')}} {{__('students.cramps')}} {{__('students.time')}} . . ." name="cramps_time"
                                    value="{{ old('cramps_time') }}">
                            </div>
                        </div>

                        {{-- Cramps Degree --}}
                        <div class="col-md-4">
                            <label for="cramps_degree" class="form-label">{{__('students.cramps')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="cramps_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.cramps')}} {{__('students.degree')}} . . ." name="cramps_degree"
                                    value="{{ old('sleep_walking_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Biting Nails --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.biting_nails')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="biting_nails"
                                        id="biting_nails_always" value="Always">
                                    <label class="form-check-label" for="biting_nails_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="biting_nails"
                                        id="biting_nails_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="biting_nails_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="biting_nails"
                                        id="biting_nails_no" value="No">
                                    <label class="form-check-label" for="biting_nails_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Biting Nails Time --}}
                        <div class="col-md-4 ">
                            <label for="biting_nails_time" class="form-label">{{__('students.biting_nails')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="biting_nails_time"
                                    placeholder="{{__('students.enter')}} {{__('students.biting_nails')}} {{__('students.time')}} . . ." name="biting_nails_time"
                                    value="{{ old('biting_nails_time') }}">
                            </div>
                        </div>

                        {{-- Biting Nails Degree --}}
                        <div class="col-md-4 ">
                            <label for="biting_nails_degree" class="form-label">{{__('students.biting_nails')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="biting_nails_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.biting_nails')}} {{__('students.degree')}} . . ." name="biting_nails_degree"
                                    value="{{ old('biting_nails_degree') }}">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Smash Clothes --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.smash_clothes')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="smash_clothes"
                                        id="smash_clothes_always" value="Always">
                                    <label class="form-check-label" for="smash_clothes_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="smash_clothes"
                                        id="smash_clothes_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="smash_clothes_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="smash_clothes"
                                        id="smash_clothes_no" value="No">
                                    <label class="form-check-label" for="smash_clothes_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Smash Clothes Time --}}
                        <div class="col-md-4 ">
                            <label for="smash_clothes_time" class="form-label">{{__('students.smash_clothes')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="smash_clothes_time"
                                    placeholder="{{__('students.enter')}} {{__('students.smash_clothes')}} {{__('students.time')}} . . ." name="smash_clothes_time"
                                    value="{{ old('smash_clothes_time') }}">
                            </div>
                        </div>

                        {{-- Smash Clothes Degree --}}
                        <div class="col-md-4 ">
                            <label for="smash_clothes_degree" class="form-label">{{__('students.smash_clothes')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="smash_clothes_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.smash_clothes')}} {{__('students.degree')}} . . ." name="smash_clothes_degree"
                                    value="{{ old('smash_clothes_degree') }}">
                            </div>
                        </div>
                    </div>


                    <div class="mb-3 row align-items-center justify-content-between py-2">

                        {{-- Stereotyped Movements --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.stereotyped_movements')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="stereotyped_movements"
                                        id="stereotyped_movements_always" value="Always">
                                    <label class="form-check-label" for="stereotyped_movements_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="stereotyped_movements"
                                        id="stereotyped_movements_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="stereotyped_movements_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="stereotyped_movements"
                                        id="stereotyped_movements_no" value="No">
                                    <label class="form-check-label" for="stereotyped_movements_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Stereotyped Movements Time --}}
                        <div class="col-md-4 ">
                            <label for="stereotyped_movements_time" class="form-label">{{__('students.stereotyped_movements')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="stereotyped_movements_time"
                                    placeholder="{{__('students.enter')}} {{__('students.stereotyped_movements')}} {{__('students.time')}} . . ." name="stereotyped_movements_time"
                                    value="{{ old('stereotyped_movements_time') }}">
                            </div>
                        </div>

                        {{-- Stereotyped Movements Degree --}}
                        <div class="col-md-4 ">
                            <label for="stereotyped_movements_degree" class="form-label">{{__('students.stereotyped_movements')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="stereotyped_movements_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.stereotyped_movements')}} {{__('students.degree')}} . . ."
                                    name="stereotyped_movements_degree"
                                    value="{{ old('stereotyped_movements_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">

                        {{-- Baby Gets Nervous From Loud Noises --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.baby_gets_nervous_from_loud_noises')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_loud_noises"
                                        id="baby_gets_nervous_from_loud_noises_always" value="Always">
                                    <label class="form-check-label" for="baby_gets_nervous_from_loud_noises_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_loud_noises"
                                        id="baby_gets_nervous_from_loud_noises_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="baby_gets_nervous_from_loud_noises_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_loud_noises" id="baby_gets_nervous_from_loud_noises_no"
                                        value="No">
                                    <label class="form-check-label" for="baby_gets_nervous_from_loud_noises_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Baby Gets Nervous From Loud Noises Time --}}
                        <div class="col-md-4 ">
                            <label for="baby_gets_nervous_from_loud_noises_time" class="form-label">{{__('students.baby_gets_nervous_from_loud_noises')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start"
                                    id="baby_gets_nervous_from_loud_noises_time"
                                    placeholder="{{__('students.enter')}} {{__('students.baby_gets_nervous_from_loud_noises')}} {{__('students.time')}} . . ."
                                    name="baby_gets_nervous_from_loud_noises_time"
                                    value="{{ old('baby_gets_nervous_from_loud_noises_time') }}">
                            </div>
                        </div>

                        {{-- Baby Gets Nervous From Loud Noises Degree --}}
                        <div class="col-md-4 ">
                            <label for="baby_gets_nervous_from_loud_noises_degree" class="form-label">{{__('students.baby_gets_nervous_from_loud_noises')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start"
                                    id="baby_gets_nervous_from_loud_noises_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.baby_gets_nervous_from_loud_noises')}} {{__('students.degree')}} . . ."
                                    name="baby_gets_nervous_from_loud_noises_degree"
                                    value="{{ old('baby_gets_nervous_from_loud_noises_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Baby Gets Nervous From Bright Lights --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.baby_gets_nervous_from_bright_lights')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_bright_lights"
                                        id="baby_gets_nervous_from_bright_lights_always" value="Always">
                                    <label class="form-check-label" for="baby_gets_nervous_from_bright_lights_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_bright_lights"
                                        id="baby_gets_nervous_from_bright_lights_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="baby_gets_nervous_from_bright_lights_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio"
                                        name="baby_gets_nervous_from_bright_lights"
                                        id="baby_gets_nervous_from_bright_lights_no" value="No">
                                    <label class="form-check-label" for="baby_gets_nervous_from_bright_lights_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Baby Gets Nervous From Bright Lights Time --}}
                        <div class="col-md-4 ">
                            <label for="baby_gets_nervous_from_bright_lights_time" class="form-label">{{__('students.baby_gets_nervous_from_bright_lights')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start"
                                    id="baby_gets_nervous_from_bright_lights_time"
                                    placeholder="{{__('students.enter')}} {{__('students.baby_gets_nervous_from_bright_lights')}} {{__('students.time')}} . . ."
                                    name="baby_gets_nervous_from_bright_lights_time"
                                    value="{{ old('baby_gets_nervous_from_bright_lights_time') }}">
                            </div>
                        </div>

                        {{-- Baby Gets Nervous From Bright Lights Degree --}}
                        <div class="col-md-4 ">
                            <label for="baby_gets_nervous_from_bright_lights_degree" class="form-label">{{__('students.baby_gets_nervous_from_bright_lights')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start"
                                    id="baby_gets_nervous_from_bright_lights_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.baby_gets_nervous_from_bright_lights')}} {{__('students.degree')}} . . ."
                                    name="baby_gets_nervous_from_bright_lights_degree"
                                    value="{{ old('baby_gets_nervous_from_bright_lights_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Sexual Behaviors --}}
                        <div class="col-md-4 my-2">
                            <h6 class="mb-4">{{__('students.sexual_behaviors')}}</h6>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sexual_behaviors"
                                        id="sexual_behaviors_always" value="Always">
                                    <label class="form-check-label" for="sexual_behaviors_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sexual_behaviors"
                                        id="sexual_behaviors_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="sexual_behaviors_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="sexual_behaviors"
                                        id="sexual_behaviors_no" value="No">
                                    <label class="form-check-label" for="sexual_behaviors_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Sexual Behaviors Time --}}
                        <div class="col-md-4 ">
                            <label for="sexual_behaviors_time" class="form-label">{{__('students.sexual_behaviors')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="sexual_behaviors_time"
                                    placeholder="{{__('students.enter')}} {{__('students.sexual_behaviors')}} {{__('students.time')}} . . ." name="sexual_behaviors_time"
                                    value="{{ old('sexual_behaviors_time') }}">
                            </div>
                        </div>

                        {{-- Sexual Behaviors Degree --}}
                        <div class="col-md-4 ">
                            <label for="sexual_behaviors_degree" class="form-label">{{__('students.sexual_behaviors')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="sexual_behaviors_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.sexual_behaviors')}} {{__('students.degree')}} . . ." name="sexual_behaviors_degree"
                                    value="{{ old('sexual_behaviors_degree') }}">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 row align-items-center justify-content-between py-2">
                        {{-- Epileptic Seizures --}}
                        <div class="col-md-4 my-2">
                            <h5>{{__('students.epileptic_seizures')}}</h5>
                            <div class="d-flex justify-content-between">
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="epileptic_seizures"
                                        id="epileptic_seizures_always" value="Always">
                                    <label class="form-check-label" for="epileptic_seizures_always">
                                        {{__('students.always')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="epileptic_seizures"
                                        id="epileptic_seizures_sometimes" value="Sometimes">
                                    <label class="form-check-label" for="epileptic_seizures_sometimes">
                                        {{__('students.sometimes')}}
                                    </label>
                                </div>
                                <div class="form-check d-flex align-items-start">
                                    <input class="form-check-input me-2" type="radio" name="epileptic_seizures"
                                        id="epileptic_seizures_no" value="No">
                                    <label class="form-check-label" for="epileptic_seizures_no">
                                        {{__('students.no')}}
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- Epileptic Seizures Time --}}
                        <div class="col-md-4 ">
                            <label for="epileptic_seizures_time" class="form-label">{{__('students.epileptic_seizures')}} {{__('students.time')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="epileptic_seizures_time"
                                    placeholder="{{__('students.enter')}} {{__('students.epileptic_seizures')}} {{__('students.time')}} . . ." name="epileptic_seizures_time"
                                    value="{{ old('epileptic_seizures_time') }}">
                            </div>
                        </div>

                        {{-- Epileptic Seizures Degree --}}
                        <div class="col-md-4 ">
                            <label for="epileptic_seizures_degree" class="form-label">{{__('students.epileptic_seizures')}} {{__('students.degree')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control text-start" id="epileptic_seizures_degree"
                                    placeholder="{{__('students.enter')}} {{__('students.epileptic_seizures')}} {{__('students.degree')}} . . ." name="epileptic_seizures_degree"
                                    value="{{ old('epileptic_seizures_degree') }}">
                            </div>
                        </div>
                    </div>


                    <h2>{{__('students.Childs social problems')}}</h2>

                    {{-- Difficulty Interacting With Peers --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.difficulty_interacting_with_peers')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="difficulty_interacting_with_peers"
                                    id="difficulty_interacting_with_peers_always" value="Always">
                                <label class="form-check-label" for="difficulty_interacting_with_peers_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="difficulty_interacting_with_peers"
                                    id="difficulty_interacting_with_peers_sometimes" value="Sometimes">
                                <label class="form-check-label" for="difficulty_interacting_with_peers_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="difficulty_interacting_with_peers"
                                    id="difficulty_interacting_with_peers_no" value="No">
                                <label class="form-check-label" for="difficulty_interacting_with_peers_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Difficulty Interacting With Peers Description --}}
                    <div class="col-md-7 ">
                        <label for="difficulty_interacting_with_peers_desc" class="form-label">{{__('students.difficulty_interacting_with_peers')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="difficulty_interacting_with_peers_desc"
                                placeholder="{{__('students.enter')}} {{__('students.difficulty_interacting_with_peers')}} {{__('students.description')}} . . ."
                                name="difficulty_interacting_with_peers_desc"
                                value="{{ old('difficulty_interacting_with_peers_desc') }}">
                        </div>
                    </div>


                    {{-- Extra Activity --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.extra_activity')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="extra_activity"
                                    id="extra_activity_always" value="Always">
                                <label class="form-check-label" for="extra_activity_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="extra_activity"
                                    id="extra_activity_sometimes" value="Sometimes">
                                <label class="form-check-label" for="extra_activity_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="extra_activity"
                                    id="extra_activity_no" value="No">
                                <label class="form-check-label" for="extra_activity_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Extra Activity Desc --}}
                    <div class="col-md-7 ">
                        <label for="extra_activity_desc" class="form-label">{{__('students.extra_activity_description')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="extra_activity_desc"
                                placeholder="{{__('students.enter')}} {{__('students.extra_activity_description')}} {{__('students.description')}} . . ." name="extra_activity_desc"
                                value="{{ old('extra_activity_desc') }}">
                        </div>
                    </div>

                    {{-- Make Fun Of Others --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.make_fun_of_others')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="make_fun_of_others"
                                    id="make_fun_of_others_always" value="Always">
                                <label class="form-check-label" for="make_fun_of_others_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="make_fun_of_others"
                                    id="make_fun_of_others_sometimes" value="Sometimes">
                                <label class="form-check-label" for="make_fun_of_others_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="make_fun_of_others"
                                    id="make_fun_of_others_no" value="No">
                                <label class="form-check-label" for="make_fun_of_others_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Make Fun Of Others Desc --}}
                    <div class="col-md-7 ">
                        <label for="make_fun_of_others_desc" class="form-label">{{__('students.always')}}Make Fun Of Others {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="make_fun_of_others_desc"
                                placeholder="{{__('students.enter')}} Make Fun Of Others {{__('students.description')}} . . ." name="make_fun_of_others_desc"
                                value="{{ old('make_fun_of_others_desc') }}">
                        </div>
                    </div>

                    {{-- Can Not Wait --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.can_not_wait')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="can_not_wait"
                                    id="can_not_wait_always" value="Always">
                                <label class="form-check-label" for="can_not_wait_always">
                                     {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="can_not_wait"
                                    id="can_not_wait_sometimes" value="Sometimes">
                                <label class="form-check-label" for="can_not_wait_sometimes">
                                     {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="can_not_wait" id="can_not_wait_no"
                                    value="No">
                                <label class="form-check-label" for="can_not_wait_no">
                                     {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Can Not Wait Description --}}
                    <div class="col-md-7 ">
                        <label for="can_not_wait_desc" class="form-label">{{__('students.can_not_wait')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="can_not_wait_desc"
                                placeholder="{{__('students.enter')}} {{__('students.can_not_wait')}} {{__('students.description')}} . . ." name="can_not_wait_desc"
                                value="{{ old('can_not_wait_desc') }}">
                        </div>
                    </div>


                    {{-- Curses And Says Inappropriate Words --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.curses_and_says_inappropriate_words')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="curses_and_says_inappropriate_words"
                                    id="curses_and_says_inappropriate_words_always" value="Always">
                                <label class="form-check-label" for="curses_and_says_inappropriate_words_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="curses_and_says_inappropriate_words"
                                    id="curses_and_says_inappropriate_words_sometimes" value="Sometimes">
                                <label class="form-check-label" for="curses_and_says_inappropriate_words_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="curses_and_says_inappropriate_words" id="curses_and_says_inappropriate_words_no"
                                    value="No">
                                <label class="form-check-label" for="curses_and_says_inappropriate_words_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Curses And Says Inappropriate Words Description --}}
                    <div class="col-md-7">
                        <label for="curses_and_says_inappropriate_words_desc" class="form-label">{{__('students.curses_and_says_inappropriate_words')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start"
                                id="curses_and_says_inappropriate_words_desc"
                                placeholder="{{__('students.enter')}} {{__('students.curses_and_says_inappropriate_words')}} {{__('students.description')}} . . ."
                                name="curses_and_says_inappropriate_words_desc"
                                value="{{ old('curses_and_says_inappropriate_words_desc') }}">
                        </div>
                    </div>

                    {{-- Acts Inappropriately --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.acts_inappropriately')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="acts_inappropriately"
                                    id="acts_inappropriately_always" value="Always">
                                <label class="form-check-label" for="acts_inappropriately_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="acts_inappropriately"
                                    id="acts_inappropriately_sometimes" value="Sometimes">
                                <label class="form-check-label" for="acts_inappropriately_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="acts_inappropriately"
                                    id="acts_inappropriately_no" value="No">
                                <label class="form-check-label" for="acts_inappropriately_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Acts Inappropriately Description --}}
                    <div class="col-md-7">
                        <label for="acts_inappropriately_desc" class="form-label">{{__('students.acts_inappropriately')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="acts_inappropriately_desc"
                                placeholder="{{__('students.enter')}} {{__('students.acts_inappropriately')}} {{__('students.description')}} . . ." name="acts_inappropriately_desc"
                                value="{{ old('acts_inappropriately_desc') }}">
                        </div>
                    </div>

                    {{-- Very Shy --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.very_shy')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="very_shy" id="very_shy_always"
                                    value="Always">
                                <label class="form-check-label" for="very_shy_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="very_shy" id="very_shy_sometimes"
                                    value="Sometimes">
                                <label class="form-check-label" for="very_shy_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="very_shy" id="very_shy_no"
                                    value="No">
                                <label class="form-check-label" for="very_shy_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Very Shy Description --}}
                    <div class="col-md-7">
                        <label for="very_shy_desc" class="form-label">{{__('students.very_shy')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="very_shy_desc"
                                placeholder="{{__('students.enter')}} {{__('students.very_shy')}} {{__('students.description')}} . . ." name="very_shy_desc"
                                value="{{ old('very_shy_desc') }}">
                        </div>
                    </div>

                    {{-- Speaks Low Voice --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.speaks_low_voice')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="speaks_low_voice"
                                    id="speaks_low_voice_always" value="Always">
                                <label class="form-check-label" for="speaks_low_voice_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="speaks_low_voice"
                                    id="speaks_low_voice_sometimes" value="Sometimes">
                                <label class="form-check-label" for="speaks_low_voice_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="speaks_low_voice"
                                    id="speaks_low_voice_no" value="No">
                                <label class="form-check-label" for="speaks_low_voice_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Speaks Low Voice Description --}}
                    <div class="col-md-7 ">
                        <label for="speaks_low_voice_desc" class="form-label">{{__('students.speaks_low_voice')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="speaks_low_voice_desc"
                                placeholder="{{__('students.enter')}} {{__('students.speaks_low_voice')}} {{__('students.description')}} . . ." name="speaks_low_voice_desc"
                                value="{{ old('speaks_low_voice_desc') }}">
                        </div>
                    </div>


                    {{-- Not Defend Himself --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.not_defend_himself')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="not_defend_himself"
                                    id="not_defend_himself_always" value="Always">
                                <label class="form-check-label" for="not_defend_himself_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="not_defend_himself"
                                    id="not_defend_himself_sometimes" value="Sometimes">
                                <label class="form-check-label" for="not_defend_himself_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="not_defend_himself"
                                    id="not_defend_himself_no" value="No">
                                <label class="form-check-label" for="not_defend_himself_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Not Defend Himself Description --}}
                    <div class="col-md-7">
                        <label for="not_defend_himself_desc" class="form-label">{{__('students.not_defend_himself')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="not_defend_himself_desc"
                                placeholder="{{__('students.enter')}} {{__('students.not_defend_himself')}} {{__('students.description')}} . . ." name="not_defend_himself_desc"
                                value="{{ old('not_defend_himself_desc') }}">
                        </div>
                    </div>

                    {{-- Afraid Of Animals --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.afraid_of_animals')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="afraid_of_animals"
                                    id="afraid_of_animals_always" value="Always">
                                <label class="form-check-label" for="afraid_of_animals_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="afraid_of_animals"
                                    id="afraid_of_animals_sometimes" value="Sometimes">
                                <label class="form-check-label" for="afraid_of_animals_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="afraid_of_animals"
                                    id="afraid_of_animals_no" value="No">
                                <label class="form-check-label" for="afraid_of_animals_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Afraid Of Animals Description --}}
                    <div class="col-md-7">
                        <label for="afraid_of_animals_desc" class="form-label">{{__('students.afraid_of_animals')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="afraid_of_animals_desc"
                                placeholder="{{__('students.enter')}} {{__('students.afraid_of_animals')}} {{__('students.description')}} . . ." name="afraid_of_animals_desc"
                                value="{{ old('afraid_of_animals_desc') }}">
                        </div>
                    </div>

                    {{-- Hesitant And Confused --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.hesitant_and_confused')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="hesitant_and_confused"
                                    id="hesitant_and_confused_always" value="Always">
                                <label class="form-check-label" for="hesitant_and_confused_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="hesitant_and_confused"
                                    id="hesitant_and_confused_sometimes" value="Sometimes">
                                <label class="form-check-label" for="hesitant_and_confused_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="hesitant_and_confused"
                                    id="hesitant_and_confused_no" value="No">
                                <label class="form-check-label" for="hesitant_and_confused_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Hesitant And Confused Description --}}
                    <div class="col-md-7">
                        <label for="hesitant_and_confused_desc" class="form-label">{{__('students.hesitant_and_confused')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="hesitant_and_confused_desc"
                                placeholder="{{__('students.enter')}} {{__('students.hesitant_and_confused')}} {{__('students.description')}} . . ."
                                name="hesitant_and_confused_desc" value="{{ old('hesitant_and_confused_desc') }}">
                        </div>
                    </div>

                    {{-- Feeling Powerless And Lacking In Self Confidence --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.feeling_powerless_and_lacking_in_self_confidence')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="feeling_powerless_and_lacking_in_self_confidence"
                                    id="feeling_powerless_and_lacking_in_self_confidence_always" value="Always">
                                <label class="form-check-label"
                                    for="feeling_powerless_and_lacking_in_self_confidence_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="feeling_powerless_and_lacking_in_self_confidence"
                                    id="feeling_powerless_and_lacking_in_self_confidence_sometimes" value="Sometimes">
                                <label class="form-check-label"
                                    for="feeling_powerless_and_lacking_in_self_confidence_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="feeling_powerless_and_lacking_in_self_confidence"
                                    id="feeling_powerless_and_lacking_in_self_confidence_no" value="No">
                                <label class="form-check-label" for="feeling_powerless_and_lacking_in_self_confidence_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Feeling Powerless And Lacking In Self Confidence Description --}}
                    <div class="col-md-7">
                        <label for="feeling_powerless_and_lacking_in_self_confidence_desc" class="form-label">{{__('students.feeling_powerless_and_lacking_in_self_confidence')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start"
                                id="feeling_powerless_and_lacking_in_self_confidence_desc"
                                placeholder="{{__('students.enter')}} {{__('students.feeling_powerless_and_lacking_in_self_confidence')}} {{__('students.description')}} . . ."
                                name="feeling_powerless_and_lacking_in_self_confidence_desc"
                                value="{{ old('feeling_powerless_and_lacking_in_self_confidence_desc') }}">
                        </div>
                    </div>

                    {{-- Feeling Tense And Refuses To Hug --}}
                    <div class="col-md-4 my-2">
                        <h6 class="mb-3">{{__('students.feeling_tense_and_refuses_to_hug')}}</h6>
                        <div class="d-flex justify-content-between">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="feeling_tense_and_refuses_to_hug"
                                    id="feeling_tense_and_refuses_to_hug_always" value="Always">
                                <label class="form-check-label" for="feeling_tense_and_refuses_to_hug_always">
                                    {{__('students.always')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="feeling_tense_and_refuses_to_hug"
                                    id="feeling_tense_and_refuses_to_hug_sometimes" value="Sometimes">
                                <label class="form-check-label" for="feeling_tense_and_refuses_to_hug_sometimes">
                                    {{__('students.sometimes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="feeling_tense_and_refuses_to_hug"
                                    id="feeling_tense_and_refuses_to_hug_no" value="No">
                                <label class="form-check-label" for="feeling_tense_and_refuses_to_hug_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Feeling Tense And Refuses To Hug Description --}}
                    <div class="col-md-7 ">
                        <label for="feeling_tense_and_refuses_to_hug_desc" class="form-label">{{__('students.feeling_tense_and_refuses_to_hug')}} {{__('students.description')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="feeling_tense_and_refuses_to_hug_desc"
                                placeholder="{{__('students.enter')}} {{__('students.feeling_tense_and_refuses_to_hug')}} {{__('students.description')}} . . ."
                                name="feeling_tense_and_refuses_to_hug_desc"
                                value="{{ old('feeling_tense_and_refuses_to_hug_desc') }}">
                        </div>
                    </div>

                    {{-- Other Social Problems --}}
                    <div class="col-md-8 my-4">
                        <label for="other_social_problems" class="form-label">{{__('students.other_social_problems')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <textarea class="form-control text-start" id="other_social_problems" aria-describedby="other_social_problems"
                                placeholder="{{__('students.enter')}} {{__('students.other_social_problems')}} . . ." name="other_social_problems"
                                rows="3">{{ old('other_social_problems') }}</textarea>
                        </div>
                    </div>

                    {{-- Previous Pychological Examinations --}}
                    <h2 class="mb-3">{{__('students.previous_pychological_examinations')}}</h2>
                    {{-- Last Psychological Examination Name --}}
                    <div class="col-md-6 ">
                        <label for="last_psychological_examination_name" class="form-label">{{__('students.last_psychological_examination_name')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-file"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="last_psychological_examination_name"
                                placeholder="{{__('students.enter')}} {{__('students.last_psychological_examination_name')}} . . ."
                                name="last_psychological_examination_name"
                                value="{{ old('last_psychological_examination_name') }}">
                        </div>
                    </div>

                    {{-- Last Psychological Examination Date --}}
                    <div class="col-md-6 ">
                        <label for="last_psychological_examination_date" class="form-label">{{__('students.last_psychological_examination_date')}}</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-calendar-minus"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="last_psychological_examination_date"
                                name="last_psychological_examination_date"
                                value="{{ old('last_psychological_examination_date') }}">
                        </div>
                    </div>

                    <h2 class="my-3">{{__('students.previous_mental_disorders')}}</h2>
                    {{-- Previous Mental Disorders --}}
                    <div class="d-flex align-items-start flex-column ">

                        <div class="w-100  noParents" id="noParents13">
                            <div class="row g-3 align-items-end mb-3">
                                {{-- Turbulence --}}
                                <div class="col-md">
                                    <label for="validationCustomParent" class="form-label">{{__('students.turbulence')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="previous_mental_disorders[0][turbulence]"> <i
                                                class="fa-solid fa-pen-to-square"></i></span>
                                        <input type="text" class="form-control"
                                            id="previous_mental_disorders[0][turbulence]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.turbulence')}} . . ."
                                            name="previous_mental_disorders[0][turbulence]"
                                            value="{{ old('previous_mental_disorders[0][turbulence]') }}">
                                    </div>
                                </div>
                                {{-- Age --}}
                                <div class="col-md">
                                    <label for="previous_mental_disorders[0][age]" class="form-label">{{__('students.age')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input type="number" class="form-control" id="previous_mental_disorders[0][age]"
                                            aria-describedby="inputGroupPrepend" placeholder="{{__('students.enter')}} {{__('students.age')}} . . ."
                                            name="previous_mental_disorders[0][age]"
                                            value="{{ old('previous_mental_disorders[0][age]') }}">
                                    </div>
                                </div>
                                {{-- Duration --}}
                                <div class="col-md">
                                    <label for="previous_mental_disorders[0][duration]"
                                        class="form-label">{{__('students.duration')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"><i
                                                class="fa-solid fa-clock-rotate-left"></i></span>
                                        <input type="number" class="form-control" placeholder="{{__('students.enter')}} {{__('students.duration')}} . . ."
                                            name="previous_mental_disorders[0][duration]"
                                            id="previous_mental_disorders[0][duration]" aria-describedby="inputGroupPrepend"
                                            value="{{ old('previous_mental_disorders[0][duration]') }}">
                                    </div>
                                </div>
                                {{-- Healer --}}
                                <div class="col-md">
                                    <label for="previous_mental_disorders[0][healer]"
                                        class="form-label">{{__('students.healer')}}</label>
                                    <div class="input-group has-validation">
                                        <span class="input-group-text" id="inputGroupPrepend"> <i
                                                class="fa-solid fa-address-card"></i></span>
                                        <input type="text" class="form-control"
                                            name="previous_mental_disorders[0][healer]"
                                            id="previous_mental_disorders[0][healer]" aria-describedby="inputGroupPrepend"
                                            placeholder="{{__('students.enter')}} {{__('students.healer')}} . . ."
                                            value="{{ old('previous_mental_disorders[0][healer]') }}">
                                    </div>
                                </div>
                                {{-- Results --}}
                                <div class="col-md">
                                    <label for="validationCustomUserPhoneNumber" class="form-label d-block">
                                        {{__('students.results')}}
                                    </label>
                                    <div class="d-flex justify-content-between mt-3">
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio"
                                                id="previous_mental_disorders[0][results][negative]"
                                                name="previous_mental_disorders[0][results]" value="Negative">
                                            <label class="form-check-label"
                                                for="previous_mental_disorders[0][results][negative]">
                                                {{__('students.negative')}}
                                            </label>
                                        </div>
                                        <div class="form-check d-flex align-items-start">
                                            <input class="form-check-input me-2" type="radio"
                                                id="previous_mental_disorders[0][results][positive]"
                                                name="previous_mental_disorders[0][results]" value="Positive">
                                            <label class="form-check-label"
                                                for="previous_mental_disorders[0][results][positive]">
                                                {{__('students.positive')}}
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-1 d-flex justify-content-end">
                                    <i class="fa-regular fa-plus  icons bg-success text-white"
                                        onclick="previous_mental_disorders();"></i>
                                </div>

                            </div>
                        </div>
                    </div>


                    {{-- Intelligence and previous ability tests --}}
                    <h2 class="my-3">{{__('students.intelligence_and_previous_ability_tests')}}</h2>

                    {{-- First Test --}}
                    <h4>{{__('students.first')}}</h4>
                    <div class="row w-10 mb-4 align-items-end">

                        {{-- First Intelligence And Ability Test Name --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_name" class="form-label">{{__('students.intelligence_and_ability_test_name')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="first_intelligence_and_ability_test_name"
                                    aria-describedby="inputGroupPrepend" name="first_intelligence_and_ability_test_name"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} Intelligence And Ability Test Name . . ."
                                    value="{{ old('first_intelligence_and_ability_test_name') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Date --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_date" class="form-label">{{__('students.intelligence_and_ability_test_date')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="first_intelligence_and_ability_test_date"
                                    aria-describedby="inputGroupPrepend" name="first_intelligence_and_ability_test_date"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_date')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_date') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Reason --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_reason" class="form-label">{{__('students.intelligence_and_ability_test_reason')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="first_intelligence_and_ability_test_reason"
                                    aria-describedby="inputGroupPrepend" name="first_intelligence_and_ability_test_reason"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_reason')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_reason') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Result --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_result" class="form-label">{{__('students.intelligence_and_ability_test_result')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="first_intelligence_and_ability_test_result"
                                    aria-describedby="inputGroupPrepend" name="first_intelligence_and_ability_test_result"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_result')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_result') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Who Recommended It --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_who_recommended_it"
                                class="form-label">{{__('students.intelligence_and_ability_test_who_recommended_it')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="first_intelligence_and_ability_test_who_recommended_it"
                                    aria-describedby="inputGroupPrepend"
                                    name="first_intelligence_and_ability_test_who_recommended_it"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_who_recommended_it')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_who_recommended_it') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Explan --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_explan" class="form-label">{{__('students.intelligence_and_ability_test_explan')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="first_intelligence_and_ability_test_explan"
                                    aria-describedby="inputGroupPrepend" name="first_intelligence_and_ability_test_explan"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_explan')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_explan') }}">
                            </div>
                        </div>

                        {{-- First Intelligence And Ability Test Recommendations --}}
                        <div class="col-md-4">
                            <label for="first_intelligence_and_ability_test_recommendations"
                                class="form-label">{{__('students.intelligence_and_ability_test_recommendations')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="first_intelligence_and_ability_test_recommendations"
                                    aria-describedby="inputGroupPrepend"
                                    name="first_intelligence_and_ability_test_recommendations"
                                    placeholder="{{__('students.enter')}} {{__('students.first')}} {{__('students.intelligence_and_ability_test_recommendations')}} . . ."
                                    value="{{ old('first_intelligence_and_ability_test_recommendations') }}">
                            </div>
                        </div>

                    </div>

                    {{-- Second Test --}}
                    <h4>{{__('students.second')}}</h4>
                    <div class="row w-100  align-items-end mb-4">

                        {{-- Second Intelligence And Ability Test Name --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_name" class="form-label">{{__('students.intelligence_and_ability_test_name')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="second_intelligence_and_ability_test_name"
                                    aria-describedby="inputGroupPrepend" name="second_intelligence_and_ability_test_name"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_name')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_name') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Date --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_date" class="form-label">{{__('students.intelligence_and_ability_test_date')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="second_intelligence_and_ability_test_date"
                                    aria-describedby="inputGroupPrepend" name="second_intelligence_and_ability_test_date"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_date')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_date') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Reason --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_reason" class="form-label">{{__('students.intelligence_and_ability_test_reason')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="second_intelligence_and_ability_test_reason"
                                    aria-describedby="inputGroupPrepend" name="second_intelligence_and_ability_test_reason"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_reason')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_reason') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Result --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_result" class="form-label">{{__('students.intelligence_and_ability_test_result')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="second_intelligence_and_ability_test_result"
                                    aria-describedby="inputGroupPrepend" name="second_intelligence_and_ability_test_result"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_result')}} . ."
                                    value="{{ old('second_intelligence_and_ability_test_result') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Who Recommended It --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_who_recommended_it"
                                class="form-label">{{__('students.intelligence_and_ability_test_who_recommended_it')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="second_intelligence_and_ability_test_who_recommended_it"
                                    aria-describedby="inputGroupPrepend"
                                    name="second_intelligence_and_ability_test_who_recommended_it"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_who_recommended_it')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_who_recommended_it') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Explan --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_explan" class="form-label">{{__('students.intelligence_and_ability_test_explan')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="second_intelligence_and_ability_test_explan"
                                    aria-describedby="inputGroupPrepend" name="second_intelligence_and_ability_test_explan"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_explan')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_explan') }}">
                            </div>
                        </div>

                        {{-- Second Intelligence And Ability Test Recommendations --}}
                        <div class="col-md-4">
                            <label for="second_intelligence_and_ability_test_recommendations"
                                class="form-label">{{__('students.intelligence_and_ability_test_recommendations')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="second_intelligence_and_ability_test_recommendations"
                                    aria-describedby="inputGroupPrepend"
                                    name="second_intelligence_and_ability_test_recommendations"
                                    placeholder="{{__('students.enter')}} {{__('students.second')}} {{__('students.intelligence_and_ability_test_recommendations')}} . . ."
                                    value="{{ old('second_intelligence_and_ability_test_recommendations') }}">
                            </div>
                        </div>

                    </div>

                    {{-- Third Test --}}
                    <h4>{{__('students.third')}}</h4>
                    <div class="row w-100  align-items-end mb-4">

                        {{-- Third Intelligence And Ability Test Name --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_name" class="form-label">{{__('students.intelligence_and_ability_test_name')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="third_intelligence_and_ability_test_name"
                                    aria-describedby="inputGroupPrepend" name="third_intelligence_and_ability_test_name"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_name')}} . . ."
                                    value="{{ old('third_intelligence_and_ability_test_name') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Date --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_date" class="form-label">{{__('students.intelligence_and_ability_test_date')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="third_intelligence_and_ability_test_date"
                                    aria-describedby="inputGroupPrepend" name="third_intelligence_and_ability_test_date"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_date')}} .. ."
                                    value="{{ old('third_intelligence_and_ability_test_date') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Reason --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_reason" class="form-label">{{__('students.intelligence_and_ability_test_reason')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="third_intelligence_and_ability_test_reason"
                                    aria-describedby="inputGroupPrepend" name="third_intelligence_and_ability_test_reason"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_reason')}} . .."
                                    value="{{ old('third_intelligence_and_ability_test_reason') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Result --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_result" class="form-label">{{__('students.intelligence_and_ability_test_result')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="third_intelligence_and_ability_test_result"
                                    aria-describedby="inputGroupPrepend" name="third_intelligence_and_ability_test_result"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_result')}} . ."
                                    value="{{ old('third_intelligence_and_ability_test_result') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Who Recommended It --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_who_recommended_it"
                                class="form-label">{{__('students.intelligence_and_ability_test_who_recommended_it')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="third_intelligence_and_ability_test_who_recommended_it"
                                    aria-describedby="inputGroupPrepend"
                                    name="third_intelligence_and_ability_test_who_recommended_it"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_who_recommended_it')}} . . ."
                                    value="{{ old('third_intelligence_and_ability_test_who_recommended_it') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Explan --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_explan" class="form-label">{{__('students.intelligence_and_ability_test_explan')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="third_intelligence_and_ability_test_explan"
                                    aria-describedby="inputGroupPrepend" name="third_intelligence_and_ability_test_explan"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_explan')}} . . ."
                                    value="{{ old('third_intelligence_and_ability_test_explan') }}">
                            </div>
                        </div>

                        {{-- Third Intelligence And Ability Test Recommendations --}}
                        <div class="col-md-4">
                            <label for="third_intelligence_and_ability_test_recommendations"
                                class="form-label">{{__('students.intelligence_and_ability_test_recommendations')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="third_intelligence_and_ability_test_recommendations"
                                    aria-describedby="inputGroupPrepend"
                                    name="third_intelligence_and_ability_test_recommendations"
                                    placeholder="{{__('students.enter')}} {{__('students.third')}} {{__('students.intelligence_and_ability_test_recommendations')}} . . ."
                                    value="{{ old('third_intelligence_and_ability_test_recommendations') }}">
                            </div>
                        </div>

                    </div>

                    {{-- Fourth Test --}}
                    <h4>{{__('students.fourth')}}</h4>
                    <div class="row w-100  align-items-end mb-4">

                        {{-- Fourth Intelligence And Ability Test Name --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_name" class="form-label">{{__('students.intelligence_and_ability_test_name')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="fourth_intelligence_and_ability_test_name"
                                    aria-describedby="inputGroupPrepend" name="fourth_intelligence_and_ability_test_name"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_name')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_name') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Date --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_date" class="form-label">{{__('students.intelligence_and_ability_test_date')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="fourth_intelligence_and_ability_test_date"
                                    aria-describedby="inputGroupPrepend" name="fourth_intelligence_and_ability_test_date"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_date')}} . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_date') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Reason --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_reason" class="form-label">{{__('students.intelligence_and_ability_test_reason')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="fourth_intelligence_and_ability_test_reason"
                                    aria-describedby="inputGroupPrepend" name="fourth_intelligence_and_ability_test_reason"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_reason')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_reason') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Result --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_result" class="form-label">{{__('students.intelligence_and_ability_test_result')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="fourth_intelligence_and_ability_test_result"
                                    aria-describedby="inputGroupPrepend" name="fourth_intelligence_and_ability_test_result"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_result')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_result') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Who Recommended It --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_who_recommended_it"
                                class="form-label">{{__('students.intelligence_and_ability_test_who_recommended_it')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="fourth_intelligence_and_ability_test_who_recommended_it"
                                    aria-describedby="inputGroupPrepend"
                                    name="fourth_intelligence_and_ability_test_who_recommended_it"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_who_recommended_it')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_who_recommended_it') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Explan --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_explan" class="form-label">{{__('students.intelligence_and_ability_test_explan')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control" id="fourth_intelligence_and_ability_test_explan"
                                    aria-describedby="inputGroupPrepend" name="fourth_intelligence_and_ability_test_explan"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_explan')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_explan') }}">
                            </div>
                        </div>

                        {{-- Fourth Intelligence And Ability Test Recommendations --}}
                        <div class="col-md-4">
                            <label for="fourth_intelligence_and_ability_test_recommendations"
                                class="form-label">{{__('students.intelligence_and_ability_test_recommendations')}}</label>
                            <div class="input-group has-validation">
                                <span class="input-group-text" id="inputGroupPrepend">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </span>
                                <input type="text" class="form-control"
                                    id="fourth_intelligence_and_ability_test_recommendations"
                                    aria-describedby="inputGroupPrepend"
                                    name="fourth_intelligence_and_ability_test_recommendations"
                                    placeholder="{{__('students.enter')}} {{__('students.fourth')}} {{__('students.intelligence_and_ability_test_recommendations')}} . . ."
                                    value="{{ old('fourth_intelligence_and_ability_test_recommendations') }}">
                            </div>
                        </div>

                    </div>


                    {{-- The Independence Side --}}
                    <h2>{{__('students.the_independence_side')}}</h2>

                    {{-- Eats Alone Without Help --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.eats_alone_without_help')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="eats_alone_without_help"
                                id="eats_alone_without_help_always" value="Always">
                            <label class="form-check-label" for="eats_alone_without_help_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="eats_alone_without_help"
                                id="eats_alone_without_help_sometimes" value="Sometimes">
                            <label class="form-check-label" for="eats_alone_without_help_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="eats_alone_without_help"
                                id="eats_alone_without_help_no" value="No">
                            <label class="form-check-label" for="eats_alone_without_help_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                    </div>

                    {{-- Gets Dressed Without Help --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.gets_dressed_without_help')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="gets_dressed_without_help"
                                id="gets_dressed_without_help_always" value="Always">
                            <label class="form-check-label" for="gets_dressed_without_help_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="gets_dressed_without_help"
                                id="gets_dressed_without_help_sometimes" value="Sometimes">
                            <label class="form-check-label" for="gets_dressed_without_help_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="gets_dressed_without_help"
                                id="gets_dressed_without_help_no" value="No">
                            <label class="form-check-label" for="gets_dressed_without_help_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                    </div>

                    {{-- Asking To Go To The Bathroom --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.asking_to_go_to_the_bathroom')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="asking_to_go_to_the_bathroom"
                                id="asking_to_go_to_the_bathroom_always" value="Always">
                            <label class="form-check-label" for="asking_to_go_to_the_bathroom_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="asking_to_go_to_the_bathroom"
                                id="asking_to_go_to_the_bathroom_sometimes" value="Sometimes">
                            <label class="form-check-label" for="asking_to_go_to_the_bathroom_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="asking_to_go_to_the_bathroom"
                                id="asking_to_go_to_the_bathroom_no" value="No">
                            <label class="form-check-label" for="asking_to_go_to_the_bathroom_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                    </div>

                    {{-- Takes Care Of Himself In Bathroom --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.takes_care_of_himself_in_bathroom')}}</h6>

                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="takes_care_of_himself_in_bathroom"
                                id="takes_care_of_himself_in_bathroom_always" value="Always">
                            <label class="form-check-label" for="takes_care_of_himself_in_bathroom_always">
                                {{__('students.always')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="takes_care_of_himself_in_bathroom"
                                id="takes_care_of_himself_in_bathroom_sometimes" value="Sometimes">
                            <label class="form-check-label" for="takes_care_of_himself_in_bathroom_sometimes">
                                {{__('students.sometimes')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="takes_care_of_himself_in_bathroom"
                                id="takes_care_of_himself_in_bathroom_no" value="No">
                            <label class="form-check-label" for="takes_care_of_himself_in_bathroom_no">
                                {{__('students.no')}}
                            </label>
                        </div>

                    </div>
                </div>
            </div>


            {{-- Linguistic side --}}
            <div class="tab-pane fade" id="pills-Linguistic-side" role="tabpanel"
                aria-labelledby="pills-Linguistic-side-tab">

                <div class="row align-items-end justify-conent-center ">

                    {{-- Use Of Yelling To Express --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.of_yelling_to_express')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="use_of_yelling_to_express"
                                    id="use_of_yelling_to_express_yes" value="Yes">
                                <label class="form-check-label" for="use_of_yelling_to_express_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="use_of_yelling_to_express"
                                    id="use_of_yelling_to_express_no" value="No">
                                <label class="form-check-label" for="use_of_yelling_to_express_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Pay Attention To Sounds --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.pay_attention_to_sounds')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="pay_attention_to_sounds"
                                    id="pay_attention_to_sounds_yes" value="Yes">
                                <label class="form-check-label" for="pay_attention_to_sounds_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="pay_attention_to_sounds"
                                    id="pay_attention_to_sounds_no" value="No">
                                <label class="form-check-label" for="pay_attention_to_sounds_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Distinguish Mother And Father Voice --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.distinguish_mother_and_father_voice')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="distinguish_mother_and_father_voice" id="distinguish_mother_and_father_voice_yes"
                                    value="Yes">
                                <label class="form-check-label" for="distinguish_mother_and_father_voice_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="distinguish_mother_and_father_voice" id="distinguish_mother_and_father_voice_no"
                                    value="No">
                                <label class="form-check-label" for="distinguish_mother_and_father_voice_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Distinguish Family Members Voice --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.distinguish_family_members_voice')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="distinguish_family_members_voice"
                                    id="distinguish_family_members_voice_yes" value="Yes">
                                <label class="form-check-label" for="distinguish_family_members_voice_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="distinguish_family_members_voice"
                                    id="distinguish_family_members_voice_no" value="No">
                                <label class="form-check-label" for="distinguish_family_members_voice_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Using Audio Clips --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.using_audio_clips')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="using_audio_clips"
                                    id="using_audio_clips_yes" value="Yes">
                                <label class="form-check-label" for="using_audio_clips_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="using_audio_clips"
                                    id="using_audio_clips_no" value="No">
                                <label class="form-check-label" for="using_audio_clips_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Pronounces Word Understandable --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.pronounces_word_understandable')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="pronounces_word_understandable"
                                    id="pronounces_word_understandable_yes" value="Yes">
                                <label class="form-check-label" for="pronounces_word_understandable_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="pronounces_word_understandable"
                                    id="pronounces_word_understandable_no" value="No">
                                <label class="form-check-label" for="pronounces_word_understandable_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Turns Around When He Hears His Name --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.turns_around_when_he_hears_his_name')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="turns_around_when_he_hears_his_name" id="turns_around_when_he_hears_his_name_yes"
                                    value="Yes">
                                <label class="form-check-label" for="turns_around_when_he_hears_his_name_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="turns_around_when_he_hears_his_name" id="turns_around_when_he_hears_his_name_no"
                                    value="No">
                                <label class="form-check-label" for="turns_around_when_he_hears_his_name_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Looking The Person Speaking During Conversation --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.looking_the_person_speaking_during_conversation')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="looking_the_person_speaking_during_conversation"
                                    id="looking_the_person_speaking_during_conversation_yes" value="Yes">
                                <label class="form-check-label" for="looking_the_person_speaking_during_conversation_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="looking_the_person_speaking_during_conversation"
                                    id="looking_the_person_speaking_during_conversation_no" value="No">
                                <label class="form-check-label" for="looking_the_person_speaking_during_conversation_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Uses Two Words Sentence --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.uses_two_words_sentence')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="uses_two_words_sentence"
                                    id="uses_two_words_sentence_yes" value="Yes">
                                <label class="form-check-label" for="uses_two_words_sentence_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="uses_two_words_sentence"
                                    id="uses_two_words_sentence_no" value="No">
                                <label class="form-check-label" for="uses_two_words_sentence_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Needs Encouragement To Speak --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.yes')}}{{__('students.needs_encouragement_to_speak')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="needs_encouragement_to_speak"
                                    id="needs_encouragement_to_speak_yes" value="Yes">
                                <label class="form-check-label" for="needs_encouragement_to_speak_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="needs_encouragement_to_speak"
                                    id="needs_encouragement_to_speak_no" value="No">
                                <label class="form-check-label" for="needs_encouragement_to_speak_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Uses Expressive Language To Express His Needs --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.uses_expressive_language_to_express_his_needs')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="uses_expressive_language_to_express_his_needs"
                                    id="uses_expressive_language_to_express_his_needs_yes" value="Yes">
                                <label class="form-check-label" for="uses_expressive_language_to_express_his_needs_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="uses_expressive_language_to_express_his_needs"
                                    id="uses_expressive_language_to_express_his_needs_no" value="No">
                                <label class="form-check-label" for="uses_expressive_language_to_express_his_needs_no">
                                    {{__('students.yes')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Stutters While Speaking --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.stutters_while_speaking')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="stutters_while_speaking"
                                    id="stutters_while_speaking_yes" value="Yes">
                                <label class="form-check-label" for="stutters_while_speaking_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="stutters_while_speaking"
                                    id="stutters_while_speaking_no" value="No">
                                <label class="form-check-label" for="stutters_while_speaking_no">
                                    {{__('students.yes')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Remove Letters From Words --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.remove_letters_from_words')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="remove_letters_from_words"
                                    id="remove_letters_from_words_yes" value="Yes">
                                <label class="form-check-label" for="remove_letters_from_words_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="remove_letters_from_words"
                                    id="remove_letters_from_words_no" value="No">
                                <label class="form-check-label" for="remove_letters_from_words_no">
                                    {{__('students.no')}}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Add Letters To Words --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.add_letters_to_words')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="add_letters_to_words"
                                    id="add_letters_to_words_yes" value="Yes">
                                <label class="form-check-label" for="add_letters_to_words_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="add_letters_to_words"
                                    id="add_letters_to_words_no" value="No">
                                <label class="form-check-label" for="add_letters_to_words_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Turns Some Letters In Word --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.turns_some_letters_in_word')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="turns_some_letters_in_word"
                                    id="turns_some_letters_in_word_yes" value="Yes">
                                <label class="form-check-label" for="turns_some_letters_in_word_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="turns_some_letters_in_word"
                                    id="turns_some_letters_in_word_no" value="No">
                                <label class="form-check-label" for="turns_some_letters_in_word_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Changes Some Letters When Saying Word --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.changes_some_letters_when_saying_word')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="changes_some_letters_when_saying_word"
                                    id="changes_some_letters_when_saying_word_yes" value="Yes">
                                <label class="form-check-label" for="changes_some_letters_when_saying_word_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="changes_some_letters_when_saying_word"
                                    id="changes_some_letters_when_saying_word_no" value="No">
                                <label class="form-check-label" for="changes_some_letters_when_saying_word_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Speaks But The Words Are Distorted And Incomprehensible --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.speaks_but_the_words_are_distorted_and_incomprehensible')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="speaks_but_the_words_are_distorted_and_incomprehensible"
                                    id="speaks_but_the_words_are_distorted_and_incomprehensible_yes" value="Yes">
                                <label class="form-check-label"
                                    for="speaks_but_the_words_are_distorted_and_incomprehensible_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio"
                                    name="speaks_but_the_words_are_distorted_and_incomprehensible"
                                    id="speaks_but_the_words_are_distorted_and_incomprehensible_no" value="No">
                                <label class="form-check-label"
                                    for="speaks_but_the_words_are_distorted_and_incomprehensible_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>

                    {{-- Understands What Is Asked Of Him --}}
                    <div class="col-md-6 my-3">
                        <label for="validationCustomUserPhoneNumber" class="form-label d-block">{{__('students.understands_what_is_asked_of_him')}}</label>
                        <div class="">
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="understands_what_is_asked_of_him"
                                    id="understands_what_is_asked_of_him_yes" value="Yes">
                                <label class="form-check-label" for="understands_what_is_asked_of_him_yes">
                                    {{__('students.yes')}}
                                </label>
                            </div>
                            <div class="form-check d-flex align-items-start">
                                <input class="form-check-input me-2" type="radio" name="understands_what_is_asked_of_him"
                                    id="understands_what_is_asked_of_him_no" value="No">
                                <label class="form-check-label" for="understands_what_is_asked_of_him_no">
                                    {{__('students.no')}}
                                </label>
                            </div>


                        </div>
                    </div>
                </div>

                {{-- Child's Language Problems --}}
                <h4>{{__('students.his_language_problems')}}</h4>
                <div class="row align-items-end">
                    {{-- Language Level --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.language_level')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="language_level"
                                id="language_level_very_weak" value="very_weak ">
                            <label class="form-check-label" for="language_level_very_weak">
                                {{__('students.very_weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="language_level"
                                id="language_level_weak" value="very_weak ">
                            <label class="form-check-label" for="language_level_weak">
                                {{__('students.weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="language_level"
                                id="language_level_acceptable" value="acceptable ">
                            <label class="form-check-label" for="language_level_acceptable">
                                {{__('students.acceptable')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="language_level"
                                id="language_level_good" value="good ">
                            <label class="form-check-label" for="language_level_good">
                                {{__('students.good')}}
                            </label>
                        </div>


                    </div>

                    {{-- Level Of Expression Of His Needs Linguistically --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3"> {{__('students.level_of_expression_of_his_needs_linguistically')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio"
                                name="level_of_expression_of_his_needs_linguistically"
                                id="level_of_expression_of_his_needs_linguistically_very_weak" value="very_weak ">
                            <label class="form-check-label"
                                for="level_of_expression_of_his_needs_linguistically_very_weak">
                                {{__('students.very_weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio"
                                name="level_of_expression_of_his_needs_linguistically"
                                id="level_of_expression_of_his_needs_linguistically_weak" value="very_weak ">
                            <label class="form-check-label" for="level_of_expression_of_his_needs_linguistically_weak">
                                {{__('students.weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio"
                                name="level_of_expression_of_his_needs_linguistically"
                                id="level_of_expression_of_his_needs_linguistically_acceptable" value="acceptable ">
                            <label class="form-check-label"
                                for="level_of_expression_of_his_needs_linguistically_acceptable">
                                {{__('students.acceptable')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio"
                                name="level_of_expression_of_his_needs_linguistically"
                                id="level_of_expression_of_his_needs_linguistically_good" value="good ">
                            <label class="form-check-label" for="level_of_expression_of_his_needs_linguistically_good">
                                {{__('students.good')}}
                            </label>
                        </div>


                    </div>

                    {{-- Level Of Coherence Of Ideas --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.level_of_coherence_of_ideas')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="level_of_coherence_of_ideas"
                                id="level_of_coherence_of_ideas_very_weak" value="very_weak ">
                            <label class="form-check-label" for="level_of_coherence_of_ideas_very_weak">
                                {{__('students.very_weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="level_of_coherence_of_ideas"
                                id="level_of_coherence_of_ideas_weak" value="very_weak ">
                            <label class="form-check-label" for="level_of_coherence_of_ideas_weak">
                                {{__('students.weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="level_of_coherence_of_ideas"
                                id="level_of_coherence_of_ideas_acceptable" value="acceptable ">
                            <label class="form-check-label" for="level_of_coherence_of_ideas_acceptable">
                                {{__('students.acceptable')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="level_of_coherence_of_ideas"
                                id="level_of_coherence_of_ideas_good" value="good ">
                            <label class="form-check-label" for="level_of_coherence_of_ideas_good">
                                {{__('students.good')}}
                            </label>
                        </div>


                    </div>

                    {{-- Speed Level --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.speed_level')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="speed_level"
                                id="speed_level_very_weak" value="very_weak ">
                            <label class="form-check-label" for="speed_level_very_weak">
                                {{__('students.very_weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="speed_level" id="speed_level_weak"
                                value="very_weak ">
                            <label class="form-check-label" for="speed_level_weak">
                                {{__('students.weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="speed_level"
                                id="speed_level_acceptable" value="acceptable ">
                            <label class="form-check-label" for="speed_level_acceptable">
                                {{__('students.acceptable')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="speed_level" id="speed_level_good"
                                value="good ">
                            <label class="form-check-label" for="speed_level_good">
                                {{__('students.good')}}
                            </label>
                        </div>


                    </div>

                    {{-- Response --}}
                    <div class="col-md-6 my-2">
                        <h6 class="mb-3">{{__('students.response')}}</h6>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="response" id="response_very_weak"
                                value="very_weak ">
                            <label class="form-check-label" for="response_very_weak">
                                {{__('students.very_weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="response" id="response_weak"
                                value="very_weak ">
                            <label class="form-check-label" for="response_weak">
                                {{__('students.weak')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="response" id="response_acceptable"
                                value="acceptable ">
                            <label class="form-check-label" for="response_acceptable">
                                {{__('students.acceptable')}}
                            </label>
                        </div>
                        <div class="form-check d-flex align-items-start">
                            <input class="form-check-input me-2" type="radio" name="response" id="response_good"
                                value="good ">
                            <label class="form-check-label" for="response_good">
                                {{__('students.good')}}
                            </label>
                        </div>


                    </div>
                </div>
            </div>

            <div class="col-12 mt-3 text-center">
                <button class="btn btn-outline-primary py-2 px-5" type="submit">{{__('students.save')}}</button>
            </div>
        </div>

    </form>
@endsection

@section('scripts')
    <script src="{{ asset('js/studentForm.js') }}"></script>
@endsection
