@extends('layouts.app_layout')

@section('title')
Student Assignment
@endsection

@section('content')
@include('inc.errors')

{{-- <p>{{$assignment_id}}</p>
<p>{{$student_id}}</p> --}}


<section id="setting">
    <div class="container">
        <div class="bg-white overflow-auto  shadow-lg  rounded-lg">
            <h1 class="text-center text-spec py-5 bg-light border-bottom">{{__('students.start_your_quiz')}}</h1>


            @if (eval("return $student_contation;"))
            <div class="p-4 text-center">

                <h1 class="text-center ">
                    @if( Config::get('languages')[App::getLocale()] =="Arabic" )
                    {{ $assignment->assignment_title_ar }}
                    @else
                    {{ $assignment->assignment_title }}
                    @endif
                </h1>
                <h5 class="text-center " id="assignment_instructions">
                </h5>

                <p class="text-muted " id="assignment_note">

                </p>
                <button id="startBtn" class="bg-gradient btn float-right py-2 px-4 bg-spec rounded-pill text-white my-4">{{__('students.start')}}
                </button>
            </div>
            @else
            <div class="alert alert-danger">

                <p>{{ $alert }}</p>
            </div>
            @endif

        </div>
    </div>
</section>



<section id="quiz">
    <div class="container">
        <div class="bg-white  shadow-lg rounded-lg  overflow-auto">
            <div class="p-3 bg-light border-bottom overflow-auto">
                <h1 class="text-spec text-center">{{__('students.quiz')}}</h1>

                <h6 id="GroupTitle" class="bg-gradient  float-start  text-white py-3 px-2 my-3 w-50  rounded-pill d-flex justify-content-center align-items-center">

                </h6>
                <h3 id="GroupIndex" class="bg-gradient  float-end  text-success py-3 px-2 my-3 w-25  rounded-pill d-flex justify-content-center align-items-center">

                </h3>
                <div class="clearFix"></div>

            </div>

            <div class="p-4 text-spec">
                <div class="float-start">
                    <h5 class="d-inline">Q: </h5>
                    <h6 id="question" class="d-inline"></h6>
                    <h6 id="questionTitle" class="d-block text-muted"></h6>
                </div>
                <div class="float-end w-25">
                    <!-- <label for="">Question Note</label> -->
                    <textarea class="form-control " placeholder="Question Note..." name="" id="noteQuestion"></textarea>
                </div>
                <div class="clearfix"></div>
                <div id="rowAnswer" class="row">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="answer" id="q1" value="value">
                            Lorem ipsum dolor sit amet.
                        </label>
                    </div>
                </div>

                <div class="alert alert-danger mt-3" id="answerAlert">{{__('students.please_choose_your_answer')}}</div>
                <button class="bg-gradient btn float-end py-2 px-4 bg-spec rounded-pill text-white my-4" id="next">{{__('students.next')}}</button>
                <button class="bg-gradient btn float-start py-2 px-4 bg-spec rounded-pill text-white my-4" id="prev">{{__('students.previous')}}</button>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>
</section>

<section id="finish">
    <form method="POST" action="{{ route('storeStudentAssignment') }}" id="FormTabs" enctype="multipart/form-data">
        @csrf
        <div class="bg-white w-75 m-auto shadow-lg rounded overflow-auto ">
            <h1 class=" text-spec py-5 bg-light border-bottom text-center">{{__('students.fininsh')}}</h1>
            <div class="container">
                <div class="row  text-capitalize border-bottom ">

                    <h4 class="col-md-4">{{__('students.name')}}</h4>
                    <h4 class="col-md-3 text-center">{{__('students.total_score')}}</h4>
                    <h4 class="col-md-5 text-end">{{__('students.evaluations_and_rescomendations')}}</h4>
                </div>
                <div id="score">

                </div>
            </div>
            <div class="p-4 text-end">

                <input type="hidden" class="form-control" name="assignment_id" value="{{ $assignment_id }}">
                <input type="hidden" class="form-control" name="assignment_shortname" value="{{ $assignment_shortname }}">
                <input type="hidden" class="form-control" name="student_id" value="{{ $student_id }}">
                <div class="form-group">
                    @foreach ($assignment_informations as $assignment_information)
                    <input type="hidden" class="form-control" name="assignment_information_provider[]" value="{{ $assignment_information }}">
                    @endforeach
                </div>

                <input type="hidden" name="assignment_data" id="DataOFQuize" value="">
                <label for="finalReport">{{__('students.final_report')}}</label>
                <textarea name="final_report" id="finalReport" class="form-control" rows="10"></textarea>
                <button class="bg-gradient btn float-end py-2 px-4 bg-spec rounded-pill text-white my-4" type="submit" id="tryBtn">{{__('students.submit')}}</button>
            </div>
        </div>
    </form>
</section>
@endsection

<script>
    var assignments = <?php echo json_encode($assignment); ?>;
    var assignment_questions = <?php echo json_encode($assignment_questions); ?>;
    var lang = <?php echo json_encode(Config::get('languages')[App::getLocale()])  ?>;
</script>
@section('scripts')
<Script src="{{ asset('js/quiz.js') }}"></Script>
@endsection