@extends('layouts.list')

@section('title')
    All Students
@endsection

@section('list-title')
    {{__('students.students')}}
@endsection

@section('list-navigation')
    <li>{{__('students.students')}}</li>
@endsection

@section('list-new-button')
    @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin')
        <a href="{{ route('createStudent') }}" class="btn btn-outline-primary btn-sm me-2">
            <i class="fa-solid fa-plus me-2"></i>{{__('students.new_student')}}
        </a>
    @endif
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('students.image')}}</th>
    <th scope="col">{{__('students.student')}}</th>
    <th scope="col">{{__('students.nationality')}}</th>
    <th scope="col">{{__('students.gender')}}</th>
    <th scope="col">{{__('students.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($students as $student)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row" class="imageTitle">
                @if ($student->image !== null && $student->image !== '')
                    <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$student->image") }}'
                        alt="{{ $student->student_name }}">
                @else
                    <h2> {{ $student->student_name[0] }}</h2>
                @endif
            </td>
            <td class="Zindex Zindex1">
                <h6 class="col-6">{{__('students.name')}}</h6>
                <a class="text-decoration-none col-6" href="{{ route('viewStudent', $student->id) }}">
                    <p class="text-custome m-0 mb-4 ">{{ $student->student_name }}</p>
                </a>
                <h6 class="col-6">{{__('students.home_phone')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->home_phone }}</p>
                <h6 class="col-6">{{__('students.phone')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->phone }}</p>
                <h6 class="col-6">{{__('students.alternative_phone')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->alternative_phone }}</p>
                <h6 class="col-6">{{__('students.contact_number')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->contact_number }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6">{{__('students.nationality')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->nationality }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6">{{__('students.gender')}}</h6>
                <p class="m-0 mb-4 col-6">{{ $student->gender }}</p>
            </td>
            <td>
                <div class="btn-group">
                    {{-- <p>{{session()->get('IPassedTheMiddleware')}}</p> --}}
                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewStudent', $student->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('students.view')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin')
                            <li>
                                <a class="dropdown-item opacity-75 " href="{{ route('editStudent', $student->id) }}">
                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                    {{__('students.edit')}}
                                </a>
                            </li>
                        @endif
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('takeStudentAssignment', $student->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('students.take_assignment')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('takenStudentAssignments', $student->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('students.taken_assignments')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
                            <li>
                                <a class="dropdown-item opacity-75 " href="{{ route('deleteStudent', $student->id) }}">
                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                    {{__('students.delete')}}
                                </a>
                            </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $students->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $students->links() }} --}}
@endsection
