@extends('layouts.app_layout')

@section('title')
Student Assignment
@endsection

@section('content')

@include('inc.errors')

<section id="setting">
    <div class="container">
        <form method="POST" action="{{ route('createStudentAssignment') }}" id="FormTabs" enctype="multipart/form-data">
            @csrf
            <div class="bg-white overflow-auto  shadow-lg  rounded-lg">
                <h1 class="text-center text-spec py-5 bg-light border-bottom">{{__('students.setting_your_quiz')}}</h1>
                <div class="p-4">

                    <div class="row mb-3 border-bottom text-capitalize">
                        @if($student->student_name !=null)
                        <div class="col-md-6">
                            <h5>{{__('students.student_name_')}}<span class="text-muted fs-6">{{$student->student_name}}</span></h5>
                        </div>
                        @endif
                        @if($student->dob !=null)
                        <div class="col-md-6">
                            <h5>{{__('students.date_of_birth_')}}<span class="text-muted fs-6">{{$student->dob}}</span></h5>
                        </div>
                        @endif
                        @if($student->dob !=null)
                        <div class="col-md-6">
                            <h5>{{__('students.age_:')}}<span class="text-muted fs-6">
                                    {{\Carbon\Carbon::parse($student->dob)->diff(\Carbon\Carbon::now())->format('%y years, %m months and %d days');}}
                                </span>
                            </h5>
                        </div>
                        @endif
                        @if($student->nationality !=null)
                        <div class="col-md-6">
                            <h5>{{__('students.nationality_:')}}<span class="text-muted fs-6">{{$student->nationality}}</span></h5>
                        </div>
                        @endif
                    </div>
                    <div class="form-group">

                        <label for="Assignment" class="text-spec">{{__('students.assignment_title')}}</label>
                        <select id="Assignment" class="form-control" name="assignment">
                            @foreach ($assignments as $assignment)
                            <option value="{{$assignment->id}}|{{$assignment->assignment_shortname}}">{{$assignment->assignment_title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group my-3">

                        <label for="informationAssignment" class="text-spec">
                            {{__('students.based_on_the_information_which_has_been_taken_from')}}

                        </label>
                        <select id="informationAssignment" multiple class="form-control" name="assignmentInformation[]" aria-label="multiple select example" required>
                            <option value="Father">{{__('students.father')}}</option>
                            <option value="Mother">{{__('students.mother')}}</option>
                            <option value="Superior">{{__('students.superior')}}</option>
                            <option value="Teacher">{{__('students.teacher')}}</option>
                            <option value="Trainer">{{__('students.trainer')}}</option>
                            <option value="Notes">{{__('students.notes')}}</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="hidden" class="form-control" name="studentId" value="{{$student->id}}">
                    </div>
                    <button id="startBtn" type="submit" class="bg-gradient btn float-right py-2 px-4 bg-spec rounded-pill text-white my-4">{{__('students.start')}}
                    </button>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection