@extends('layouts.list')

@section('title')
    Taken Assignments
@endsection

@section('list-title')
    {{__('students.taken_assignments')}}
@endsection

@section('list-navigation')
    {{-- <li><a class="text-decoration-none" href="{{ route('allSubmissions') }}">Submissions</a></li> --}}
    <li><a class="text-decoration-none" href="{{ route('allStudents') }}">{{__('students.students')}}</a></li>
    <li>{{__('students.taken_assignments')}}</li>
@endsection

@section('list-new-button')
    {{-- <a href="{{ route('createtaken_assignment') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New taken_assignment
    </a> --}}
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('students.student_name')}}</th>
    <th scope="col">{{__('students.assignment_title')}}</th>
    <th scope="col">{{__('students.businss_location')}}</th>
    <th scope="col">{{__('students.trainer')}}</th>
    <th scope="col">{{__('students.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($taken_assignments as $taken_assignment)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="Zindex text-center d-block">
                {{-- <a class="text-decoration-none" href="{{ route('viewStudent', $taken_assignment->student_id) }}"> --}}
                    <p class="text-custome m-0 px-3">{{ $taken_assignment->student->student_name }}</p>
                {{-- </a> --}}
            </td>
            <td class="Zindex text-center d-block">
                {{-- <a class="text-decoration-none" href="{{ route('viewAssignment', $taken_assignment->assignment_id) }}"> --}}
                    <p class="text-custome m-0 px-3">{{ $taken_assignment->assignment->assignment_title }}</p>
                {{-- </a> --}}
            </td>
            <td class="Zindex text-center d-block">
                {{-- <a class="text-decoration-none" href="{{ route('viewBusinessLocation', $taken_assignment->business_id) }}"> --}}
                    <p class="text-custome m-0 px-3">{{ $taken_assignment->businessLocation->business_name }}</p>
                {{-- </a> --}}
            </td>
            <td class="Zindex text-center d-block" >
                {{-- <a class="text-decoration-none" href="{{ route('viewTrainer', $taken_assignment->trainer_id) }}"> --}}
                    <p class="text-custome m-0 px-3">{{ $taken_assignment->trainer->full_name }}</p>
                {{-- </a> --}}
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('assignmentReportIndex', ['assignment_id' => $taken_assignment->assignment_id , 'submission_id' => $taken_assignment->id]) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('students.reports')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                            href="{{ route('viewStudent', $taken_assignment->student_id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('students.view_student')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                            href="{{ route('viewAssignment', $taken_assignment->assignment_id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('students.view_assignment')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                            href="{{ route('viewTrainer', $taken_assignment->trainer_id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('students.view_trainer')}} 
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $taken_assignments->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $taken_assignments->links() }} --}}
@endsection
