@extends('layouts.view')

@section('title')
View student
@endsection

@section('view-title')
{{__('students.view_user')}} - {{ $student -> student_name}}
<i class="fa-solid fa-print text-custome" onclick="printData()"></i>
@endsection

@section('view-navigation')
<li><a class="text-decoration-none" href="{{ route('allStudents') }}">{{__('students.list_students')}}</a></li>
<li>{{__('students.view_user')}}</li>
@endsection

@section('view-panel')
<div class="user-avtar" id="userImage">
    @if ($student->image !== null)
    <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='{{ asset("uploads/$student->image") }}' alt="{{ $student->full_name }}">
    @else
    <span>{{ ucfirst($student->student_name[0]) }}</span>
    @endif
</div>
<div class="user-details text-center pt-3">
    <h3 id="userName">{{$student->student_name}}</h3>
    <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

        <button class="nav-link active" id="pills-student-info-tab" data-bs-toggle="pill" data-bs-target="#pills-student-info" type="button" role="tab" aria-controls="pills-student-info" aria-selected="true">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.list_students')}}</span>
        </button>

        <button class="nav-link" id="v-pills-student-address-tab" data-bs-toggle="pill" data-bs-target="#v-pills-student-address" type="button" role="tab" aria-controls="v-pills-student-address" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.address_info')}}</span>
        </button>

        <button class="nav-link" id="v-pills-father-tab" data-bs-toggle="pill" data-bs-target="#v-pills-father" type="button" role="tab" aria-controls="v-pills-father" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.father')}}</span>
        </button>

        <button class="nav-link" id="v-pills-mother-tab" data-bs-toggle="pill" data-bs-target="#v-pills-mother" type="button" role="tab" aria-controls="v-pills-mother" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.mother')}}</span>
        </button>
        @if($student->superior =='Yes')
        <button class="nav-link" id="v-pills-superior-tab" data-bs-toggle="pill" data-bs-target="#v-pills-superior" type="button" role="tab" aria-controls="v-pills-superior" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.superior')}}</span>
        </button>
        @endif

        <button class="nav-link" id="v-pills-main-complaint-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main-complaint" type="button" role="tab" aria-controls="v-pills-main-complaint" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.main_problem')}}</span>
        </button>


        <button class="nav-link" id="v-pills-relation_family-history-tab" data-bs-toggle="pill" data-bs-target="#v-pills-family-history" type="button" role="tab" aria-controls="v-pills-family-history" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.family_history')}}</span>
        </button>

        <button class="nav-link" id="v-pills-economic_situation-tab" data-bs-toggle="pill" data-bs-target="#v-pills-economic_situation" type="button" role="tab" aria-controls="v-pills-economic_situation" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.economic_situation')}}</span>
        </button>

        <button class="nav-link" id="v-pills-organic-growth-history-tab" data-bs-toggle="pill" data-bs-target="#v-pills-organic-growth-history" type="button" role="tab" aria-controls="v-pills-organic-growth-history" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.organic_growth_history')}}</span>
        </button>

        <button class="nav-link" id="v-pills-psychological-and-behavioral-side-tab" data-bs-toggle="pill" data-bs-target="#v-pills-psychological-and-behavioral-side" type="button" role="tab" aria-controls="v-pills-psychological-and-behavioral-side" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.psychological_and_behavioral_side')}}</span>
        </button>

        <button class="nav-link" id="v-pills-Linguistic-side-tab" data-bs-toggle="pill" data-bs-target="#v-pills-Linguistic-side" type="button" role="tab" aria-controls="v-pills-Linguistic-side" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>{{__('students.linguistic_side')}}</span>
        </button>


        <button class="nav-link" id="v-pills-student-social-media-tab" data-bs-toggle="pill" data-bs-target="#v-pills-student-social-media" type="button" role="tab" aria-controls="v-pills-student-social-media" aria-selected="false">

            <i class="fa-solid fa-link"></i>
            <span>{{__('students.social_links')}}</span>
        </button>



        <a class="nav-link" type="button" role="tab" aria-selected="false">

            <i class="fa-solid fa-user-pen"></i><span>{{__('students.edit_student')}}</span>

        </a>
    </div>
</div>
@endsection


@section('view-tabs')

{{-- Student Info --}}
<div class="tab-pane fade show active" id="pills-student-info" role="tabpanel" aria-labelledby="pills-student-info-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.student_info')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.full_name')}}</td>
                        <td>{{ $student->student_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.mobile_number')}}</td>
                        <td>{{ $student->phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.birth_address')}}</td>
                        <td>{{ $student->birth_address }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.height')}}</td>
                        <td>{{ $student->height }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.weight')}}</td>
                        <td>{{ $student->weight }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.home_phone')}}</td>
                        <td>{{ $student->home_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.alternative_mobile_number')}}</td>
                        <td>{{ $student->alternative_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.gender')}}</td>
                        <td>{{ $student->gender }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.school_name')}}</td>
                        <td>{{ $student->school_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.blood_group')}}</td>
                        <td>{{ $student->blood_group }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.contact_number')}}</td>
                        <td>{{ $student->contact_number }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.dob')}}</td>
                        <td>{{ $student->dob }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.created_by')}}</td>
                        <td><a class="text-decoration-none" href="{{ route('viewUser', $student->created_by) }}">{{ $student->createdPerson->full_name }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.created_date')}}</td>
                        <td>{{ $student->created_at }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Student Address --}}
<div class="tab-pane fade" id="v-pills-student-address" role="tabpanel" aria-labelledby="v-pills-student-address-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.student_address')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.address')}}</td>
                        <td>{{ $student->address }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.city')}}</td>
                        <td>{{ $student->city }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.state')}}</td>
                        <td>{{ $student->state }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.country')}}</td>
                        <td>{{ $student->country }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.landmark')}}</td>
                        <td>{{ $student->landmark }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- father --}}
<div class="tab-pane fade" id="v-pills-father" role="tabpanel" aria-labelledby="v-pills-father-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.father')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            @if ($student->father_image !== null)
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='{{ asset("uploads/$student->father_image") }}' alt="{{ $student->father_name }}">
                            @else
                            <span>{{ ucfirst( $student->father_name[0] ) }}</span>
                            @endif
                        </div>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_name')}}</td>
                        <td>{{ $student->father_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_dob')}}</td>
                        <td>{{ $student->father_dob }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_nationality')}}</td>
                        <td>{{ $student->father_nationality }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_national_number')}}</td>
                        <td>{{ $student->father_national_number }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_degree_of_kinship')}}</td>
                        <td>{{ $student->father_degree_of_kinship }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.address')}}</td>
                        <td>{{ $student->father_address }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.city')}}</td>
                        <td>{{ $student->father_city }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.state')}}</td>
                        <td>{{ $student->father_state }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.country')}}</td>
                        <td>{{ $student->father_country }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.landmark')}}</td>
                        <td>{{ $student->father_landmark }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_job')}}</td>
                        <td>{{ $student->father_job }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.marital_status')}}</td>
                        <td>{{ $student->father_marital_status }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_phone')}}</td>
                        <td>{{ $student->father_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_alternative_phone')}}</td>
                        <td>{{ $student->father_alternative_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_email')}}</td>
                        <td>{{ $student->father_email }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.facebook_link')}}</td>
                        <td><a href=" {{ $student->father_fb_link }}"> {{ $student->father_fb_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.twitter_link')}}</td>
                        <td><a href=" {{ $student->father_twitter_link }}"> {{ $student->father_twitter_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link')}}</td>
                        <td><a href=" {{ $student->father_social_media_1 }}"> {{ $student->father_social_media_1 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link_2')}}</td>
                        <td><a href=" {{ $student->father_social_media_2 }}"> {{ $student->father_social_media_2 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_qualification')}}</td>
                        <td> {{ $student->father_qualification }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.other_qualification')}}</td>
                        <td> {{ $student->father_qualification_other }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.wedding_date')}}</td>
                        <td> {{ $student->father_wedding_date }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.interests')}}</td>
                        <td> {{ $student->father_interests }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitudes_towards_father')}}</td>
                        <td> {{ $student->father_attitudes_towards_parent }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.created_by')}}</td>
                        <td> {{ $student->father_created_by }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- mother --}}
<div class="tab-pane fade" id="v-pills-mother" role="tabpanel" aria-labelledby="v-pills-mother-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.mother')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            @if ($student->mother_image !== null)
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='{{ asset("uploads/$student->mother_image") }}' alt="{{ $student->mother_name }}">
                            @else
                            <span>{{ ucfirst( $student->mother_name[0] ) }}</span>
                            @endif
                        </div>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_name')}}</td>
                        <td>{{ $student->mother_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_dob')}}</td>
                        <td>{{ $student->mother_dob }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_nationality')}}</td>
                        <td>{{ $student->mother_nationality }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_national_number')}}</td>
                        <td>{{ $student->mother_national_number }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_degree_of_kinship')}}</td>
                        <td>{{ $student->mother_degree_of_kinship }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.address')}}</td>
                        <td>{{ $student->mother_address }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.city')}}</td>
                        <td>{{ $student->mother_city }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.state')}}</td>
                        <td>{{ $student->mother_state }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.country')}}</td>
                        <td>{{ $student->mother_country }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.landmark')}}</td>
                        <td>{{ $student->mother_landmark }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_job')}}</td>
                        <td>{{ $student->mother_job }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.marital_status')}}</td>
                        <td>{{ $student->mother_marital_status }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_phone')}}</td>
                        <td>{{ $student->mother_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_alternative_phone')}}</td>
                        <td>{{ $student->mother_alternative_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_email')}}</td>
                        <td>{{ $student->mother_email }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.facebook_link')}}</td>
                        <td><a href=" {{ $student->mother_fb_link }}"> {{ $student->mother_fb_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.twitter_link')}}</td>
                        <td><a href=" {{ $student->mother_twitter_link }}"> {{ $student->mother_twitter_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link')}}</td>
                        <td><a href=" {{ $student->mother_social_media_1 }}"> {{ $student->mother_social_media_1 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link_2')}}</td>
                        <td><a href=" {{ $student->mother_social_media_2 }}"> {{ $student->mother_social_media_2 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_qualification')}}</td>
                        <td> {{ $student->mother_qualification }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.other_qualification')}}</td>
                        <td> {{ $student->mother_qualification_other }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.wedding_date')}}</td>
                        <td> {{ $student->mother_wedding_date }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.interests')}}</td>
                        <td> {{ $student->mother_interests }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitudes_towards_mother')}}</td>
                        <td> {{ $student->mother_attitudes_towards_parent }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.created_by')}}</td>
                        <td> {{ $student->mother_created_by }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
{{-- superior --}}
@if($student->superior =='Yes')
<div class="tab-pane fade" id="v-pills-superior" role="tabpanel" aria-labelledby="v-pills-superior-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.superior')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            @if ($student->superior_image !== null)
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='{{ asset("uploads/$student->superior_image") }}' alt="{{ $student->superior_name }}">
                            @else
                            @if($student->superior_name !==null)
                            <span >{{ ucfirst( $student->superior_name[0] ) }}</span>
                            @endif
                            @endif
                        </div>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_name')}}</td>
                        <td>{{ $student->superior_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_dob')}}</td>
                        <td>{{ $student->superior_dob }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_nationality')}}</td>
                        <td>{{ $student->superior_nationality }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_national_number')}}</td>
                        <td>{{ $student->superior_national_number }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_degree_of_kinship')}}</td>
                        <td>{{ $student->superior_degree_of_kinship }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.address')}}</td>
                        <td>{{ $student->superior_address }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.city')}}</td>
                        <td>{{ $student->superior_city }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.state')}}</td>
                        <td>{{ $student->superior_state }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.country')}}</td>
                        <td>{{ $student->superior_country }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.landmark')}}</td>
                        <td>{{ $student->superior_landmark }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_dob')}}</td>
                        <td>{{ $student->superior_job }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.marital_status')}}</td>
                        <td>{{ $student->superior_marital_status }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_phone')}}</td>
                        <td>{{ $student->superior_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_alternative_phone')}}</td>
                        <td>{{ $student->superior_alternative_phone }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_email')}}</td>
                        <td>{{ $student->superior_email }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.facebook_link')}}</td>
                        <td><a href=" {{ $student->superior_fb_link }}"> {{ $student->superior_fb_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.twitter_link')}}</td>
                        <td><a href=" {{ $student->superior_twitter_link }}"> {{ $student->superior_twitter_link }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link')}}</td>
                        <td><a href=" {{ $student->superior_social_media_1 }}"> {{ $student->superior_social_media_1 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link_2')}}</td>
                        <td><a href=" {{ $student->superior_social_media_2 }}"> {{ $student->superior_social_media_2 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.parent_qualification')}}</td>
                        <td> {{ $student->superior_qualification }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.other_qualification')}}</td>
                        <td> {{ $student->superior_qualification_other }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.wedding_date')}}</td>
                        <td> {{ $student->superior_wedding_date }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.interests')}}</td>
                        <td> {{ $student->superior_interests }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitudes_towards_superior')}}</td>
                        <td> {{ $student->superior_attitudes_towards_parent }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.created_by')}}</td>
                        <td> {{ $student->superior_created_by }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif
{{-- main complaint --}}
<div class="tab-pane fade" id="v-pills-main-complaint" role="tabpanel" aria-labelledby="v-pills-main-complaint-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.main_problem')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.main_problem')}}</td>
                        <td>{{ $student->main_complaint }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.feeling_problem_date')}}</td>
                        <td>{{ $student->problem_start_at }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.time_of_increasing_problem_feeling')}}</td>
                        <td>{{ $student->time_of_increasing_problem_feeling }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.time_of_decreasing_problem_feeling')}}</td>
                        <td>{{ $student->time_of_decreasing_problem_feeling }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.problem_as_child_sideview')}}</td>
                        <td>{{ $student->problem_as_child_view }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.problem_as_father_sideview')}}</td>
                        <td>{{ $student->problem_as_father_view }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.problem_as_mother_sideview')}}</td>
                        <td>{{ $student->problem_as_mother_view }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.problem_reasons')}}</td>
                        <td>{{ $student->problem_reasons }}</td>
                    </tr>

                </tbody>
            </table>
            {{-- student diseases --}}
            <h4>{{__('students.student_diseases')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.disease')}}</th>
                    <th>{{__('students.age_at_inJury')}}</th>
                    <th>{{__('students.disease_duration')}}</th>
                    <th>{{__('students.disease_strength')}}</th>
                </thead>
                <tbody>
                    @if($student->student_diseases != null)
                    @foreach ( json_decode($student->student_diseases) as $student_diseases )
                    <tr>
                        <td>{{ $student_diseases->disease }}</td>
                        <td>{{ $student_diseases->age_at_injury }}</td>
                        <td>{{ $student_diseases->disease_duration }}</td>
                        <td>{{ $student_diseases->disease_degree }}</td>
                    </tr>


                    @endforeach

                    @endif

                </tbody>
            </table>
            {{-- previous treatment efforts --}}
            <h4>{{__('students.previous_treatment_efforts')}}previous treatment efforts</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.medical_institution')}}</th>
                    <th>{{__('students.provided_service')}}</th>
                    <th>{{__('students.provided_service_effects')}}</th>
                </thead>
                <tbody>
                    @if($student->previous_treatment_efforts != null)
                    @foreach ( json_decode($student->previous_treatment_efforts) as $previousTreatmentOfforts )
                    <tr>
                        <td>{{ $previousTreatmentOfforts->medical_institution }}</td>
                        <td>{{ $previousTreatmentOfforts->provided_service }}</td>
                        <td>{{ $previousTreatmentOfforts->provided_service_effects }}</td>
                    </tr>


                    @endforeach

                    @endif
                </tbody>
            </table>

            {{-- genetic diseases --}}
            <h4>{{__('students.genetic_diseases')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.name')}}</th>
                    <th>{{__('students.age_at_inJury')}}</th>
                    <th>{{__('students.degree_of_kinship')}}</th>
                    <th>{{__('students.disease')}}</th>
                </thead>
                <tbody>

                    @if($student->genetic_diseases != null)
                    @foreach ( json_decode($student->genetic_diseases) as $genetic_diseases )
                    <tr>
                        <td>{{ $genetic_diseases->name }}</td>
                        <td>{{ $genetic_diseases->age_at_injury }}</td>
                        <td>{{ $genetic_diseases->degree_of_kinship }}</td>
                        <td>{{ $genetic_diseases->disease }}</td>
                    </tr>
                    @endforeach

                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Family History --}}
<div class="tab-pane fade" id="v-pills-family-history" role="tabpanel" aria-labelledby="v-pills-family-history-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.family_history')}}Family History
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.father')}} {{__('students.age_on_applying')}}</td>
                        <td>{{ $student->father_age_when_applying }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.father')}} {{__('students.age_on_student_birth')}}</td>
                        <td>{{ $student->father_age_at_student_birth }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.father')}} {{__('students.relation_with_child')}}</td>
                        <td>{{ $student->father_relation_with_child }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitudes_towards_father')}}</td>
                        <td>{{ $student->child_attitudes_towards_father }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.mother')}} {{__('students.age_on_applying')}}</td>
                        <td>{{ $student->mother_age_when_applying }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.mother')}} {{__('students.age_on_student_birth')}}</td>
                        <td>{{ $student->mother_age_at_student_birth }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.mother')}} {{__('students.relation_with_child')}}</td>
                        <td>{{ $student->mother_relation_with_child }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitudes_towards_mother')}}</td>
                        <td>{{ $student->child_attitudes_towards_mother }}</td>
                    </tr>

                </tbody>
            </table>
            {{-- relation between parents --}}
            <h4 class="mb-3">{{__('students.relation_between_parents')}}</h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.relation_between_parents')}}</td>
                        <td>{{ $student->relation_between_parents }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.main_problems_between_parents')}}</td>
                        <td>{{ $student->main_problems_between_parents }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_attitude_towards_family_problems')}}</td>
                        <td>{{ $student->child_attitude_towards_family_problems }}</td>
                    </tr>

                </tbody>
            </table>
            {{-- brothers and sisters --}}
            <h4 class="mb-3">{{__('students.brothers_and_sisters')}}</h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <thead>
                    <th>{{__('students.name')}}</th>
                    <th>{{__('students.dob')}}</th>
                    <th>{{__('students.gender')}}</th>
                    <th>{{__('students.job')}}</th>
                    <th>{{__('students.status')}}</th>
                    <th>{{__('students.education_level')}}</th>
                    <th>{{__('students.relation_with_student')}}</th>
                    <th>{{__('students.student_relation')}}</th>
                </thead>
                <tbody>


                    @if( $student->brothers_and_sisters != null )
                    @foreach ( json_decode($student->brothers_and_sisters) as $brothersAndSisters )
                    <tr>
                        <td>{{$brothersAndSisters->name}}</td>
                        <td>{{$brothersAndSisters->dob}}</td>
                        <td>{{$brothersAndSisters->gender}}</td>
                        <td>{{$brothersAndSisters->job}}</td>
                        <td>{{$brothersAndSisters->status}}</td>
                        <td>{{$brothersAndSisters->education_level}}</td>
                        <td>{{$brothersAndSisters->relation_with_student}}</td>
                        <td>{{$brothersAndSisters->student_relation}}</td>
                    </tr>
                    @endforeach


                    @endif
                    <tr>
                        <td colspan="3">{{__('students.brothers_and_sisters_notes')}}</td>
                        <td colspan="5">{{ $student->brothers_and_sisters_notes }}</td>
                    </tr>
                </tbody>
            </table>
            {{-- are relatives--}}
            @if($student->are_relatives == 'Yes')
            <h4 class="mb-3">{{__('students.are_relatives')}}</h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <thead>
                    <th>{{__('students.name')}}</th>
                    <th>{{__('students.dob')}}</th>
                    <th>{{__('students.relationship')}}</th>
                    <th>{{__('students.education_level')}}</th>
                    <th>{{__('students.relation_with_student')}}</th>
                    <th>{{__('students.student_relation')}}</th>
                </thead>
                <tbody>


                    @if( $student->other_relatives != null )
                    @foreach ( json_decode($student->other_relatives) as $otherRelatives )
                    <tr>
                        <td>{{$otherRelatives->name}}</td>
                        <td>{{$otherRelatives->dob}}</td>
                        <td>{{$otherRelatives->relationship}}</td>
                        <td>{{$otherRelatives->education_level}}</td>
                        <td>{{$otherRelatives->relation_with_student}}</td>
                        <td>{{$otherRelatives->student_relation}}</td>
                    </tr>
                    @endforeach


                    @endif
                    <tr>
                        <td colspan="3">{{__('students.other_relatives_notes')}}</td>
                        <td colspan="5">{{ $student->other_relatives_notes }}</td>
                    </tr>
                </tbody>
            </table>

            @endif
        </div>
    </div>
</div>

{{-- economic situation --}}
<div class="tab-pane fade" id="v-pills-economic_situation" role="tabpanel" aria-labelledby="v-pills-economic_situation-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.economic_situation')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>


                    <tr>
                        <td>{{__('students.economic_situation')}}</td>
                        <td>{{ $student->economic_situation }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.monthly_average_income')}}</td>
                        <td>{{ $student->monthly_average_income }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.monthly_average_expenses')}}</td>
                        <td>{{ $student->monthly_average_expenses }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.family_economic_problems')}}</td>
                        <td>{{ $student->family_economic_problems }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.family_child_acceptance')}}</td>
                        <td>{{ $student->family_child_acceptance }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.home_type')}}</td>
                        <td>{{ $student->home_type }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.number_persons_in_room')}}</td>
                        <td>{{ $student->no_persons_in_room }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.has_child_individual_room')}}</td>
                        <td>{{ $student->has_child_individual_room }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.number_father_married')}}</td>
                        <td>{{ $student->no_father_married }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.number_mother_married')}}</td>
                        <td>{{ $student->no_mother_married }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.family_divorce_cases')}}</td>
                        <td>{{ $student->family_divorce_cases }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.family_stress_source')}}</td>
                        <td>{{ $student->family_stress_source }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.family_entertainment_source')}}</td>
                        <td>{{ $student->family_entertainment_source }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_interacting_with_family_entertainment_source')}}</td>
                        <td>{{ $student->family_entertainment_source_child_involve }}</td>
                    </tr>
                </tbody>
            </table>

        </div>
    </div>
</div>

{{-- Organic Growth History --}}
<div class="tab-pane fade" id="v-pills-organic-growth-history" role="tabpanel" aria-labelledby="v-pills-organic-growth-history-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.organic_growth_history')}}
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>


                    <tr>
                        <td>{{__('students.mother_diseases_during_pregnancy')}}</td>
                        <td>{{ $student->mother_diseases_during_pregnancy }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.mother_pregnancy_type')}}</td>
                        <td>{{ $student->mother_pregnancy_type }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.disturbances_during_child_birth')}}</td>
                        <td>{{ $student->disturbances_during_childbirth }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.mother_pregnancy_injuries')}}</td>
                        <td>{{ $student->mother_pregnancy_injuries }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_weight_at_birth')}}</td>
                        <td>{{ $student->child_weight_at_birth }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.breastfeeding_type')}}</td>
                        <td>{{ $student->breastfeeding_type }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.breastfeeding_type_note')}}</td>
                        <td>{{ $student->breastfeeding_type_note }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_weaning')}}</td>
                        <td>{{ $student->child_age_on_weaning }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.weaning_problems')}}</td>
                        <td>{{ $student->weaning_problems }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_first_tooth')}}</td>
                        <td>{{ $student->child_age_on_first_tooth }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_sitting')}}</td>
                        <td>{{ $student->child_age_on_sitting }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_crawls')}}</td>
                        <td>{{ $student->child_age_on_crawls }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_stand_up')}}</td>
                        <td>{{ $student->child_age_on_stand_up }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_walking')}}</td>
                        <td>{{ $student->child_age_on_walking }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_first_word')}}</td>
                        <td>{{ $student->child_age_on_first_word }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_open_door')}}</td>
                        <td>{{ $student->child_age_on_open_door }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_use_spoon')}}</td>
                        <td>{{ $student->child_age_on_use_spoon }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.child_age_on_adjust_output_process')}}</td>
                        <td>{{ $student->child_age_on_adjust_output_process }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.does_health_problems')}}</td>
                        <td>{{ $student->does_health_problems }}</td>
                    </tr>
                    @if($student->current_health_problems != null)
                    <tr>

                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th></th>
                                    <th>{{__('students.current_health_problems')}}</th>
                                </thead>
                                <tbody>
                                    @foreach ( json_decode($student->current_health_problems) as $currentproblems )
                                    <tr>
                                        <td>{{ $loop->index }}</td>
                                        <td>{{$currentproblems}}</td>
                                    </tr>


                                    @endforeach
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    @endif

                    @if( $student->does_regularly_medicines != null )

                    <tr>
                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th>{{__('students.medicine_name')}}</th>
                                    <th>{{__('students.medicine_dose')}}</th>
                                </thead>
                                <tbody>
                                    @foreach ( json_decode($student->regularly_medicines) as $regularlymedicines )
                                    <tr>
                                        <td>{{$regularlymedicines->medicine}}</td>
                                        <td>{{$regularlymedicines->dose}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </td>

                    </tr>
                    @endif


                    @if( $student->does_complex_disabilities != null )
                    <tr>
                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th>{{__('students.does_complex_disabilities')}}</th>

                                </thead>
                                <tbody>
                                    @foreach ( json_decode($student->does_complex_disabilities) as $complexDisabilities )
                                    <tr>
                                        <td>{{$complexDisabilities}}</td>
                                    </tr>

                                    @endforeach
                                </tbody>
                            </table>
                        </td>
                    </tr>


                    @endif


                    <tr>
                        <td>{{__('students.other_complex_disabilities')}}</td>
                        <td>{{ $student->complex_disabilities_other }}</td>
                    </tr>

                    @if( $student->does_prosthetic_devices =='Yes' )
                    @foreach ( json_decode($student->prosthetic_devices) as $prostheticdevices )
                    <tr>
                        <td>{{__('students.prosthetic_devices')}}</td>
                        <td>{{$prostheticdevices}}</td>


                    </tr>

                    @endforeach


                    @endif

                </tbody>
            </table>

        </div>
    </div>
</div>

{{-- Psychological and behavioral side --}}
<div class="tab-pane fade" id="v-pills-psychological-and-behavioral-side" role="tabpanel" aria-labelledby="v-pills-psychological-and-behavioral-side-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                Psychological and behavioral side
            </div>
        </div>
        <div class="panel-body p-3">
            <!-- The child's relationship with people -->
            <h4>{{__('students.child_relationship_with_people')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th>{{__('students.result')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.personality_traits')}}</td>
                        <td>{{ $student->personality_traits }}</td>
                    </tr>
                    {{-- <tr>
                        <td>{{__('students.prosthetic_devices')}}personality traits details</td>
                        <td>{{ $student->personality_traits_details }}</td>
                    </tr> --}}
                    <tr>
                        <td>{{__('students.relation_with_friends')}}</td>
                        <td>{{ $student->relation_with_friends }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.relation_with_relatives')}}</td>
                        <td>{{ $student->relation_with_relatives }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.relation_with_neighbour')}}</td>
                        <td>{{ $student->relation_with_neighbour }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.relation_with_other_gender')}}</td>
                        <td>{{ $student->relation_with_other_gender }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- upbringing style -->
            <h4>{{__('students.prosthetic_devices')}}{{__('students.relation_with_other_gender')}}upbringing style</h4>
            <table class="table  user-table mb-4  table-bordered">
                <tr>
                    <td>{{__('students.upbringing_style')}}</td>
                    <td>{{ $student->upbringing_style }}</td>
                </tr>
            </table>

            <!-- reinforcements -->
            <h4>{{__('students.upbringing_style')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>#</th>
                    <th>{{__('students.reinforcements')}}</th>

                </thead>
                <tbody>
                    @if($student->reinforcements != null)

                    @foreach ( json_decode($student->reinforcements) as $reinforcement )
                    <tr>
                        <td>{{ ($loop->index)+1 }}</td>
                        <td>{{ $reinforcement }}</td>

                    </tr>
                    @endforeach

                    @endif
                </tbody>
            </table>

            <!-- is punishment -->
            <h4>{{__('students.reinforcements')}}</h4>
            <table class="table  user-table mb-4  table-bordered">
                <tr>
                    <td>{{__('students.is_punishment')}}</td>
                    <td>{{ $student->is_punishment }}</td>
                </tr>
                @if($student->is_punishment=='Yes')

                <tr>
                    <td>{{__('students.child_behavior_notes')}}</td>
                    <td>{{ $student->child_behavior_notes }}</td>
                </tr>
                <tr>
                    <td>{{__('students.source_of_authority')}}</td>
                    <td>{{ $student->source_of_authority }}</td>
                </tr>
                <tr>
                    <td>{{__('students.source_of_authority_notes')}}</td>
                    <td>{{ $student->source_of_authority_notes }}</td>
                </tr>

                @endif
            </table>

            <!--  Child behavior -->
            <h4>{{__('students.child_behavior')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th>{{__('students.result')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.crying')}}</td>
                        <td>{{ $student->crying }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.talkative')}}</td>
                        <td>{{ $student->talkative }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.lots_of_movement')}}</td>
                        <td>{{ $student->lots_of_movement }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.orderly_plan')}}</td>
                        <td>{{ $student->orderly_plan }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.damages')}}</td>
                        <td>{{ $student->damages }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.find_around_place')}}</td>
                        <td>{{ $student->find_around_place }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.grieves_with_specialist')}}</td>
                        <td>{{ $student->grieves_with_specialist }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.afraid')}}</td>
                        <td>{{ $student->afraid }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.enjoys')}}</td>
                        <td>{{ $student->enjoys }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.runs_randomly')}}</td>
                        <td>{{ $student->runs_randomly }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Neurological and behavioral symptoms -->
            <h4>{{__('students.the_main_neurological_and_behavioral_symptoms')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.behavior')}}</th>
                    <th>{{__('students.result')}}</th>
                    <th>{{__('students.time')}}</th>
                    <th>{{__('students.degree')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.outbursts_of_anger')}}</td>
                        <td>{{ $student->outbursts_of_anger }}</td>
                        <td>{{ $student->outbursts_of_anger_time }}</td>
                        <td>{{ $student->outbursts_of_anger_degree }}</td>
                    </tr>


                    <tr>
                        <td>{{__('students.finger_sucking')}}</td>
                        <td>{{ $student->finger_sucking }}</td>
                        <td>{{ $student->finger_sucking_time }}</td>
                        <td>{{ $student->finger_sucking_degree }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.wetting_bed')}}</td>
                        <td>{{ $student->wetting_bed }}</td>
                        <td>{{ $student->wetting_bed_time }}</td>
                        <td>{{ $student->wetting_bed_degree }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.night_screams_of_terror')}}</td>
                        <td>{{ $student->night_screams_of_terror }}</td>
                        <td>{{ $student->night_screams_of_terror_time }}</td>
                        <td>{{ $student->night_screams_of_terror_degree }}</td>
                    </tr>


                    <tr>
                        <td>{{__('students.sleep_walking')}}</td>
                        <td>{{ $student->sleep_walking }}</td>
                        <td>{{ $student->sleep_walking_time }}</td>
                        <td>{{ $student->sleep_walking_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.excessive_fears')}}</td>
                        <td>{{ $student->excessive_fears }}</td>
                        <td>{{ $student->excessive_fears_time }}</td>
                        <td>{{ $student->excessive_fears_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.nervous_crises')}}</td>
                        <td>{{ $student->nervous_crises }}</td>
                        <td>{{ $student->nervous_crises_time }}</td>
                        <td>{{ $student->nervous_crises_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.cramps')}}</td>
                        <td>{{ $student->cramps }}</td>
                        <td>{{ $student->cramps_time }}</td>
                        <td>{{ $student->cramps_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.biting_nails')}}</td>
                        <td>{{ $student->biting_nails }}</td>
                        <td>{{ $student->biting_nails_time }}</td>
                        <td>{{ $student->biting_nails_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.smash_clothes')}}</td>
                        <td>{{ $student->smash_clothes }}</td>
                        <td>{{ $student->smash_clothes_time }}</td>
                        <td>{{ $student->smash_clothes_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.stereotyped_movements')}}</td>
                        <td>{{ $student->stereotyped_movements }}</td>
                        <td>{{ $student->stereotyped_movements_time }}</td>
                        <td>{{ $student->stereotyped_movements_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.baby_gets_nervous_from_loud_noises')}}</td>
                        <td>{{ $student->baby_gets_nervous_from_loud_noises }}</td>
                        <td>{{ $student->baby_gets_nervous_from_loud_noises_time }}</td>
                        <td>{{ $student->baby_gets_nervous_from_loud_noises_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.baby_gets_nervous_from_bright_lights')}}</td>
                        <td>{{ $student->baby_gets_nervous_from_bright_lights }}</td>
                        <td>{{ $student->baby_gets_nervous_from_bright_lights_time }}</td>
                        <td>{{ $student->baby_gets_nervous_from_bright_lights_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.sexual_behaviors')}}</td>
                        <td>{{ $student->sexual_behaviors }}</td>
                        <td>{{ $student->sexual_behaviors_time }}</td>
                        <td>{{ $student->sexual_behaviors_degree }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.epileptic_seizures')}}</td>
                        <td>{{ $student->epileptic_seizures }}</td>
                        <td>{{ $student->epileptic_seizures_time }}</td>
                        <td>{{ $student->epileptic_seizures_degree }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Child's social problems -->
            <h4>{{__('students.Childs_social_problems')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.behavior')}}</th>
                    <th>{{__('students.result')}}</th>
                    <th>{{__('students.description')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.difficulty_interacting_with_peers')}}</td>
                        <td>{{ $student->difficulty_interacting_with_peers }}</td>
                        <td>{{ $student->difficulty_interacting_with_peers_desc }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.extra_activity')}}</td>
                        <td>{{ $student->extra_activity }}</td>
                        <td>{{ $student->extra_activity_desc }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.make_fun_of_others')}}</td>
                        <td>{{ $student->make_fun_of_others }}</td>
                        <td>{{ $student->make_fun_of_others_desc }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.can_not_wait')}}</td>
                        <td>{{ $student->can_not_wait }}</td>
                        <td>{{ $student->can_not_wait_dec }}</td>
                    </tr>

                    <tr>
                        <td>{{__('students.curses_and_says_inappropriate_words')}}</td>
                        <td>{{ $student->curses_and_says_inappropriate_words }}</td>
                        <td>{{ $student->curses_and_says_inappropriate_words_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.acts_inappropriately')}}</td>
                        <td>{{ $student->acts_inappropriately }}</td>
                        <td>{{ $student->acts_inappropriately_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.very_shy')}}</td>
                        <td>{{ $student->very_shy }}</td>
                        <td>{{ $student->very_shy_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.speaks_low_voice')}}</td>
                        <td>{{ $student->speaks_low_voice }}</td>
                        <td>{{ $student->speaks_low_voice_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.not_defend_himself')}}</td>
                        <td>{{ $student->not_defend_himself }}</td>
                        <td>{{ $student->not_defend_himself_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.afraid_of_animals')}}</td>
                        <td>{{ $student->afraid_of_animals }}</td>
                        <td>{{ $student->afraid_of_animals_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.hesitant_and_confused')}}</td>
                        <td>{{ $student->hesitant_and_confused }}</td>
                        <td>{{ $student->hesitant_and_confused_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.feeling_powerless_and_lacking_in_self_confidence')}}</td>
                        <td>{{ $student->feeling_powerless_and_lacking_in_self_confidence }}</td>
                        <td>{{ $student->feeling_powerless_and_lacking_in_self_confidence_dec }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.feeling_tense_and_refuses_to_hug')}}</td>
                        <td>{{ $student->feeling_tense_and_refuses_to_hug }}</td>
                        <td>{{ $student->feeling_tense_and_refuses_to_hug_dec }}</td>
                    </tr>
                </tbody>
            </table>


            <!-- other social problems -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <tr>
                    <td>{{__('students.other_social_problems')}}</td>
                    <td>{{ $student->other_social_problems }}</td>
                </tr>
            </table>


            <table class="table  user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.last_psychological_examination_name')}}</td>
                        <td>{{ $student->last_psychological_examination_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.last_psychological_examination_date')}}</td>
                        <td>{{ $student->last_psychological_examination_date }}</td>
                    </tr>

                </tbody>
            </table>

            <!-- previous mental disorders -->
            <h4>{{__('students.previous_mental_disorders')}}</h4>
            <div class="table-responsive">
                <table class="table table-striped user-table mb-4  table-bordered">

                    <thead>
                        <th>N</th>
                        <th>{{__('students.name')}}</th>
                        <th>{{__('students.date')}}</th>
                        <th>{{__('students.reason')}}</th>
                        <th>{{__('students.who_recommended_it')}}</th>
                        <th>{{__('students.explan')}}</th>
                        <th>{{__('students.recommendations')}}</th>



                    </thead>
                    <tbody>
                        <tr>
                            <th>{{__('students.first')}}</th>
                            <td>{{ $student->first_intelligence_and_ability_test_name }}</td>
                            <td>{{ $student->first_intelligence_and_ability_test_date }}</td>
                            <td>{{ $student->first_intelligence_and_ability_test_reason }}</td>
                            <td>{{ $student->first_intelligence_and_ability_test_who_recommended_it }}</td>
                            <td>{{ $student->first_intelligence_and_ability_test_result }}</td>
                            <td>{{ $student->first_intelligence_and_ability_test_result }}</td>
                        </tr>

                        <tr>
                            <th>{{__('students.second')}}</th>
                            <td>{{ $student->second_intelligence_and_ability_test_name }}</td>
                            <td>{{ $student->second_intelligence_and_ability_test_date }}</td>
                            <td>{{ $student->second_intelligence_and_ability_test_reason }}</td>
                            <td>{{ $student->second_intelligence_and_ability_test_who_recommended_it }}</td>
                            <td>{{ $student->second_intelligence_and_ability_test_result }}</td>
                            <td>{{ $student->second_intelligence_and_ability_test_result }}</td>
                        </tr>
                        <tr>
                            <th>{{__('students.third')}}</th>
                            <td>{{ $student->third_intelligence_and_ability_test_name }}</td>
                            <td>{{ $student->third_intelligence_and_ability_test_date }}</td>
                            <td>{{ $student->third_intelligence_and_ability_test_reason }}</td>
                            <td>{{ $student->third_intelligence_and_ability_test_who_recommended_it }}</td>
                            <td>{{ $student->third_intelligence_and_ability_test_result }}</td>
                            <td>{{ $student->third_intelligence_and_ability_test_result }}</td>
                        </tr>
                        <tr>
                            <th>{{__('students.fourth')}}</th>
                            <td>{{ $student->fourth_intelligence_and_ability_test_name }}</td>
                            <td>{{ $student->fourth_intelligence_and_ability_test_date }}</td>
                            <td>{{ $student->fourth_intelligence_and_ability_test_reason }}</td>
                            <td>{{ $student->fourth_intelligence_and_ability_test_who_recommended_it }}</td>
                            <td>{{ $student->fourth_intelligence_and_ability_test_result }}</td>
                            <td>{{ $student->fourth_intelligence_and_ability_test_result }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Independent aspect -->
            <h4>{{__('students.independent_aspect')}}</h4>
            <table class="table table-striped user-table mb-4  table-bordered">

                <thead>
                    <th>{{__('students.behavior')}}</th>
                    <th>{{__('students.result')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.eats_alone_without_help')}}</td>
                        <td>{{ $student->eats_alone_without_help }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.gets_dressed_without_help')}}</td>
                        <td>{{ $student->gets_dressed_without_help }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.asking_to_go_to_the_bathroom')}}</td>
                        <td>{{ $student->asking_to_go_to_the_bathroom }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.takes_care_of_himself_in_bathroom')}}</td>
                        <td>{{ $student->takes_care_of_himself_in_bathroom }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Linguistic side --}}
<div class="tab-pane fade" id="v-pills-Linguistic-side" role="tabpanel" aria-labelledby="v-pills-Linguistic-side-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                {{__('students.linguistic_side')}}
            </div>
        </div>
        <div class="panel-body p-3">

            <!--     Linguistic side -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>{{__('students.behavior')}}</th>
                    <th>{{__('students.result')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.pay_attention_to_sounds')}}</td>
                        <td>{{ $student->pay_attention_to_sounds }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.distinguish_mother_and_father_voice')}}</td>
                        <td>{{ $student->distinguish_mother_and_father_voice }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.distinguish_family_members_voice')}}</td>
                        <td>{{ $student->distinguish_family_members_voice }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.using_audio_clips')}}</td>
                        <td>{{ $student->using_audio_clips }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.pronounces_word_understandable')}}</td>
                        <td>{{ $student->pronounces_word_understandable }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.turns_around_when_he_hears_his_name')}}</td>
                        <td>{{ $student->turns_around_when_he_hears_his_name }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.looking_the_person_speaking_during_conversation')}}</td>
                        <td>{{ $student->looking_the_person_speaking_during_conversation }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.uses_two_words_sentence')}}</td>
                        <td>{{ $student->uses_two_words_sentence }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.needs_encouragement_to_speak')}}</td>
                        <td>{{ $student->needs_encouragement_to_speak }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.uses_expressive_language_to_express_his_needs')}}</td>
                        <td>{{ $student->uses_expressive_language_to_express_his_needs }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.stutters_while_speaking')}}</td>
                        <td>{{ $student->stutters_while_speaking }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.remove_letters_from_words')}}</td>
                        <td>{{ $student->remove_letters_from_words }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.add_letters_to_words')}}</td>
                        <td>{{ $student->add_letters_to_words }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.turns_some_letters_in_word')}}</td>
                        <td>{{ $student->turns_some_letters_in_word }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.changes_some_letters_when_saying_word')}}</td>
                        <td>{{ $student->changes_some_letters_when_saying_word }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.speaks_but_the_words_are_distorted_and_incomprehensible')}}</td>
                        <td>{{ $student->speaks_but_the_words_are_distorted_and_incomprehensible }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.understands_what_is_asked_of_him')}}</td>
                        <td>{{ $student->understands_what_is_asked_of_him }}</td>
                    </tr>

                </tbody>
            </table>
            <!-- Child linguistic problems -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th>{{__('students.result')}}</th>
                </thead>
                <tbody>
                    <tr>
                        <td>{{__('students.language_level')}}</td>
                        <td>{{ $student->language_level }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.level_of_expression_of_his_needs_linguistically')}}</td>
                        <td>{{ $student->level_of_expression_of_his_needs_linguistically }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.level_of_coherence_of_ideas')}}</td>
                        <td>{{ $student->level_of_coherence_of_ideas }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.speed_level')}}</td>
                        <td>{{ $student->speed_level }}</td>
                    </tr>
                    <tr>
                        <td>{{__('students.response')}}</td>
                        <td>{{ $student->response }}</td>
                    </tr>

                </tbody>
            </table>

        </div>
    </div>
</div>


{{-- Student Social Media --}}
<div class="tab-pane fade" id="v-pills-student-social-media" role="tabpanel" aria-labelledby="v-pills-student-social-media-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">{{__('students.social_links')}}</div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>{{__('students.facebook_link')}}k</td>
                        <td><a class="text-decoration-none" href="{{ $student->fb_link }}">{{ $student->fb_link }}</a>
                        </td>
                    </tr>
                    <tr>
                        <td>{{__('students.twitter_link')}}r</td>
                        <td>
                            <a class="text-decoration-none" href="{{ $student->twitter_link }}">
                                {{ $student->twitter_link }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link')}}</td>
                        <td><a class="text-decoration-none" href="{{ $student->social_media_1 }}">{{ $student->social_media_1 }}</a></td>
                    </tr>
                    <tr>
                        <td>{{__('students.social_media_link_2')}}</td>
                        <td><a class="text-decoration-none" href="{{ $student->social_media_2 }}">{{ $student->social_media_2 }}</a></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script>
    var superior = {!! json_encode($student->superior) !!};
</script>

<script src="{{ asset('js/print.js') }}"></script>
@endsection