@extends('layouts.app_layout')

@section('title')
Searched Submissions
@endsection

@section('content')

@if(session('message'))
    <h6 class="alert alert-success">
        {{ session('message') }}
    </h6>
@endif


<table id="example" class="table table-striped cell-border" style="width:100%">
    <thead>
      <tr>
        <th scope="col">Student Name</th>
        <th scope="col">submission Title</th>
        <th scope="col">Businss location</th>
        <th scope="col">Trainer</th>
        <th scope="col">Actions</th>
      </tr>
    </thead>
    <tbody>
        @foreach ($submissions as $submission)
      <tr>
        <td>
          <a href="{{route('viewStudent' , $submission->student_id )}}"><p>{{ $submission->student->student_name }}</p></a>
      </td>
      <td>
          <a href="{{route('viewAssignment' , $submission->assignment_id )}}"><p>111111{{ $submission->assignment->assignment_title }}</p></a>
      </td>
      <td>
          <a href="{{route('viewTrainer' , $submission->trainer_id )}}"><p>{{ $submission->trainer->full_name }}</p></a>
      </td>
      <td>
          <a href="{{route('viewBusinessLocation' , $submission->business_id )}}"><p>{{ $submission->businessLocation->business_name }}</p></a>
      </td>
      <td>
          <a href="{{ route('viewSubmission' , $submission->id ) }}" class="btn btn-outline-primary mt-3">View</a>
          <a href="{{ route('editSubmission' , $submission->id ) }}" class="btn btn-outline-primary mt-3">Edit</a>
          <a href="{{ route('deleteSubmission' , $submission->id) }}" class="btn btn-outline-primary mt-3">Delete</a>
      </td>
      </tr>

      @endforeach
      
    </tbody>
</table>

{{ $submissions->links() }}



@endsection


