@extends('layouts.app_layout')

@section('title')
Add Superior
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('storeSuperior') }}" enctype="multipart/form-data">
    @csrf
    <h2>Add Superior</h2>
    <div class="form-group">
      <label for="superior_name">Full Name</label>
      <input type="text" class="form-control" id="superior_name" aria-describedby="nameHelp" placeholder="Father Full Name" name="superior_name" value="{{old('superior_name')}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="superior_email">Email</label>
      <input type="text" class="form-control" id="superior_email" aria-describedby="superior_email" placeholder="Email" name="superior_email" value="{{old('superior_email')}}" required>
      {{-- <small id="superior_email" class="form-text text-muted">Email will be used .</small> --}}
    </div>
    
    <hr>
    <h2>More Informations</h2>
    
    <div class="form-group">
        <label for="superior_address">Address</label>
        <input type="text" class="form-control" id="superior_address" placeholder="Address" name="superior_address" value="{{old('superior_address')}}">
    </div>

    <div class="form-group">
        <label for="superior_city">City</label>
        <input type="text" class="form-control" id="superior_city" placeholder="City" name="superior_city" value="{{old('superior_city')}}">
    </div>

    <div class="form-group">
        <label for="superior_state">State</label>
        <input type="text" class="form-control" id="superior_state" placeholder="State" name="superior_state" value="{{old('superior_state')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_country">Country</label>
        <input type="text" class="form-control" id="superior_country" placeholder="Country" name="superior_country" value="{{old('superior_country')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_landmark">Landmark</label>
        <input type="text" class="form-control" id="superior_landmark" placeholder="Landmark" name="superior_landmark" value="{{old('superior_landmark')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_phone">Phone</label>
        <input type="number" class="form-control" id="superior_phone" placeholder="Phone" name="superior_phone" value="{{old('superior_phone')}}">
    </div>

    <div class="form-group">
        <label for="superior_alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="superior_alternative_phone" placeholder="Alternative Phone Number" name="superior_alternative_phone" value="{{old('superior_alternative_phone')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_nationality">Nationality</label>
        <input type="text" class="form-control" id="superior_nationality" placeholder="Nationality" name="superior_nationality" value="{{old('superior_nationality')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_national_number">National Number</label>
        <input type="number" class="form-control" id="superior_national_number" placeholder="National Number" name="superior_national_number" value="{{old('superior_national_number')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_dob">Date Of Birth</label>
        <input type="date" class="form-control" id="superior_dob" placeholder="Date Of Birth" name="superior_dob" value="{{old('superior_dob')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_image">Upload Image</label>
        <input type="file" name="superior_image" id="superior_image" >
    </div>

    <div class="form-group">
        <label for="superior_gender">Gender</label>
        <select class="form-control" id="superior_gender" name="superior_gender">
            <option value="Male" {{ old('superior_gender') == "Male" ? 'selected' : '' }}>Male</option>
            <option value="Female" {{ old('superior_gender') == "Female" ? 'selected' : '' }}>Female</option>
        </select>
    </div>
        
    <div class="form-group">
        <label for="superior_job">Job</label>
        <input type="text" class="form-control" id="superior_job" placeholder="Job" name="superior_job" value="{{old('superior_job')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_degree_of_kinship">Degree Of Kinship</label>
        <input type="text" class="form-control" id="superior_degree_of_kinship" placeholder="Degree Of Kinship" name="superior_degree_of_kinship" value="{{old('superior_degree_of_kinship')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="superior_fb_link" placeholder="FaceBook Link" name="superior_fb_link" value="{{old('superior_fb_link')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="superior_twitter_link" placeholder="Twitter Link" name="superior_twitter_link" value="{{old('superior_twitter_link')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="superior_social_media_1" placeholder="Social Media Link" name="superior_social_media_1" value="{{old('superior_social_media_1')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="superior_social_media_2" placeholder="Social Media Link" name="superior_social_media_2" value="{{old('superior_social_media_2')}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="superior_qualification">Qualification</label>
        <select class="form-control" id="superior_qualification" name="superior_qualification">
            <option value="Bachelor" {{ old('superior_qualification') == "Bachelor" ? 'selected' : '' }}>Bachelor</option>
            <option value="Diploma" {{ old('superior_qualification') == "Diploma" ? 'selected' : '' }}>Diploma</option>
            <option value="Phd" {{ old('superior_qualification') == "Phd" ? 'selected' : '' }}>Phd</option>
            <option value="Other" {{ old('superior_qualification') == "Other" ? 'selected' : '' }}>Other</option>
        </select>
    </div>
    {{-- If other selected show the other qualification --}}
    <div class="form-group">
        <label for="superior_qualification_other">Other Qualification</label>
        <input type="text" class="form-control" id="superior_qualification_other" placeholder="Other Qualification" name="superior_qualification_other" value="{{old('superior_qualification_other')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_wedding_date">Wedding Date</label>
        <input type="date" class="form-control" id="superior_wedding_date" placeholder="Wedding Date" name="superior_wedding_date" value="{{old('superior_wedding_date')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_interests">Interests</label>
        <input type="text" class="form-control" id="superior_interests" placeholder="Interests" name="superior_interests" value="{{old('superior_interests')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_age_at_student_birth">Father Age At Student Birth</label>
        <input type="text" class="form-control" id="superior_age_at_student_birth" placeholder="Father Age At Student Birth" name="superior_age_at_student_birth" value="{{old('superior_age_at_student_birth')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_relation_with_child">Father Relation With Child</label>
        <input type="text" class="form-control" id="superior_relation_with_child" placeholder="Father Relation With Child" name="superior_relation_with_child" value="{{old('superior_relation_with_child')}}">
    </div>
    
    <div class="form-group">
        <label for="superior_attitudes_towards_parent">Student Attitudes Towards Parent</label>
        <input type="text" class="form-control" id="superior_attitudes_towards_parent" placeholder="Student Attitudes Towards Parent" name="superior_attitudes_towards_parent" value="{{old('superior_attitudes_towards_parent')}}">
    </div>
    

    {{-- If Gender Female has been selected --}}
    <div class="form-group">
        <label for="superior_pregnancy_number">Superior Pregnancy Number</label>
        <input type="text" class="form-control" id="superior_pregnancy_number" placeholder="Superior Pregnancy Number" name="superior_pregnancy_number" value="{{old('superior_pregnancy_number')}}">
    </div>
    {{-- If Gender Female has been selected --}}
    <div class="form-group">
        <label for="superior_miscarriages_number">Superior Miscarriages Number</label>
        <input type="text" class="form-control" id="superior_miscarriages_number" placeholder="Superior Miscarriages Number" name="superior_miscarriages_number" value="{{old('superior_miscarriages_number')}}">
    </div>
    
    
    <button type="submit" class="btn btn-outline-primary mt-3">Submit</button>
</form>


<a href="{{ route('allMothers') }}" class="btn btn-info mt-3">Back To All Mothers</a>


@endsection