@extends('layouts.view')

@section('title')
    View Superior
@endsection

@section('view-title')
    View Superior - {{ $student_superior_profile->superior_name }}
@endsection

@section('view-navigation')
    <li><a class="text-decoration-none" href="{{ route('allSuperiors') }}">List Superiors </a></li>
    <li>View Superior</li>
@endsection

@section('view-panel')
    <div class="user-avtar">
        @if ($student_superior_profile->superior_image !== null)
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='{{ asset("uploads/$student_superior_profile->superior_image") }}'
                alt="{{ $student_superior_profile->superior_name }}">
        @else
            <span>{{ ucfirst($student_superior_profile->superior_name[0]) }}</span>
        @endif
    </div>
    <div class="user-details text-center pt-3">
        <h3>{{ $student_superior_profile->superior_name }}</h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="v-pills-superior-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-superior-info" type="button" role="tab" aria-controls="v-pills-superior-info"
                aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>Superior Info</span>
            </button>
            <button class="nav-link" id="v-pills-superior-address-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-superior-address" type="button" role="tab" aria-controls="v-pills-superior-address"
                aria-selected="false"><i class="fa-solid fa-address-book"></i><span>Address Info</span></button>
            <button class="nav-link" id="v-pills-superior-social-media-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-superior-social-media" type="button" role="tab"
                aria-controls="v-pills-superior-social-media" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Social
                    Links</span></button>
            <button class="nav-link" id="v-pills-superior-children-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-superior-children" type="button" role="tab"
                aria-controls="v-pills-superior-children" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Superior Childrens</span></button>
            <a class="nav-link" type="button" role="tab" aria-selected="false"
                href="{{ route('editSuperior', $student_superior_profile->id) }}"><i
                    class="fa-solid fa-user-pen"></i><span>Edit
                    Superior</span></a>
            {{-- <button class="nav-link" id="v-pills-user-documents-tab" data-bs-toggle="pill" data-bs-target="#v-pills-user-documents" type="button" role="tab" aria-controls="v-pills-user-documents" aria-selected="false"><i class="fa-solid fa-envelope"></i><span>Send Email</span></button> --}}
            <button class="nav-link" id="v-pills-superior-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-superior-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-superior-sendwhatsapp" aria-selected="false"><i class="fa-solid fa-envelope"></i>
                <span>Send WhatsApp</span></button>
        </div>
    </div>
@endsection


@section('view-tabs')
    {{-- Superior Info --}}
    <div class="tab-pane fade show active" id="v-pills-superior-info" role="tabpanel"
        aria-labelledby="v-pills-superior-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Superior Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Superior Name</td>
                            <td>{{ $student_superior_profile->superior_name }}</td>
                        </tr>
                        <tr>
                            <td>Email Address</td>
                            <td>{{ $student_superior_profile->superior_email }}</td>
                        </tr>
                        <tr>
                            <td>Mobile Number</td>
                            <td>{{ $student_superior_profile->superior_phone }}</td>
                        </tr>
                        <tr>
                            <td>Alternative Mobile Number</td>
                            <td>{{ $student_superior_profile->superior_alternative_phone }}</td>
                        </tr>
                        <tr>
                            <td>Date of Birth</td>
                            <td>{{ $student_superior_profile->superior_dob }}</td>
                        </tr>
                        <tr>
                            <td>Gender</td>
                            <td>{{ $student_superior_profile->superior_gender }}</td>
                        </tr>
                        <tr>
                            <td>Nationality</td>
                            <td>{{ $student_superior_profile->superior_nationality }}</td>
                        </tr>
                        <tr>
                            <td>National Number</td>
                            <td>{{ $student_superior_profile->superior_national_number }}</td>
                        </tr>
                        <tr>
                            <td>Marital Status</td>
                            <td>{{ $student_superior_profile->superior_marital_status }}</td>
                        </tr>
                        <tr>
                            <td>Created By</td>
                            <td><a class="text-decoration-none"
                                    href="{{ route('viewUser', $student_superior_profile->superior_created_by) }}">{{ $student_superior_profile->createdPerson->full_name }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>Created Date</td>
                            <td>{{ $student_superior_profile->created_at }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Superior Address --}}
    <div class="tab-pane fade" id="v-pills-superior-address" role="tabpanel"
        aria-labelledby="v-pills-superior-address-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Superior Address</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Address</td>
                            <td>{{ $student_superior_profile->superior_address }}</td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td>{{ $student_superior_profile->superior_city }}</td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td>{{ $student_superior_profile->superior_state }}</td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td>{{ $student_superior_profile->superior_country }}</td>
                        </tr>
                        <tr>
                            <td>Landmark</td>
                            <td>{{ $student_superior_profile->superior_landmark }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Superior Social Media --}}
    <div class="tab-pane fade" id="v-pills-superior-social-media" role="tabpanel"
        aria-labelledby="v-pills-superior-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Superior Social Media</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>FaceBook</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $student_superior_profile->superior_fb_link }}">{{ $student_superior_profile->superior_fb_link }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>Twitter</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $student_superior_profile->superior_twitter_link }}">{{ $student_superior_profile->superior_twitter_link }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $student_superior_profile->superior_social_media_1 }}">{{ $student_superior_profile->superior_social_media_1 }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $student_superior_profile->superior_social_media_2 }}">{{ $student_superior_profile->superior_social_media_2 }}</a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Send Email --}}

    {{-- Send Whatsapp to Superior --}}
    <div class="tab-pane fade" id="v-pills-superior-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-superior-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Send Whatsapp to Superior
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>To</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>Message</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "{{ $student_superior_profile->superior_phone }}";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>

    {{-- Superior Other Info --}}
    <div class="tab-pane fade" id="v-pills-superior-social-media" role="tabpanel"
        aria-labelledby="v-pills-superior-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Superior Other Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Superior Degree Of Kinship</td>
                            <td>{{ $student_superior_profile->superior_degree_of_kinship }}</td>
                        </tr>
                        <tr>
                            <td>Superior Job</td>
                            <td>{{ $student_superior_profile->superior_job }}</td>
                        </tr>
                        <tr>
                            <td>Superior Qualification</td>
                            <td>{{ $student_superior_profile->superior_qualification }}</td>
                        </tr>
                        <tr>
                            <td>Superior Qualification Other</td>
                            <td>{{ $student_superior_profile->superior_qualification_other }}</td>
                        </tr>
                        <tr>
                            <td>Superior Wedding Date</td>
                            <td>{{ $student_superior_profile->superior_wedding_date }}</td>
                        </tr>
                        <tr>
                            <td>Superior Interests</td>
                            <td>{{ $student_superior_profile->superior_interests }}</td>
                        </tr>
                        <tr>
                            <td>Superior Age At Student Birth</td>
                            <td>{{ $student_superior_profile->superior_age_at_student_birth }}</td>
                        </tr>
                        <tr>
                            <td>Superior Relation With Child</td>
                            <td>{{ $student_superior_profile->superior_relation_with_child }}</td>
                        </tr>
                        <tr>
                            <td>Superior Attitudes Towards Parent</td>
                            <td>{{ $student_superior_profile->superior_attitudes_towards_parent }}</td>
                        </tr>
                        <tr>
                            <td>Superior Pregnancy Number</td>
                            <td>{{ $student_superior_profile->superior_pregnancy_number }}</td>
                        </tr>
                        <tr>
                            <td>Superior Miscarriages Number</td>
                            <td>{{ $student_superior_profile->superior_miscarriages_number }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Superior His Children Data --}}
    <div class="tab-pane fade" id="v-pills-superior-children" role="tabpanel"
        aria-labelledby="v-pills-superior-children-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Superior Children Data</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <thead>
                        <tr>
                            <th scope="col">Student Image</th>
                            <th scope="col">Student Name</th>
                            <th scope="col">Student Phone</th>
                            <th scope="col">Student Gender</th>
                            <th scope="col">Student DOB</th>
                            <th scope="col">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($students as $student)
                            <tr>
                                <th scope="row">
                                    @if ($student->image !== null)
                                        <img class="image-fload" width="100px" height="100px"
                                            src='{{ asset("uploads/$student->image") }}'
                                            alt="{{ $student->student_name }}">
                                    @else
                                        No Student Image
                                    @endif
                                </th>
                                <td>
                                    <a class="text-decoration-none" href="{{ route('viewStudent', $student->id) }}">
                                        <p>{{ $student->student_name }}</p>
                                    </a>
                                </td>
                                <td>
                                    <p>{{ $student->phone }}</p>
                                </td>
                                <td>
                                    <p>{{ $student->gender }}</p>
                                </td>
                                <td>
                                    <p>{{ $student->dob }}</p>
                                </td>
                                <td>
                                    <div class="btn-group">

                                        <i data-bs-toggle="dropdown" aria-expanded="false"
                                            class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                                        <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('viewStudent', $student->id) }}">
                                                    <i class="fa-solid fa-eye me-2 text-custome"></i>
                                                    View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('editStudent', $student->id) }}">
                                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                                    Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('deleteStudent', $student->id) }}">
                                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                                    Delete
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
