@extends('layouts.form')

@section('title')
Add Trainer
@endsection

@section('form-title')
Add Trainer
@endsection

@section('form-navigation')
<li><a class="text-decoration-none" href="{{ route('allTrainers') }}">List Trainers </a></li>
<li>Add Trainer</li>
@endsection

@section('form-tabs-li')
<li class="nav-item" role="presentation">
    <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">Basic Info</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary" aria-selected="false">Address Info</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links" type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">Social Links</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-education-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-education-primary" type="button" role="tab" aria-controls="pills-education-primary" aria-selected="false">Education Info</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-previous-job-tab" data-bs-toggle="pill" data-bs-target="#pills-previous-job" type="button" role="tab" aria-controls="pills-previous-job" aria-selected="false">Previous Job</button>
</li>
@endsection

@section('form-tabs-content')
<form class="needs-validation" method="POST" action="{{ route('storeTrainer') }}" enctype="multipart/form-data">
    @csrf
    <div class="tab-content" id="pills-tabContent">
        {{-- Basic Info Group --}}
        <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel" aria-labelledby="pills-basic-primary-tab">


            <div class="row">

                {{-- Full Name --}}
                <div class="col-md-4 mt-4">
                    <label for="full_name" class="form-label">Full Name</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="full_name" aria-describedby="nameHelp" placeholder="Enter Full Name ..." name="full_name" value="{{ old('full_name') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Email --}}
                <div class="col-md-4 mt-4">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-envelope"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="email" aria-describedby="email" placeholder="Enter Email Address ..." name="email" value="{{ old('email') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Is Active --}}
                <div class="col-md-4 mt-4">
                    <label for="is_active" class="form-label">Is Active ?</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="is_active" name="is_active" required>
                            <option value="Active" {{ old('is_active') == 'Active' ? 'selected' : '' }}>Active</option>
                            <option value="InActive" {{ old('is_active') == 'InActive' ? 'selected' : '' }}>InActive
                            </option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                <?php /*
                {{-- Allow Login --}}
                <div class="col-md-2 mt-4">
                    <label for="allow_login" class="form-label">Allow Login</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="allow_login" name="allow_login" required>
                            <option value="Allowable" {{ old('allow_login') == 'Allowable' ? 'selected' : '' }}>Allowable
                            </option>
                            <option value="Not Allowable" {{ old('allow_login') == 'Not Allowable' ? 'selected' : '' }}>
                                Not Allowable</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>
                */?>

                {{-- Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="phone" class="form-label">Mobile Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="phone" placeholder="Enter Mobile Number . . ." name="phone" value="{{ old('phone') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Alternative Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="alternative_phone" class="form-label">Alternative Mobile Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="alternative_phone" placeholder="Enter Alternative Mobile Number . . ." name="alternative_phone" value="{{ old('alternative_phone') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Nationality --}}
                <div class="col-md-4 mt-4">
                    <label for="nationality" class="form-label">Nationality</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-house"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="nationality" placeholder="Enter Nationality . . ." name="nationality" value="{{ old('nationality') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- National Number --}}
                <div class="col-md-4 mt-4">
                    <label for="national_number" class="form-label">National Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-id-card"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="national_number" placeholder="Enter National Number . . ." name="national_number" value="{{ old('national_number') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Date of Birth --}}
                <div class="col-md-4 mt-4">
                    <label for="dob" class="form-label">Date Of Birth</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-days"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="dob" placeholder="Enter Date of Birth . . ." name="dob" value="{{ old('dob') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Gender --}}
                <div class="col-md-4 mt-4">
                    <label for="gender" class="form-label">Gender</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="gender" name="gender" required>
                            <option value="" disabled>-- Please choose an option --</option>
                            <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                            <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Blood Group --}}
                <div class="col-md-4 mt-4">
                    <label for="blood_group" class="form-label">Blood Group</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-heart-pulse"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                            <option value="">-- Please choose an option --</option>
                            <option value="A+" {{ old('blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                            <option value="A-" {{ old('blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                            <option value="B+" {{ old('blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                            <option value="B-" {{ old('blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                            <option value="O+" {{ old('blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                            <option value="O-" {{ old('blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                            <option value="AB+" {{ old('blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                            <option value="AB-" {{ old('blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                {{-- Marital Status --}}
                <div class="col-md-4 mt-4">
                    <label for="marital_status" class="form-label">Marital Status</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="marital_status" name="marital_status" required>
                            <option value="">-- Please choose an option --</option>
                            <option value="Single" {{ old('marital_status') == 'Single' ? 'selected' : '' }}>Single
                            </option>
                            <option value="Married" {{ old('marital_status') == 'Married' ? 'selected' : '' }}>Married
                            </option>
                            <option value="Divorced" {{ old('marital_status') == 'Divorced' ? 'selected' : '' }}>Divorced
                            </option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                {{-- Upload Image --}}
                <div class="col-md-4 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            Upload Image
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                    </label>
                    {{-- <input type="file" name="image" id="image"> --}}
                    {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                </div>

            </div>

            <div class="dotted-seprator mt-4 "></div>

            <div class="row">

                {{-- User Name --}}
                <div class="col-md-4 mt-4">
                    <label for="user_name" class="form-label">User Name</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="user_name" aria-describedby="user_name" placeholder="Enter User Name ..." name="user_name" value="{{ old('user_name') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Password --}}
                <div class="col-md-4 mt-4">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="password" data-password="myPass" class="form-control text-start" id="password" aria-describedby="password" placeholder="Enter Password ..." name="password" value="{{ old('password') }}" required>
                        <div class="invalid-feedback">
                            Please choose a student_name.
                        </div>
                    </div>
                </div>

                {{-- Confirm Password --}}
                <div class="col-md-4 mt-4">
                    <label for="confirm_password" class="form-label">Confirm Password</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="password" class="form-control text-start" id="confirm_password" aria-describedby="confirm_password" placeholder="Enter Password Again ..." name="confirm_password" value="{{ old('confirm_password') }}"  onblur="CheckPassword(this)"  required>
                        <div class="invalid-feedback invalid-Password">
                        confirm password "doesn't match"
                        </div>
                    </div>
                </div>

                {{-- Business Location Name --}}
                <div class="col-md-4 mt-4">
                    <label for="businessLocations" class="form-label">Business Location Name</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="businessLocations" name="business_id" required>
                            <option value="" disabled>-- Please choose an option --</option>
                            @foreach ($business_locations as $business_location)
                            <option value="{{ $business_location->id }}" {{ old('business_id') == '$business_location->id' ? 'selected' : '' }}>
                                {{ $business_location->business_name }}
                            </option>
                            @endforeach
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Join Job Date --}}
                <div class="col-md-4 mt-4">
                    <label for="join_job_date" class="form-label">Join Job Date</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-days"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="join_job_date" placeholder="Enter Join Job Date . . ." name="join_job_date" value="{{ old('join_job_date') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>



            </div>
        </div>



        {{-- Address Info --}}
        <div class="tab-pane fade show px-3" id="pills-address-primary" role="tabpanel" aria-labelledby="pills-address-primary-tab">

            <div class="row">

                {{-- Address --}}
                <div class="col-md-4 mt-4">
                    <label for="address" class="form-label">Address</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="address" aria-describedby="address" placeholder="Enter Address ..." name="address" value="{{ old('address') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- City --}}
                <div class="col-md-4 mt-4">
                    <label for="city" class="form-label">City</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-city"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="city" aria-describedby="city" placeholder="Enter City ..." name="city" value="{{ old('city') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- State --}}
                <div class="col-md-4 mt-4">
                    <label for="state" class="form-label">State</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-map"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="state" aria-describedby="state" placeholder="Enter State ..." name="state" value="{{ old('state') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Country --}}
                <div class="col-md-4 mt-4">
                    <label for="country" class="form-label">Country</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-map"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="country" aria-describedby="country" placeholder="Enter Country ..." name="country" value="{{ old('country') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Landmark --}}
                <div class="col-md-4 mt-4">
                    <label for="landmark" class="form-label">Landmark</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-landmark"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="landmark" aria-describedby="landmark" placeholder="Enter Landmark ..." name="landmark" value="{{ old('landmark') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>


            </div>
        </div>



        {{-- Socail Links --}}
        <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel" aria-labelledby="pills-social-links-tab">

            <div class="row">

                {{-- Website Link --}}
                <div class="col-md-4 mt-4">
                    <label for="website" class="form-label">Website Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="website" placeholder="Enter Website Link ..." name="website" value="{{ old('website') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- FaceBook Link --}}
                <div class="col-md-4 mt-4">
                    <label for="fb_link" class="form-label">FaceBook Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-brands fa-facebook-f"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="fb_link" placeholder="Enter FaceBook Link ..." name="fb_link" value="{{ old('fb_link') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Twitter Link --}}
                <div class="col-md-4 mt-4">
                    <label for="twitter_link" class="form-label">Twitter Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-brands fa-twitter"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="twitter_link" placeholder="Enter Twitter Link ..." name="twitter_link" value="{{ old('twitter_link') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Social Media Link --}}
                <div class="col-md-4 mt-4">
                    <label for="social_media_1" class="form-label">Social Media Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="social_media_1" placeholder="Enter Social Media Link ..." name="social_media_1" value="{{ old('social_media_1') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Social Media Link 2 --}}
                <div class="col-md-4 mt-4">
                    <label for="social_media_2" class="form-label">Social Media Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="social_media_2" placeholder="Enter Social Media Link ..." name="social_media_2" value="{{ old('social_media_2') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>


            </div>
        </div>



        {{-- Education & Expereience Info --}}
        <div class="tab-pane fade show px-3" id="pills-education-primary" role="tabpanel" aria-labelledby="pills-education-primary-tab">

            <div class="row">

                {{-- Specialization --}}
                <div class="col-md-4 mt-4">
                    <label for="specialization" class="form-label">Specialization</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-school"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="specialization" aria-describedby="specialization" placeholder="Enter Specialization ..." name="specialization" value="{{ old('specialization') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- University --}}
                <div class="col-md-4 mt-4">
                    <label for="university" class="form-label">University</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-building-columns"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="university" aria-describedby="university" placeholder="Enter University ..." name="university" value="{{ old('university') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Graduation Date --}}
                <div class="col-md-4 mt-4">
                    <label for="graduation_date" class="form-label">Graduation DateGraduation Date</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-days"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="graduation_date" placeholder="Enter Graduation Date . . ." name="graduation_date" value="{{ old('graduation_date') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Qualification --}}
                <div class="col-md-4 mt-4">
                    <label for="qualification" class="form-label">Qualification</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-file"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="qualification" name="qualification" required>
                            <option value="" disabled>-- Please choose an option --</option>
                            <option value="Bachelor" {{ old('qualification') == 'Bachelor' ? 'selected' : '' }}>Bachelor
                            </option>
                            <option value="Diploma" {{ old('qualification') == 'Diploma' ? 'selected' : '' }}>Diploma
                            </option>
                            <option value="Phd" {{ old('qualification') == 'Phd' ? 'selected' : '' }}>Phd</option>
                            <option value="Other" {{ old('qualification') == 'Other' ? 'selected' : '' }}>Other</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>
                {{-- If other selected show the other qualification --}}
                {{-- Other Qualification --}}
                <div class="col-md-4 mt-4">
                    <label for="qualification_other" class="form-label">Other Qualification</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-file"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="qualification_other" aria-describedby="qualification_other" placeholder="Enter Other Qualification ..." name="qualification_other" value="{{ old('qualification_other') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Membership --}}
                <div class="col-md-4 mt-4">
                    <label for="membership" class="form-label">Membership</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-file"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="membership" name="membership" required>
                            <option value="" disabled>-- Please choose an option --</option>
                            <option value="American Board" {{ old('membership') == 'American Board' ? 'selected' : '' }}>
                                American Board</option>
                            <option value="Canadian Board" {{ old('membership') == 'Canadian Board' ? 'selected' : '' }}>
                                Canadian Board</option>
                            <option value="British Board" {{ old('membership') == 'British Board' ? 'selected' : '' }}>
                                British Board</option>
                            <option value="HELP Center Membership" {{ old('membership') == 'HELP Center Membership' ? 'selected' : '' }}>HELP Center
                                Membership</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Expereience --}}
                <div class="col-md-12 mt-4">
                    <label for="expereience" class="form-label">Expereience</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-file"></i>
                        </span>
                        {{-- <input type="text" class="form-control text-start" id="expereience" aria-describedby="expereience"
                            placeholder="Enter Expereience ..." name="expereience" value="{{ old('expereience') }}"> --}}
                        <textarea class="form-control text-start" id="expereience" rows="5" placeholder="Enter Expereience ..." name="expereience">{{ old('expereience') }}</textarea>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

            </div>
        </div>



        {{-- Previous Job Info --}}
        <div class="tab-pane fade show px-3" id="pills-previous-job" role="tabpanel" aria-labelledby="pills-previous-job-tab">

            <div class="row">

                {{-- Previous Job --}}
                <div class="col-md-4 mt-4">
                    <label for="previous_job" class="form-label">Previous Job</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-user-doctor"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="previous_job" aria-describedby="previous_job" placeholder="Enter Previous Job ..." name="previous_job" value="{{ old('previous_job') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Previous Job Address --}}
                <div class="col-md-4 mt-4">
                    <label for="previous_job_address" class="form-label">Previous Job Address</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="previous_job_address" aria-describedby="previous_job_address" placeholder="Enter Previous Job Address ..." name="previous_job_address" value="{{ old('previous_job_address') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Previous Job Country --}}
                <div class="col-md-4 mt-4">
                    <label for="previous_job_country" class="form-label">Previous Job Country</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="previous_job_country" aria-describedby="previous_job_country" placeholder="Enter Previous Job Country ..." name="previous_job_country" value="{{ old('previous_job_country') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

            </div>
        </div>


    </div>
    <div class="col-12 mt-3 text-center">
    <button class="btn btn-outline-primary py-2 px-5" id="submit" disabled type="submit">save</button>
    </div>

</form>
@endsection