@extends('layouts.app_layout')

@section('title')
Add Trainer
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('storeTrainer') }}" enctype="multipart/form-data">
    @csrf
    <h2>Add Trainer</h2>
    <div class="form-group">
      <label for="full_name">Full Name</label>
      <input type="text" class="form-control" id="full_name" aria-describedby="nameHelp" placeholder="Full Name" name="full_name" value="{{old('full_name')}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="email">Email</label>
      <input type="text" class="form-control" id="email" aria-describedby="email" placeholder="Email" name="email" value="{{old('email')}}" required>
      {{-- <small id="email" class="form-text text-muted">Email will be used .</small> --}}
    </div>
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="is_active" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="is_active" @if (old('is_active') == null) value = 1 checked @else {{(old('is_active') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="active">Is Active ?</label>
    </div>
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="allow_login" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="allow_login" @if (old('allow_login') == null) value = 1 checked @else {{(old('allow_login') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="allow_login">Allow Login ?</label>
    </div>

    <hr>
    <h2>Roles and Permissions</h2>
    
    <div class="form-group">
        <label for="user_name">UserName</label>
        <input type="text" class="form-control" id="user_name" aria-describedby="userNameHelp" placeholder="UserName" name="user_name" value="{{old('user_name')}}" required>
        <small id="userNameHelp" class="form-text text-muted">Be careful will writing your username.</small>
    </div>
    
    <div class="form-group">
        <label for="password">Password</label>
        <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" name="password" required>
        <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and use complex password</small>
    </div>
    
    <div class="form-group">
        <label for="confirm_password">Confirm Password</label>
        <input type="password" class="form-control" id="confirm_password" aria-describedby="confirmPasswordHelp" placeholder="Password" required>
        <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small>
    </div>
    
    <hr>
    <h2>More Informations</h2>
    
    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" placeholder="Address" name="address" value="{{old('address')}}">
    </div>

    <div class="form-group">
        <label for="city">City</label>
        <input type="text" class="form-control" id="city" placeholder="City" name="city" value="{{old('city')}}">
    </div>

    <div class="form-group">
        <label for="state">State</label>
        <input type="text" class="form-control" id="state" placeholder="State" name="state" value="{{old('state')}}">
    </div>
    
    <div class="form-group">
        <label for="country">Country</label>
        <input type="text" class="form-control" id="country" placeholder="Country" name="country" value="{{old('country')}}">
    </div>
    
    <div class="form-group">
        <label for="landmark">Landmark</label>
        <input type="text" class="form-control" id="landmark" placeholder="Landmark" name="landmark" value="{{old('landmark')}}">
    </div>
    
    <div class="form-group">
        <label for="phone">Phone</label>
        <input type="number" class="form-control" id="phone" placeholder="Phone" name="phone" value="{{old('phone')}}">
    </div>

    <div class="form-group">
        <label for="alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="alternative_phone" placeholder="Alternative Phone Number" name="alternative_phone" value="{{old('alternative_phone')}}">
    </div>
    
    <div class="form-group">
        <label for="nationality">Nationality</label>
        <input type="text" class="form-control" id="nationality" placeholder="Nationality" name="nationality" value="{{old('nationality')}}">
    </div>
    
    <div class="form-group">
        <label for="national_number">National Number</label>
        <input type="number" class="form-control" id="national_number" placeholder="National Number" name="national_number" value="{{old('national_number')}}">
    </div>
    
    <div class="form-group">
        <label for="dob">Date Of Birth</label>
        <input type="date" class="form-control" id="dob" placeholder="Date Of Birth" name="dob" value="{{old('dob')}}">
    </div>
    
    <div class="form-group">
        <label for="image">Upload Image</label>
        <input type="file" name="image" id="image" >
    </div>
    
    <div class="form-group">
        <label for="gender">Gender</label>
        <select class="form-control" id="gender" name="gender">
            <option value="male" {{ old('gender') == "male" ? 'selected' : '' }}>Male</option>
            <option value="female" {{ old('gender') == "female" ? 'selected' : '' }}>Female</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="marital_status">Marital Status</label>
        <select class="form-control" id="marital_status" name="marital_status">
            <option value="single" {{ old('marital_status') == "single" ? 'selected' : '' }}>Single</option>
            <option value="married" {{ old('marital_status') == "married" ? 'selected' : '' }}>Married</option>
            <option value="divorced" {{ old('marital_status') == "divorced" ? 'selected' : '' }}>Divorced</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="blood_group">Blood Group</label>
        <input type="text" class="form-control" id="blood_group" placeholder="Blood Group" name="blood_group" value="{{old('blood_group')}}">
    </div>
    
    <div class="form-group">
        <label for="website">Website</label>
        <input type="url" class="form-control" id="website" placeholder="Website" name="website" value="{{old('website')}}">
    </div>
    
    <div class="form-group">
        <label for="fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="fb_link" placeholder="FaceBook Link" name="fb_link" value="{{old('fb_link')}}">
    </div>
    
    <div class="form-group">
        <label for="twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="twitter_link" placeholder="Twitter Link" name="twitter_link" value="{{old('twitter_link')}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_1" placeholder="Social Media Link" name="social_media_1" value="{{old('social_media_1')}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_2" placeholder="Social Media Link" name="social_media_2" value="{{old('social_media_2')}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="specialization">Specialization</label>
        <input type="text" class="form-control" id="specialization" placeholder="Specialization" name="specialization" value="{{old('Specialization')}}">
    </div>
    
    <div class="form-group">
        <label for="university">University</label>
        <input type="text" class="form-control" id="university" placeholder="University" name="university" value="{{old('university')}}">
    </div>
    
    <div class="form-group">
        <label for="graduation_date">Graduation Date</label>
        <input type="date" class="form-control" id="graduation_date" placeholder="Graduation Date" name="graduation_date" value="{{old('graduation_date')}}">
    </div>
    
    <div class="form-group">
        <label for="expereience">Expereience</label>
        <input type="text" class="form-control" id="expereience" placeholder="Expereience" name="expereience" value="{{old('expereience')}}">
    </div>
    
    <div class="form-group">
        <label for="qualification">Qualification</label>
        <select class="form-control" id="qualification" name="qualification">
            <option value="Bachelor" {{ old('qualification') == "Bachelor" ? 'selected' : '' }}>Bachelor</option>
            <option value="Diploma" {{ old('qualification') == "Diploma" ? 'selected' : '' }}>Diploma</option>
            <option value="Phd" {{ old('qualification') == "Phd" ? 'selected' : '' }}>Phd</option>
            <option value="Other" {{ old('qualification') == "Other" ? 'selected' : '' }}>Other</option>
        </select>
    </div>
    {{-- If other selected show the other qualification --}}
    <div class="form-group">
        <label for="qualification_other">Other Qualification</label>
        <input type="text" class="form-control" id="qualification_other" placeholder="Other Qualification" name="qualification_other" value="{{old('qualification_other')}}">
    </div>
    
    <div class="form-group">
        <label for="membership">Membership</label>
        <select class="form-control" id="membership" name="membership">
            <option value="American Board" {{ old('membership') == "American Board" ? 'selected' : '' }}>American Board</option>
            <option value="Canadian Board" {{ old('membership') == "Canadian Board" ? 'selected' : '' }}>Canadian Board</option>
            <option value="British Board" {{ old('membership') == "British Board" ? 'selected' : '' }}>British Board</option>
            <option value="HELP Center Membership" {{ old('membership') == "HELP Center Membership" ? 'selected' : '' }}>HELP Center Membership</option>
        </select>
    </div>
    
    <hr>
    <h2>Experience INfo</h2>
    
    <div class="form-group">
        <label for="previous_job">Previous Job</label>
        <input type="text" class="form-control" id="previous_job" placeholder="Previous Job" name="previous_job" value="{{old('previous_job')}}">
    </div>
    
    <div class="form-group">
        <label for="previous_job_address">Previous Job Address</label>
        <input type="text" class="form-control" id="previous_job_address" placeholder="Previous Job Address" name="previous_job_address" value="{{old('previous_job_address')}}">
    </div>
    
    <div class="form-group">
        <label for="previous_job_country">Previous Job Country</label>
        <input type="text" class="form-control" id="previous_job_country" placeholder="Previous Job Country" name="previous_job_country" value="{{old('previous_job_country')}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="businessLocations">Business Location Name</label>
        <select class="form-control" id="businessLocations" name="business_id">
            <option value="">Select Business Location</option>
            @foreach ($business_locations as $business_location)
            <option value="{{$business_location->id}}"  {{ old('business_id') == '$business_location->id' ? 'selected' : '' }}>{{$business_location->business_name}}</option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="join_job_date">Join Job Date</label>
        <input type="date" class="form-control" id="join_job_date" placeholder="Join Job Date" name="join_job_date" value="{{old('join_job_date')}}">
    </div>
    
    
    
    <button type="submit" class="btn btn-outline-primary mt-3">Submit</button>
</form>


<a href="{{ route('allTrainers') }}" class="btn btn-outline-primary mt-3">Back To All Trainers</a>


@endsection