@extends('layouts.form')

@section('title')
    Edit Trainer
@endsection

@section('form-title')
    Edit Trainer
@endsection

@section('form-navigation')
    <li><a class="text-decoration-none" href="{{ route('allTrainers') }}">List Trainers </a></li>
    <li>Edit Trainer - {{ $trainer->users->full_name }}</li>
@endsection

@section('form-tabs-li')
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary"
            type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">Basic Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary"
            aria-selected="false">Address Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links"
            type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">Social Links</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-education-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-education-primary" type="button" role="tab" aria-controls="pills-education-primary"
            aria-selected="false">Education Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-previous-job-tab" data-bs-toggle="pill" data-bs-target="#pills-previous-job"
            type="button" role="tab" aria-controls="pills-previous-job" aria-selected="false">Previous Job</button>
    </li>
@endsection

@section('form-tabs-content')
    <form class="needs-validation" method="POST" action="{{ route('updateTrainer', $trainer->id) }}"
        enctype="multipart/form-data">
        @csrf

        <div class="tab-content" id="pills-tabContent">
            {{-- Basic Info Group --}}
            <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel"
                aria-labelledby="pills-basic-primary-tab">

                <div class="row">

                    {{-- Full Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="full_name" class="form-label">Full Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="full_name" aria-describedby="nameHelp"
                                placeholder="Enter Full Name ..." name="full_name"
                                value="{{ old('full_name') ?? $trainer->users->full_name }}" required>
                            <div class="invalid-feedback">Please choose a student_name.</div>
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-4 mt-4">
                        <label for="email" class="form-label">Email Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="email" aria-describedby="email"
                                placeholder="Enter Email Address ..." name="email"
                                value="{{ old('email') ?? $trainer->users->email }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Is Active --}}
                    <div class="col-md-2 mt-4">
                        <label for="is_active" class="form-label">Is Active ?</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="is_active" name="is_active"
                                required>
                                <option value="Active"
                                    @if (old('is_active') == null) {{ $trainer->users->is_active == 'Active' ? 'selected' : '' }} @else {{ old('is_active') == 'Active' ? 'selected' : '' }} @endif>
                                    Active</option>
                                <option value="InActive"
                                    @if (old('is_active') == null) {{ $trainer->users->is_active == 'InActive' ? 'selected' : '' }} @else {{ old('is_active') == 'InActive' ? 'selected' : '' }} @endif>
                                    InActive</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                        </div>
                    </div>

                    {{-- Allow Login --}}
                    <?php /*
                                        <div class="col-md-4 mt-4">
                                            <label for="allow_login" class="form-label">Allow Login</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text" id="inputGroupPrepend">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                                <select class="form-control text-start text-start custom-select" id="allow_login"
                                                    name="allow_login" required>
                                                    <option value="Allowable"
                                                        @if (old('allow_login') == null) {{ $trainer->allow_login == 'Allowable' ? 'selected' : '' }} @else {{ old('allow_login') == 'Allowable' ? 'selected' : '' }} @endif>
                                                        Allowable</option>
                                                    <option value="Not Allowable"
                                                        @if (old('allow_login') == null) {{ $trainer->allow_login == 'Not Allowable' ? 'selected' : '' }} @else {{ old('allow_login') == 'Not Allowable' ? 'selected' : '' }} @endif>
                                                        Not Allowable</option>
                    
                                                </select>
                                                {{-- <div class="invalid-feedback">
                                                    Please choose a student_name.
                                                </div> --}}
                                            </div>
                                        </div>
                                        */
                    ?>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="phone" class="form-label">Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="phone"
                                placeholder="Enter Mobile Number . . ." name="phone"
                                value="{{ old('phone') ?? $trainer->users->phone }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="alternative_phone" class="form-label">Alternative Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="alternative_phone"
                                placeholder="Enter Alternative Mobile Number . . ." name="alternative_phone"
                                value="{{ old('alternative_phone') ?? $trainer->users->alternative_phone }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Nationality --}}
                    <div class="col-md-4 mt-4">
                        <label for="nationality" class="form-label">Nationality</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="nationality"
                                placeholder="Enter Nationality . . ." name="nationality"
                                value="{{ old('nationality') ?? $trainer->users->nationality }}" required>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- National Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="national_number" class="form-label">National Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-id-card"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="national_number"
                                placeholder="Enter National Number . . ." name="national_number"
                                value="{{ old('national_number') ?? $trainer->users->national_number }}" required>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Upload Image --}}
                    <div class="col-md-2 mt-4">
                        @php
                            $image = $trainer->users->image;
                        @endphp
                        @if ($trainer->users->image !== null)
                            <div class="form-group">
                                <img class="image-fload" width="100%" height="100%"
                                    src='{{ asset("uploads/$image") }}' alt="{{ $trainer->users->full_name }}">
                            </div>
                        @else
                            <br>
                            <p class="filelabel">No User Image</p>
                        @endif
                    </div>
                    <div class="col-md-2 mt-4">
                        <label for="image_input" class="form-label filelabel">
                            <i class="fa fa-paperclip">
                            </i>
                            <span class="title">
                                Upload Image
                            </span>
                            <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                        </label>
                    </div>

                    {{-- Date of Birth --}}
                    <div class="col-md-4 mt-4">
                        <label for="dob" class="form-label">Date Of Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="dob"
                                placeholder="Enter Date of Birth . . ." name="dob"
                                value="{{ old('dob') ?? $trainer->users->dob }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Gender --}}
                    <div class="col-md-4 mt-4">
                        <label for="gender" class="form-label">Gender</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="gender" name="gender" required>
                                <option value="" disabled>-- Please choose an option --</option>
                                <option value="Male"
                                    @if (old('gender') == null) {{ $trainer->users->gender == 'Male' ? 'selected' : '' }} @else {{ old('gender') == 'Male' ? 'selected' : '' }} @endif>
                                    Male</option>
                                <option value="Female"
                                    @if (old('gender') == null) {{ $trainer->users->gender == 'Female' ? 'selected' : '' }} @else {{ old('gender') == 'Female' ? 'selected' : '' }} @endif>
                                    Female</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Blood Group --}}
                    <div class="col-md-4 mt-4">
                        <label for="blood_group" class="form-label">Blood Group</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                                <option value="">-- Please choose an option --</option>
                                <option value="A+"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'A+' ? 'selected' : '' }} @else {{ old('blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    A+</option>
                                <option value="A-"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'A-' ? 'selected' : '' }} @else {{ old('blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    A-</option>
                                <option value="B+"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'B+' ? 'selected' : '' }} @else {{ old('blood_group') == 'B+' ? 'selected' : '' }} @endif>
                                    B+</option>
                                <option value="B-"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'B-' ? 'selected' : '' }} @else {{ old('blood_group') == 'B-' ? 'selected' : '' }} @endif>
                                    B-</option>
                                <option value="O+"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'O+' ? 'selected' : '' }} @else {{ old('blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    O+</option>
                                <option value="O-"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'O-' ? 'selected' : '' }} @else {{ old('blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    O-</option>
                                <option value="AB+"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'AB+' ? 'selected' : '' }} @else {{ old('blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    AB+</option>
                                <option value="AB-"
                                    @if (old('blood_group') == null) {{ $trainer->users->blood_group == 'AB-' ? 'selected' : '' }} @else {{ old('blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    AB-</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                        </div>
                    </div>

                    {{-- Marital Status --}}
                    <div class="col-md-4 mt-4">
                        <label for="marital_status" class="form-label">Marital Status</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="marital_status"
                                name="marital_status" required>
                                <option value="">-- Please choose an option --</option>
                                <option value="Single"
                                    @if (old('marital_status') == null) {{ $trainer->users->marital_status == 'Single' ? 'selected' : '' }} @else {{ old('marital_status') == 'Single' ? 'selected' : '' }} @endif>
                                    Single</option>
                                <option value="Married"
                                    @if (old('marital_status') == null) {{ $trainer->users->marital_status == 'Married' ? 'selected' : '' }} @else {{ old('marital_status') == 'Married' ? 'selected' : '' }} @endif>
                                    Married</option>
                                <option value="Divorced"
                                    @if (old('marital_status') == null) {{ $trainer->users->marital_status == 'Divorced' ? 'selected' : '' }} @else {{ old('marital_status') == 'Divorced' ? 'selected' : '' }} @endif>
                                    Divorced</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                        </div>
                    </div>

                </div>

                <div class="dotted-seprator mt-4 "></div>

                <div class="row">

                    {{-- User Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="user_name" class="form-label">User Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="user_name"
                                aria-describedby="user_name" placeholder="Enter User Name ..." name="user_name"
                                value="{{ old('user_name') ?? $trainer->users->user_name }}" required>
                            <div class="invalid-feedback">
                                Please choose a student_name.
                            </div>
                        </div>
                    </div>

                    {{-- Change Password --}}
                    <div class="col-md-4 mt-4">
                        <label for="user_name" class="form-label">Changing User Password</label>
                        <div class="input-group has-validation">
                            <a class="btn btn-outline-primary btn-sm me-2" data-bs-toggle="modal"
                                data-bs-target="#exampleModal">
                                <i class="fa-solid fa-plus me-2"></i> Change password
                            </a>
                        </div>
                    </div>

                    {{-- Business Location Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="businessLocations" class="form-label">Business Location Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="businessLocations"
                                name="business_id" required>
                                <option value="" disabled>-- Please choose an option --</option>
                                @foreach ($business_locations as $business_location)
                                    <option value="{{ $business_location->id }}"
                                        @if (old('business_id') == null) {{ $trainer->business_id == $business_location->id ? 'selected' : '' }} @else {{ old('business_id') == $business_location->id ? 'selected' : '' }} @endif>
                                        {{ $business_location->business_name }}
                                    </option>
                                @endforeach
                            </select>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Join Job Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="join_job_date" class="form-label">Join Job Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="join_job_date"
                                placeholder="Enter Join Job Date . . ." name="join_job_date"
                                value="{{ old('join_job_date') ?? $trainer->join_job_date }}" required>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>



                </div>
            </div>



            {{-- Address Info --}}
            <div class="tab-pane fade show px-3" id="pills-address-primary" role="tabpanel"
                aria-labelledby="pills-address-primary-tab">

                <div class="row">

                    {{-- Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="address" class="form-label">Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="address"
                                aria-describedby="address" placeholder="Enter Address ..." name="address"
                                value="{{ old('address') ?? $trainer->users->address }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- City --}}
                    <div class="col-md-4 mt-4">
                        <label for="city" class="form-label">City</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="city" aria-describedby="city"
                                placeholder="Enter City ..." name="city"
                                value="{{ old('city') ?? $trainer->users->city }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- State --}}
                    <div class="col-md-4 mt-4">
                        <label for="state" class="form-label">State</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="state"
                                aria-describedby="state" placeholder="Enter State ..." name="state"
                                value="{{ old('state') ?? $trainer->users->state }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="country" class="form-label">Country</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="country"
                                aria-describedby="country" placeholder="Enter Country ..." name="country"
                                value="{{ old('country') ?? $trainer->users->country }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Landmark --}}
                    <div class="col-md-4 mt-4">
                        <label for="landmark" class="form-label">Landmark</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="landmark"
                                aria-describedby="landmark" placeholder="Enter Landmark ..." name="landmark"
                                value="{{ old('landmark') ?? $trainer->users->landmark }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>


                </div>
            </div>



            {{-- Socail Links --}}
            <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel"
                aria-labelledby="pills-social-links-tab">

                <div class="row">

                    {{-- Website Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="website" class="form-label">Website Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="website"
                                placeholder="Enter Website Link ..." name="website"
                                value="{{ old('website') ?? $trainer->website }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- FaceBook Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="fb_link" class="form-label">FaceBook Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="fb_link"
                                placeholder="Enter FaceBook Link ..." name="fb_link"
                                value="{{ old('fb_link') ?? $trainer->users->fb_link }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Twitter Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="twitter_link" class="form-label">Twitter Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="twitter_link"
                                placeholder="Enter Twitter Link ..." name="twitter_link"
                                value="{{ old('twitter_link') ?? $trainer->users->twitter_link }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Social Media Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="social_media_1" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_1"
                                placeholder="Enter Social Media Link ..." name="social_media_1"
                                value="{{ old('social_media_1') ?? $trainer->users->social_media_1 }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Social Media Link 2 --}}
                    <div class="col-md-4 mt-4">
                        <label for="social_media_2" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_2"
                                placeholder="Enter Social Media Link ..." name="social_media_2"
                                value="{{ old('social_media_2') ?? $trainer->users->social_media_2 }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>


                </div>
            </div>



            {{-- Education & Expereience Info --}}
            <div class="tab-pane fade show px-3" id="pills-education-primary" role="tabpanel"
                aria-labelledby="pills-education-primary-tab">

                <div class="row">

                    {{-- Specialization --}}
                    <div class="col-md-4 mt-4">
                        <label for="specialization" class="form-label">Specialization</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="specialization"
                                aria-describedby="specialization" placeholder="Enter Specialization ..."
                                name="specialization" value="{{ old('Specialization') ?? $trainer->specialization }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- University --}}
                    <div class="col-md-4 mt-4">
                        <label for="university" class="form-label">University</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="university"
                                aria-describedby="university" placeholder="Enter University ..." name="university"
                                value="{{ old('university') ?? $trainer->university }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Graduation Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="graduation_date" class="form-label">Graduation Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="graduation_date"
                                placeholder="Enter Graduation Date . . ." name="graduation_date"
                                value="{{ old('graduation_date') ?? $trainer->graduation_date }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="qualification" class="form-label">Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="qualification" name="qualification"
                                required>
                                <option value="" disabled>-- Please choose an option --</option>
                                <option value="Bachelor"
                                    @if (old('qualification') == null) {{ $trainer->qualification == 'Bachelor' ? 'selected' : '' }} @else {{ old('qualification') == 'Bachelor' ? 'selected' : '' }} @endif>
                                    Bachelor</option>
                                <option value="Diploma"
                                    @if (old('qualification') == null) {{ $trainer->qualification == 'Diploma' ? 'selected' : '' }} @else {{ old('qualification') == 'Diploma' ? 'selected' : '' }} @endif>
                                    Diploma</option>
                                <option value="Phd"
                                    @if (old('qualification') == null) {{ $trainer->qualification == 'Phd' ? 'selected' : '' }} @else {{ old('qualification') == 'Phd' ? 'selected' : '' }} @endif>
                                    Phd</option>
                                <option value="Other"
                                    @if (old('qualification') == null) {{ $trainer->qualification == 'Other' ? 'selected' : '' }} @else {{ old('qualification') == 'Other' ? 'selected' : '' }} @endif>
                                    Other</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>
                    {{-- If other selected show the other qualification --}}
                    {{-- Other Qualification --}}
                    <div class="col-md-4 mt-4">
                        <label for="qualification_other" class="form-label">Other Qualification</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="qualification_other"
                                aria-describedby="qualification_other" placeholder="Enter Other Qualification ..."
                                name="qualification_other"
                                value="{{ old('qualification_other') ?? $trainer->qualification_other }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Membership --}}
                    <div class="col-md-4 mt-4">
                        <label for="membership" class="form-label">Membership</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="membership" name="membership"
                                required>
                                <option value="" disabled>-- Please choose an option --</option>
                                <option value="American Board"
                                    @if (old('membership') == null) {{ $trainer->membership == 'American Board' ? 'selected' : '' }} @else {{ old('membership') == 'American Board' ? 'selected' : '' }} @endif>
                                    American Board</option>
                                <option value="Canadian Board"
                                    @if (old('membership') == null) {{ $trainer->membership == 'Canadian Board' ? 'selected' : '' }} @else {{ old('membership') == 'Canadian Board' ? 'selected' : '' }} @endif>
                                    Canadian Board</option>
                                <option value="British Board"
                                    @if (old('membership') == null) {{ $trainer->membership == 'British Board' ? 'selected' : '' }} @else {{ old('membership') == 'British Board' ? 'selected' : '' }} @endif>
                                    British Board</option>
                                <option value="HELP Center Membership"
                                    @if (old('membership') == null) {{ $trainer->membership == 'HELP Center Membership' ? 'selected' : '' }} @else {{ old('membership') == 'HELP Center Membership' ? 'selected' : '' }} @endif>
                                    HELP Center Membership</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Expereience --}}
                    <div class="col-md-12 mt-4">
                        <label for="expereience" class="form-label">Expereience</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            {{-- <input type="text" class="form-control text-start" id="expereience" aria-describedby="expereience"
                            placeholder="Enter Expereience ..." name="expereience" value="{{ old('expereience') }}"> --}}
                            <textarea class="form-control text-start" id="expereience" rows="5" placeholder="Enter Expereience ..."
                                name="expereience">{{ old('expereience') ?? $trainer->expereience }}</textarea>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                </div>
            </div>



            {{-- Previous Job Info --}}
            <div class="tab-pane fade show px-3" id="pills-previous-job" role="tabpanel"
                aria-labelledby="pills-previous-job-tab">

                <div class="row">

                    {{-- Previous Job --}}
                    <div class="col-md-4 mt-4">
                        <label for="previous_job" class="form-label">Previous Job</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="previous_job"
                                aria-describedby="previous_job" placeholder="Enter Previous Job ..." name="previous_job"
                                value="{{ old('previous_job') ?? $trainer->previous_job }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Previous Job Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="previous_job_address" class="form-label">Previous Job Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="previous_job_address"
                                aria-describedby="previous_job_address" placeholder="Enter Previous Job Address ..."
                                name="previous_job_address"
                                value="{{ old('previous_job_address') ?? $trainer->previous_job_address }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                    {{-- Previous Job Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="previous_job_country" class="form-label">Previous Job Country</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="previous_job_country"
                                aria-describedby="previous_job_country" placeholder="Enter Previous Job Country ..."
                                name="previous_job_country"
                                value="{{ old('previous_job_country') ?? $trainer->previous_job_country }}">
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>

                </div>
            </div>

        </div>


        <form method="POST" action="{{ route('updateUserPassword', $trainer->user_id) }}"
            enctype="multipart/form-data">
            @csrf

            <div class="col-12">
                <button class="btn btn-outline-primary" type="submit">save</button>
            </div>

        </form>

        <!-- Change password Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Changing User Password</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">


                        <form method="POST" action="{{ route('updateUserPassword', $trainer->user_id) }}"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="form-group">
                                <label for="password">New Password</label>
                                <input type="password" data-password="myPass" class="form-control" id="password"
                                    aria-describedby="passwordHelp" placeholder="Password" name="password">
                                <small id="passwordHelp" class="form-text text-muted">Be careful will writing your
                                    password and
                                    use complex password</small>
                            </div>

                            <div class="form-group">
                                <label for="confirm_password">Confirm New Password</label>
                                <input type="password" class="form-control" id="confirm_password"
                                    aria-describedby="confirmPasswordHelp" placeholder="Password"
                                    onblur="CheckPassword(this)" required>
                                <div class="invalid-feedback invalid-Password">
                                    confirm password "doesn't match"
                                </div>
                                <!-- <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small> -->
                            </div>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button class="btn btn-outline-primary py-2 px-5" id="submit" disabled
                            type="submit">Submit</button>
    </form>
    </div>
    </div>
    </div>
    </div>
@endsection
