@extends('layouts.app_layout')

@section('title')
Edit Trainer
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('updateTrainer' , $trainer->id ) }}" enctype="multipart/form-data">
    @csrf
    <h2>Edit Trainer - {{$trainer->full_name}}</h2>
    <div class="form-group">
      <label for="full_name">Full Name</label>
      <input type="text" class="form-control" id="full_name" aria-describedby="nameHelp" placeholder="Full Name" name="full_name" value="{{old('full_name') ?? $trainer->full_name}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="email">Email</label>
      <input type="text" class="form-control" id="email" aria-describedby="email" placeholder="Email" name="email" value="{{old('email') ?? $trainer->email}}" required>
      {{-- <small id="email" class="form-text text-muted">Email will be used .</small> --}}
    </div>
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="is_active" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="is_active" @if (old('is_active') == null && $trainer->is_active == 1)  value = 1 checked @else {{(old('is_active') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="active">Is Active ?</label>
    </div>
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="allow_login" value = 0 >
        <input class="form-check-input" type="checkbox" id="allow_login" name="allow_login" @if (old('allow_login') == null && $trainer->allow_login == 1) value = 1 checked @else {{(old('allow_login') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >

        <label class="form-check-label" for="allow_login">Allow Login ?</label>
    </div>

    <hr>
    <h2>Roles and Permissions</h2>

    {{-- Change Password --}}
    <p>Username : {{ $trainer->user_name }}</p>
        {{-- <form method="POST" action="{{ route('updateUserPassword' , $user->id) }}" enctype="multipart/form-data">
            @csrf
                      
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" required>
                <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and use complex password</small>
            </div>
        
            <div class="form-group">
                <label for="password">New Password</label>
                <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" name="password" required>
                <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and use complex password</small>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Confirm New Password</label>
                <input type="password" class="form-control" id="confirm_password" aria-describedby="confirmPasswordHelp" placeholder="Password" required>
                <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small>
            </div>
            
            <button type="submit" class="btn btn-outline-primary">Submit</button>
        </form> --}}
    
    <hr>
    <h2>More Informations</h2>
    
    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" placeholder="Address" name="address" value="{{old('address') ?? $trainer->address}}">
    </div>

    <div class="form-group">
        <label for="city">City</label>
        <input type="text" class="form-control" id="city" placeholder="City" name="city" value="{{old('city') ?? $trainer->city}}">
    </div>

    <div class="form-group">
        <label for="state">State</label>
        <input type="text" class="form-control" id="state" placeholder="State" name="state" value="{{old('state') ?? $trainer->state}}">
    </div>
    
    <div class="form-group">
        <label for="country">Country</label>
        <input type="text" class="form-control" id="country" placeholder="Country" name="country" value="{{old('country') ?? $trainer->country}}">
    </div>
    
    <div class="form-group">
        <label for="landmark">Landmark</label>
        <input type="text" class="form-control" id="landmark" placeholder="Landmark" name="landmark" value="{{old('landmark') ?? $trainer->landmark}}">
    </div>
    
    <div class="form-group">
        <label for="phone">Phone</label>
        <input type="number" class="form-control" id="phone" placeholder="Phone" name="phone" value="{{old('phone') ?? $trainer->phone}}">
    </div>

    <div class="form-group">
        <label for="alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="alternative_phone" placeholder="Alternative Phone Number" name="alternative_phone" value="{{old('alternative_phone') ?? $trainer->alternative_phone}}">
    </div>
    
    <div class="form-group">
        <label for="nationality">Nationality</label>
        <input type="text" class="form-control" id="nationality" placeholder="Nationality" name="nationality" value="{{old('nationality') ?? $trainer->nationality}}">
    </div>
    
    <div class="form-group">
        <label for="national_number">National Number</label>
        <input type="number" class="form-control" id="national_number" placeholder="National Number" name="national_number" value="{{old('national_number') ?? $trainer->national_number}}">
    </div>
    
    <div class="form-group">
        <label for="dob">Date Of Birth</label>
        <input type="date" class="form-control" id="dob" placeholder="Date Of Birth" name="dob" value="{{old('dob') ?? $trainer->dob}}">
    </div>
    
    @if ($trainer->image !== null)
    <div class="form-group">
        <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$trainer->image") }}' alt="{{$trainer->full_name}}">   
    </div>
    @endif

    <div class="form-group">
        <label for="image">Upload Image</label>
        <input type="file" name="image" id="image" >
    </div>
    
    <div class="form-group">
        <label for="gender">Gender</label>
        <select class="form-control" id="gender" name="gender">
            <option value="Male" @if (old('gender') == null) {{ $trainer->gender == "Male" ? 'selected' : '' }} @else {{ old('gender') == "Male" ? 'selected' : '' }} @endif >Male</option>
            <option value="Female" @if (old('gender') == null) {{ $trainer->gender == "Female" ? 'selected' : '' }} @else {{ old('gender') == "Female" ? 'selected' : '' }} @endif >Female</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="marital_status">Marital Status</label>
        <select class="form-control" id="marital_status" name="marital_status">
            <option value="Single" @if (old('marital_status') == null) {{ $trainer->marital_status == "Single" ? 'selected' : '' }} @else {{ old('marital_status') == "Single" ? 'selected' : '' }} @endif >Single</option>
            <option value="Married" @if (old('marital_status') == null) {{ $trainer->marital_status == "Married" ? 'selected' : '' }} @else {{ old('marital_status') == "Married" ? 'selected' : '' }} @endif >Married</option>
            <option value="Divorced" @if (old('marital_status') == null) {{ $trainer->marital_status == "Divorced" ? 'selected' : '' }} @else {{ old('marital_status') == "Divorced" ? 'selected' : '' }} @endif >Divorced</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="blood_group">Blood Group</label>
        <input type="text" class="form-control" id="blood_group" placeholder="Blood Group" name="blood_group" value="{{old('blood_group') ?? $trainer->blood_group}}">
    </div>
    
    <div class="form-group">
        <label for="website">Website</label>
        <input type="url" class="form-control" id="website" placeholder="Website" name="website" value="{{old('website') ?? $trainer->website}}">
    </div>
    
    <div class="form-group">
        <label for="fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="fb_link" placeholder="FaceBook Link" name="fb_link" value="{{old('fb_link') ?? $trainer->fb_link}}">
    </div>
    
    <div class="form-group">
        <label for="twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="twitter_link" placeholder="Twitter Link" name="twitter_link" value="{{old('twitter_link') ?? $trainer->twitter_link}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_1" placeholder="Social Media Link" name="social_media_1" value="{{old('social_media_1') ?? $trainer->social_media_1}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_2" placeholder="Social Media Link" name="social_media_2" value="{{old('social_media_2') ?? $trainer->social_media_2}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="specialization">Specialization</label>
        <input type="text" class="form-control" id="specialization" placeholder="Specialization" name="specialization" value="{{old('Specialization') ?? $trainer->specialization}}">
    </div>
    
    <div class="form-group">
        <label for="university">University</label>
        <input type="text" class="form-control" id="university" placeholder="University" name="university" value="{{old('university') ?? $trainer->university}}">
    </div>
    
    <div class="form-group">
        <label for="graduation_date">Graduation Date</label>
        <input type="date" class="form-control" id="graduation_date" placeholder="Graduation Date" name="graduation_date" value="{{old('graduation_date') ?? $trainer->graduation_date}}">
    </div>
    
    <div class="form-group">
        <label for="expereience">Expereience</label>
        <input type="text" class="form-control" id="expereience" placeholder="Expereience" name="expereience" value="{{old('expereience') ?? $trainer->expereience}}">
    </div>
    
    <div class="form-group">
        <label for="qualification">Qualification</label>
        <select class="form-control" id="qualification" name="qualification">
            <option value="Bachelor" @if (old('qualification') == null) {{ $trainer->qualification == "Bachelor" ? 'selected' : '' }} @else {{ old('qualification') == "Bachelor" ? 'selected' : '' }} @endif >Bachelor</option>
            <option value="Diploma" @if (old('qualification') == null) {{ $trainer->qualification == "Diploma" ? 'selected' : '' }} @else {{ old('qualification') == "Diploma" ? 'selected' : '' }} @endif >Diploma</option>
            <option value="Phd" @if (old('qualification') == null) {{ $trainer->qualification == "Phd" ? 'selected' : '' }} @else {{ old('qualification') == "Phd" ? 'selected' : '' }} @endif >Phd</option>
            <option value="Other" @if (old('qualification') == null) {{ $trainer->qualification == "Other" ? 'selected' : '' }} @else {{ old('qualification') == "Other" ? 'selected' : '' }} @endif >Other</option>
        </select>
    </div>
    {{-- If other selected show the other qualification --}}
    <div class="form-group">
        <label for="qualification_other">Other Qualification</label>
        <input type="text" class="form-control" id="qualification_other" placeholder="Other Qualification" name="qualification_other" value="{{old('qualification_other') ?? $trainer->qualification_other}}">
    </div>
    
    <div class="form-group">
        <label for="membership">Membership</label>
        <select class="form-control" id="membership" name="membership">
            <option value="American Board" @if (old('membership') == null) {{ $trainer->membership == "American Board" ? 'selected' : '' }} @else {{ old('membership') == "American Board" ? 'selected' : '' }} @endif >American Board</option>
            <option value="Canadian Board" @if (old('membership') == null) {{ $trainer->membership == "Canadian Board" ? 'selected' : '' }} @else {{ old('membership') == "Canadian Board" ? 'selected' : '' }} @endif >Canadian Board</option>
            <option value="British Board" @if (old('membership') == null) {{ $trainer->membership == "British Board" ? 'selected' : '' }} @else {{ old('membership') == "British Board" ? 'selected' : '' }} @endif >British Board</option>
            <option value="HELP Center Membership" @if (old('membership') == null) {{ $trainer->membership == "HELP Center Membership" ? 'selected' : '' }} @else {{ old('membership') == "HELP Center Membership" ? 'selected' : '' }} @endif >HELP Center Membership</option>
        </select>
    </div>
    
    <hr>
    <h2>Experience INfo</h2>
    
    <div class="form-group">
        <label for="previous_job">Previous Job</label>
        <input type="text" class="form-control" id="previous_job" placeholder="Previous Job" name="previous_job" value="{{old('previous_job') ?? $trainer->previous_job}}">
    </div>
    
    <div class="form-group">
        <label for="previous_job_address">Previous Job Address</label>
        <input type="text" class="form-control" id="previous_job_address" placeholder="Previous Job Address" name="previous_job_address" value="{{old('previous_job_address') ?? $trainer->previous_job_address}}">
    </div>
    
    <div class="form-group">
        <label for="previous_job_country">Previous Job Country</label>
        <input type="text" class="form-control" id="previous_job_country" placeholder="Previous Job Country" name="previous_job_country" value="{{old('previous_job_country') ?? $trainer->previous_job_country}}">
    </div>
    
    <hr>
    <h2>Education INfo</h2>
    
    <div class="form-group">
        <label for="businessLocations">Business Location Name</label>
        <select class="form-control" id="businessLocations" name="business_id">
            <option value="">Select Business Location</option>
            @foreach ($business_locations as $business_location)
            <option value="{{$business_location->id}}" @if (old('business_id') == null) {{ $trainer->business_id == $business_location->id ? 'selected' : '' }} @else {{ old('business_id') == $business_location->id ? 'selected' : '' }} @endif >{{$business_location->business_name}}</option>

            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="join_job_date">Join Job Date</label>
        <input type="date" class="form-control" id="join_job_date" placeholder="Join Job Date" name="join_job_date" value="{{old('join_job_date') ?? $trainer->join_job_date}}">
    </div>
    
    
    
    <button type="submit" class="btn btn-outline-primary mt-3">Submit</button>
</form>


<a href="{{ route('allTrainers') }}" class="btn btn-outline-primary mt-3">Back To All Trainers</a>

@endsection