@extends('layouts.list')

@section('title')
    All Trainers
@endsection

@section('list-title')
    Trainers
@endsection

@section('list-navigation')
    <li>Trainers</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createTrainer') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Trainer
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">Trainer</th>
    <th scope="col">Gender</th>
    <th scope="col">Nationality</th>
    <th scope="col">Business Location</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($trainers as $trainer)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row" class="imageTitle">
                @php
                    $image = $trainer->users->image;
                @endphp
                @if ($trainer->users->image !== null && $trainer->users->image !== '')
                    <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$image") }}'
                        alt="{{ $trainer->users->full_name }}">
                @else
                    <h2> {{ $trainer->users->full_name[0] }}</h2>
                @endif
            </th>
            <td class="Zindex Zindex1">
                <h6 class="col-4"> Name </h6>
                <a class="text-decoration-none col-8" href="{{ route('viewTrainer', $trainer->id) }}">
                    <p class="text-custome m-0">{{ $trainer->users->full_name }}</p>
                </a>
                <h6 class="col-4"> email </h6>
                <p class="m-0 col-8">{{ $trainer->users->email }}</p>
                <h6 class="col-4"> phone </h6>
                <p class="m-0 col-8">{{ $trainer->users->phone }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> gender </h6>
                <p class="m-0 col-8">{{ $trainer->users->gender }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> nationality </h6>
                <p class="m-0 col-8">{{ $trainer->users->nationality }}</p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> business name </h6>
                <a class="text-decoration-none col-8" href="{{ route('viewBusinessLocation', $trainer->business_id) }}">
                    <p class="m-0 ">{{ $trainer->businessLocation->business_name }}</p>
                </a>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> user name </h6>
                <a class="text-decoration-none col-8" href="{{ route('viewUser', $trainer->created_by) }}">
                    <p class="m-0 ">{{ $trainer->createdBy->full_name }}</p>

                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewTrainer', $trainer->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editTrainer', $trainer->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
                            <li>
                                <a class="dropdown-item opacity-75 " href="{{ route('deleteTrainer', $trainer->id) }}">
                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                    Delete
                                </a>
                            </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $trainers->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $trainers->links() }} --}}
@endsection
