@extends('layouts.app_layout')

@section('title')
    Searched Trainers
@endsection

@section('content')
    @if (session('message'))
        <h6 class="alert alert-success">
            {{ session('message') }}
        </h6>
    @endif

    <div class="px-3">

        <div class="row align-items-center">
            <div class="col-sm-6">
                <h5 class="page-title-text d-inline-block">Trainers</h5>
                <div class="breadcrumbs d-inline-block">
                    <ul>
                        <li><a class="text-decoration-none" href="{{ route('dashboardIndex') }}">{{__('common.home')}}</a></li>
                        <li><a class="text-decoration-none" href="{{ route('allTrainers') }}">List Trainers </a></li>
                        <li>Search Trainers</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 text-right">
                <div class=" text-end mb-3">
                    <a href="{{ route('createTrainer') }}" class="btn btn-outline-primary btn-sm me-2">
                        <i class="fa-solid fa-plus me-2"></i> New Trainer
                    </a>
                </div>
            </div>
        </div>

        <div class="bg-white rounded shadow p-4">

            <div class="  table-responsive">
                <table id="example" class="table table-striped cell-border" style="width:100%">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Image</th>
                            <th scope="col">Name</th>
                            <th scope="col">Gender</th>
                            <th scope="col">Nationality</th>
                            <th scope="col">Business Location</th>
                            <th scope="col">Created By</th>
                            <th scope="col">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($trainers as $trainer)
                            <tr>
                                <td>
                                    <p class="m-0 px-3">1</p>
                                </td>
                                <th scope="row">
                                    @if ($trainer->image !== null)
                                        <img class="image-fload" width="100px" height="100px"
                                            src='{{ asset("uploads/$trainer->image") }}'
                                            alt="{{ $trainer->full_name }}">
                                    @else
                                        No Trainer Image
                                    @endif
                                </th>
                                <td>
                                    <a class="text-decoration-none" href="{{ route('viewTrainer', $trainer->id) }}">
                                        <p class="text-custome m-0 px-3">{{ $trainer->full_name }}</p>
                                    </a>
                                    <p class="m-0 px-3">{{ $trainer->email }}</p>
                                    <p class="m-0 px-3">{{ $trainer->phone }}</p>
                                </td>
                                <td>
                                    <p class="m-0 px-3">{{ $trainer->gender }}</p>
                                </td>
                                <td>
                                    <p class="m-0 px-3">{{ $trainer->nationality }}</p>
                                </td>
                                <td>
                                    <a class="text-decoration-none"
                                        href="{{ route('viewBusinessLocation', $trainer->business_id) }}">
                                        <p class="m-0 px-3">{{ $trainer->businessLocation->business_name }}</p>
                                    </a>
                                </td>
                                <td>
                                    <a class="text-decoration-none" href="{{ route('viewUser', $trainer->created_by) }}">
                                        <p class="m-0 px-3">{{ $trainer->users->user_name }}</p>
                                    </a>
                                </td>
                                <td>
                                    <div class="btn-group">

                                        <i data-bs-toggle="dropdown" aria-expanded="false"
                                            class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                                        <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('viewTrainer', $trainer->id) }}">
                                                    <i class="fa-solid fa-eye me-2 text-custome"></i>
                                                    View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('editTrainer', $trainer->id) }}">
                                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                                    Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item opacity-75 "
                                                    href="{{ route('deleteTrainer', $trainer->id) }}">
                                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                                    Delete
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
                {{-- <div class="d-flex">
                    {!! $trainers->links() !!}
                </div> --}}
            </div>
        </div>
    </div>

                {{-- {{ $trainers->links() }} --}}
            @endsection
