@extends('layouts.form')

@section('title')
Add User
@endsection

@section('form-title')
{{__('users.new_user')}}
@endsection

@section('form-navigation')
<li><a class="text-decoration-none" href="{{ route('allUsers') }}">{{__('users.list_users')}}</a></li>
<li>{{__('users.new_user')}}</li>
@endsection

@section('form-tabs-li')
<li class="nav-item" role="presentation">
    <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">{{__('users.basic_info')}}</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary" aria-selected="false">{{__('users.address_info')}}</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links" type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">{{__('users.social_links')}}</button>
</li>
@endsection

@section('form-tabs-content')
<form class="needs-validation" method="POST" action="{{ route('storeUser') }}" enctype="multipart/form-data">
    @csrf

    <div class="tab-content" id="pills-tabContent">
    {{-- Basic Info Group --}}
        <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel" aria-labelledby="pills-basic-primary-tab">

            <div class="row">

                {{-- Full Name --}}
                <div class="col-md-4 mt-4">
                    <label for="full_name" class="form-label">{{__('users.full_name')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="full_name" aria-describedby="nameHelp" placeholder="{{__('users.enter_full_name')}}" name="full_name" value="{{ old('full_name') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Email --}}
                <div class="col-md-4 mt-4">
                    <label for="email" class="form-label">{{__('users.email_address')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-envelope"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="email" aria-describedby="email" placeholder="{{__('users.enter_email_address')}}" name="email" value="{{ old('email') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Is Active --}}
                <div class="col-md-2 mt-4">
                    <label for="is_active" class="form-label">{{__('users.is_active_question')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="is_active" name="is_active" required>
                            <option value="Active" {{ old('is_active') == 'Active' ? 'selected' : '' }}>{{__('users.active')}}</option>
                            <option value="InActive" {{ old('is_active') == 'InActive' ? 'selected' : '' }}>{{__('users.in_active')}}</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                <?php /*
                {{-- Allow Login --}}
                <div class="col-md-2 mt-4">
                    <label for="allow_login" class="form-label">Allow Login</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="allow_login" name="allow_login" required>
                            <option value="Allowable" {{ old('allow_login') == 'Allowable' ? 'selected' : '' }}>Allowable
                            </option>
                            <option value="Not Allowable" {{ old('allow_login') == 'Not Allowable' ? 'selected' : '' }}>
                                Not Allowable</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>
                */?>

                {{-- Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="phone" class="form-label">{{__('users.mobile_number')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="phone" placeholder="{{__('users.enter_mobile_number')}}" name="phone" value="{{ old('phone') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Alternative Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="alternative_phone" class="form-label">{{__('users.alternative_mobile_number')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="alternative_phone" placeholder="{{__('users.enter_alternative_mobile_number')}}" name="alternative_phone" value="{{ old('alternative_phone') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Contact Number --}}
                <div class="col-md-4 mt-4">
                    <label for="contact_number" class="form-label">{{__('users.contact_number')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="contact_number" placeholder="{{__('users.enter_contact_number')}}" name="contact_number" value="{{ old('contact_number') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Nationality --}}
                <div class="col-md-4 mt-4">
                    <label for="nationality" class="form-label">{{__('users.nationality')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-building"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="nationality" placeholder="{{__('users.enter_nationality')}}" name="nationality" value="{{ old('nationality') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- National Number --}}
                <div class="col-md-4 mt-4">
                    <label for="national_number" class="form-label">{{__('users.national_number')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-id-card"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="national_number" placeholder="{{__('users.enter_national_number')}}" name="national_number" value="{{ old('national_number') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

           
                {{-- Date of Birth --}}
                <div class="col-md-4 mt-4">
                    <label for="dob" class="form-label">{{__('users.dob')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-calendar-minus"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="dob" placeholder="{{__('users.enter_dob')}}" name="dob" value="{{ old('dob') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Gender --}}
                <div class="col-md-4 mt-4">
                    <label for="gender" class="form-label">{{__('users.gender')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-user-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="gender" name="gender" required>
                            <option value="" disabled>{{__('users.choose_option')}}</option>
                            <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>{{__('users.male')}}</option>
                            <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>{{__('users.female')}}</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Blood Group --}}
                <div class="col-md-4 mt-4">
                    <label for="blood_group" class="form-label">{{__('users.blood_group')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-heart-pulse"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                            <option value="">{{__('users.choose_option')}}</option>
                            <option value="A+" {{ old('blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                            <option value="A-" {{ old('blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                            <option value="B+" {{ old('blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                            <option value="B-" {{ old('blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                            <option value="O+" {{ old('blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                            <option value="O-" {{ old('blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                            <option value="AB+" {{ old('blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                            <option value="AB-" {{ old('blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                {{-- Mother Language --}}
                <div class="col-md-4 mt-4">
                    <label for="language" class="form-label">{{__('users.mother_language')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="language" placeholder="{{__('users.enter_mother_language')}}" name="language" value="{{ old('language') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Marital Status --}}
                <div class="col-md-4 mt-4">
                    <label for="marital_status" class="form-label">{{__('users.marital_status')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="marital_status" name="marital_status" required>
                            <option value="">{{__('users.choose_option')}}</option>
                            <option value="Single" {{ old('marital_status') == 'Single' ? 'selected' : '' }}>{{__('users.single')}}
                            </option>
                            <option value="Married" {{ old('marital_status') == 'Married' ? 'selected' : '' }}>{{__('users.married')}}
                            </option>
                            <option value="Divorced" {{ old('marital_status') == 'Divorced' ? 'selected' : '' }}>{{__('users.divorced')}}
                            </option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>
                {{-- Upload Image --}}
                <div class="col-md-4 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            {{__('users.upload_image')}}
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                    </label>
                    {{-- <input type="file" name="image" id="image"> --}}
                    {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                </div>

                {{-- Upload Image --}}
                {{-- <div class="col-md-4 mt-4">
                    <label for="image" class="form-label">Upload Image</label>
                    <div class="input-group has-validation"> --}}
                {{-- <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span> --}}
                {{-- <input type="file" name="image" id="image"> --}}
                {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                {{-- </div>
                </div> --}}


            </div>

            <div class="dotted-seprator mt-4 "></div>

            <div class="row">

                {{-- User Name --}}
                <div class="col-md-4 mt-4">
                    <label for="user_name" class="form-label">{{__('users.user_name')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="user_name" aria-describedby="user_name" placeholder="{{__('users.enter_user_name')}}" name="user_name" value="{{ old('user_name') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Password --}}
                <div class="col-md-4 mt-4">
                    <label for="password" class="form-label">{{__('users.password')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="text" data-password="myPass" class="form-control text-start" id="password" aria-describedby="password" placeholder="{{__('users.enter_password')}}" name="password" value="{{ old('password') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Confirm Password --}}
                <div class="col-md-4 mt-4">
                    <label for="confirm_password" class="form-label">{{__('users.confirm_password')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="confirm_password" aria-describedby="confirm_password" placeholder="{{__('users.enter_confirm_password')}}" name="confirm_password" value="{{ old('confirm_password') }}" onblur="CheckPassword(this)"  required>
                        {{-- <div class="invalid-feedback invalid-Password">
                        confirm password "doesn't match"
                        </div> --}}
                    </div>
                </div>

                {{-- Business Location Name --}}
                <div class="col-md-4 mt-4">
                    <label for="businessLocations" class="form-label">{{__('users.business_location_name')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="businessLocations" name="business_id" required>
                            <option value="" disabled>{{__('users.choose_option')}}</option>
                            @foreach ($business_locations as $business_location)
                            <option value="{{ $business_location->id }}" {{ old('business_id') == '$business_location->id' ? 'selected' : '' }}>
                                {{ $business_location->business_name }}
                            </option>
                            @endforeach
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>



            </div>
        </div>



        {{-- Address Info --}}
        <div class="tab-pane fade show px-3" id="pills-address-primary" role="tabpanel" aria-labelledby="pills-address-primary-tab">

            <div class="row">

                {{-- Address --}}
                <div class="col-md-4 mt-4">
                    <label for="address" class="form-label">{{__('users.address')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="address" aria-describedby="address" placeholder="{{__('users.enter_address')}}" name="address" value="{{ old('address') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- City --}}
                <div class="col-md-4 mt-4">
                    <label for="city" class="form-label">{{__('users.city')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-map-location"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="city" aria-describedby="city" placeholder="{{__('users.enter_city')}}" name="city" value="{{ old('city') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- State --}}
                <div class="col-md-4 mt-4">
                    <label for="state" class="form-label">{{__('users.state')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-map"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="state" aria-describedby="state" placeholder="{{__('users.enter_state')}}" name="state" value="{{ old('state') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Country --}}
                <div class="col-md-4 mt-4">
                    <label for="country" class="form-label">{{__('users.country')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-map-pin"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="country" aria-describedby="country" placeholder="{{__('users.enter_country')}}" name="country" value="{{ old('country') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Landmark --}}
                <div class="col-md-4 mt-4">
                    <label for="landmark" class="form-label">{{__('users.landmark')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-landmark"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="landmark" aria-describedby="landmark" placeholder="{{__('users.enter_landmark')}}" name="landmark" value="{{ old('landmark') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>


            </div>
        </div>



        {{-- Socail Links --}}
        <div class="tab-pane fade show px-3" id="pills-social-links" role="tabpanel" aria-labelledby="pills-social-links-tab">

            <div class="row">

                {{-- FaceBook Link --}}
                <div class="col-md-4 mt-4">
                    <label for="fb_link" class="form-label">{{__('users.facebook_link')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-brands fa-facebook-f"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="fb_link" placeholder="{{__('users.enter_facebook_link')}}" name="fb_link" value="{{ old('fb_link') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Twitter Link --}}
                <div class="col-md-4 mt-4">
                    <label for="twitter_link" class="form-label">{{__('users.twitter_link')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-brands fa-twitter"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="twitter_link" placeholder="{{__('users.enter_twitter_link')}}" name="twitter_link" value="{{ old('twitter_link') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Social Media Link --}}
                <div class="col-md-4 mt-4">
                    <label for="social_media_1" class="form-label">{{__('users.social_media_link')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="social_media_1" placeholder="{{__('users.enter_social_media_link')}}" name="social_media_1" value="{{ old('social_media_1') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Social Media Link 2 --}}
                <div class="col-md-4 mt-4">
                    <label for="social_media_2" class="form-label">{{__('users.social_media_link_2')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="social_media_2" placeholder="{{__('users.enter_social_media_link_2')}}" name="social_media_2" value="{{ old('social_media_2') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>


            </div>
        </div>


    </div>
    <div class="col-12 mt-3 text-center">
    <button class="btn btn-outline-primary py-2 px-5" id="submit" disabled type="submit">{{__('users.save')}}</button>
    </div>

</form>

@endsection