@extends('layouts.app_layout')

@section('title')
Edit User
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('updateUser' , $user->id) }}" enctype="multipart/form-data">
    @csrf
    <h2>Edit User - {{$user->full_name}}</h2>
    <div class="form-group">
      <label for="full_name">Full Name</label>
      <input type="text" class="form-control" id="full_name" aria-describedby="nameHelp" placeholder="Full Name" name="full_name" value="{{old('full_name') ?? $user->full_name}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    <div class="form-group">
      <label for="email">Email</label>
      <input type="text" class="form-control" id="email" aria-describedby="email" placeholder="Email" name="email" value="{{old('email') ?? $user->email}}" required>
      {{-- <small id="email" class="form-text text-muted">Email will be used .</small> --}}
    </div>

    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="is_active" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="is_active" @if (old('is_active') == null && $user->is_active == 1)  value = 1 checked @else {{(old('is_active') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="active">Is Active ?</label>
    </div>

    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="allow_login" value = 0 >
        <input class="form-check-input" type="checkbox" id="allow_login" name="allow_login" @if (old('allow_login') == null && $user->allow_login == 1) value = 1 checked @else {{(old('allow_login') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="allow_login">Allow Login ?</label>
    </div>

    <hr>
    <h2>Roles and Permissions</h2>
    <p>{{ $user->user_name }}</p>
        {{-- Change Password --}}
        {{-- <form method="POST" action="{{ route('updateUserPassword' , $user->id) }}" enctype="multipart/form-data">
            @csrf
                      
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" required>
                <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and use complex password</small>
            </div>
        
            <div class="form-group">
                <label for="password">New Password</label>
                <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" name="password" required>
                <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and use complex password</small>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Confirm New Password</label>
                <input type="password" class="form-control" id="confirm_password" aria-describedby="confirmPasswordHelp" placeholder="Password" required>
                <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small>
            </div>
            
            <button type="submit" class="btn btn-outline-primary">Submit</button>
        </form> --}}
    
    <div class="form-group">
        <label for="businessLocations">Business Location Name</label>
        <select class="form-control" id="businessLocations" name="business_id">
            @foreach ($business_locations as $business_location)
            {{-- <option value="{{$business_location->id}}"  {{ old('business_location_id') ?? $user->address == '$business_location->id' ? 'selected' : '' }}>{{$business_location->business_name}}</option> --}}
            <option value="{{$business_location->id}}" @if (old('business_id') == null) {{ $user->business_id == $business_location->id ? 'selected' : '' }} @else {{ old('business_id') == $business_location->id ? 'selected' : '' }} @endif >{{$business_location->business_name}}</option>
            @endforeach
        </select>
    </div>
    
    <hr>
    <h2>More Informations</h2>

    <div class="form-group">
        <label for="nationality">Nationality</label>
        <input type="text" class="form-control" id="nationality" placeholder="Nationality" name="nationality" value="{{old('nationality') ?? $user->nationality}}">
    </div>
    
    <div class="form-group">
        <label for="national_number">National Number</label>
        <input type="text" class="form-control" id="national_number" placeholder="National Number" name="national_number" value="{{old('national_number') ?? $user->national_number}}">
    </div>

    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" placeholder="Address" name="address" value="{{old('address') ?? $user->address}}">
    </div>

    <div class="form-group">
        <label for="city">City</label>
        <input type="text" class="form-control" id="city" placeholder="City" name="city" value="{{old('city') ?? $user->city}}">
    </div>

    <div class="form-group">
        <label for="state">State</label>
        <input type="text" class="form-control" id="state" placeholder="State" name="state" value="{{old('state') ?? $user->state}}">
    </div>

    <div class="form-group">
        <label for="country">Country</label>
        <input type="text" class="form-control" id="country" placeholder="Country" name="country" value="{{old('country') ?? $user->country}}">
    </div>

    <div class="form-group">
        <label for="landmark">Landmark</label>
        <input type="text" class="form-control" id="landmark" placeholder="Landmark" name="landmark" value="{{old('landmark') ?? $user->landmark}}">
    </div>

    <div class="form-group">
        <label for="phone">Phone</label>
        <input type="number" class="form-control" id="phone" placeholder="Phone" name="phone" value="{{old('phone') ?? $user->phone}}">
    </div>

    <div class="form-group">
        <label for="alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="alternative_phone" placeholder="Alternative Phone Number" name="alternative_phone" value="{{old('alternative_phone') ?? $user->alternative_phone}}">
    </div>

    <div class="form-group">
        <label for="contact_number">Contact Number</label>
        <input type="number" class="form-control" id="contact_number" placeholder="Contact Number" name="contact_number" value="{{old('contact_number') ?? $user->contact_number}}">
    </div>

    <div class="form-group">
        <label for="language">Mother Language</label>
        <input type="text" class="form-control" id="language" placeholder="Mother Language" name="language" value="{{old('language') ?? $user->language}}">
    </div>

    @if ($user->image !== null)
    <div class="form-group">
        <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$user->image") }}' alt="{{$user->full_name}}">   
    </div>
    @endif

    <div class="form-group">
        <label for="image">Upload Image</label>
        <input type="file" name="image" id="image" >
    </div>
    
    <div class="form-group">
        <label for="dob">Date Of Birth</label>
        <input type="date" class="form-control" id="dob" placeholder="Date Of Birth" name="dob" value="{{old('dob') ?? $user->dob}}">
    </div>
    
    <div class="form-group">
        <label for="gender">Gender</label>
        <select class="form-control" id="gender" name="gender">
            <option value="Male" @if (old('gender') == null) {{ $user->gender == "Male" ? 'selected' : '' }} @else {{ old('gender') == "Male" ? 'selected' : '' }} @endif >Male</option>
            <option value="Female" @if (old('gender') == null) {{ $user->gender == "Female" ? 'selected' : '' }} @else {{ old('gender') == "Female" ? 'selected' : '' }} @endif >Female</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="marital_status">Marital Status</label>
        <select class="form-control" id="marital_status" name="marital_status">
            <option value="Single" @if (old('marital_status') == null) {{ $user->gender == "Single" ? 'selected' : '' }} @else {{ old('marital_status') == "Single" ? 'selected' : '' }} @endif >Single</option>
            <option value="Married" @if (old('marital_status') == null) {{ $user->gender == "Married" ? 'selected' : '' }} @else {{ old('marital_status') == "Married" ? 'selected' : '' }} @endif >Married</option>
            <option value="Divorced" @if (old('marital_status') == null) {{ $user->gender == "Divorced" ? 'selected' : '' }} @else {{ old('marital_status') == "Divorced" ? 'selected' : '' }} @endif >Divorced</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="blood_group">Blood Group</label>
        <input type="text" class="form-control" id="blood_group" placeholder="Blood Group" name="blood_group" value="{{old('blood_group') ?? $user->blood_group}}">
    </div>
    
    <div class="form-group">
        <label for="fb_link">FaceBook Link</label>
        <input type="url" class="form-control" id="fb_link" placeholder="FaceBook Link" name="fb_link" value="{{old('fb_link') ?? $user->fb_link}}">
    </div>
    
    <div class="form-group">
        <label for="twitter_link">Twitter Link</label>
        <input type="url" class="form-control" id="twitter_link" placeholder="Twitter Link" name="twitter_link" value="{{old('twitter_link') ?? $user->twitter_link}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_1">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_1" placeholder="Social Media Link" name="social_media_1" value="{{old('social_media_1') ?? $user->social_media_1}}">
    </div>
    
    <div class="form-group">
        <label for="social_media_2">Social Media Link</label>
        <input type="url" class="form-control" id="social_media_2" placeholder="Social Media Link" name="social_media_2" value="{{old('social_media_2') ?? $user->social_media_2}}">
    </div>

    {{-- <div class="form-group">
      <label for="desc">Desc</label>
      <textarea class="form-control" rows="3" id="desc" placeholder="Description" name="desc"></textarea>
    </div>
    <div class="form-group">
      <label for="authorName">Author Name</label>
      <select class="form-control" id="authorName" name="author_id">
    @foreach ($authors as $author)
        <option value="{{$author->id}}">{{$author->name}}</option>
    @endforeach
      </select>
    </div>
    <div class="form-group">
      <label for="price">Price</label>
      <input type="number" class="form-control" id="price"  placeholder="Book Price" name="price">
    </div>
    <div class="form-group">
      <label for="image">Upload Image</label>
      <input type="file" name="img" id="image">
    </div> --}}
    <button type="submit" class="btn btn-outline-primary">Submit</button>
</form>

<hr>
<hr>

{{-- Handle Changine the password --}}






  <a href="{{ route('allUsers') }}" class="btn btn-outline-primary mt-3">Back To All</a>



@endsection