@extends('layouts.list')

@section('title')
    {{__('users.list_users')}}
@endsection

@section('list-title')
{{__('users.users')}}
@endsection

@section('list-navigation')
    <li>{{__('users.users')}}</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createUser') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i>{{__('users.new_user')}}
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('users.new_user')}}</th>
    <th scope="col">{{__('users.user')}}</th>
    <th scope="col">{{__('users.nationality')}}</th>
    <th scope="col">{{__('users.gender')}}</th>
    <th scope="col">{{__('users.business_location')}}</th>
    {{-- <th scope="col">Allow Login</th> --}}
    <th scope="col">{{__('users.is_active')}}</th>
    <th scope="col">{{__('users.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($users as $user)
    <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row" class="imageTitle">
                @if ($user->image !== null && $user->image !== '')
                    <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$user->image") }}'
                        alt="{{ $user->full_name }}">
                @else
                    <h2> {{ $user->full_name[0] }}</h2>
                @endif
            </td>
            <td class="Zindex Zindex1">
                <h6 class="col-5">{{__('users.name')}}</h6>
                <p class="m-0  col-7">
                    <a class="text-decoration-none text-custome " href="{{ route('viewUser', $user->id) }}">
                        {{ $user->full_name }}
                    </a>
                </p>
                <h6 class="col-5">{{__('users.email')}}</h6>
                <p class="m-0  col-7">{{ $user->email }}</p>
                <h6 class="col-5">{{__('users.phone')}}</h6>
                <p class="m-0  col-7">{{ $user->phone }}</p>

            </td>
            <td class="Zindex">
                <h6 class="col-5">{{__('users.nationality')}}</h6>
                <p class="m-0  col-7">{{ $user->nationality }}</p>

            </td>
            <td class="Zindex">
                <h6 class="col-5">{{__('users.gender')}}</h6>
                <p class="m-0  col-7">{{ $user->gender }}</p>

            </td>

            <td class="Zindex">
                <h6 class="col-5">{{__('users.business_location')}}</h6>
                <a class="text-decoration-none m-0 col-7" href="{{ route('viewBusinessLocation', $user->business_id) }}">
                    <p class="m-0 px-3">{{ $user->business_location->business_name }}</p>
                </a>
            </td>
            <td class="Zindex">
                <h6 class="col-5">{{__('users.status')}}</h6>
                {{-- @if ($user->allow_login == 'Allowable')
                    <p class="text-success">Allowable</p>
                @else
                    <p class="text-danger">Not Allowable</p>
                @endif --}}
                @if ($user->is_active == 'Active')
                    <p class="text-success m-0  col-7">{{__('users.active')}}</p>
                @else
                    <p class="text-danger m-0  col-7">{{__('users.in_active')}}</p>
                @endif
            </td>

            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewUser', $user->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('users.view')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editUser', $user->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('users.edit')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == 'super_admin')
                            <li>
                                <a class="dropdown-item opacity-75 " href="{{ route('deleteUser', $user->id) }}">
                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                    {{__('users.delete')}}
                                </a>
                            </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $users->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $users->links() }} --}}
@endsection
