@extends('layouts.list')

@section('title')
    Search Users
@endsection

@section('list-title')
    Users
@endsection

@section('list-navigation')
    <li><a class="text-decoration-none" href="{{ route('allUsers') }}">List Users </a></li>
    <li>Search Users</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createUser') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New User
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">User</th>
    <th scope="col">Nationality</th>
    <th scope="col">Gender</th>
    <th scope="col">Allow Login</th>
    <th scope="col">Is Active</th>
    <th scope="col">Business Location</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($users as $user)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row">
                @if ($user->image !== null)
                    <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$user->image") }}'
                        alt="{{ $user->full_name }}">
                @else
                    No User Image
                @endif
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewUser', $user->id) }}">
                    <p class="text-custome m-0 px-3">{{ $user->user_name }}</p>
                </a>
                <p class="m-0 px-3">{{ $user->email }}</p>
                <p class="m-0 px-3">{{ $user->phone }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $user->nationality }}</p>
            </td>
            <td>
                <p class="m-0 px-3">{{ $user->gender }}</p>
            </td>
            <td>
                @if ($user->allow_login == 1)
                    <p class="m-0 px-3 text-success">Allowable</p>
                @else
                    <p class="m-0 px-3 text-danger">NotAllowable</p>
                @endif
            </td>
            <td>
                @if ($user->is_active == 1)
                    <p class="m-0 px-3 text-success">Active</p>
                @else
                    <p class="m-0 px-3 text-danger">InActive</p>
                @endif
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewBusinessLocation', $user->business_id) }}">
                    <p class="m-0 px-3">{{ $user->business_location->business_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewUser', $user->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editUser', $user->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('deleteUser', $user->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $users->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $users->links() }} --}}
@endsection
