@extends('layouts.view')

@section('title')
    View User
@endsection

@section('view-title')
    {{__('users.view_user')}} - {{ $user->user_name }}
@endsection

@section('view-navigation')
    <li><a class="text-decoration-none" href="{{ route('allUsers') }}">{{__('users.list_users')}}</a></li>
    <li>{{__('users.view_user')}}</li>
@endsection

@section('view-panel')
    <div class="user-avtar">
        @if ($user->image !== null)
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='{{ asset("uploads/$user->image") }}' alt="{{ $user->full_name }}">
        @else
            <span>{{ ucfirst($user->full_name[0]) }}</span>
        @endif
    </div>
    <div class="user-details text-center pt-3">
        <h3>{{ $user->full_name }}</h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="v-pills-user-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-info" type="button" role="tab" aria-controls="v-pills-user-info"
                aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>{{__('users.basic_info')}}</span>
            </button>
            <button class="nav-link" id="v-pills-user-address-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-address" type="button" role="tab" aria-controls="v-pills-user-address"
                aria-selected="false"><i class="fa-solid fa-address-book"></i><span>{{__('users.address_info')}}</span></button>
            <button class="nav-link" id="v-pills-user-social-media-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-social-media" type="button" role="tab"
                aria-controls="v-pills-user-social-media" aria-selected="false"><i class="fa-solid fa-link"></i><span>{{__('users.social_links')}}</span></button>
            @if (Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner')
                <a class="nav-link" type="button" role="tab" aria-selected="false"
                    href="{{ route('editUser', $user->id) }}"><i class="fa-solid fa-user-pen"></i><span>{{__('users.edit_user')}}</span></a>
            @endif
            {{-- <button class="nav-link" id="v-pills-user-documents-tab" data-bs-toggle="pill" data-bs-target="#v-pills-user-documents" type="button" role="tab" aria-controls="v-pills-user-documents" aria-selected="false"><i class="fa-solid fa-envelope"></i><span>Send Email</span></button> --}}
            <button class="nav-link" id="v-pills-user-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-user-sendwhatsapp" aria-selected="false"><i class="fa-solid fa-envelope"></i>
                <span>{{__('users.send_whatsApp')}}</span></button>
        </div>
    </div>
@endsection


@section('view-tabs')
    {{-- User Info --}}
    <div class="tab-pane fade show active" id="v-pills-user-info" role="tabpanel" aria-labelledby="v-pills-user-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('users.basic_info')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('users.user_name')}}</td>
                            <td>{{ $user->user_name }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.full_name')}}</td>
                            <td>{{ $user->full_name }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.email_address')}}</td>
                            <td>{{ $user->email }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.mobile_number')}}</td>
                            <td>{{ $user->phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.alternative_mobile_number')}}</td>
                            <td>{{ $user->alternative_phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.contact_number')}}</td>
                            <td>{{ $user->contact_number }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.dob')}}</td>
                            <td>{{ $user->dob }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.gender')}}</td>
                            <td>{{ $user->gender }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.blood_group')}}</td>
                            <td>{{ $user->blood_group }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.mother_language')}}</td>
                            <td>{{ $user->language }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.nationality')}}</td>
                            <td>{{ $user->nationality }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.national_number')}}</td>
                            <td>{{ $user->national_number }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.marital_status')}}</td>
                            <td>{{ $user->marital_status }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.business_location')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ route('viewBusinessLocation', $user->business_id) }}">{{ $user->business_location->business_name }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('users.status')}}</td>
                            <td>
                                @if ($user->is_active == 'Active')
                                    <span class="text-success">{{ $user->is_active }}</span>
                                @else
                                    <span class="text-danger">{{ $user->is_active }}</span>
                                @endif
                            </td>
                        </tr>
                        {{-- <tr>
				<td>Email Confirmation</td>
				<td class="text-danger">Unconfirmed</td>
			</tr> --}}
                        <tr>
                            <td>{{__('users.created_date')}}</td>
                            <td>{{ $user->created_at }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- User Address --}}
    <div class="tab-pane fade" id="v-pills-user-address" role="tabpanel" aria-labelledby="v-pills-user-address-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('users.address_info')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('users.address')}}</td>
                            <td>{{ $user->address }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.city')}}</td>
                            <td>{{ $user->city }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.state')}}</td>
                            <td>{{ $user->state }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.country')}}</td>
                            <td>{{ $user->country }}</td>
                        </tr>
                        <tr>
                            <td>{{__('users.landmark')}}</td>
                            <td>{{ $user->landmark }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- User Social Media --}}
    <div class="tab-pane fade" id="v-pills-user-social-media" role="tabpanel"
        aria-labelledby="v-pills-user-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('users.social_links')}}</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>{{__('users.facebook_link')}}</td>
                            <td><a class="text-decoration-none" href="{{ $user->fb_link }}">{{ $user->fb_link }}</a>
                            </td>
                        </tr>
                        <tr>
                            <td>{{__('users.twitter_link')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $user->twitter_link }}">{{ $user->twitter_link }}</a></td>
                        </tr>
                        <tr>
                            <td>{{__('users.social_media_link')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $user->social_media_1 }}">{{ $user->social_media_1 }}</a></td>
                        </tr>
                        <tr>
                            <td>{{__('users.social_media_link')}}</td>
                            <td><a class="text-decoration-none"
                                    href="{{ $user->social_media_2 }}">{{ $user->social_media_2 }}</a></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- <div class="tab-pane fade" id="v-pills-saas" role="tabpanel" aria-labelledby="v-pills-saas-tab">
<div class="panel panel-default">
<div class="panel-head">
	<div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Clinical Notes</div>  
</div>
<div class="panel-body p-3">
	<div class="notes-container">
											<div class="text-danger text-center">No Record Found !!!</div>
									</div>
</div>
</div>
</div>

<div class="tab-pane fade" id="v-pills-user-documents" role="tabpanel" aria-labelledby="v-pills-user-documents-tab">
<div class="panel panel-default">
	<div class="panel-head">
		<div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Documents/Reports</div>  
	</div>
	<div class="panel-body p-3">
									<p class="text-danger text-center">No Documents Found !!!</p>
							</div>
</div>
</div> --}}

    {{-- Send Whatsapp to User --}}
    <div class="tab-pane fade" id="v-pills-user-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-user-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">{{__('users.send_whatsApp_user')}}
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>{{__('users.send_whatsApp_to')}}</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>{{__('users.send_whatsApp_message')}}</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "{{ $user->phone }}";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>
@endsection
