<?php

use App\Http\Controllers\StudentController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('front-end.index');
// });
Route::get('/', 'FrontEndController@index')->name('frontEnd');
// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('lang/{lang}', ['as' => 'lang.switch', 'uses' => '\App\Http\Controllers\LanguageController@switchLang']);

/* Login Routes */
// Login Authentication
Route::get('/login', 'AuthController@login')->name('authLogin');
Route::POST('/do-login', 'AuthController@doLogin')->name('authDoLogin');
/* End Login Routes */
// Register Authentication
Route::get('/register', 'AuthController@register')->name('authRegister');
Route::POST('/do-register', 'AuthController@doRegister')->name('authDoRegister');
/* End Register Routes */

Route::middleware('userAuth')->group(function()
{
    // logout Authentication
    Route::get('/logout', 'AuthController@logout')->name('authLogout');
    /* End logout Routes */


    /* Users Routes*/
    // Read Users
    Route::get('/users', 'UserController@list')->name('allUsers')->middleware('isOwner');
    // Route::get('/users/test', 'UserController@test')->name('allUsersTest');
    Route::get('/users/view/{id}', 'UserController@view')->name('viewUser')->middleware('isTrainer');
    Route::get('/users/search/{word}', 'UserController@search')->name('searchUsers')->middleware('isOwner');

    // Create User
    Route::get('/users/create', 'UserController@create')->name('createUser')->middleware('isOwner');
    Route::POST('/users/store', 'UserController@store')->name('storeUser')->middleware('isOwner');

    // Update User
    Route::get('/users/edit/{id}', 'UserController@edit')->name('editUser')->middleware('isOwner');
    Route::POST('/users/update/{id}', 'UserController@update')->name('updateUser')->middleware('isOwner');
    Route::POST('/users/updatepassword/{id}', 'UserController@updatePassword')->name('updateUserPassword')->middleware('isOwner');

    // Delete User
    Route::get('/users/delete/{id}', 'UserController@delete')->name('deleteUser')->middleware('isSuperAdmin');

    /* End users Routes */

    /* Business Locations Routes*/
    // Read Business Locations
    Route::get('/business-locations', 'BusinessLocationController@list')->name('allBusinessLocations')->middleware('isOwner');
    Route::get('/business-locations/view/{id}', 'BusinessLocationController@view')->name('viewBusinessLocation')->middleware('isOwner');
    Route::get('/business-locations/search/{word}', 'BusinessLocationController@search')->name('searchBusinessLocations')->middleware('isOwner');

    // Create Business Location
    Route::get('/business-locations/create', 'BusinessLocationController@create')->name('createBusinessLocation')->middleware('isSuperAdmin');
    Route::POST('/business-locations/store', 'BusinessLocationController@store')->name('storeBusinessLocation')->middleware('isSuperAdmin');

    // Update Business Location
    Route::get('/business-locations/edit/{id}', 'BusinessLocationController@edit')->name('editBusinessLocation')->middleware('isOwner');
    Route::POST('/business-locations/update/{id}', 'BusinessLocationController@update')->name('updateBusinessLocation')->middleware('isOwner');

    // Delete Business Locations
    Route::get('/business-locations/delete/{id}', 'BusinessLocationController@delete')->name('deleteBusinessLocation')->middleware('isSuperAdmin');

    /* End Business Location Routes */

    /* Trainers Routes*/
    // Read Trainers
    Route::get('/trainers', 'TrainerController@list')->name('allTrainers')->middleware('isAdmin');
    Route::get('/trainers/view/{id}', 'TrainerController@view')->name('viewTrainer')->middleware('isAdmin');
    Route::get('/trainers/search/{word}', 'TrainerController@search')->name('searchTrainers')->middleware('isAdmin');

    // Create Trainer
    Route::get('/trainers/create', 'TrainerController@create')->name('createTrainer')->middleware('isAdmin');
    Route::POST('/trainers/store', 'TrainerController@store')->name('storeTrainer')->middleware('isAdmin');

    // Update Trainer
    Route::get('/trainers/edit/{id}', 'TrainerController@edit')->name('editTrainer')->middleware('isAdmin');
    Route::POST('/trainers/update/{id}', 'TrainerController@update')->name('updateTrainer')->middleware('isAdmin');
    // Route::POST('/trainers/updatepassword/{id}', 'TrainerController@updatePassword')->name('updateTrainerPassword')->middleware('isAdmin');


    // Delete Trainer
    Route::get('/trainers/delete/{id}', 'TrainerController@delete')->name('deleteTrainer')->middleware('isOwner');

    /* End Trainers Routes */

    /* Fathers Routes*/
    // Read Fathers
    Route::get('/fathers', 'StudentFatherProfileController@list')->name('allFathers')->middleware('isAdmin');
    Route::get('/fathers/view/{id}', 'StudentFatherProfileController@view')->name('viewFather')->middleware('isAdmin');
    Route::get('/fathers/search/{word}', 'StudentFatherProfileController@search')->name('searchFathers')->middleware('isAdmin');

    // Create Father
    Route::get('/fathers/create', 'StudentFatherProfileController@create')->name('createFather')->middleware('isAdmin');
    Route::POST('/fathers/store', 'StudentFatherProfileController@store')->name('storeFather')->middleware('isAdmin');

    // Update Father
    Route::get('/fathers/edit/{id}', 'StudentFatherProfileController@edit')->name('editFather')->middleware('isAdmin');
    Route::POST('/fathers/update/{id}', 'StudentFatherProfileController@update')->name('updateFather')->middleware('isAdmin');

    // Delete Father
    Route::get('/fathers/delete/{id}', 'StudentFatherProfileController@delete')->name('deleteFather')->middleware('isOwner');

    /* End Fathers Routes */

    /* Mothers Routes*/
    // Read Mothers
    Route::get('/mothers', 'StudentMotherProfileController@list')->name('allMothers')->middleware('isAdmin');
    Route::get('/mothers/view/{id}', 'StudentMotherProfileController@view')->name('viewMother')->middleware('isAdmin');
    Route::get('/mothers/search/{word}', 'StudentMotherProfileController@search')->name('searchMothers')->middleware('isAdmin');

    // Create Mother
    Route::get('/mothers/create', 'StudentMotherProfileController@create')->name('createMother')->middleware('isAdmin');
    Route::POST('/mothers/store', 'StudentMotherProfileController@store')->name('storeMother')->middleware('isAdmin');

    // Update Mother
    Route::get('/mothers/edit/{id}', 'StudentMotherProfileController@edit')->name('editMother')->middleware('isAdmin');
    Route::POST('/mothers/update/{id}', 'StudentMotherProfileController@update')->name('updateMother')->middleware('isAdmin');

    // Delete Mother
    Route::get('/mothers/delete/{id}', 'StudentMotherProfileController@delete')->name('deleteMother')->middleware('isOwner');

    /* End Mothers Routes */

    /* Superiors Routes*/
    // Read Superiors
    Route::get('/superiors', 'StudentSuperiorProfileController@list')->name('allSuperiors')->middleware('isAdmin');
    Route::get('/superiors/view/{id}', 'StudentSuperiorProfileController@view')->name('viewSuperior')->middleware('isAdmin');
    Route::get('/superiors/search/{word}', 'StudentSuperiorProfileController@search')->name('searchSuperiors')->middleware('isAdmin');

    // Create Superior
    Route::get('/superiors/create', 'StudentSuperiorProfileController@create')->name('createSuperior')->middleware('isAdmin');
    Route::POST('/superiors/store', 'StudentSuperiorProfileController@store')->name('storeSuperior')->middleware('isAdmin');

    // Update Superior
    Route::get('/superiors/edit/{id}', 'StudentSuperiorProfileController@edit')->name('editSuperior')->middleware('isAdmin');
    Route::POST('/superiors/update/{id}', 'StudentSuperiorProfileController@update')->name('updateSuperior')->middleware('isAdmin');

    // Delete Superior
    Route::get('/superiors/delete/{id}', 'StudentSuperiorProfileController@delete')->name('deleteSuperior')->middleware('isOwner');

    /* End Superiors Routes */

    /* Questions Routes*/
    // Read Questions
    Route::get('/questions', 'QuestionController@list')->name('allQuestions')->middleware('isAdmin');
    Route::get('/questions/view/{id}', 'QuestionController@view')->name('viewQuestion')->middleware('isAdmin');
    Route::get('/questions/search/{word}', 'QuestionController@search')->name('searchQuestions')->middleware('isAdmin');

    // Create Question
    Route::get('/questions/create', 'QuestionController@create')->name('createQuestion')->middleware('isAdmin');
    Route::POST('/questions/store', 'QuestionController@store')->name('storeQuestion')->middleware('isAdmin');

    // Update Question
    Route::get('/questions/edit/{id}', 'QuestionController@edit')->name('editQuestion')->middleware('isOwner');
    Route::POST('/questions/update/{id}', 'QuestionController@update')->name('updateQuestion')->middleware('isOwner');

    // Delete Question
    Route::get('/questions/delete/{id}', 'QuestionController@delete')->name('deleteQuestion')->middleware('isOwner');

    /* End Questions Routes */

    /* Assignments Routes*/
    // Read Assignments
    Route::get('/assignments', 'AssignmentController@list')->name('allAssignments')->middleware('isTrainer');
    Route::get('/assignments/view/{id}', 'AssignmentController@view')->name('viewAssignment')->middleware('isTrainer');
    Route::get('/assignments/search/{word}', 'AssignmentController@search')->name('searchAssignments')->middleware('isTrainer');

    // Create Assignment
    Route::get('/assignments/create', 'AssignmentController@create')->name('createAssignment')->middleware('isAdmin');
    Route::POST('/assignments/store', 'AssignmentController@store')->name('storeAssignment')->middleware('isAdmin');

    // Update Assignment
    Route::get('/assignments/edit/{id}', 'AssignmentController@edit')->name('editAssignment')->middleware('isOwner');
    Route::POST('/assignments/update/{id}', 'AssignmentController@update')->name('updateAssignment')->middleware('isOwner');

    // Delete Assignment
    Route::get('/assignments/delete/{id}', 'AssignmentController@delete')->name('deleteAssignment')->middleware('isOwner');

    /* End Assignments Routes */

    /* Submissions Routes*/
    // Read Submissions
    // Route::get('/submissions', 'SubmissionController@list')->name('allSubmissions');
    // Route::get('/submissions/view/{id}', 'SubmissionController@view')->name('viewSubmission');
    // Route::get('/submissions/search/{word}' , 'SubmissionController@search')->name('searchSubmissions');

    // Create Submission
    // Route::get('/submissions/create', 'SubmissionController@create')->name('createSubmission');
    // Route::POST('/submissions/store', 'SubmissionController@store')->name('storeSubmission');

    // Update Submission
    // Route::get('/submissions/edit/{id}', 'SubmissionController@edit')->name('editSubmission');
    // Route::POST('/submissions/update/{id}', 'SubmissionController@update')->name('updateSubmission');

    // Delete Submission
    // Route::get('/submissions/delete/{id}', 'SubmissionController@delete')->name('deleteSubmission');

    /* End Submissions Routes */


    /* Students Routes*/
    // Read Students
    Route::get('/students', 'StudentController@list')->name('allStudents')->middleware('isTrainer');
    Route::get('/students/view/{id}', 'StudentController@view')->name('viewStudent')->middleware('isTrainer');
    Route::get('/students/search/{word}', 'StudentController@search')->name('searchStudents')->middleware('isTrainer');

    // Create Student
    Route::get('/students/create', 'StudentController@create')->name('createStudent')->middleware('isAdmin');
    Route::POST('/students/store', 'StudentController@store')->name('storeStudent')->middleware('isAdmin');

    Route::get('/students/create-old', 'StudentController@create_old')->name('createOldStudent');

    // Create Student Assignment
    Route::get('/students/takeAssignment/{studentId}', 'StudentController@take_assignment')->name('takeStudentAssignment')->middleware('isTrainer');
    Route::POST('/students/create_assignment', 'StudentController@create_assignment')->name('createStudentAssignment')->middleware('isTrainer');
    Route::POST('/students/store_assignment', 'StudentController@store_assignment')->name('storeStudentAssignment')->middleware('isTrainer');

    // Taken Assignment
    Route::get('/students/takenAssignment/{studentId}', 'StudentController@taken_assignment')->name('takenStudentAssignments')->middleware('isTrainer');


    // // Update Student Assignment
    // Route::get('/students/takenAssignment/{id}', 'StudentController@taken_assignment')->name('takenStudentAssignment');
    // Route::POST('/students/edit_assignment/{id}', 'StudentController@edit_assignment')->name('editStudentAssignment');
    // Route::POST('/students/update_assignment/{id}', 'StudentController@update_assignment')->name('updateStudentAssignment');

    // Update Student
    Route::get('/students/edit/{id}', 'StudentController@edit')->name('editStudent')->middleware('isAdmin');
    Route::POST('/students/update/{id}', 'StudentController@update')->name('updateStudent')->middleware('isAdmin');

    // Delete Student
    Route::get('/students/delete/{id}', 'StudentController@delete')->name('deleteStudent')->middleware('isOwner');

    /* End Students Routes */


    /* Reports Routes */
    // Route::get('/report/{report_id}/{Submission_id}', 'ReportController@view')->name('assignmentReport');
    Route::get('/reports/{assignment_id}/{submission_id}', 'ReportController@index')->name('assignmentReportIndex')->middleware('isTrainer');
    Route::get('/reports/templates/check_templates/{report_id}', 'ReportController@check')->name('assignmentReportCheck')->middleware('isTrainer');
    // Route::get('/reports/templates/{report_id}/{submission_id}', 'ReportController@view')->name('assignmentReportView');
    Route::POST('/reports/templates', 'ReportController@view')->name('assignmentReportView')->middleware('isTrainer');
    /* End Reports Routes */

});

/* Dashboard Routes */
Route::get('/dashboard', 'DashboardController@index')->name('dashboardIndex');
/* End Dashboard Routes */
/* Dashboard Routes */
Route::get('/front-end', 'frontEndController@index')->name('frontEndIndex');
/* End Dashboard Routes */
/* Not Authorized 403 Routes */
Route::get('/403', 'AuthController@notAuth')->name('notAuth');
/* End Not Authorized 403 Routes */