

<?php $__env->startSection('title'); ?>
    All Questions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    <?php echo e(__('questions.questions')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li><?php echo e(__('questions.questions')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createQuestion')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i><?php echo e(__('questions.new_question')); ?>

    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col"><?php echo e(__('questions.question_title')); ?></th>
    <th scope="col"><?php echo e(__('questions.business_location')); ?></th>
    <th scope="col"><?php echo e(__('questions.created_by')); ?></th>
    <th scope="col"><?php echo e(__('questions.actions')); ?></th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6"><?php echo e(__('questions.question_title')); ?></h6>
                <a class="text-decoration-none col-6" href="<?php echo e(route('viewQuestion' , $question->id )); ?>">
                    <?php if(Config::get('languages')[App::getLocale()] = "english"): ?>
                        <p class="text-custome m-0 "><?php echo e($question->question_title); ?></p>
                    <?php else: ?>
                        <p class="text-custome m-0 "><?php echo e($question->question_title_ar); ?></p>
                    <?php endif; ?>
                </a>
            </td>
            
            
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('viewQuestion', $question->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                <?php echo e(__('questions.view')); ?>

                            </a>
                        </li>
                        <?php if(Auth::user()->role == "super_admin" || Auth::user()->role == "owner"): ?>    
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('editQuestion', $question->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                <?php echo e(__('questions.edit')); ?>

                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('deleteQuestion', $question->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                <?php echo e(__('questions.delete')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/questions/list.blade.php ENDPATH**/ ?>