

<?php $__env->startSection('title'); ?>
View Assignment - <?php echo e($assignment->assignment_title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3">

    <div class="row align-items-center">
        <div class="col-sm-8">
            <h2 class="page-title-text d-inline-block">View Assignment - <?php echo e($assignment->assignment_title); ?></h2>
        </div>
        <div class="col-sm-4 text-right">
            <div class=" text-end mb-3">
                <a href="<?php echo e(route('editAssignment' , $assignment->id)); ?>" class="btn btn-outline-warning btn-sm me-2">
                    <i class="fa-solid fa-pen-to-square me-2"></i> Edit Assignment
                </a>  
            </div>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-12">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="#">Home</a></li>
                    <li><a class="text-decoration-none" href="<?php echo e(route('allAssignments')); ?>">List Assignments </a></li>
                    <li>View Assignment</li>
                </ul>
            </div>
        </div>
    </div>

<div class="bg-white rounded shadow p-4">

    <h2 class="text-center"> <?php echo e($assignment->assignment_title); ?>

        <span class="text-muted d-block fs-6 mt-2"><?php echo e($assignment->assignment_note); ?></span>
    </h2>


    <div class="bhoechie-tab-container container row m-0 my-4">

        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 bhoechie-tab-menu">
            <div class="list-group">
                <?php $__currentLoopData = json_decode($assignment->assignment_structure); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="#" <?php echo $loop->first ? 'class="list-group-item active text-center py-3"':'class="list-group-item text-center py-3"'; ?>>

                    <?php echo e($assignments->name); ?>

                </a>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 bhoechie-tab text-center">
            <!-- flight section -->
            <?php $__currentLoopData = json_decode($assignment->assignment_structure); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assignments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


            <div <?php echo $loop->first ? 'class="bhoechie-tab-content active "':'class="bhoechie-tab-content"'; ?>>
                <?php $__currentLoopData = $assignments->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $questionindx => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bhoechie">
                    <div id="rowAnswer" class="row px-2">
                        <h2 class=""><?php echo e($question->question_title); ?> </h2>
                        <h6 id="question" class="text-muted "><?php echo e($question->question_note); ?></h6>
                        <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Answerindex=>$Answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="form-check d-flex justify-content-center col-md-3">
                            <label class="form-check-label text-center">
                                <!-- <?php echo e($loop->index); ?> -->
                                <input type="radio" disabled class="form-check-input d-block m-auto my-2" name="answer" id="q1" value="value">


                                <?php if($Answer->answer_image !== null): ?>
                                <img class="image-fload img-thumbnail" src='<?php echo e(asset("uploads/$Answer->answer_image")); ?>' alt="<?php echo e($Answer->answer_text); ?>">
                                <?php endif; ?>

                                <p class="my-2 Qtitle"> <?php echo e($Answer->answer_text); ?></p>
                                <p class="my-2"> <?php echo e($Answer->degree); ?></p>
                                <p class="my-2"> <?php echo e($Answer->answers_redirection_group_index); ?></p>
                                <p class="my-2"> <?php echo e($Answer->answers_redirection_group_question); ?></p>
                            </label>
                        </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>



            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>






        </div>

        
    </div>
    <div class="row mb-3 border-bottom text-capitalize">
        <div class="col-md-6">
            <h5>Business Location: 
                <span class="text-muted fs-6">
                    <a class="text-decoration-none" href="<?php echo e(route('viewBusinessLocation' , $assignment->business_id )); ?>">
                        <?php echo e($assignment->businessLocation->business_name); ?>

                    </a>
                </span>
            </h5>
        </div>
        <div class="col-md-6 text-end">
            <h5>Created By: 
                <span class="text-muted fs-6">
                    <a class="text-decoration-none" href="<?php echo e(route('viewUser' , $assignment->created_by )); ?>">
                        <?php echo e($assignment->createdPerson->full_name); ?>

                    </a>
                </span>
            </h5>
        </div>

    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<Script src="<?php echo e(asset('js/assignment.js')); ?>"></Script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/assignments/view.blade.php ENDPATH**/ ?>