

<?php $__env->startSection('title'); ?>
Edit User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-title'); ?>
Edit User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-navigation'); ?>
<li><a class="text-decoration-none" href="<?php echo e(route('allUsers')); ?>">List Users </a></li>
<li>Edit User - <?php echo e($user->full_name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-li'); ?>
<li class="nav-item" role="presentation">
    <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">Basic Info</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary" aria-selected="false">Address Info</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links" type="button" role="tab" aria-controls="pills-social-links" aria-selected="false">Social Links</button>
</li>
<?php $__env->stopSection(); ?>

<form class="needs-validation" method="POST" action="<?php echo e(route('updateUser', $user->id)); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <?php $__env->startSection('form-tabs-content'); ?>
    
    <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel" aria-labelledby="pills-basic-primary-tab">

        <div class="row">

            
            <div class="col-md-4 mt-4">
                <label for="full_name" class="form-label">Full Name</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="full_name" aria-describedby="nameHelp" placeholder="Enter Full Name ..." name="full_name" value="<?php echo e(old('full_name') ?? $user->full_name); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="email" class="form-label">Email Address</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-envelope"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="email" aria-describedby="email" placeholder="Enter Email Address ..." name="email" value="<?php echo e(old('email') ?? $user->email); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-2 mt-4">
                <label for="is_active" class="form-label">Is Active ?</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="is_active" name="is_active" required>
                        <option value="Active" <?php if(old('is_active')==null): ?> <?php echo e($user->is_active == 'Active' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('is_active') == 'Active' ? 'selected' : ''); ?> <?php endif; ?>>
                            Active</option>
                        <option value="InActive" <?php if(old('is_active')==null): ?> <?php echo e($user->is_active == 'InActive' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('is_active') == 'InActive' ? 'selected' : ''); ?> <?php endif; ?>>
                            InActive</option>
                    </select>
                    
                </div>
            </div>

            
            <div class="col-md-2 mt-4">
                <label for="allow_login" class="form-label">Allow Login</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="allow_login" name="allow_login" required>
                        <option value="Allowable" <?php if(old('allow_login')==null): ?> <?php echo e($user->allow_login == 'Allowable' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('allow_login') == 'Allowable' ? 'selected' : ''); ?> <?php endif; ?>>
                            Allowable</option>
                        <option value="Not Allowable" <?php if(old('allow_login')==null): ?> <?php echo e($user->allow_login == 'Not Allowable' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('allow_login') == 'Not Allowable' ? 'selected' : ''); ?> <?php endif; ?>>
                            Not Allowable</option>

                    </select>
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="phone" class="form-label">Mobile Number</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="phone" placeholder="Enter Mobile Number . . ." name="phone" value="<?php echo e(old('phone') ?? $user->phone); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="alternative_phone" class="form-label">Alternative Mobile Number</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="alternative_phone" placeholder="Enter Alternative Mobile Number . . ." name="alternative_phone" value="<?php echo e(old('alternative_phone') ?? $user->alternative_phone); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="contact_number" class="form-label">Contact Number</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="contact_number" placeholder="Enter Contact Number . . ." name="contact_number" value="<?php echo e(old('contact_number') ?? $user->contact_number); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="nationality" class="form-label">Nationality</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="nationality" placeholder="Enter Nationality . . ." name="nationality" value="<?php echo e(old('nationality') ?? $user->nationality); ?>" required>
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="national_number" class="form-label">National Number</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-id-card"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="national_number" placeholder="Enter National Number . . ." name="national_number" value="<?php echo e(old('national_number') ?? $user->national_number); ?>" required>
                    
                </div>
            </div>

            
            <div class="col-md-2 mt-4">
                <?php if($user->image !== null): ?>
                <div class="form-group">
                    <img class="image-fload" width="100%" height="100%" src='<?php echo e(asset("uploads/$user->image")); ?>' alt="<?php echo e($user->full_name); ?>">
                </div>
                <?php else: ?>
                <br>
                <p class="filelabel">No User Image</p>
                <?php endif; ?>
            </div>
            <div class="col-md-2 mt-4">
                <label for="image_input" class="form-label filelabel">
                    <i class="fa fa-paperclip">
                    </i>
                    <span class="title">
                        Upload Image
                    </span>
                    <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                </label>
            </div>


            
            <div class="col-md-4 mt-4">
                <label for="dob" class="form-label">Date Of Birth</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="date" class="form-control text-start" id="dob" placeholder="Enter Date of Birth . . ." name="dob" value="<?php echo e(old('dob') ?? $user->dob); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="gender" class="form-label">Gender</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="gender" name="gender" required>
                        <option value="" disabled>-- Please choose an option --</option>
                        <option value="Male" <?php if(old('gender')==null): ?> <?php echo e($user->gender == 'Male' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('gender') == 'Male' ? 'selected' : ''); ?> <?php endif; ?>>
                            Male</option>
                        <option value="Female" <?php if(old('gender')==null): ?> <?php echo e($user->gender == 'Female' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('gender') == 'Female' ? 'selected' : ''); ?> <?php endif; ?>>
                            Female</option>
                    </select>
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="blood_group" class="form-label">Blood Group</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                        <option value="">-- Please choose an option --</option>
                        <option value="A+" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'A+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                            A+</option>
                        <option value="A-" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'A-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                            A-</option>
                        <option value="B+" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'B+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'B+' ? 'selected' : ''); ?> <?php endif; ?>>
                            B+</option>
                        <option value="B-" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'B-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'B-' ? 'selected' : ''); ?> <?php endif; ?>>
                            B-</option>
                        <option value="O+" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'O+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                            O+</option>
                        <option value="O-" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'O-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                            O-</option>
                        <option value="AB+" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'AB+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                            AB+</option>
                        <option value="AB-" <?php if(old('blood_group')==null): ?> <?php echo e($user->blood_group == 'AB-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                            AB-</option>
                    </select>
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="language" class="form-label">Mother Language</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="language" placeholder="Enter Mother Language . . ." name="language" value="<?php echo e(old('language') ?? $user->language); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="marital_status" class="form-label">Marital Status</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="marital_status" name="marital_status" required>
                        <option value="">-- Please choose an option --</option>
                        <option value="Single" <?php if(old('marital_status')==null): ?> <?php echo e($user->marital_status == 'Single' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Single' ? 'selected' : ''); ?> <?php endif; ?>>
                            Single</option>
                        <option value="Married" <?php if(old('marital_status')==null): ?> <?php echo e($user->marital_status == 'Married' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Married' ? 'selected' : ''); ?> <?php endif; ?>>
                            Married</option>
                        <option value="Divorced" <?php if(old('marital_status')==null): ?> <?php echo e($user->marital_status == 'Divorced' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Divorced' ? 'selected' : ''); ?> <?php endif; ?>>
                            Divorced</option>
                    </select>
                    
                </div>
            </div>

        </div>

        <div class="dotted-seprator mt-4 "></div>

        <div class="row">

            
            <div class="col-md-4 mt-4">
                <label for="user_name" class="form-label">User Name</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="user_name" aria-describedby="user_name" placeholder="Enter User Name ..." name="user_name" value="<?php echo e(old('user_name') ?? $user->user_name); ?>" required>
                    <div class="invalid-feedback">
                        Please choose a student_name.
                    </div>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="user_name" class="form-label">Changing User Password</label>
                <div class="input-group has-validation">
                    <a class="btn btn-outline-primary btn-sm me-2" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        <i class="fa-solid fa-plus me-2"></i> Change password
                    </a>
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="businessLocations" class="form-label">Business Location Name</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-check"></i>
                    </span>
                    <select class="form-control text-start custom-select" id="businessLocations" name="business_id" required>
                        <option value="" disabled>-- Please choose an option --</option>
                        <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($business_location->id); ?>" <?php if(old('business_id')==null): ?> <?php echo e($user->business_id == $business_location->id ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('business_id') == $business_location->id ? 'selected' : ''); ?> <?php endif; ?>>
                            <?php echo e($business_location->business_name); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    
                </div>
            </div>


        </div>
    </div>



    
    <div class="tab-pane  fade px-3" id="pills-address-primary" role="tabpanel" aria-labelledby="pills-address-primary-tab">

        <div class="row">

            
            <div class="col-md-4 mt-4">
                <label for="address" class="form-label">Address</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="address" aria-describedby="address" placeholder="Enter Address ..." name="address" value="<?php echo e(old('address') ?? $user->address); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="city" class="form-label">City</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-envelope"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="city" aria-describedby="city" placeholder="Enter City ..." name="city" value="<?php echo e(old('city') ?? $user->city); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="state" class="form-label">State</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="state" aria-describedby="state" placeholder="Enter State ..." name="state" value="<?php echo e(old('state') ?? $user->state); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="country" class="form-label">Country</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-envelope"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="country" aria-describedby="country" placeholder="Enter Country ..." name="country" value="<?php echo e(old('country') ?? $user->country); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="landmark" class="form-label">Landmark</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-solid fa-envelope"></i>
                    </span>
                    <input type="text" class="form-control text-start" id="landmark" aria-describedby="landmark" placeholder="Enter Landmark ..." name="landmark" value="<?php echo e(old('landmark') ?? $user->landmark); ?>">
                    
                </div>
            </div>


        </div>
    </div>



    
    <div class="tab-pane fade  px-3" id="pills-social-links" role="tabpanel" aria-labelledby="pills-social-links-tab">

        <div class="row">

            
            <div class="col-md-4 mt-4">
                <label for="fb_link" class="form-label">FaceBook Link</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="url" class="form-control text-start" id="fb_link" placeholder="Enter FaceBook Link ..." name="fb_link" value="<?php echo e(old('fb_link') ?? $user->fb_link); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="twitter_link" class="form-label">Twitter Link</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="url" class="form-control text-start" id="twitter_link" placeholder="Enter Twitter Link ..." name="twitter_link" value="<?php echo e(old('twitter_link') ?? $user->twitter_link); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="social_media_1" class="form-label">Social Media Link</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="url" class="form-control text-start" id="social_media_1" placeholder="Enter Social Media Link ..." name="social_media_1" value="<?php echo e(old('social_media_1') ?? $user->social_media_1); ?>">
                    
                </div>
            </div>

            
            <div class="col-md-4 mt-4">
                <label for="social_media_2" class="form-label">Social Media Link</label>
                <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend">
                        <i class="fa-regular fa-user"></i>
                    </span>
                    <input type="url" class="form-control text-start" id="social_media_2" placeholder="Enter Social Media Link ..." name="social_media_2" value="<?php echo e(old('social_media_2') ?? $user->social_media_2); ?>">
                    
                </div>
            </div>


        </div>
    </div>



    <div class="col-12 mt-5">
        <button class="btn btn-primary" type="submit">save</button>
    </div>
    <?php $__env->stopSection(); ?>

</form>

<!-- Change password Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Changing User Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">


                <form method="POST" action="<?php echo e(route('updateUserPassword', $user->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="password">New Password</label>
                        <input type="password" class="form-control" id="password" aria-describedby="passwordHelp" placeholder="Password" name="password">
                        <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password and
                            use complex password</small>
                    </div>

                    <div class="form-group">
                        <label for="confirm_password">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm_password" aria-describedby="confirmPasswordHelp" placeholder="Password">
                        <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small>
                    </div>




            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/users/edit.blade.php ENDPATH**/ ?>