

<?php $__env->startSection('title'); ?>
Edit Question
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-title'); ?>
<?php echo e(__('questions.edit_question')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-navigation'); ?>
<li><a class="text-decoration-none" href="<?php echo e(route('allQuestions')); ?>"><?php echo e(__('questions.list_questions')); ?></a></li>
<li><?php echo e(__('questions.edit_question')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-li'); ?>
<li class="nav-item" role="presentation">
    <button class="nav-link active" id="english-tab" data-bs-toggle="tab" data-bs-target="#english" type="button" role="tab" aria-controls="english" aria-selected="true">English</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="arabic-tab" data-bs-toggle="tab" data-bs-target="#arabic" type="button" role="tab" aria-controls="arabic" aria-selected="false">العربي</button>
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-content'); ?>
<form method="POST" action="<?php echo e(route('updateQuestion', $question->id)); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    
    <div class="tab-pane fade show active px-3" id="pills-question-info" role="tabpanel" aria-labelledby="pills-question-info-tab">

        <div class="row">


            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="english" role="tabpanel" aria-labelledby="english-tab">
                    
        
                    <div class="row">
        
                        
                        <div class="form-group mt-4">
                            <label for="question_title">Question Title</label>
                            <textarea type="text" class="form-control" id="question_title" aria-describedby="nameHelp" placeholder="Question Title" name="question_title" rows="5" required><?php echo e(old('question_title') ?? $question->question_title); ?></textarea>
                        </div>
        
                        
                        <div class="form-group mt-4">
                            <label for="question_note">Question Note</label>
                            <input type="text" class="form-control" id="question_note" aria-describedby="question_note" placeholder="Question Note" name="question_note" value="<?php echo e(old('question_note') ?? $question->question_note); ?>">
                        </div>
        
        
                    </div>
        
                </div>
                <div class="tab-pane fade" id="arabic" role="tabpanel" aria-labelledby="arabic-tab">
                    <div class="row">
        
                        
                        <div class="form-group mt-4">
                            <label for="question_title_ar">عنوان السؤال</label>
                            <textarea type="text" class="form-control" id="question_title_ar" aria-describedby="nameHelp" placeholder="عنوان السؤال" name="question_title_ar" rows="5" required><?php echo e(old('question_title_ar') ?? $question->question_title_ar); ?></textarea>
                        </div>
        
                        
                        <div class="form-group mt-4">
                            <label for="question_note_ar">ملاحظة السؤال</label>
                            <input type="text" class="form-control" id="question_note_ar" aria-describedby="question_note_ar" placeholder="ملاحظة السؤال" name="question_note_ar" value="<?php echo e(old('question_note_ar') ?? $question->question_note_ar); ?>">
                        </div>
        
        
        
                    </div>
                </div>
            </div>


            
            <div class="w-100 " id="Answar">

                <?php $__currentLoopData = json_decode($question->answers); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row removeclass<?php echo e($loop->index); ?> align-items-center answer-row">


                    <div class="col-md-1 mt-4">
                        <label for="index">Index</label>
                        <input type="number" class="form-control" id="index" placeholder="index" name="answers[<?php echo e($loop->index); ?>][answer_index]" value="<?php echo e($answer->answer_index); ?>">
                    </div>
                    <div class="col-md-3 mt-4">
                        <label for="answers">Answers</label>
                        <input type="text" class="form-control" id="answers" placeholder="Answers" name="answers[<?php echo e($loop->index); ?>][answer_text]" value="<?php echo e($answer->answer_text); ?>">
                    </div>
                    <div class="col-md-3 mt-4">
                        <label for="answers">الاجابه</label>
                        <input type="text" class="form-control" id="answers" placeholder="الاجابه" name="answers[<?php echo e($loop->index); ?>][answer_text_ar]" value="<?php echo e($answer->answer_text_ar ?? ""); ?>">
                    </div>
                    
                    <div class="col-md-2 mt-4">
                        <?php if($answer->answer_image !== null): ?>
                        <div class="form-group">
                            <img class="image-fload" width="100%" height="100%" src='<?php echo e(asset("uploads/$answer->answer_image")); ?>'>
                        </div>
                        <?php else: ?>
                        <br>
                        <p class="filelabel">No User Image</p>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-2 mt-4">
                        <label for="image_input<?php echo e($loop->index); ?>" class="form-label filelabel">
                            <i class="fa fa-paperclip">
                            </i>
                            <span class="title">
                                Upload Image
                            </span>

                            <input class="FileUpload1 form-control" id="image_input" name="answers[<?php echo e($loop->index); ?>][answer_image]" type="file" />
                        </label>
                    </div>
                    <div class="col-md-1 d-flex justify-content-end">
                        <i class="fa-solid fa-minus  icons bg-danger  bg-gradient  text-white " onclick="remove_Anwser('removeclass<?php echo e($loop->index); ?>');"></i>
                    </div>




                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-1 d-flex justify-content-end">
                    <i class="fa-regular fa-plus  icons bg-success text-white" onclick="addAnswer();"></i>
                </div>
            </div>

        </div>
    </div>



    <div class="col-12 mt-4">
        <button class="btn btn-outline-primary" type="submit"><?php echo e(__('questions.save')); ?></button>
    </div>

</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<Script src="<?php echo e(asset('js/questionForm.js')); ?>"></Script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/questions/edit.blade.php ENDPATH**/ ?>