

<?php $__env->startSection('title'); ?>
    All Assignments
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Assignments
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Assignments</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
<?php if(Auth::user()->role == "super_admin" || Auth::user()->role == "owner" || Auth::user()->role == "admin"): ?>
<a href="<?php echo e(route('createAssignment')); ?>" class="btn btn-outline-primary btn-sm me-2">
    <i class="fa-solid fa-plus me-2"></i> New Assignments
</a>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">Assignment Title</th>
    <th scope="col">Business Location</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6"> Assignment Title </h6>
                <a class="text-decoration-none col-6" href="<?php echo e(route('viewAssignment', $assignment->id)); ?>">
                    <p class="text-custome m-0 "><?php echo e($assignment->assignment_title); ?></p>
                </a>
            </td>
        
            <td class="Zindex">
                <h6 class="col-6"> Created By </h6>
                <a class="text-decoration-none col-6" href="<?php echo e(route('viewUser', $assignment->created_by)); ?>">
                    <p class="text-custome m-0 "><?php echo e($assignment->createdPerson->full_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('viewAssignment', $assignment->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <?php if(Auth::user()->role == "super_admin" || Auth::user()->role == "owner"): ?>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('editAssignment', $assignment->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('deleteAssignment', $assignment->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/assignments/list.blade.php ENDPATH**/ ?>