<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@200;300;400&family=Poppins:wght@200;300;400&display=swap" rel="stylesheet">
    <!-- <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css" /> -->

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/dataTables.bootstrap5.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/buttons.dataTables.min.css')); ?>" />
    




    <link rel="stylesheet" href="<?php echo e(asset('css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="bg-light bg-gradient">


    <nav class="navbar  navbar-expand-sm navbar-light bg-white shadow-sm fixed-top homenav">
        <div class="container-fluid">
            <div class="collapse navbar-collapse">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item" id="minmus">
                        <a class="nav-link" href="#">
                            <i class="fa-solid fa-hand-point-left border p-2 rounded-circle" ></i>
                        </a>
                    </li>

                    <li class="nav-item fullScreen">
                        <a class="nav-link " href="#">
                            <i class="fa-solid fa-expand border p-2 rounded-circle "></i>
                        </a>
                    </li>
                    <li class="nav-item">

                        <input type="text" class="form-control rounded-pill m-2" placeholder="Search...">

                    </li>



                </ul>
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fa-solid fa-house border p-2 rounded-circle"></i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fa-solid fa-grip border p-2 rounded-circle"></i>
                        </a>
                    </li>

                    <li class="nav-item menu-dropdown-wrapper rounded">
                        <a class="nav-link " href="#">
                            <i class="fa-regular fa-user border p-2 rounded-circle"></i>
                        </a>
                        <div class="menu-dropdown menu-dropdown-right menu-dropdown-push-right">
                            <div class="arrow arrow-right"></div>
                            <div class="menu-dropdown-inner ">
                                <div class="menu-dropdown-head pb-3 bg-gradient">
                                    <div class="tbl-cell d-flex align-items-center">
                                        <i class="fa-regular fa-1x fa-user border p-2 rounded-circle me-2"></i>
                                        <h5>Admin TPs</h5>

                                    </div>
                                    <div class="tbl-cell pl-2 text-left">

                                    </div>
                                </div>
                                <div class="menu-dropdown-body">
                                    <ul class="menu-nav navbar-nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="#"><i class="fa-solid fa-address-card me-2 "></i>Visit Profile</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="#"><i class="fa-solid fa-house me-2  me-2"></i>profile</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="#">
                                                <i class="fa-solid fa-key me-2  "></i>
                                                change Password</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="menu-dropdown-footer text-end">
                                    <a href="#" class="btn btn-outline-primary  rounded-pill btn-sm">Logout</a>
                                </div>
                            </div>
                        </div>
                    </li>


                </ul>

            </div>
        </div>
    </nav>

    <div class="d-flex" id="navbarSupportedContent">
        <div class="col-md-2 vh-100 sidebar navbar-dark position-fixed">
            <div class=" m-3"> <a href="#" class="navbar-brand">Bahaaa</a></div>

            <ul class="navbar-nav justify-content-end flex-grow-1 text-capitalize">
                <li class="nav-item">

                    <a class="nav-link <?php echo e(Route::is('allUsers' , 'viewUser', 'searchUsers','createUser','storeUser','editUser','updateUserPassword','deleteUser') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allUsers')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-user-group"></i> users</a>
                </li>
                <li class="nav-item">

                    <a class="nav-link <?php echo e(Route::is('allStudents','viewStudent','searchStudents','createStudent','storeStudent','editStudent','updateStudent','deleteStudent','takeStudentAssignment','createStudentAssignment','storeStudentAssignment') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allStudents')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-user-graduate"></i> students</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allBusinessLocations','viewBusinessLocation','searchBusinessLocations','createBusinessLocation','storeBusinessLocation','editBusinessLocation','updateBusinessLocation','deleteBusinessLocation') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allBusinessLocations')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-briefcase"></i>business locations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allTrainers','viewTrainer','searchTrainers','createTrainer','storeTrainer','editTrainer','updateTrainer','updateTrainerPassword','deleteTrainer') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allTrainers')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-user-tag"></i> trainers</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allFathers','viewFather','searchFathers','createFather','storeFather','editFather','updateFather','deleteFather') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allFathers')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-user"></i> fathers</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allMothers','viewMother','searchMothers','createMother','storeMother','editMother','updateMother','deleteMother') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allMothers')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-user"></i> mothers</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allSuperiors','viewSuperior','searchSuperiors','createSuperior','storeSuperior','editSuperior','updateSuperior','deleteSuperior') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allSuperiors')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-school "></i> superiors</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allQuestions','viewQuestion','searchQuestions','createQuestion','storeQuestion','editQuestion','updateQuestion','deleteQuestion') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allQuestions')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-file-code"></i> questions</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allAssignments','viewAssignment','searchAssignments','createAssignment','storeAssignment','editAssignment','updateAssignment','deleteAssignment') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allAssignments')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-file-lines"></i> assignments</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('allSubmissions','viewSubmission','createSubmission','storeSubmission','editSubmission','updateSubmission','deleteSubmission') ? 'active text-primary fw-bolder' : ''); ?>" href="<?php echo e(route('allSubmissions')); ?>">
                        <span class="shape1"></span>

                        <i class="fa-solid fa-file-arrow-up"></i> submissions</a>
                </li>

            </ul>

        </div>

        <div class="col-md-10 my-5 py-5 offset-2 content">
            <div class="container">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <Script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/dataTables.bootstrap5.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/dataTables.buttons.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/jszip.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/pdfmake.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/vfs_fonts.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/buttons.html5.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/buttons.print.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/index.js')); ?>"></Script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH D:\xampp\htdocs\assignments\resources\views/layouts/app.blade.php ENDPATH**/ ?>