

<?php $__env->startSection('title'); ?>
    All Submissions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Submissions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Submissions</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createSubmission')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Submission
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">Student Name</th>
    <th scope="col">Assignment Title</th>
    <th scope="col">Businss location</th>
    <th scope="col">Trainer</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewStudent', $submission->student_id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($submission->student->student_name); ?></p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewAssignment', $submission->assignment_id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($submission->assignment->assignment_title); ?></p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewBusinessLocation', $submission->business_id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($submission->businessLocation->business_name); ?></p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewTrainer', $submission->trainer_id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($submission->trainer->full_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('viewSubmission', $submission->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-primary"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('editSubmission', $submission->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('deleteSubmission', $submission->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/submissions/list.blade.php ENDPATH**/ ?>