

<?php $__env->startSection('title'); ?>
    All Students
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    <?php echo e(__('students.students')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li><?php echo e(__('students.students')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <?php if(Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin'): ?>
        <a href="<?php echo e(route('createStudent')); ?>" class="btn btn-outline-primary btn-sm me-2">
            <i class="fa-solid fa-plus me-2"></i><?php echo e(__('students.new_student')); ?>

        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col"><?php echo e(__('students.image')); ?></th>
    <th scope="col"><?php echo e(__('students.student')); ?></th>
    <th scope="col"><?php echo e(__('students.nationality')); ?></th>
    <th scope="col"><?php echo e(__('students.gender')); ?></th>
    <th scope="col"><?php echo e(__('students.actions')); ?></th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row" class="imageTitle">
                <?php if($student->image !== null && $student->image !== ''): ?>
                    <img class="image-fload" width="100px" height="100px" src='<?php echo e(asset("uploads/$student->image")); ?>'
                        alt="<?php echo e($student->student_name); ?>">
                <?php else: ?>
                    <h2> <?php echo e($student->student_name[0]); ?></h2>
                <?php endif; ?>
            </td>
            <td class="Zindex Zindex1">
                <h6 class="col-6"><?php echo e(__('students.name')); ?></h6>
                <a class="text-decoration-none col-6" href="<?php echo e(route('viewStudent', $student->id)); ?>">
                    <p class="text-custome m-0 mb-4 "><?php echo e($student->student_name); ?></p>
                </a>
                <h6 class="col-6"><?php echo e(__('students.home_phone')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->home_phone); ?></p>
                <h6 class="col-6"><?php echo e(__('students.phone')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->phone); ?></p>
                <h6 class="col-6"><?php echo e(__('students.alternative_phone')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->alternative_phone); ?></p>
                <h6 class="col-6"><?php echo e(__('students.contact_number')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->contact_number); ?></p>
            </td>
            <td class="Zindex">
                <h6 class="col-6"><?php echo e(__('students.nationality')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->nationality); ?></p>
            </td>
            <td class="Zindex">
                <h6 class="col-6"><?php echo e(__('students.gender')); ?></h6>
                <p class="m-0 mb-4 col-6"><?php echo e($student->gender); ?></p>
            </td>
            <td>
                <div class="btn-group">
                    
                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('viewStudent', $student->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                <?php echo e(__('students.view')); ?>

                            </a>
                        </li>
                        <?php if(Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner' || Auth::user()->role == 'admin'): ?>
                            <li>
                                <a class="dropdown-item opacity-75 " href="<?php echo e(route('editStudent', $student->id)); ?>">
                                    <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                    <?php echo e(__('students.edit')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('takeStudentAssignment', $student->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                <?php echo e(__('students.take_assignment')); ?>

                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('takenStudentAssignments', $student->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                <?php echo e(__('students.taken_assignments')); ?>

                            </a>
                        </li>
                        <?php if(Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner'): ?>
                            <li>
                                <a class="dropdown-item opacity-75 " href="<?php echo e(route('deleteStudent', $student->id)); ?>">
                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                    <?php echo e(__('students.delete')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/students/list.blade.php ENDPATH**/ ?>