

<?php $__env->startSection('title'); ?>
View Question
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="px-3">

    <div class="row align-items-center">
        <div class="col-sm-8">
            <h5 class="page-title-text d-inline-block"><?php echo e(__('questions.view_question')); ?> </h5>
        </div>
        <div class="col-sm-4 text-right">
            <div class=" text-end mb-3">
                <a href="<?php echo e(route('editQuestion' , $question->id)); ?>" class="btn btn-outline-warning btn-sm me-2">
                    <i class="fa-solid fa-pen-to-square me-2"></i><?php echo e(__('questions.edit_question')); ?>

                </a>  
            </div>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-12">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="<?php echo e(route('dashboardIndex')); ?>"><?php echo e(__('common.home')); ?></a></li>
                    <li><a class="text-decoration-none" href="<?php echo e(route('allUsers')); ?>"><?php echo e(__('questions.list_questions')); ?></a></li>
                    <li><?php echo e(__('questions.view_question')); ?></li>
                </ul>
            </div>
        </div>
    </div>

    <section class="container px-5">
        <div class="bg-white w-100 m-auto shadow-lg rounded-lg  overflow-auto">
            <div class="p-3 bg-light border-bottom overflow-auto">
                <h1 class="text-spec text-center"><?php echo e(__('questions.questions')); ?></h1>
            </div>
    
            <div class="p-4 text-spec">
                <?php if(Config::get('languages')[App::getLocale()] = "english"): ?>
                    <h6 class="">Q: <?php echo e($question->question_title); ?> </h6>
                    <h6 id="question" class="text-muted mb-5"><?php echo e($question->question_note); ?></h6>
                <?php else: ?>
                    <h6 class="">س: <?php echo e($question->question_title_ar); ?> </h6>
                    <h6 id="question" class="text-muted mb-5"><?php echo e($question->question_note_ar); ?></h6>
                <?php endif; ?>
    
                <div id="rowAnswer" class="row g-5 px-2">
                    <?php $__currentLoopData = json_decode($question->answers); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-check d-flex justify-content-center col-md-3">
                        <label class="form-check-label text-center">
                            <!-- <?php echo e($loop->index); ?> -->
                            <input type="radio" disabled class="form-check-input d-block m-auto my-2" name="answer" id="q1" value="value">
                           
                         
                            <?php if($Answer->answer_image !== null): ?>
                            <img class="image-fload img-thumbnail"  src='<?php echo e(asset("uploads/$Answer->answer_image")); ?>' alt="<?php echo e($Answer->answer_text); ?>">
                            <?php endif; ?>

                            <?php if(Config::get('languages')[App::getLocale()] = "english"): ?>
                                <p class="my-2"> <?php echo e($Answer->answer_text); ?></p>
                            <?php else: ?>
                                <p class="my-2"> <?php echo e($Answer->answer_text_ar); ?></p>
                            <?php endif; ?>
                            
                        </label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/questions/view.blade.php ENDPATH**/ ?>