<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@200;300;400&family=Poppins:wght@200;300;400&display=swap" rel="stylesheet">
    <!-- <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css" /> -->

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/dataTables.bootstrap5.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/buttons.dataTables.min.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('css/all.min.css')); ?>">
    <?php if( Config::get('languages')[App::getLocale()] =="Arabic" ): ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.rtl.min.css')); ?>">
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">

    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <?php if( Config::get('languages')[App::getLocale()] =="Arabic" ): ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/style_ar.css')); ?>">
    <?php endif; ?>
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="bg-light bg-gradient">

    <?php echo $__env->yieldContent('layout'); ?>


    <script>
        var assetBaseUrl = "<?php echo e(asset('')); ?>";
    </script>
    <Script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/dataTables.bootstrap5.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/dataTables.buttons.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/jszip.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/pdfmake.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/vfs_fonts.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/buttons.html5.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/buttons.print.min.js')); ?>"></Script>
    <Script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>"></Script>
    <!-- <Script src="<?php echo e(asset('js/tinymce.min.js')); ?>" referrerpolicy="origin"></Script> -->
    <script src="https://cdn.tiny.cloud/1/0a0lx6zhkn9c5lloq7t8y1o1arjhhljo8xuya3qzza88z0jq/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <Script src="<?php echo e(asset('js/index.js')); ?>"></Script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH C:\xampp\htdocs\assignments\resources\views/layouts/app.blade.php ENDPATH**/ ?>